/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)passone.c	2.5    1/15/85
*/

#include "loader.h"
#include "lx68.h"

passone(fname,fp,why,lname)
char *fname;
FILE *fp;
char *why;
char *lname;
{
	register struct nlist *sptr;
	register struct symtbl *stptr;
	register short i, type;
	struct nlist syms;
#ifdef LNG_NMS
	FILE *symfp;
	long soff;
#endif

	if (fp == NULL) {
		if( (ifd = fopen(fname,"r")) == NULL ) {
			printf(":can't open file '%s'\n",fname);
			ldexit(1);
		}
#ifdef LNG_NMS
		symfp = fopen(fname,"r");
#endif
	}
	else {
		ifd = fp;
#ifdef LNG_NMS
		symfp = fopen(lname,"r");
#endif
	}
	if( (i = getsizes(ifd,fname)) != 0 ) {	/* must be a library */
		if( fp == NULL )
			fclose(ifd);
		return(i);
	}
	if( mflag )
		printf(":%s(%s)\n",fname,lname);
	fseek(ifd,symstart,1);					/* Seek to start of symbols */
	sptr = &syms;
#ifdef LNG_NMS
    soff = ftell(ifd);  
    fseek(symfp,soff,0);
	islngnms = 1;
    GETSYM(sptr,symfp,NULL,0);    /* Get a symbol */
    if (sptr->n_name != -1 || sptr->n_type != 0)
        islngnms = 0;
    else {
        fseek(symfp,soff+sptr->n_value,0);
		ssize = sptr->n_value - S_LSYMSIZ;
		GETSYM(sptr,ifd,NULL,0);    /* Get past fake symbol */
    }
#endif
	for( ; ssize > 0; ssize -= STE_SIZE ) {
		GETSYM(sptr,ifd,symfp,0);
		type = sptr->n_type;
		if( type & S_DEFINED ) {
			if( GLOBAL(type) || EXTERNAL(type) || COMMON(type) ) {
				if( addsym(sptr) == 0L ) {
					printf(":warning, multiple global definition of '%.8s' in %s"
						,sptr->n_name,fname);
					if( why != NULL )
						printf(" due to '%s'",why);
					putchar('\n');
				}	
			}
		}
		else if( (type & S_FILE) == 0 )
			printf(":undefined symbol '%.8s' in %s\n",sptr->n_name,fname);
	}
	if( fp == NULL)
		fclose(ifd);
#ifdef LNG_NMS
	fclose(symfp);
#endif
	stptr = &symtab;
	stptr->s_text += tsize;
	stptr->s_data += dsize;
	stptr->s_bss += bsize;
	return(0);
}

getsizes(fdes,fname)
FILE *fdes;
char *fname;
{
	register struct exec2 *hdr;
	struct exec2 header;

	hdr = &header;
	GETCHD(fdes,hdr);	/* Read in the file header */
	if( hdr->a_magic != E_MAGIC ) {
		if( hdr->a_magic == LIBMAGIC || hdr->a_magic == LIBRMAGIC )
			return(hdr->a_magic);
		printf(":invalid magic number %x in '%s'\n",hdr->a_magic,fname);
	}
	else if( hdr->a_flag == R_NOBITS )
		printf(":object file '%s' without relocation information\n",fname);
	else if( (ssize = hdr->a_syms) == 0 )
		printf(":object file '%s' without symbol information\n",fname);
	else {
		tsize = hdr->a_text;
		dsize = hdr->a_data;
		bsize = hdr->a_bss;
		symstart = tsize + dsize;
		return(0);
	}
	ldexit(1);
}
