/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)loader.h	2.6    2/1/85
*/

#include <stdio.h>

#ifdef FILE_TEST
FILE *tfopen();

#define fopen  tfopen
#define fclose tfclose
#endif

#ifdef VAX11
#	ifndef vax11c
#		include <sys/types.h>
#		include <c68/ar68.h>
#		include <c68/a.out.h>
#		include <c68/order.h>
#		define LTEMPLATE	"/usr/local/lib/lib"
#		define ALTEMPLATE	"/usr/local/usr/lib/lib"
#	endif
#endif

#ifdef vax11c
#	define VMS   1
#	define VAX11 1
#	define DECC  1
#	include <IAR68>
#	include <IAOUT>
#	include <IORDER>
#	include <ISTAT>
#	define LTEMPLATE	"lib:lib"
#	define ALTEMPLATE	"ulib:lib"
#	define unlink		delete
#else
#	include <sys/stat.h>
#endif

#ifdef PDP11
#	include <sys/types.h>
#	include <c68/ar68.h>
#	include <c68/a.out.h>
#	include <c68/order.h>
#	define LTEMPLATE	"/usr/local/lib/lib"
#	define ALTEMPLATE	"/usr/local/usr/lib/lib"
#endif

#ifdef MC68000
#	include <ar68.h>
#	include <a.out.h>
#	include <order.h>
#	ifdef OPENFD
#		include <fcntl.h>
		FILE *newopen();
#	else
#		ifdef FCNTL
#			include <fcntl.h>
#		endif
#	endif
#	define LTEMPLATE	"/lib/lib"
#	define ALTEMPLATE	"/usr/lib/lib"
#endif

#include <ctype.h>

#define RESOLVE		1	/* used with the -f flag */
#define RELOCATE	2
#define ALIASES		3

#define FILESEP		'/'

#define S_USED		1	/* Marks a used symbol */
#define S_END		2	/* Marks an end variable(_end,_etext..) */
#define S_ALIAS0	4	/* Marks an aliased symbol */
#define S_ALIAS1	8	/* */

#define HASHVAL		97

#define COMMON(x)	((x&S_GLOBAL) && ((x&S_EXTERNAL) || (x&S_ABS)))
#define GLOBAL(x)	((x&S_GLOBAL) && (x&(S_TEXT|S_DATA|S_BSS|S_REG)))
#define EXTERNAL(x)	((!(x&S_GLOBAL)) && (x&S_EXTERNAL))
#define LOCAL(x)	((!(x&S_GLOBAL)) && (x&(S_TEXT|S_DATA|S_BSS)))

struct relbits {
	unsigned short rtype:3;	/* Relocation type */
	unsigned short symnum:13;	/* Relocation symbol number */
};

struct hashel {
	struct nlist h_sym;		/* Symbol entry */
	int symval;				/* New symbol number for partial links */
	struct hashel *n_hptr;	/* Next symbol entry pointer */
};
#define HSYMSIZ		sizeof(struct hashel)

struct bssel {
	struct hashel *b_hptr;
	struct bssel *n_bptr;
};
#define BSSEL		sizeof (struct bssel)

struct symtbl {
	struct hashel *hashcol[HASHVAL];	/* Hash table column array */
	struct libfile *f_lptr;				/* Library - filenames list pointer */
	struct bssel *f_bptr;				/* BSS list */
	struct aliases *f_aptr;				/* Alias List */
	long s_text;						/* Last text size */
	long s_data;						/* Last data size */
	long s_bss;							/* Last bss size */
};

struct libfile {
	char *plibname;			/* Library name */
	long offset;			/* Offset to the file within library */
	long l_text;
	long l_data;
	long l_bss;
	struct libfile *n_lptr;	/* Next library file entry pointer */
};
#define LFILSIZ		sizeof(struct libfile)

struct aliases {
	char symname[8];
	struct hashel *link;
	struct aliases *n_aptr;
};
#define ALIASIZ		sizeof(struct aliases)

#define MAXUFNAME	128
