/*
    Copyright 1983
    Alcyon Corp.
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)libes.c	2.5    1/15/85
*/

#include "loader.h"
#include "lx68.h"
#define  THRESHOLD 50

long lsymsiz = 0;
char libname[MAXUFNAME];

readlib(name,flag)
char *name;
short flag;
{

    if( getlname(name) )
        return(-1);
    if( flag )
        lpass2(libname); /* Process lib file list */
    else 
        scanlib();  /* Scan symbol table */
    return(0);
}

getlname(name)
register char *name;
{
    struct stat stbuf;

    sprintf(libname,"%s%s.a",LTEMPLATE,name);
    if (stat(libname,&stbuf) == -1) {
        sprintf(libname,"%s%s.a",ALTEMPLATE,name);
        if (stat(libname,&stbuf) == -1) {
            printf(":no library '%s%s.a' or '%s'\n",LTEMPLATE,name,libname);
            return(-1);
        }
    }
    return(0);
}

FILE *
getltype(lname)
char *lname;
{
    register FILE *lfd;
#ifdef LNG_NMS
    FILE *sfd;
#endif
    unsigned short type;

    if( (lfd = fopen(lname,"r")) == NULL ) {
        printf(":can't open library '%s'\n",lname);
        ldexit(1);
    }
    lgetw(&type,lfd);   /* read magic number */
    if( type != LIBMAGIC && type != LIBRMAGIC ) {
        printf(":invalid magic number %x in '%s'\n",type,lname);
        ldexit(1);
    }
    if( type == LIBRMAGIC )
        return(lfd);
#ifdef LNG_NMS
    if( (sfd = fopen(lname,"r")) == NULL ) {
        printf(":can't open library '%s'\n",lname);
        ldexit(1);
    }
    scanold(lfd,sfd);   /* always returns 0 */
#else
    scanold(lfd);   /* always returns 0 */
#endif
    return((FILE *)NULL);
}

getlsymt(pname,lfd,cnt)
char *pname;
register FILE *lfd;
int cnt;
{
    register struct libhdr *hdr;
    struct stat stbuf;

    if (!cnt)
        fstat(fileno(lfd),&stbuf);
    fseek(lfd,2L,0);
    hdr = &lhdr;
    GETARHD(lfd,hdr);
    if( strcmp(hdr->lfname,"._SYMDEF") != 0 ) {
        printf(":symbol file in archive %s not first entry\n",pname);
        ldexit(1);
    }

    if (!cnt && stbuf.st_mtime > hdr->lmodti)
        printf(":warning, '%s' has been modified since last ranlib!\n",pname);

    lsymsiz = hdr->lfsize+LIBHDSIZE;    /* length of the SYMDEF table */
    return(0);
}

/* scanlib - Scan's random libraries */
scanlib()
{
    register FILE *lfd;
#ifdef LNG_NMS
    register FILE *sfd;
#endif
    register struct hashel *hptr;
    register struct nlist *sym;
    register long len, end;
    register int match, cnt;
    FILE *rfd;

    if( (lfd = getltype(libname)) == NULL ) /* old style library */
        return(NULL);

#ifdef FCNTL
    fcntl(fileno(lfd),F_SETFL,O_RANDOM);
#endif

    sym = &csym;
    getlsymt(libname,lfd,0);
    cnt = 0;
#ifdef OPENFD
    rfd = newopen(lfd); /* get a seperate fp to lib */
#else
    rfd = fopen(libname,"r");   /* get a seperate fp to lib */
# ifdef FCNTL
    fcntl(fileno(rfd),F_SETFL,O_RANDOM);
# endif
#endif
#ifdef LNG_NMS
/* This needs some work */
	sfd = fopen(libname,"r");
	islngnms = 0;
    end = lsymsiz - 0;
#else
    end = lsymsiz;
#endif
    do {
        match = 0;
        for (len = LIBHDSIZE+2; len <= end; len += STE_SIZE) {
            GETSYM(sym,lfd,sfd,0);    /* Get a symbol */
            hptr = scancol(sym->n_name,hash(sym->n_name));
            if( hptr && *hptr->h_sym.n_name != 0 ) {
                if( hptr->h_sym.n_type & S_EXTERNAL ) {
                    if( hptr->h_sym.n_value != 0 )
                        continue;
                    match++;
                    getlfile(libname,rfd,sym->n_value,hptr->h_sym.n_name);
                }
            }
        }
        if (match)
            getlsymt(libname,lfd,1);    /* reset library */
    } while (match != 0 && cnt++ < THRESHOLD);
    if (cnt == THRESHOLD)
        printf(":(warning) %d passes through '%s' failed to resolve symbols\n",
            cnt,libname);
    fclose(lfd);
    fclose(rfd);
#ifdef LNG_NMS
    fclose(sfd);
#endif
    return(0);
}

#ifdef LNG_NMS
scanold(lfd,sfd)
register FILE *sfd;
#else
scanold(lfd)
#endif
register FILE *lfd;
{
    register struct libhdr *hdr;
    register struct hashel *hptr;
    register struct exec2 *fhd;
    register struct nlist *sym;
    register long loff, size, soff;
    struct nlist syms;
    struct exec2 fhdr;

    hdr = &lhdr;
    fhd = &fhdr;
    sym = &syms;

    fseek(lfd,2L,0);    /* Skip magic */

    loff = (long)(2 + LIBHDSIZE);
    while( GETARHD(lfd,hdr) != ERROR ) {
        if( *hdr->lfname == 0 ) {
            printf(":warning, empty member in archive %s\n",libname);
            continue;
        }
        else if( strcmp(hdr->lfname,"._SYMDEF") != 0 ) {
            GETCHD(lfd,fhd);
            fseek(lfd,fhd->a_text + fhd->a_data,1); /* Seek to symbols */
#ifdef LNG_NMS
    soff = ftell(lfd);  
    fseek(sfd,soff,0);
	islngnms = 1;
    GETSYM(sym,sfd,NULL,0);    /* Get a symbol */
    if (sym->n_name != -1 || sym->n_type != 0)
        islngnms = 0;
    else {
        fseek(sfd,soff+sym->n_value,0);
		GETSYM(sym,lfd,NULL,0);    /* Get past fake  symbol */
		fhd->a_syms = sym->n_value;
    }
#endif
            for (size = fhd->a_syms; size > 0; size -= STE_SIZE) {
                GETSYM(sym,lfd,sfd,0);    /* Get a symbol */
                if( GLOBAL(sym->n_type) ||
                        (COMMON(sym->n_type) && sym->n_value != 0) ) {
                    hptr = scancol(sym->n_name,hash(sym->n_name));
                    if( hptr && *hptr->h_sym.n_name != 0 &&
                            (hptr->h_sym.n_type&S_EXTERNAL) ) {
                        addflist(libname,(long)(loff - LIBHDSIZE));
                        fseek(lfd,loff,0);  /* Seek back to file hdr */
                        passone(hdr->lfname,lfd,hptr->h_sym.n_name,libname);
                        size = 0L;
                        break;
                    }
                }
            }
        }
        else
            printf(":warning, SYMDEF in non-random archive %s\n",libname);
        loff += hdr->lfsize;
        fseek(lfd,loff,0);
        loff += LIBHDSIZE;
    }
    fclose(lfd);
#ifdef LNG_NMS
    fclose(sfd);
#endif
    return(0);
}

getlfile(lname,libfd,offset,why)
char *lname;
register FILE *libfd;
register long offset;
char *why;
{
    register struct libhdr *hdr;
    register int add;

    hdr = &lhdr;
    offset += lsymsiz;
    fseek(libfd,offset,0);
    GETARHD(libfd,hdr);
    add = addflist(lname,offset);
    passone(hdr->lfname,libfd,why,lname);
    if( add ) {
        tsize = otsize;
        dsize = odsize;
        bsize = obsize;
    }
}

addflist(lname,offset)
char *lname;
long offset;
{
    register struct libfile *lfptr;

    lfptr = scanflist(symtab.f_lptr,lname,offset);  /* See if already there */
    if( lfptr->n_lptr == 0 ) {  /* If an empty entry OK */
        if( lfptr->plibname == 0 ) {
            lfptr->plibname = ALLOC(strlen(lname)+1);
            strcpy(lfptr->plibname,lname);
        }
        lfptr->offset = offset;
        lfptr->n_lptr = ALLOC(LFILSIZ); /* Allocate next entry */
        lfptr->l_text = tsize;
        lfptr->l_data = dsize;
        lfptr->l_bss = bsize;
        return(0);
    }
    otsize = tsize;
    odsize = dsize;
    obsize = bsize;
    tsize = lfptr->l_text;
    dsize = lfptr->l_data;
    bsize = lfptr->l_bss;
    return(-1);
}

struct libfile *
scanflist(list,lname,offset)
register struct libfile *list;
char *lname;
register long offset;
{
    register char *save, *not;

    not = save = 0;
    for( ; list->n_lptr != 0 && *list->plibname; list = list->n_lptr ) {
        if( list->plibname == not )
            continue;
        if( strcmp(list->plibname,lname) != 0 ) {
            not = list->plibname;
            continue;
        }
        if( list->offset == offset )
            return(list);
        save = list->plibname;
    }
    list->plibname = save;
    return(list);
}

lpass2(lname)
char *lname;
{
    register struct libfile *lptr;
    register FILE *lfd;
    register char *here;
    FILE *rfd, *sfd, *lnlfd;

    lfd = fopen(lname,"r");
#ifdef LNG_NMS
    lnlfd = fopen(lname,"r");
#endif

#ifdef FCNTL
    fcntl(fileno(lfd),F_SETFL,O_RANDOM);
#endif

    here = 0;
    rfd = NULL;
    for( lptr = symtab.f_lptr; lptr->offset != 0; lptr = lptr->n_lptr ) {
        if( here == lptr->plibname || strcmp(lname,lptr->plibname) == 0 ) {
            if( lptr->offset == -1 )    /* already did this file */
                continue;
            fseek(lfd,lptr->offset,0);
            GETARHD(lfd,&lhdr);
            if( rfd == NULL ) {
#ifdef OPENFD
                rfd = newopen(lfd);
                sfd = newopen(lfd);
#else
                rfd = fopen(lname,"r");
                sfd = fopen(lname,"r");
# ifdef FCNTL
                fcntl(fileno(rfd),F_SETFL,O_RANDOM);
                fcntl(fileno(sfd),F_SETFL,O_RANDOM);
# endif
#endif
            }
            relocate(lptr->plibname,lfd,rfd,sfd,lptr->offset+LIBHDSIZE,
					 lhdr.lfname,lnlfd);
            lptr->offset = -1;
            here = lptr->plibname;
        }
    }
    fclose(lfd);
#ifdef LNG_NMS
    fclose(lnlfd);
#endif
    if( rfd != NULL ) {
        fclose(rfd);
        fclose(sfd);
    }
}
