/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)getsym.c	2.3    1/15/85
*/

#include "loader.h"
#include "lx68.h"

#ifdef FILE_TEST
#undef fopen
#undef fclose

FILE *
tfopen(fname,modes)
char *fname, *modes;
{
	FILE *fp;

	if ((fp = fopen(fname,modes)) == NULL)
		printf("fopen of [%s] mode [%s] failed\n",fname,modes);
	else
		printf("fopen of [%s] fdes is %d\n",fname,fileno(fp));
	return(fp);
}

tfclose(fp)
FILE *fp;
{
	printf("fclose of fdes %d\n",fileno(fp));
	fclose(fp);
}
#endif

#ifdef LCL_SYM_ROUT

#ifndef LNG_NMS
#	define GSYMLEN S_SYMLEN
#else
#	define GSYMLEN 8
#endif

getsym(symptr,fp)
register struct nlist *symptr;
FILE *fp;
{
	register char *p;
	register int i;

	SYMALLOC(symptr->n_name,GSYMLEN+1);
	for (p = symptr->n_name, i = GSYMLEN; --i != -1; )
		if( (*p++ = getc(fp)) == EOF )
			return(_FAILURE);
#ifdef LNG_NMS
	*(symptr->n_name+GSYMLEN) = '\0';
#endif
	if( lgetw(&symptr->n_type,fp) == EOF )
		return(_FAILURE);
	if( lgetl(&symptr->n_value,fp) == EOF )
		return(_FAILURE);
	return(STE_SIZE);
}

putsym(symptr,fp)
register struct nlist *symptr;
FILE *fp;
{
	register char *p;
	register int i;

	for( p = symptr->n_name, i = S_SYMLEN; --i != -1; )
		putc(*p++,fp);
	lputw(&symptr->n_type,fp);
	lputl(&symptr->n_value,fp);
}
#endif

#ifdef LNG_NMS

getlsym(symptr,fp,sfp,ssoff)
register struct nlist *symptr;
FILE *fp, *sfp;
long ssoff;		/* If seek for symbol (non-zero field), sym space offset */
{
	register char *p;
	char symarray[S_SYMLEN];
	long symoff;
	short symlen;

	 if (!islngnms) 
		return(getsym(symptr,fp));

	if (lgetl(&symoff,fp) == EOF)
		return(_FAILURE);

	if (feof(fp))
		return(_FAILURE);

	if (sfp != NULL) {
		if (ssoff != 0)		/* Seek required to find symbol */
			fseek(sfp,ssoff+symoff,0);
		p = symarray;
		symlen = 0;
		do {
			symlen++;
			if ((*p++ = getc(sfp)) == EOF)
				return(_FAILURE);
		} while (*(p-1) != '\0');
		SYMALLOC(p,(int)symlen);
		symptr->n_name = p;
		symcpy(p,symarray);
	}
	else {
		symptr->n_name = symoff;
	}
	if( lgetw(&symptr->n_type,fp) == EOF )
		return(_FAILURE);
	if( lgetl(&symptr->n_value,fp) == EOF )
		return(_FAILURE);
	return(STE_SIZE);
}

putlsym(symptr,fp,ofp)
register struct nlist *symptr;
FILE *fp, *ofp;
{
	register char *p;
	long symlen;

	if (ofp != NULL) {
		symlen = strlen(symptr->n_name) + 1;
		for (p = symptr->n_name; *p; )
			putc(*p++,ofp);
		putc('\0',ofp);
		symindex += symlen;
	}
	else
		symindex = symptr->n_name;
	lputl(&symindex,fp);
	lputw(&symptr->n_type,fp);
	lputl(&symptr->n_value,fp);
}
#endif
