/*
	Copyright 1982
	Alcyon Corporation
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)doread.c	2.2    7/27/84
*/

#include <stdio.h>

#ifdef MC68000
fread(ptr, size, nitems, fp)
register char *ptr;
register int size, nitems;
register FILE *fp;
{
	register int cnt, s;

	if( (fp->_flag&(_RMODE|_UPDATE)) == 0 || feof(fp) )
		return(NULL);

	for( cnt = nitems; --cnt != -1; ) {
		if( --fp->_nleft < 0 ) {
			if( (*ptr++ = _fillbuf(fp)) == EOF )
				return(NULL);
		}
		else
			*ptr++ = *fp->_nextp++&0377;
	}
	return(nitems);
}

fwrite(ptr, size, nitems, fp)
register char *ptr;
register int size, nitems;
register FILE *fp;
{
	register int cnt, s;

	if( (fp->_flag&(_WMODE|_UPDATE|_APPEND)) == 0 )
		return(NULL);

	for( cnt = nitems; --cnt != -1; ) {
		if( --fp->_nleft >= 0 )
			*fp->_nextp++ = *ptr++;
		else if( _flushbuf(*ptr++,fp) == EOF )
			return(nitems-cnt);
	}
	return(nitems);
}
#endif
