/*
    Copyright 1983
    Alcyon Corporation
    8716 Production Ave.
    San Diego, CA  92121

    @(#)qsort.c	2.1 7/10/84
*/

static int  (*_do_cmp)();
static int  _qs_elwd;
static int _qsort1;

qsort(base, nel, width, compar)
char *base;
int nel, width;
int (*compar)();
{

    _do_cmp = compar;
    _qs_elwd = width;
    _qsort1(base, base+nel*width);
}

static int _qsort1(ladr, hadr)
char *ladr, *hadr;
{
    register char *ptr1, *ptr2;
    char *loptr, *hiptr;
    register int t;
    register int elwidth;


    elwidth = _qs_elwd;

toplp:
    t = hadr - ladr;    //length of array of elements
    if(t <= elwidth)
        return;


    t = ((t/(2*elwidth))*elwidth) & 0x7fff; //half-way & positive
    hiptr = loptr = ladr+t;
    ptr1 = ladr;
    ptr2 = hadr-elwidth;


    while(1) {
        if(ptr1 < loptr) {
            if((t = (*_do_cmp)(ptr1, loptr)) == 0) {
                loptr -= elwidth;
                _qs_exchg(ptr1, loptr);
                continue;
            }
            if(t < 0) {
                ptr1 += elwidth;
                continue;
            }
        }

innrlp:
        if(ptr2 > hiptr) {
            if((t = (*_do_cmp)(hiptr, ptr2)) == 0) {
                hiptr += elwidth;
                _qs_exchg(hiptr, ptr2);
                goto innrlp;
            }
            if(t > 0) {
                if(ptr1 == loptr) {
                    hiptr += elwidth;
                    _qs_3exchg(ptr1, hiptr, ptr2);
                    ptr1 = loptr += elwidth;
                    goto innrlp;
                }
                _qs_exchg(ptr1, ptr2);
                ptr2 -= elwidth;
                ptr1 += elwidth;
                continue;
            }
            ptr2 -= elwidth;
            goto innrlp;
        }


        if(ptr1 == loptr) {
            if(loptr-ladr >= hadr-hiptr) {
                _qsort1(hiptr+elwidth, hadr);
                hadr = loptr;
            } 
			else {
                _qsort1(ladr, loptr);
                ladr = hiptr+elwidth;
            }
            goto toplp;
        }


        loptr -= elwidth;
        _qs_3exchg(ptr2, loptr, ptr1);
        hiptr -= elwidth;
        ptr2 = hiptr;
    }
}

static _qs_exchg(el1, el2)
register char *el1, *el2;
{
    register char c;
    register int n;

    n = _qs_elwd;
    do {
        c = *el1;
        *el1++ = *el2;
        *el2++ = c;
    } while(--n);
}

static _qs_3exchg(el1, el2, el3)
register char *el1, *el2, *el3;
{
    register char c;
    register int    n;

    n = _qs_elwd;
    do {
        c = *el1;
        *el1++ = *el3;
        *el3++ = *el2;
        *el2++ = c;
    } while(--n);
}
