	title	'MEX overlay for TurboDOS'
;
; MXO-TU13.ASM -- MEX Overlay file for TurboDOS operating system  12/20/84
;
rev	equ	13	;V 1.3
;
; Copyright (C) 1984,1985 by NightOwl Software, Inc.
;
; This overlay adapts the MEX modem program to the TurboDOS operating system,
; using the communications channel system calls.  It suports the SET-BAUD
; and SET-PORT commands, and assumes the existance of a communicatons driver
; (COMMGR) module in the operating system.  Also supported is the use of
; remote network channels ("set remote", "set local") ... the network ad-
; dress of the remote processor is the one defined in your processor's
; DEFDID variable.
;
;
; This overlay is capable of setting baud rate and setting port number
; (via the SET command) and setting baud rate from the phone library.
; Disconnect (via DTR modem control) is also supported).
;
; It is strongly recommended that your modem port be fully interupt-driven,
; utilizing queues of at least 134 bytes in length.
; 
;
; This overlay is configured for the TurboDOS 1.3 system calls (through
; location 50H).  If you're running prior releases of TurboDOS, you might try
; patching the OLDVER variable (at the end of the file) non-zero; note that
; this is NOT tested, since we don't run TurboDOS versions prior to 1.30
; (and therefore, have no way of supporting the OLDVER variable, if you have
; problems with it).
;
; Calling conventions for the various overlay entry points are detailed more
; fully in the PMMI overlay (MXO-PMxx.ASM, where xx=revision number).
;
; History
;
; 07/14/85 - Removed TCON timing junk, since timing has been repaired
;	     in MexPlus.  Also ditched IDELAY (that was for debugging,
;	     don't know why it was still there).  Added DCD and RNGDET
;	     routines for MexPlus version 1.40, added SET DTR ON/OFF.
;						- RGF / NightOwl Software
;
; 10/20/84 - Renamed to MXO-TU12 to avoid confusion
;	     with the existing (and not fully generic)
;	     TD30 overlay.			 - RGF for NightOwl Software
; 07/10/84 - Added SET TCON		         - RGF
; 05/21/84 - Added SET LOCAL/REMOTE (not tested) - RGF
; 05/12/84 - TurboDOS overlay 1.0	         - RGF
;
;
; MEX service processor stuff
;
mex	equ	0d00h		;address of the service processor
inmdm	equ	255		;get char from port to A, CY=no more in 100 ms
timer	equ	254		;delay 100ms * reg B
tmdinp	equ	253		;B=# secs to wait for char, cy=no char
chekcc	equ	252		;check for ^C from KBD, Z=present
sndrdy	equ	251		;test for modem-send ready
rcvrdy	equ	250		;test for modem-receive ready
sndchr	equ	249		;send a character to the modem (after sndrdy)
rcvchr	equ	248		;recv a char from modem (after rcvrdy)
lookup	equ	247		;table search: see CMDTBL comments for info
parsfn	equ	246		;parse filename from input stream
bdpars	equ	245		;parse baud-rate from input stream
sblank	equ	244		;scan input stream to next non-blank
evala	equ	243		;evaluate numeric from input stream
lkahed	equ	242		;get nxt char w/o removing from input
gnc	equ	241		;get char from input, cy=1 if none
ilp	equ	240		;inline print
decout	equ	239		;decimal output
prbaud	equ	238		;print baud rate
prntbl	equ	237		;print table
prid	equ	236		;print [MEX] ID string
onoff	equ	235		;parse on/off (A=0 OR 1) CY=ERR
;
print	equ	9		;BDOS/MEX print-string function call
;
bell	equ	7		;bell
tab	equ	9
cr	equ	13		;carriage return
lf	equ	10		;linefeed
esc	equ	1bh		;escape
yes	equ	0ffh
no	equ	0
;
; TurboDOS system equates
; 
bdos	equ	5		;1.3 C-function system entry (1.1 all)
bdost	equ	50h		;1.3 T-function system entry
;
; TurboDOS 1.3 system call equates
;
delay	equ	2		;delay process
cchsts	equ	34		;Comms channel status
cchin	equ	35		;Comms channel input
cchout	equ	36		;Comms channel output
cchsbr	equ	37		;Comms channel set-baudrate
cchrbr	equ	38		;Comms channel return-baudrate
cchsmc	equ	39		;Comms channel set-modem-controls
cchrmc	equ	40		;Comms channel return-modem-controls
;
;
	org	100h
;
; Change the clock speed to suit your system
;
	db	0c3h
	ds	2		;(for  "JMP   START" instruction)

	db	no		;yes=PMMI S-100 Modem
	db	no		;yes=HAYES Smartmodem, no=non-PMMI
	db	'T'		;T=touch, P=pulse (Smartmodem-only)
clock:	db	50		;clock speed in MHz x10, 25.5 MHz max.
				;20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
mspeed:	db	5		;0=110 1=300 2=450 3=600 4=710 5=1200
				;6=2400 7=4800 8=9600 9=19200 default
bytdly:	db	1		;0=0 delay  1=10ms  5=50 ms - 9=90 ms
				;default time to send character in ter-
				;minal mode file transfer for slow BBS.
crdly:	db	1		;0=0 delay 1=100 ms 5=500 ms - 9=900 ms
				;default time for extra wait after CRLF
				;in terminal mode file transfer
colums:	db	5		;number of DIR columns shown
setflg:	db	yes		;yes=user-added Setup routine
scrtst:	db	yes		;Cursor control routine
	db	yes		;yes=resend a record after any non-ACK
				;no=resend a record after a valid-NAK
bakflg:	db	yes		;yes=change any file same name to .BAK
crcdfl:	db	yes		;yes=default to CRC checking
togcrc:	db	yes		;yes=allow toggling of CRC to Checksum
cvtbs:	db	no		;yes=convert backspace to rub
toglbk:	db	yes		;yes=allow toggling of bksp to rub
addlf:	db	no		;no=no LF after CR to send file in
				;terminal mode (added by remote echo)
toglf:	db	yes		;yes=allow toggling of LF after CR
	db	yes		;yes=allow transmission of logon
				;write logon sequence at location LOGON
savccp:	db	no		;yes=do not overwrite CCP
	db	no		;yes=local command if EXTCHR precedes
				;no=external command if EXTCHR precedes
	db	yes		;yes=allow toggling of LOCONEXTCHR
lsttst:	db	yes		;yes=printer available on printer port
xoftst:	db	no		;yes=checks for XOFF from remote while
				;sending a file in terminal mode
xonwt:	db	no		;yes=wait for XON after CR while
				;sending a file in terminal mode
togxof:	db	yes		;yes=allow toggling of XOFF checking
ignctl:	db	no		;yes=CTL-chars above ^M not displayed
extra1:	db	0		;for future expansion
exitchr	db	'E'-40h		;^E = Exit to main menu
brkchr:	db	'@'-40h		;^@ = Send 300 ms. break tone
noconn:	db	'N'-40h		;^N = Disconnect from the phone line
logchr:	db	'L'-40h		;^L = Send logon
lstchr:	db	'P'-40h		;^P = Toggle printer
unsave:	db	'R'-40h		;^R = Close input text buffer
trnchr:	db	'T'-40h		;^T = Transmit file to remote
savchr:	db	'Y'-40h		;^Y = Open input text buffer
extchr:	db	'^'-40h		;^^ = Send next character
	ds	2		;unused by MEX
;
inctl1:	jmp	justrt		;input status port
	ds	7
otdata:	jmp	outdp		;go output data port
	ds	7
inport:	jmp	indp		;go input data port
	ds	7
;
; Jump table #1
;
	jmp	justrt		;mask receive bit (not done here)
	jmp	instat		;return z=1 if receive rdy
	jmp	justrt		;mask send bit (not done here)
	jmp	otstat		;return z=1 if send ready
	jmp	dcdtst		;return carrier-detect
	jmp	rngtst		;return ring-detect
	db	0,0,0,0,0	;reserved (assumed 0)
;
	ds	3		;SMDISC: done in Smartmodem overlay
	ds	3		;DIALV:  done in Smartmodem overlay
	jmp	discon		;hardware disconnect
	jmp	goodby		;exit to O/S: called just before exit
	jmp	nitmod		;modem initialization
	jmp	pbaud		;change baud-rate
	jmp	justrt		;select no-parity
	jmp	justrt		;select parity
	jmp	setcmd		;SET command
	ds	3		;not used by MEX
	jmp	sysver		;print overlay ID string
	jmp	sbreak		;send break
;
; Some MODEM7 stuff that we don't support
;
	ds	36
;
; Screen clear routines.  No longer supported here, since
; mexplus now has a terminal overlay.  
;
	ds	9		;clear screen
	ds	9		;clear to end-of-screen
;
; end of fixed area: from here to 200H is reserved
;

	org	200h
;
sysver:	mvi	c,ilp		;in-line print
	call	mex
	db	'TurboDOS Overlay v'
	db	rev/10+'0'
	db	'.'
	db	rev mod 10+'0'
	db	cr,lf,0
justrt:	ret
;
; Routine to exit just prior to exit-to-cpm
;
goodby:	lda	baud		;get baud-rate code
	mov	b,a		;save it in B
	lda	flags		;combine baud and flags
	ora	b		;(restores flags to original values)
	mov	e,a		;code to E
	mvi	c,cchsbr	;set baud-rate function code
	call	turcom
	ret
;
; Send break to remote
;
sbreak:	ret			;not supported
;
; Disconnect the modem
;
discon:	push	h
	push	d
	push	b
	xra	a		;all control bits off
	call	putdtr
	lhld	dtrdly		;get DTR delay factor
	xchg			;to DE
	mvi	c,delay		;delay for that amount
	call	turcom
	mvi	a,0C0H		;turn DTR back on
	call	putdtr
	pop	b
	pop	d
	pop	h
	ret
;
; Initialize the port; either set an initial baud rate, or (if
; your system is capable of it) query the current rate and set
; MSPEED value.
;
nitmod:	push	h		;stack 'em all
	push	d
	push	b
	mvi	c,cchrbr	;get return-baud function code
	call	turcom
	push	psw		;save it
	ani	0f0h		;get flags
	sta	flags		;save 'em
	pop	psw		;recall baud/flags
	ani	0fh		;isolate baudrate
	sta	baud		;save baudrate code
	lxi	h,baudtb	;offset into MSPEED table
	call	addha
	mov	a,m		;fetch MSPEED
	cpi	0ffh		;invalid?
	jz	nitm1		;jump if so
	sta	mspeed		;no, it's valid
	call	sbaud		;set it
nitm1:	mvi	a,40h		;turn DTR on
	call	putdtr
	pop	b
	pop	d
	pop	h
	ret
;
; Set current baud rate
;
sbaud:	lda	baud		;re-set baud with our flags
	mov	e,a		;code to E with flags=0
	mvi	c,cchsbr	;get function code
	call	turcom		;do it
	ret
;
; SET command: select baud rate, port number. Port number may be any of
; 0,1,2,3,4,5,6,7,S  (S=SS1), baud rate any of 300, 600, 1200, 4800
; 9600, 19200.  Special set-port syntax allows baud rate after port
; number.  Examples:
;
;	SET PORT 3
;	SET PORT 5 1200
;	SET PORT S 300
;	SET BAUD 9600
;
setcmd:	mvi	c,sblank	;any arguments?
	call	mex
	jc	tell		;if not, go display port/baud
	lxi	d,cmdtbl
	mvi	c,lookup
	call	mex		;parse argument
	push	h		;save any parsed argument adrs on stack
	rnc			;if we have one, return to it
	pop	h		;oops, input not found in table
seterr:	mvi	c,ilp		;inline print
	call	mex
	db	cr,lf,'SET command error',cr,lf,0
	ret
;
; Argument table
;
cmdtbl:	db	'?'+80h		;help
	dw	sthelp
	db	'BAU','D'+80h	;"set baud"
	dw	stbaud
	db	'DT','R'+80h	;"set dtr"
	dw	setdtr
	db	'POR','T'+80h	;"set port"
	dw	setpor
	db	'REMOT','E'+80h	;"set remote"
	dw	setrem
	db	'LOCA','L'+80h	;"set local"
	dw	setloc
	db	'WIN','K'+80h	;"set wink"
	dw	swink
;
	db	0		;<<=== table terminator
;
; "SET ?" processor
;
sthelp:	mvi	c,ilp		;inline print
	call	mex
	db	cr,lf,'SET BAUD <rate>'
	db	cr,lf,'SET DTR <"ON"> | <"OFF">'
	db	cr,lf,'SET PORT <port-number>'
	db	cr,lf,'SET REMOTE'
	db	cr,lf,'SET LOCAL'
	db	cr,lf,'SET WINK <value>'
	db	cr,lf
	db	cr,lf,'Baud rate is one of:'
	db	cr,lf,'  110 300 600 1200 2400 4800 9600 19200'
	db	cr,lf,0
	ret
;
; "SET WINK"
;
swink:	mvi	c,sblank	;got an arg?
	call	mex
	jc	twink		;if not, go show wink value
	mvi	c,evala		;get numeric arg
	call	mex
	jc	seterr		;error out if bad arg
	shld	dtrdly		;no, set it
twink:	mvi	c,ilp
	call	mex
	db	cr,lf,'discon drop-DTR (wink) time: ',0
	lhld	dtrdly
	mvi	c,decout
	call	mex
	call	crlf
	ret
;
; "SET DTR" processor
;
setdtr:	mvi	c,sblank	;empty command line?
	call	mex
	jc	shdtr		;to tell DTR if so
	mvi	c,onoff
	call	mex
	jc	seterr		;if bad spec, error out
	rrc			;move bit to position 40H
	rrc
	call	putdtr
shdtr:	call	dtrtel
	call	crlf
	ret
;
dtrtel:	mvi	c,ilp
	call	mex
	db	cr,lf,'DTR is ',0
	lda	dtrsav		;get dtr value
	ani	40h		;test it
	mvi	c,ilp		;get print function
	jz	dtoff
	call	mex
	db	'ON',0
	ret
dtoff:	call	mex
	db	'OFF',0
	ret
;
; send DTR flags in A to Tdos serial driver
;
putdtr:	sta	dtrsav		;save state
	mov	e,a		;to E as arg
	mvi	c,cchsmc	;set modem controls
	call	turcom
	ret
;
dtrsav:	ds	1
;
; "SET BAUD" processor
;
stbaud:	mvi	c,sblank	;any args?
	call	mex
	jnc	nobsho		;jump if so
	call	bdshow		;no, tell current baudrate
	call	crlf		;newline and exit
	ret
nobsho:	jc	showit		;if none, just go display
	mvi	c,bdpars	;function code: parse a baudrate
	call	mex		;let MEX look up code
	jc	seterr		;jump if invalid code
	call	pbaud		;no, try to set it
	jc	seterr		;if not one of ours, bomb out
showit:	call	bdshow
crlf:	mvi	c,ilp
	call	mex
	db	cr,lf,0
	ret
;
bdshow:	mvi	c,ilp		;inline print
	call	mex		;display baud
	db	'Rate: ',0
	lda	mspeed		;get current baud rate
	mvi	c,prbaud	;let MEX print it
	call	mex
	ret
;
; SET PORT processor
;
setpor:	mvi	c,sblank	;scan to argument
	call	mex
	jc	pinfo		;if no arg, go display port #
	mvi	c,gnc		;else consume it
	call	mex
	sui	'0'		;convert
	jc	seterr
	cpi	9+1		;0-9
	jnc	seterr
	push	psw		;save the port #
	call	goodby		;restore the old port
	pop	psw		;recall the new
	sta	port
	call	nitmod		;set up baud rate, etc
	mvi	c,sblank	;any thing more?
	call	mex
	jnc	stbaud		;if so, go parse as baud rate
pinfo:	call	shport
	call	crlf
	ret
;
; SET with no arguments
;
tell:	call	shport		;show port information
	call	dtrtel
	call	twink
	ret
;
; Set REMOTE/LOCAL
;
setrem:	mvi	a,80h
	jmp	setrl
;
setloc:	xra	a
setrl:	sta	remflg
	jmp	telrem
;
; display port information
;
shport:	mvi	c,ilp
	call	mex
	db	cr,lf,'Port: ',0
	lda	port		;get port #
	adi	'0'		;get port # in ASCII
	sta	portas
	mvi	c,ilp
	call	mex
portas:	db	'    ',0
	call	bdshow
telrem:	mvi	c,ilp		;display remote/local
	lda	remflg
	ora	a
	jz	telloc		;jump if local
	call	mex		;remote
	db	' (Remote',0
	jmp	tellr2
telloc:	call	mex
	db	'  (Local',0
tellr2:	mvi	c,ilp
	call	mex
	db	' channel)',0
	ret
;
; This routine sets baud rate passed as MSPEED code in A.
; Returns CY=1 if baud rate not supported (if supported,
; this routine must set the new MSPEED code).
;
pbaud:	push	h		;don't alter anybody
	push	d
	push	b
	mov	e,a		;MSPEED code to DE
	mvi	d,0
	lxi	h,baudc		;offset into table
	dad	d
	mov	a,m		;fetch code
	ora	a		;0? (means unsupported code)
	stc			;prep carry in case unsupported
	jz	pbexit		;exit if bad
	sta	baud		;no, save it
	mov	a,e		;get MSPEED code back
	sta	mspeed		;set it
	call	sbaud		;set rate
	ora	a		;return no-errors
pbexit:	pop	b
	pop	d
	pop	h
	ret
;
; This table maps baud-rate to MSPEED values.  Rates
; not supported by MEX have entries of 0FFH.
;
baudtb:	db	0ffh		;50    (not supported)
	db	0ffh		;75    (not supported)
	db	0		;110
	db	0ffh		;134.5 (not supported)
	db	0ffh		;150   (not supported)
	db	1		;300
	db	3		;600
	db	5		;1200
	db	0ffh		;1800  (not supported)
	db	0ffh		;2000  (not supported)
	db	6		;2400
	db	0ffh		;3600  (not supported)
	db	7		;4800
	db	0ffh		;7200  (not supported)
	db	8		;9600
	db	9		;19200
;
; This table maps MSPEED codes to TurboDOS baudrate codes
;
baudc:	db	2		;110
	db	5		;300
	db	0		;450 (not supported)
	db	6		;600
	db	0		;710 (not supported)
	db	7		;1200
	db	10		;2400
	db	12		;4800
	db	14		;9600
	db	15		;19200
;
;	Port access routines
;
; Input data port
;
indp:	call	instat		;anything from port?
	jz	indp1		;jump if so
	lda	last		;nope, return last char input
	ret
indp1:	push	h		;save 'em
	push	d
	push	b
	mvi	c,cchin		;get function code
	call	turcom		;get character
	sta	last		;save it
	pop	b
	pop	d
	pop	h
	ret
;
; Input status: returns Z=1 if ready
;
instat:	push	h		;save 'em all
	push	d
	push	b
	mvi	c,cchsts	;get function code
	call	turcom
	pop	b
	pop	d
	pop	h
	ora	a		;anything waiting?
	jz	instno		;jump if not
	xra	a		;yep, twist Z flag
	ret
instno:	ori	0ffh
	ret
;
; Output status
;
otstat:	xra	a		;always TRUE for send
	ret
;
; Output data port
;
outdp:	push	h		;out data-port
	push	d
	push	b
	push	psw
	mov	e,a		;char goes in E
	mvi	c,cchout	;get function code
	call	turcom		;do it
	pop	psw
	pop	b
	pop	d
	pop	h
	ret
;
; Following are two new entry points for MEXPLUS. DCDTST re-
; turns data-carrier detect in A: 0 if no carrier present, 0FFH
; if carrier is present, and 0FEH if overlay doesn't know (ie,
; it doesn't support carrier detect). RNGDET works similarly
; for ring-detect.
;
; ring-detect check.  Return A=0 if not ringing, 
; A=255 if ringing, A=254 if don't-know
;
rngtst:	mvi	b,10H		;bit mask for ring-detect
	jmp	dcdcom		;go join common code
;
dcdtst:	mvi	b,20H		;bit mask for data-carrier-detect
dcdcom:	push	b		;save bit mask
	mvi	c,cchrmc	;func code #40: get modem status
	call	turcom		;call COMMS handler
	pop	b		;recall bit mask
	ana	b		;reset non dcd (or rngdet) bits
	rz			;exit if condition not present
	ori	0ffh		;else set true
	ret			;a=0 if condition not true
;
; Call TurboDOS Comms handler
;
turcom:	lda	port		;get channel #
	mov	d,a		;passed in D
	lda	remflg		;add remote/local flag
	ora	d
	mov	d,a
	lda	oldver		;get TurboDOS version #
	ora	a		;1.1/1.2?
	jz	bdost		;jump if not to 50H call
	mov	a,c		;yes, fix function code
	adi	53
	mov	c,a
	call	bdos		;old versions used CALL 5
	ret
;
; Add A to HL
;
addha:	add	l
	mov	l,a
	rnc
	inr	h
	ret
;
;	Data Area
;
port:	db	1		;initial port #
baud:	ds	1		;baud-rate
flags:	ds	1		;attn-det/CTS/input-disabled flags
oldver:	db	0		;1=pre-1.3 TurboDOS system
remflg:	db	0		;remote/local flag
last:	db	0		;most recent character input
itime:	db	0
dtrdly:	dw	30		;DTR delay (in system ticks) .5 sec
;
; Clear-to-end-of-screen and clear-screen sequences
;
eosmsg:	db	esc,'T','$'
clsmsg:	db	26,'$'
;
;
	end
                  