;
; Animation avec une frame en mode "compact"
;
; Source  utiliser avec un export de Make3DFrame
;
; Code par DEMONIAK - 07/04/2006
;

        ORG     #200

        Nolist

        DI
Debut:
        LD      IX,TabIndex             ; Tableau d'index des frames
BclFram:
        LD      H,(IX+1)
        LD      L,(IX+0)                ; Rcupre pointeur frame
        LD      A,H
        OR      L                       ; Plus de frames ?
        JR      Z,Debut                 ; On reboucle
        LD      SP,HL                   ; SP = pointeur frame

        LD      BC,#7F10                ; Juste
        LD      A,#54                   ; Pour mesurer
        OUT     (C),C                   ; Le temps d'affichage
        OUT     (C),A                   ; D'une frame

        LD      B,#F5
Sync:
        IN      A,(C)
        RRA
        JR      NC,SYNC                 ; Attendre la vbl

        LD      BC,#7F10                ; Juste
        LD      A,#4B                   ; Pour mesurer
        OUT     (C),C                   ; Le temps d'affichage
        OUT     (C),A                   ; D'une frame

        LD      B,#C0                   ; Utilis comme masque
DrawFram:
        POP     HL                      ; Rcupre adresse octet
        LD      A,H
        OR      L                       ; Si == 0
        JR      Z,FinFram               ; c'est que la frame est termine
        LD      A,H
        AND     B                       ; Rcup. seulement 2 bits de poids forts
        RLCA
        RLCA
        RLCA
        RLCA                            ; Transform en 0, 4, 8 ou 12
        LD      (NbOct+1),A             ; Adresse relative pour le JR
        LD      A,H
        OR      B                       ; Si adresse dbut = #C000
        LD      H,A
NbOct:
        JR      NbOct                   ; #00, #04, #08 ou #0C
        DEC     SP                      ; si JR #00
        POP     AF
        LD      (HL),A
        INC     HL
        DEC     SP                      ; si JR #04
        POP     AF
        LD      (HL),A
        INC     HL
        DEC     SP                      ; si JR #08
        POP     AF
        LD      (HL),A
        INC     HL
        DEC     SP                      ; si JR #0C
        POP     AF
        LD      (HL),A
        JR      DrawFram
FinFram:
        INC     IX                      ; Passer  la frame suivante
        INC     IX
        JR      BclFram

;
; Inclure ici le fichier .ASM gnr par Make3DFrame
;
; Exemple 
        read    "StarFieldCmp.asm"
;

        list
_fin: