/* zcndisk - does file ops etc. on a ZCN drive image */

#include <stdio.h>
#include <string.h>

long getfilesize();
long getdword();

char diskfile[1024];
int drive=0,user=0;
int card_size=0;
int drive_valid[4]={1,0,0,0};
int drive_formatted[4]={0,0,0,0};


unsigned char card[1024*1024];


main()
{
strcpy(diskfile,"nc100.card");
readcard_and_init();
titlescreen();
shellmode();
writecard();
exit(0);
}


long getfilesize(fname)
char *fname;
{
FILE *in;
long filesz;

if((in=fopen(fname,"rb"))==NULL)
  return(-1);
fseek(in,(long)0,SEEK_END);
filesz=ftell(in);
fclose(in);
return(filesz);
}


int is_zcn_fmt(drv)
int drv;
{
return(strncmp(card+drv*256*1024+2,"ZCN1",4)==0);
}



/* this also does init stuff like checking drives */
readcard_and_init()
{
FILE *in;
int f;

if((in=fopen(diskfile,"rb"))!=NULL)
  {
  card_size=fread(card,1024,1024,in);
  fclose(in);
  }
else
  {
  printf("Couldn't load PCMCIA memory card file '%s'.\n",diskfile);
  exit(1);
  }

if(card_size<32)
  {
  printf("Card must be at least 32k!\n");
  exit(1);
  }

/* work out which drives of a: b: c: d: are valid */
drive_valid[0]=1;
if(card_size>256) drive_valid[1]=1;
if(card_size>512) drive_valid[2]=1;
if(card_size>768) drive_valid[3]=1;

/* see which are formatted */
for(f=0;f<4;f++)
  if(drive_valid[f] && is_zcn_fmt(f))
    drive_formatted[f]=1;
}


writecard()
{
FILE *out;

if((out=fopen(diskfile,"wb"))!=NULL)
  {
  if(fwrite(card,1024,card_size,out)!=card_size)
    printf("Couldn't write all of card!\n");
  fclose(out);
  }
else
  {
  printf("Couldn't write PCMCIA memory card file '%s'.\n",diskfile);
  exit(1);
  }
}



titlescreen()
{
printf("\nZcndisk v1.0 - (c) 1996 Russell Marks\n");
printf(" ZCN disk image file being used is '%s'.\n",diskfile);
printf("Commands: (all can be abbreviated to one letter)\n");
printf(" a:	(or b:, etc.) change current drive\n");
printf(" user	change current user area\n");
printf(" dir    show directory of virtual ZCN drive\n");
printf(" ls     show directory of Unix fs\n");
printf(" get    get file from disk to Unix   (you'll then be prompted for the filename)\n");
printf(" put    put file from Unix onto DOS (as above)\n");
printf(" format	format the specified drive\n");
printf(" rm     remove (delete) file from virtual disk\n");
printf(" zero	zero out blank space (for better gzipping of card, etc.)\n");
printf(" quit   exit zcndisk\n\n");

printf("card is %dk\nvalid drives are a: ",card_size);
if(drive_valid[1]) printf("b: ");
if(drive_valid[2]) printf("c: ");
if(drive_valid[3]) printf("d: ");

if(drive_formatted[0] || drive_formatted[1] || drive_formatted[2] || 
    drive_formatted[3])
  {
  printf("\nformatted drives are ");
  if(drive_formatted[0]) printf("a: ");
  if(drive_formatted[1]) printf("b: ");
  if(drive_formatted[2]) printf("c: ");
  if(drive_formatted[3]) printf("d: ");
  }

printf("\n\n");
}


shellmode()
{
int quit;
char inpline[256];

quit=0;
while(!quit)
  {
  putchar('A'+drive);
  if(user) printf("%d",user);
  putchar('>');
  fflush(stdout);
  
  inpline[0]=0;
  while(inpline[0]==0) gets(inpline);
  
  if(inpline[0]!=0 && inpline[1]==':')
    {
    drive=((tolower(inpline[0])-'a')&3);
    continue;
    }
  
  switch(tolower(inpline[0]))
    {
    case 'd':
      do_dir(); break;
    case 'g':
      printf("File to get? >");
      gets(inpline);
      getfile(inpline);
      break;
    case 'p':
      printf("File to put? >");
      gets(inpline);
      putfile(inpline);
      break;
    case 'r':
      printf("File to remove? >");
      gets(inpline);
      deletefile(inpline);
      break;
    case 'l':
      system("ls -l");
      break;
    case 'f':
      printf("Drive to format? >");
      gets(inpline);
      formatdrive(tolower(inpline[0])-'a');
      break;
    case 'u':
      printf("User? >");
      gets(inpline);
      user=(atoi(inpline)&15);
      break;
    case 'z':
      zeroblank();
      break;
    case 'q':
      quit=1; break;
    default:
      printf("Command not recognised\n");
    }
  }
}


unsigned char *matchfcb(name83,anyeras,extent)
char *name83;	/* FILENAMEEXT :-) - 11-char uppercase */
int anyeras;	/* match any available entry */
int extent;	/* extent to match */
{
unsigned char *drvptr;	/* ptr to drive */
unsigned char *dirptr;	/* ptr to first entry */
unsigned char *ptr;	/* ptr to current entry */
int nument;	/* num. dir. entries */
int f;

if(!drive_valid[drive] || !drive_formatted[drive]) return(NULL);

drvptr=card+256*1024*drive;
dirptr=drvptr+1024*(1+drvptr[8]);
nument=drvptr[9]*32;

for(f=0;f<nument;f++,dirptr+=32)
  {
  if(anyeras && dirptr[0]==0xe5)
    return(dirptr);
  if(!anyeras && dirptr[0]==user && strncmp(dirptr+1,name83,11)==0 &&
      (dirptr[12]==extent || extent==-1))
    return(dirptr);
  }

/* if we got here, couldn't find it */
return(NULL);
}


/* returns free block on current drive, or -1 if none */
int findfreeblock(freecountptr)
int *freecountptr;
{
static char avail[256];
unsigned char *drvptr;	/* ptr to drive */
unsigned char *dirptr;	/* ptr to first entry */
unsigned char *ptr;	/* ptr to current entry */
int nument;	/* num. dir. entries */
int f,g,total=0;
int ret=-1;
int numdatablks;
int drvsiz;

if(!drive_valid[drive] || !drive_formatted[drive]) return(-1);

memset(avail,1,256);

drvptr=card+256*1024*drive;
dirptr=drvptr+1024*(1+drvptr[8]);
nument=drvptr[9]*32;

drvsiz=drvptr[6]+256*drvptr[7];
if(drvsiz>256) drvsiz=256;
numdatablks=drvsiz-1-drvptr[8];
for(f=0;f<drvptr[9];f++) avail[f]=0;	/* discount dir. blks */

for(f=0;f<nument;f++,dirptr+=32)
  {
  if(dirptr[0]!=0xe5)
    {
    for(g=16;g<32;g++)
      if(dirptr[g]!=0)
        avail[dirptr[g]]=0;
    }
  }

for(f=0;f<numdatablks;f++)
  if(avail[f])
    {
    total++;
    if(ret==-1) ret=f;
    }

if(freecountptr!=NULL) *freecountptr=total;

return(ret);
}


/* convert 8.3 filename.ext to FILENAMEEXT */
char *make83(fn)
char *fn;
{
static char name83[1024];
int f,pos=0;

/* this saves us messing about later */
memset(name83,0,12);

for(f=0;f<8;f++)
  {
  if(fn[pos]=='.' || fn[pos]==0)
    name83[f]=32;
  else
    name83[f]=toupper(fn[pos++]);
  }

for(f=8;f<11;f++)
  {
  if(fn[pos]=='.' || fn[pos]==0)
    name83[f]=32;
  else
    name83[f]=toupper(fn[pos++]);
  }

return(name83);
}


/* makes a CP/M 8.3 filename, but returns it in the
 * filename.ext style rather than FILENAMEEXT.
 */
char *makecpmname(filename)
char *filename;
{
static char cpmname[1024];
int f,namelen,extlen;
char *ptr,*ptr2;

if((ptr=strrchr(filename,'/'))==NULL)
  ptr=filename;
else
  ptr++;

/* ok, we need to allow for files like '.wibble' i.e. no chars before the
 * dot. For now, we just add an 'x' as the filename and contract the rest
 * to 3 chars. It's crap, but what do you expect?
 */
if((*ptr)=='.')
  {
  *cpmname='x';
  strcpy(cpmname+1,ptr);
  }
else
  strcpy(cpmname,ptr);

/* find the dot, if there is one */
if((ptr=strchr(cpmname,'.'))==NULL)
  namelen=strlen(cpmname);
else
  namelen=(ptr-cpmname);
  
/* squash the stuff before the dot to 8 chars. */
if(namelen>8) namelen=8;
cpmname[namelen]=0;
  
/* if there was a dot, try to find another dot or zero to end string */
if(ptr!=NULL)
  {
  ptr++;
  if((ptr2=strchr(ptr,'.'))!=NULL)
    *ptr2=0;
  
  if(strlen(ptr)>3) ptr[3]=0;
  memmove(cpmname+8,ptr,strlen(ptr));
  }

for(f=namelen;f<=7;f++) cpmname[f]=32;
for(f=strlen(cpmname+8);f<=2;f++) cpmname[8+f]=32;
cpmname[11]=0;
for(f=0;f<strlen(cpmname);f++)
  cpmname[f]=toupper(cpmname[f]);

return(cpmname);
}


int bfmake(n83)
char *n83;
{
char *dirptr;
int f;

if(matchfcb(n83,0,0))	/* if it exists */
  bfdel(n83);

/* find blank dir entry */
if((dirptr=matchfcb(n83,1,0))==NULL)
  {
  printf("Directory full!\n");
  return(0);
  }

/* create the entry */
dirptr[0]=user;
strncpy(dirptr+1,n83,11);
for(f=12;f<32;f++) dirptr[f]=0;
}


/* read a 128-byte record from n83 at pos */
int bfread(n83,pos,dma)
char *n83;
int pos;
unsigned char *dma;
{
unsigned char *dirptr,*drvptr;
int extent,ofs;		/* extent and block offset into it */
int blk;

pos&=(~127);	/* make sure it's a multiple of 128 */
extent=pos/16384;
ofs=(pos/1024)%16;

/* find correct dir entry */
if((dirptr=matchfcb(n83,0,extent))==NULL)
  return(0);	/* couldn't find extent */

/* get data block number which contains record */
blk=dirptr[16+ofs];

/* if it's zero, almost certainly a read past eof */
if(blk==0) return(0);

/* convert data block num. to real 1k offset from start of drive */
drvptr=((dirptr-card)&(~(256*1024-1)))+card;
blk+=1+drvptr[8];

/* check this block was actually written */
if(ofs*8+(pos/128)%8>=dirptr[15]) return(0);

/* actually read it! */
memcpy(dma,drvptr+blk*1024+pos%1024,128);

return(1);
}


/* write a 128-byte record to n83 at pos */
int bfwrite(n83,pos,dma)
char *n83;
int pos;
unsigned char *dma;
{
unsigned char *dirptr,*drvptr;
int extent,ofs;		/* extent and block offset into it */
int blk;
int f;

pos&=(~127);	/* make sure it's a multiple of 128 */
extent=pos/16384;
ofs=(pos/1024)%16;

/* find correct dir entry */
if((dirptr=matchfcb(n83,0,extent))==NULL)
  {
  /* if we couldn't find extent, make one */
  if((dirptr=matchfcb(n83,1,0))==NULL)
    return(0);	/* give up if we couldn't do that */
  
  /* construct it, rather like bfmake */
  dirptr[0]=user;
  strncpy(dirptr+1,n83,11);
  for(f=12;f<32;f++) dirptr[f]=0;
  dirptr[12]=extent;
  }

/* get data block number which contains record */
blk=dirptr[16+ofs];

/* if it's zero, none allocated yet, so do that */
if(blk==0)
  {
  if((blk=findfreeblock(NULL))==-1)
    return(0);	/* disk full */
  
  dirptr[16+ofs]=blk;
  }

/* convert data block num. to real 1k offset from start of drive */
drvptr=((dirptr-card)&(~(256*1024-1)))+card;
blk+=1+drvptr[8];

/* update extent size field */
if(ofs*8+(pos/128)%8+1>dirptr[15])
  dirptr[15]=ofs*8+(pos/128)%8+1;

/* actually write it! */
memcpy(drvptr+blk*1024+pos%1024,dma,128);

return(1);
}


int bfopen(n83)
char *n83;
{
/* just see if the 0th extent is there */
if(matchfcb(n83,0,0)) return(1);
return(0);
}


int bfclose(n83)
char *n83;
{
/* shouldn't need to do anything */
return(1);
}


do_dir()
{
unsigned char *drvptr;	/* ptr to drive */
unsigned char *dirptr;	/* ptr to first entry */
unsigned char *ptr;	/* ptr to current entry */
int nument;	/* num. dir. entries */
int f;
int free;
char buf[12];

if(!drive_valid[drive] || !drive_formatted[drive])
  {
  printf("Drive not valid or unformatted.\n");
  return(0);
  }

drvptr=card+256*1024*drive;
dirptr=drvptr+1024*(1+drvptr[8]);
nument=drvptr[9]*32;

for(f=0;f<nument;f++,dirptr+=32)
  {
  if(dirptr[0]==user && dirptr[12]==0)
    {
    strncpy(buf,dirptr+1,11);
    buf[11]=0;
    printf("%s\n",buf);
    }
  }

findfreeblock(&free);
printf("%dk free.\n",free);
}


int putfile(fn)
char *fn;
{
FILE *in;
char n83[12],dma[128];
int f,siz,rcdsiz;

strcpy(n83,make83(makecpmname(fn)));

if(!bfmake(n83))
  {
  printf("Couldn't create file.\n");
  return(0);
  }

if((siz=getfilesize(fn))==-1 || (in=fopen(fn,"rb"))==NULL)
  {
  printf("Couldn't read file.\n");
  return(0);
  }

rcdsiz=(siz+127)/128;

for(f=0;f<rcdsiz;f++)
  {
  memset(dma,26,128);	/* set to all ^Z's */
  fread(dma,1,128,in);
  if(!bfwrite(n83,f*128,dma))
    {
    printf("Couldn't write all of file.\n");
    bfclose(n83); fclose(in);
    return(0);
    }
  }

bfclose(n83);
fclose(in);

return(1);
}


int getfile(fn)
char *fn;
{
FILE *out;
char n83[12],dma[128];
int pos=0;

strcpy(n83,make83(makecpmname(fn)));

if(!bfopen(n83))
  {
  printf("Couldn't open file.\n");
  return(0);
  }

if((out=fopen(fn,"wb"))==NULL)
  {
  printf("Couldn't create file.\n");
  return(0);
  }

while(bfread(n83,pos,dma))
  {
  fwrite(dma,1,128,out);
  pos+=128;
  }

fclose(out);

return(1);
}


int bfdel(n83)
char *n83;
{
unsigned char *dirptr;
int f;

if((dirptr=matchfcb(n83,0,-1))==NULL)
  return(0);

do
  dirptr[0]=0xe5;
while((dirptr=matchfcb(n83,0,-1))!=NULL);

return(1);
}


deletefile(fn)
char *fn;
{
char n83[12];

strcpy(n83,make83(makecpmname(fn)));

if(!bfdel(n83))
  {
  printf("Couldn't open file.\n");
  return(0);
  }

return(1);
}


formatdrive(drv)
int drv;
{
unsigned char *drvptr;
int f;

if(!drive_valid[drv])
  {
  printf("Drive not available.\n");
  return(0);
  }

if(is_zcn_fmt(drv))
  {
  char buf[256];
  printf("Drive already formatted - reformat? (y/n) ");
  gets(buf);
  if(tolower(buf[0])!='y')
    {
    printf("Format aborted!\n");
    return(0);
    }
  }

/* ok, format it */
drvptr=card+256*1024*drv;

drvptr[0]=0xc9; drvptr[1]=0x7e;
strncpy(drvptr+2,"ZCN1",4);
drvptr[6]=card_size%256; drvptr[7]=card_size/256;
drvptr[8]=0; drvptr[9]=2;

for(f=10;f<1024;f++) drvptr[f]=0;

/* write the blank dir blocks */
for(f=1024;f<1024+2048;f++) drvptr[f]=0xe5;

drive_formatted[drv]=1;
printf("Drive formatted.\n");
}


/* zero out unused space
 * based on findfreeblock()
 */
zeroblank()
{
static unsigned char avail[256];
unsigned char *drvptr;	/* ptr to drive */
unsigned char *basedirptr; /* ptr to first entry */
unsigned char *dirptr;	/* ptr to current entry */
int nument;	/* num. dir. entries */
int f,g;
int numdatablks;
int drvsiz;
int drv;

printf("zeroing... ");

for(drv=0;drv<4;drv++)
  if(drive_valid[drv] && is_zcn_fmt(drv))
    {
    memset(avail,1,256);
    
    drvptr=card+256*1024*drv;
    basedirptr=dirptr=drvptr+1024*(1+drvptr[8]);
    nument=drvptr[9]*32;
    
    drvsiz=drvptr[6]+256*drvptr[7];
    if(drvsiz>256) drvsiz=256;
    numdatablks=drvsiz-1-drvptr[8];
    for(f=0;f<drvptr[9];f++) avail[f]=0;	/* discount dir. blks */
    
    for(f=0;f<nument;f++,dirptr+=32)
      {
      if(dirptr[0]!=0xe5)
        {
        for(g=16;g<32;g++)
          if(dirptr[g]!=0)
            avail[dirptr[g]]=0;
        }
      }
    
    for(f=0;f<numdatablks;f++)
      if(avail[f])
        {
        memset(drvptr+(f+1+drvptr[8])*1024,0,1024);
        printf("%c:%d,",drv+'A',f);
        }
    }
printf("done!\n");
}
