.updatepanel
; Reset update panel flag
res 2,(hl)

; Place stack in bank 0
; Place panel video RAM in bank 1
pop hl
ld sp,&4000
ld bc,&7fc0
out (c),c
push hl

; Calculate speed
ld de,(time_lapse_spd)
ld a,&eb
ld c,&81
ld hl,0
call calcspeed

; Transform speed to ascii, store it in a variable and remove trailing zeros
ld de,speedascii
call bin2asc
inc de
call decs
ld hl,speedascii
ld b,3
call clrzero

; Transform gen. number to ascii, store it in a variable and remove trailing zeros
ld hl,(gencounter)
ld de,genascii
call bin2asc
call decs
ld hl,genascii
ld b,5
call clrzero

; Calculate ACP percentage, transform to ascii, store it in a variable,
; and remove trailing zeros
call calcACPpercent
ld de,ACPascii
ld b,&ff
call cents
call decs
ld hl,ACPascii
ld b,3
call clrzero

; Update buffer to the new values and set-up changelist
ld de,CHLIST
ld hl,ROW2BUFFER+4
ld bc,genascii
call updatebuffer

ld hl,ROW2BUFFER+12
ld bc,speedascii
call updatebuffer

ld hl,ROW3BUFFER+6
ld bc,ACPascii
call updatebuffer

inc de
call updatebuffer_percentbar

; Print buffer changes to panel video area
ld h,ROW2BUFFER/256
ld de,CHLIST
call printnum
inc de
call printpercentbar

; Place ACP list back in bank 1
ld bc,&7fc4
out (c),c
ret

; Sub-routine to update buffer and set-up changelist
.updatebuffer_loop
cp (hl)
jp z,skip_character
ld (hl),a
ld a,l
ld (de),a
inc e
.skip_character
inc l
inc c
.updatebuffer
ld a,(bc)
cp 0
jp nz,updatebuffer_loop
ld (de),a
ret

; Sub-routine to update buffer and set-up changelist for
; ACP percentage bar
.updatebuffer_percentbar
ld hl,(ACPcounter)
add hl,hl
ld c,h
ld hl,ROW3BUFFER+12
ld b,8
.updatebuffer_percentbar_loop
ld a,c
sub b
jp nc,skip1_percentbar
xor a
ld b,c
.skip1_percentbar
ld c,a

ld a,b
cp (hl)
jp z,skip2_percentbar
ld (hl),b
ld a,l
ld (de),a
inc e
.skip2_percentbar
inc l

ld a,l
cp ROW3BUFFER+20
jp nz,updatebuffer_percentbar_loop
xor a
ld (de),a
ret

; Binary to Ascii
.bin2asc
ld bc,-10000
call Num1
ld bc,-1000
call Num1
.cents
ld bc,-100
call Num1
ret
.decs
ld c,-10
call Num1
ld c,b
.Num1	
ld a,'0'-1
.Num2
inc a
add hl,bc
jr c,Num2
sbc hl,bc
ld (de),a
inc de
ret

; Remove leading zeroes
.clrzero_loop
cp '0'
ret nz
ld (hl),' '
inc hl
.clrzero
ld a,(hl)
djnz clrzero_loop
ret

; Calculate speed
.calcspeed
ld b,16
.division_loop
rl c
rla
adc hl,hl
sbc hl,de
jr nc,$+3
add hl,de
djnz division_loop

rl c
rla
cpl
ld h,a
ld a,c
cpl
ld l,a
ret

; Calculate ACP percentage
.calcACPpercent
ld hl,(ACPcounter)

srl h
rr l
srl h
rr l
srl h
rr l

ld d,h
ld e,l

add hl,hl
add hl,de
add hl,hl
add hl,hl
add hl,hl
add hl,de

ld l,h
ld h,0
ret

; Prints a string using firmware functions
.printstring
pop hl
jr printstring_entry
.printstring_loop
inc hl
call &bb5a
.printstring_entry
ld a,(hl)
or a
jp nz,printstring_loop
inc hl
push hl
ret

; Clear a memory area
; INPUT
; HL = start address of block
; BC = lengh of block - 1
.clmem
ld e,l
ld d,h
inc de
ld (hl),0
ldir
ret

; Write register/value pairs to CRTC
; INPUT
; HL - Poinut to the list of register/value pairs
; C  - Number of pairs in the list
.write_CRTC
ld b,&bd
.writeCRTCloop
outi
inc b: inc b
outi
dec c
jr nz,writeCRTCloop
ret

; Wait for THE BEGINNING of a VSYNC signal
.wait_vbl_safe
ld b,&f5
.wait_vbl_end
in a,(c)
rra
jp c,wait_vbl_end
; Wait for VSYNC signal (don't care if we're already
; there)
.wait_vbl
ld b,&f5
in a,(c)
rra
jp nc,wait_vbl
ret

; Initialize keyboard
.initkeyb
ld bc,&f782
out (c),c	; PPI port A out
ld bc,&f40e
out (c),c	; Select Ay reg 14 (keyboard) on ppi port A 
ld bc,&f6c0
out (c),c 	; PSG function select register
xor a
out (c),a	; Validate (PSG function inactive)
ld bc,&f792	
out (c),c	; PPI port A in
ld bc,&f640
out (c),c	; Send KbdLine on reg 14 AY through ppi port C
ret

; Scan keyboard
.scankeyb
push de
ld bc,&f440
ld hl,keybmapraw

repeat 9

in a,(c) 
ld d,a
xor (hl)
and (hl)
set 4,l
or (hl)
ld (hl),a
res 4,l
ld (hl),d
inc l

inc c
ld b,&f6
out (c),c
ld b,&f4

rend

in a,(c) 
ld d,a
xor (hl)
and (hl)
set 4,l
or (hl)
ld (hl),a
res 4,l
ld (hl),d
dec l

ld bc,&f640
out (c),c
pop de
ret

; Parse keyboard
.parsekeys_nosplit

call parsekeys_split

ld hl,keybmapraw

bit 0,(hl)
jp nz,skip_cur_up_nosplit
ld bc,&ffe0
call scroll1char
ld hl,liveareaoffset
ld c,2
call write_CRTC
ret
.skip_cur_up_nosplit

bit 2,(hl)
jp nz,skip_cur_down_nosplit
ld bc,&20
call scroll1char
ld hl,liveareaoffset
ld c,2
call write_CRTC
ret
.skip_cur_down_nosplit

ret

.parsekeys_split

; Parse 8th row
ld hl,keybmapfiltered+8
ld a,(hl)
or a
jr z,skip_parse_8th_row

bit 1,(hl)
jp z,skip_evolve_2generations
res 1,(hl)
ld a,2
jp evolveAgen
ret
.skip_evolve_2generations

bit 0,(hl)
jp z,skip_evolve_1generation
res 0,(hl)
ld a,1
jp evolveAgen
ret
.skip_evolve_1generation
.skip_parse_8th_row

; Parse 7th row
dec l
ld a,(hl)
or a
jr z,skip_parse_7th_row

bit 6,(hl)
jp z,skip_swap_colourmode
res 6,(hl)

ld hl,colourmode
inc (hl)

ld hl,flags
bit 4,(hl)
jr z,skip_dbuff_switchoff
set 5,(hl)
ld a,(savecolourmode)
ld (colourmode),a
ret
.skip_dbuff_switchoff
call setinks
ret
.skip_swap_colourmode

bit 5,(hl)
jp z,skip_toggle_doublebuffer
res 5,(hl)
ld hl,flags
bit 4,(hl)
jp z,dbuffer_switchon
ld a,(savecolourmode)
ld (colourmode),a
set 5,(hl)
ret
.dbuffer_switchon
ld a,(colourmode)
ld (savecolourmode),a
xor a
ld (colourmode),a
set 4,(hl)
call setinks
ret
.skip_toggle_doublebuffer

bit 1,(hl)
jp z,skip_evolve_3generations
res 1,(hl)
ld a,3
jp evolveAgen
ret
.skip_evolve_3generations

bit 0,(hl)
jp z,skip_evolve_4generations
res 0,(hl)
ld a,4
jp evolveAgen
ret
.skip_evolve_4generations
.skip_parse_7th_row

; Parse 6th row
dec l
ld a,(hl)
or a
jr z,skip_parse_6th_row

bit 5,(hl)
jp z,skip_toggle_panel
res 5,(hl)
ld hl,flags
bit 0,(hl)
jr z,split_switchon
set 1,(hl)
ret
.split_switchon
set 0,(hl)
ret
.skip_toggle_panel

bit 1,(hl)
jp z,skip_evolve_5generations
res 1,(hl)
ld a,5
jp evolveAgen
ret
.skip_evolve_5generations

bit 0,(hl)
jp z,skip_evolve_6generations
res 0,(hl)
ld a,6
jp evolveAgen
ret
.skip_evolve_6generations
.skip_parse_6th_row

; Parse 5th row
dec l
ld a,(hl)
or a
jr z,skip_parse_5th_row

bit 7,(hl)
jp z,skip_toggle_run_pause
res 7,(hl)
ld a,(flags)
xor 8
ld (flags),a
ret
.skip_toggle_run_pause

bit 1,(hl)
jp z,skip_evolve_7generations
res 1,(hl)
ld a,7
jp evolveAgen
ret
.skip_evolve_7generations

bit 0,(hl)
jp z,skip_evolve_8generations
res 0,(hl)
ld a,8
jp evolveAgen
ret
.skip_evolve_8generations
.skip_parse_5th_row

; Parse 4th row
dec l
;ld a,(hl)
;or a
;jr z,skip_parse_4th_row

bit 1,(hl)
jp z,skip_evolve_9generations
res 1,(hl)
ld a,9
jp evolveAgen
ret
.skip_evolve_9generations
;.skip_parse_4th_row

ld hl,keybmapraw

bit 1,(hl)
jp nz,skip_evolve_manual
res 1,(hl)
ld a,1
ld (genlimit),a
ld hl,flags
set 3,(hl)
ret
.skip_evolve_manual

ld hl,keybmapraw+8
bit 2,(hl)
jp nz,skip_soft_reset
ld hl,keybmapraw+2
ld a,(hl)
and &a0
jp z,0
.skip_soft_reset

ret

; Scroll screen offset 1 by 1 character up or down
.scroll1char
ld ix,liveareaoffset
ld h,(ix+1)
ld l,(ix+3)
ld a,h
add hl,bc
xor h
and %11111100
xor h
ld h,a
ld (ix+3),l
ld (ix+1),h
ret

; Evolve A generations
.evolveAgen
ld (genlimit),a
ld hl,flags
set 3,(hl)
ret

; Set all inks + the border
.clearinks
ld bc,&7410
; Border colour
ld a,(bordercolour)
out (c),c
out (c),a
; Background colour
ld a,(backgroundcolour)
.clearinks_loop
dec c
out (c),c
out (c),a
jp nz,clearinks_loop
ret

; Set all inks > 8 to live cell colour
.monochromeinks
ld bc,&7409
; Live cells colour
.monochromeinks_loop
ld a,(livecolour)
out (c),c
out (c),a
inc c
ld a,c
cp 16
jp nz,monochromeinks_loop
ret

; Change inks according to colour mode
.setinks
ld bc,&7408
ld hl,colourmode

; Set colour for newborn cells
ld a,(livecolour)
bit 1,(hl)
jp z,skip_newborn_coloured
ld a,(newborncolour)
.skip_newborn_coloured
out (c),c
out (c),a

; Set colour for recently dead cells
ld c,&02
ld a,(backgroundcolour)
bit 0,(hl)
jp z,skip_rdead_coloured
ld a,(rdeadcolour)
.skip_rdead_coloured
out (c),c
out (c),a
ret

;; lookup software colour number which corresponds to the hardware colour number
;; entry:
;; A = hardware colour number
;; exit:
;; C = index in table (same as software colour number)
.hardcol2softcol
ld c,0
ld hl,colourconversion		; table to convert from software colour
.hardcol2softcol_loop		; number to hardware colour number
cp (hl)				; same as this entry in the table?
ret z				; zero set if entry is the same, zero clear if entry is different
inc hl
inc c
jr hardcol2softcol_loop

.restorefirmjumpblock
rst &8
ds 2

; Disable double buffer mode if required
.dbuff_disable
bit 5,(hl)
ret z
res 4,(hl)
res 5,(hl)
di
call setinks
ei
ret