; Macro implementing Phase2 core code.

; Input
; HL - Address of the video memory cell pair to be updated
; DE - Pointer to the new active cells list current position
; B  - Lookup table base address

macro phase2core

res 6,h		; Reads current cell pair state and neighbour count from
ld c,(hl)	; the cell data bank
set 6,h

ld a,(bc)	; Gets the updated state (and colour) from the lookup table
   
cp (hl)         ; If the cell pair has already been updated there's nothing
jr z,@noupdt    ; more to do

ld (hl),a       ; Copy the updated state to the video memory

sub c		; If the cell pair state hasn't changed (excluding possible
and %00000011	; color changes), don't add it to the new active cells list
jr z,@noupdt

ex de,hl        ; Otherwise add the cell pair to the new active cells list
ld (hl),e
inc l
ld (hl),d
inc hl
ex de,hl

@noupdt

endm

; PHASE 2

; -Iterates through the active cells list,
; -Invokes phase2core macro on each active cell pair AND all its neighbours,
;  which in turn;
;  -Generates the updated state by looking at the lookup table.
;  -Writes the updated state to the video memory bank.
;  -Adds it to the new active cells list for the next generation.
; -Loops until the end of the list

; USES
; SP - Iterates through the active cells list
; HL - Address of the video memory cell pairs (pop'd out
;      from the active cells list)
; DE - Follows the new active cells list position

; Initialize SP to the beginning of the current active cells list
ld sp,(changelist)

; Initialize DE to the beginning of the new active cells list
ld de,(changelist)
ld a,d
xor &20
ld d,a
; Stores the new active cells list address for the next generation
ld (changelist),de

pop hl		; Pop out the first video memory address from the list

ld b,LOOKUPTABLE/256

.phase2loop

; Edge detection routine, if the lower byte of screen address is either of the
; form xx111111 or xx000000 (right/left edges of the screen respectively),
; this routine detects it and jumps to the alternative edge-safe phase 2 code.
ld a,l
inc a
and &3f
sub 2
jp c,phase2edge

; The neighbours are scanned following this order to minimize vertical jumps.
; 4 5 6
; 3 1 2
; 9 8 7

phase2core

inc l

phase2core

dec l:dec l

phase2core

moveLineUp

phase2core

inc l

phase2core

inc l

phase2core

move2linesDown

phase2core

dec l

phase2core

dec l 

phase2core

.phase2initmark1
pop hl
ld a,h
or l
jp nz,phase2loop	; Loop until the end of the list
jp phase2end		; Jump to phase2end skipping the edge-safe version

.phase2edge		; Edge-safe version

phase2core

incl

phase2core

dec2l

phase2core

moveLineUp

phase2core

incl

phase2core

incl

phase2core

move2linesDown

phase2core

decl

phase2core

decl 

phase2core

.phase2initmark2
pop hl
ld a,h
or l
jp nz,phase2loop	; Loop until the end of the list

.phase2end	

ex de,hl	; Add the last popped out value (&00) to mark the end
ld (hl),d	; of the new list
inc l
ld (hl),e
inc hl

; Calculate ACP completeness, store it in a variable
; and abort calculating further generations if full
ld de,(changelist)
or a
sbc hl,de
ld (ACPcounter),hl
ld a,h
cp &20
jp nc,ACPoverflow
