; PHASE 1

; - Iterates through the active cells list
; - Calculates which specific transition took place on each cell pair
; - Generates a jump vector pointing to the appropiate routine to update its
;   neighbours
; - Jumps to this routine
; - And loops until the end of the list

; USES
; HL - Iterates through the active cells list
; BC - Used to store video memory addresses (extracted from the change list)
;      and cell data bank addresses (calculated from the former ones)
; DE - Used to calculate vector table address

ld hl,(changelist)

; Extract first video memory address from changelist
ld c,(hl)
inc l
ld b,(hl)
inc hl
ld a,b
or c
jp z,still_life	; If it is equal to zero it means that the list is empty,
		; either all cells are dead or only static debris remains
		; on the screen. The Game is Over.

.neighupdtloop

ld e,vectortable
; Edge detection routine, if the lower byte of screen address is either of the
; form xx111111 or xx000000 (right/left edges of the screen respectively),
; this routine detects it and replaces the vector table pointing to the 
; standard (fast) updating routines with another pointing to its edge-safe 
; versions
ld a,c
inc a
and &3f
sub 2
jr nc,not_edge
ld e,vectortable_edge
.not_edge

ld a,(bc)	; a = (colorinformation)(current state)
and 3
ld d,a		; d = 000000 (current state)

res 6,b		; Switch to cell data bank

ld a,(bc)	; a = (neighbourcounts)(previous state)
and 3
rlca
rlca		; a = 0000 (previous state)00
or d
rlca		; a = 000 (previous state)(current state)0
		; jump vector are two bytes long
add e
ld e,a		; e = vector table address for this particular transition
		; (low byte)

ld a,(bc)
and %11111100	; a = (neighbourcounts)00
or d		; a = (neighbourcounts)(current state)
ld (bc),a	; update state value in cell data bank

ld d,vectortable/256 ; de = vector table address


ex de,hl	; hl = vector table address
		; de = active cells list position
ld a,(hl)
inc l
ld h,(hl)
ld l,a		; hl = jump vector
		; de = active cells list position

jp (hl)		; Proceed!

align 64

.vectortable
defw neighupdtd
defw tn0001
defw tn0010
defw tn0011
defw tn0100
defw neighupdtd
defw tn0110
defw tn0111
defw tn1000
defw tn1001
defw neighupdtd
defw tn1011
defw tn1100
defw tn1101
defw tn1110
defw neighupdtd

.vectortable_edge
defw neighupdtd
defw te0001
defw te0010
defw te0011
defw te0100
defw neighupdtd
defw te0110
defw te0111
defw te1000
defw te1001
defw neighupdtd
defw te1011
defw te1100
defw te1101
defw te1110
defw neighupdtd

.neighupdtd
ex de,hl	; hl = active cells list position
; Extract next video memory address from changelist and
; loop until its end
ld c,(hl)
inc l
ld b,(hl)
inc hl
ld a,b
or c
jp nz, neighupdtloop	; Loop until the end of the list
