; Vertical pixel perfect scroll while panel is active
macro scroll
; Scan keyboard
ld b,&f4
in b,(c)
inc b
jp z,scroll_end
dec b

bit 0,b
jp nz,skip_cur_up
; Adjust live area R5 value
ld a,(liveareacfg+3)
dec a
and %00000111
ld (liveareacfg+3),a
; Adjust panel area R5 value
sub 7
cpl
inc a
ld (panelcfg+3),a
; Check whether a 1 byte scroll offset is needed
or a
jp nz,scroll_end
ld bc,&ffe0
call scroll1char
jp scroll_end
.skip_cur_up

bit 2,b
jp nz,scroll_end
; Adjust live area R5 value
ld a,(liveareacfg+3)
inc a
and %00000111
ld (liveareacfg+3),a
; Adjust panel area R5 value
sub 7
cpl
inc a
ld (panelcfg+3),a
; Check whether a 1 byte scroll offset is needed
cp 7
jp nz,scroll_end
ld bc,&20
call scroll1char
.scroll_end
endm

; Outpus 3 register/value pairs pointed to by hl to CRTC
macro write3_CRTC
outi
inc b: inc b
outi

outi
inc b: inc b
outi

outi
inc b: inc b
outi
endm

; Outpus 2 register/value pairs pointed to by hl to CRTC
macro write2_CRTC
outi
inc b: inc b
outi

outi
inc b: inc b
outi
endm

; Path CRTC config values for non-splitted setup
macro patch_CRTC_cfg_nosplit
push ix
ld ix,liveareaoffset

; Adjust live area screen offset based on live area
; R5 current value, so that it ends up in the nearest
; character-aligned position
ld bc,&20
ld a,(ix+7)
bit 2,a
jr z,skip_correction
ld c,&40
.skip_correction

call scroll1char

; Set R4 and R5 for live area CRTC config values
ld a,37
ld (ix+5),a
ld a,7
ld (ix+7),a

; Reset R5 for panel area and configure R4 for a smooth 
; transition
ld (ix+17),a
ld a,9
ld (ix+15),a

ld hl,flags
; Reset splitswitchoff flag
res 1,(hl)
; Reset split flag
res 0,(hl)
pop ix
endm

; Patch CRTC config values for splitted setup
macro patch_CRTC_cfg_split
push ix
ld ix,liveareaoffset

; Reset R4 for panel area
ld a,8
ld (ix+15),a

; Adjust live area screen offset
ld bc,&ffe0
call scroll1char

; Set R4 and R5 live area CRTC config values for this frame
ld a,0
ld (ix+7),a
ld a,27
ld (ix+5),a

; Ouput CRTC live area values for this frame
ld b,&bd
ld hl,liveareacfg
write2_CRTC

; Fix R4 live area value for next and subsequent frames
inc a
ld (ix+5),a

; Output screen offset for panel area
ld hl,paneloffset
write2_CRTC
pop ix
endm

; Sets CRTC to display cell data bank
; (to avoid flickering in double buffer mode during phase 2)
macro displayCellData
; Skip all this if double buffer mode isn't enabled
ld hl,flags
bit 4,(hl)
jp z,skip_displayCellData
; Wait for VSYNC and display cell data bank from now on
call wait_vbl
ld hl,liveareaoffset+1
res 4,(hl)
dec l
ld b,&bd
write2_CRTC
.skip_displayCellData
endm

; Sets CRTC to display video RAM bank
; (to avoid flickering in double buffer mode during phase 1)
macro displayVideoBank
; Skip all this if double buffer mode isn't enabled
ld hl,flags
bit 4,(hl)
jr z,skip_displayVideoBank
; Wait for VSYNC
call wait_vbl
; Disable double buffer mode if required
bit 5,(hl)
jr z,skip_disable_dbuffer
res 4,(hl)
res 5,(hl)
di
call setinks
ei
.skip_disable_dbuffer
; Display video bank from now on
ld hl,liveareaoffset+1
set 4,(hl)
dec l
ld b,&bd
write2_CRTC
.skip_displayVideoBank
endm

; Macros performing vertical screen displacements 
macro moveLineUp
ld a,h
sub &8           ; Decrements one line
ld h,a
bit 6,h
jr nz, @end      

ld a,l
add &c0
ld l,a
ld a,h
adc &3f
ld h,a

set 3,h          ; Fixes jump over top screen edge

@end
endm

macro moveLineDown
ld a,h
add &8           ; Increments one line
ld h,a
jr nc, @end      

ld a,l
add &40
ld l,a
ld a,h
adc &c0
ld h,a

res 3,h          ; Fixes jump over top screen edge

@end
endm

macro move2linesDown
ld a,h           
add &10          ; Increments two lines
ld h,a   
jr nc, @end      

ld a,l
add &40
ld l,a

ld a,h
adc &c0
xor h
and %11000111
xor h
ld h,a

@end
endm

macro move4linesDown
ld a,h           
add &20          ; Increments two lines
ld h,a   
bit 6,h
jr nz,@end      

ld a,l
add &40
ld l,a

ld a,h
adc &c0
xor h
and %11000111
xor h
ld h,a

@end
endm

macro move4LinesUp
ld a,h
sub &20           ; Decrements one line
ld h,a
bit 6,h
jr nz,@end      

ld a,l
add &c0
ld l,a

ld a,h
adc &3f
xor h
and %11000111
xor h
ld h,a

@end
endm
