; Set "Switch off split" flag
ld hl,flags
set 1,(hl)
; Wait until interrupts mark it as switched off
.wait_paneloff
bit 0,(hl)
jp nz,wait_paneloff
; Plus two additional interrupts for the transition
; to be completed
halt: halt

; Place stack in a firmware-compatible location
ld sp,&c000

; Clear event queues and timer lists memory area
ld hl,&b100
ld de,&b101
ld bc,&07ff
xor a
ld (hl),a
ldir    

; Put panel video ram in bank 0
ld bc,&7fc0
out (c),c

; Print panel
ld de,ROW0BUFFER
xor a
call printbuffer
ld de,ROW4BUFFER
ld a,64
call printbuffer

; Restore high jumpblock, this will also restore fimware 
; interrupts
di
call restorehighjumpblock
ei
; Restore the remaining firmware jumpblocks
call restorefirmjumpblock

call &bcff ; screen initialise

ld a,(bordercolour)
call hardcol2softcol
ld b,c
call &bc38 ; set border colour

ld a,(backgroundcolour)
call hardcol2softcol
ld b,c
xor a
call &bc32 ; set background colour

ld a,(textcolour)
call hardcol2softcol
ld b,c
ld a,1
call &bc32 ; set text colour

ld a,&c0
call &bc08 ; set screen base

ld a,2
call &bc0e ; set mode 2

call &bb00 ; keyboard initialise
ld a,&ff
ld (&b632),a ; caps lock on

call &bc65 ; cas initialise
ld de,&4000
ld hl,&b0ff
ld c,7
call &bcce ; amsdos initialise

; Select drive number
ld a,(diskdrivenumber)
ld hl,(&be7d)
ld (hl),a

call &bb4e ; txt initialize
; Patch firmware indirections to make it compatible with
; out 64 bytes wide screen
ld a,&c3
ld hl,txt_write_char
ld (&bdd3),a
ld (&bdd4),hl
ld hl,txt_draw_cursor
ld (&bdcd),a
ld (&bdce),hl
ld hl,txt_draw_cursor
ld (&bdd0),a
ld (&bdd1),hl

; Set window for DIR command
ld hl,&0300
ld (&b729),hl
ld de,&3f1a
ld (&b72b),de
ld hl,&0101
call &bb75

; Find DIR command
ld hl,dircommand
call &bcd4
; Issue DIR command
xor a
call &001b

; Print panel using firmware

; Set window for panel printing
ld hl,&001b
ld (&b729),hl
ld de,&3f1f
ld (&b72b),de
ld hl,&0101
call &bb75
; Print top horizontal line
ld a,150
call &bb5a
ld a,154
ld b,62
call &bb5a
djnz $-3
ld a,156
call &bb5a
; Print side vertical lines
ld b,3
ld a,149
.printpanel_sidelines_loop
call &bb5a
ld a,64
call &bb6f
ld a,149
call &bb5a
djnz printpanel_sidelines_loop
; Print bottom horizontal lines
ld a,147
call &bb5a
ld a,154
ld b,62
call &bb5a
djnz $-3
ld a,153
call &bb5a

; Set window for panel usage
ld hl,&011c
ld (&b729),hl
ld de,&3e1f
ld (&b72b),de
ld hl,&0101
call &bb75

call printstring
db "Type filename and press ENTER:",13,10,10,10,0

.loadpattern_loop
call printstring
db 11,11,"> ",0

ld hl,textbuffer
call &bd5e

call printstring
db 13,10,0
ld a," "
ld b,22
call &bb5a
djnz $-3
call printstring
db 11,0

ld hl,textbuffer
ld b,&ff
.filename_length_loop
ld a,(hl)
inc b
inc hl
or a
jp nz,filename_length_loop

ld hl,textbuffer
call #bc77  ; CAS_IN_OPEN
jp nc,loadpattern_loop

; Put ACP list back in bank 1
ld bc,&7fc4
out (c),c

ld hl,&4000
call #bc83  ; CAS_IN_DIRECT
call #bc7a  ; CAS_IN_CLOSE

; Stop drive motor
xor a
ld bc,&fa7e
out (c),a

; Disable firmware interrupts
ld hl,&c9fb
ld (&38),hl

; Change stack to bank 0
ld sp,&4000

; Initialize keyboard hardware
call initkeyb

; Set flag to activate panel
ld a,1
ld (flags),a

; Configure alternate registers for our custom interrupts
ld bc,&7f8c
ld hl,int2nosplit
exx

; Clear inks
call wait_vbl
call clearinks

; Wait for the appropiate moment and patch interrupt jump
call wait_vbl_safe
halt
ld hl,&e9d9		;; exx: jp (hl)
ld (&38),hl

; Copy pattern to video memory (reordering lines)
ld hl,&4000
ld de,&c000
.screencopy
ld bc,64
ldir
ex de,hl
ld bc,&ffc0
add hl,bc
moveLineDown
ex de,hl
ld a,d
sub &c0
or e
jp nz,screencopy

; Restore inks
call wait_vbl
call monochromeinks
call setinks

