; Wait for the beginning of VSYNC
call wait_vbl_safe
; Wait for first interrupt (~2 scanlines later)
halt

; Write "horizontal" CRTC registers
ld hl,initvideocfg
ld c,2
call write_CRTC

; Set inks
call clearinks
call monochromeinks
call setinks

; Wait for the third interrupt
halt: halt

; Write vertical CRTC registers for a smooth transition
ld hl,initvideocfg+2
ld c,4
call write_CRTC
; Write offset for panel area
ld hl,paneloffset
ld c,2
call write_CRTC

; Configure PPI/PSG to read keyboard
call initkeyb

; Patch interrupt jump, from now on interrupts will take care of video handling
ld bc,&7f8c
ld hl,int4split
exx
ld hl,&e9d9
ld (&38),hl

; Place stack in bank 0
ld sp,&4000
