// Copyright (c) 2014 "Vortex"
// "Super Retro Robot Rampage", a game for Amastrad CPC 464
//
// This file is part of "Super Retro Robot Rampage".
// 
// "Super Retro Robot Rampage" is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// "Super Retro Robot Rampage" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with "Super Retro Robot Rampage".  If not, see <http://www.gnu.org/licenses/>.

extern const int TABLA_CANCION[];
extern const int TABLA_PAUTAS[];
extern const int TABLA_SONIDOS[];
extern const int TABLA_EFECTOS[]; 


void asm_data_quezesto(void) {

__asm	

_TABLA_CANCION: 
    .dw _CANCION

_TABLA_PAUTAS: .DW PAUTA_0,PAUTA_1,PAUTA_2,PAUTA_3,PAUTA_4,PAUTA_5,PAUTA_6

_TABLA_SONIDOS: .DW SONIDO0,SONIDO1,SONIDO2,SONIDO3


PAUTA_0:    .DB  #46,#0,#12,#0,#10,#0,#9,#0,#129
PAUTA_1:    .DB  #46,#0,#13,#0,#12,#0,#10,#0,#10,#0,#9,#0,#8,#0,#11,#0,#10,#0,#9,#0,#129
PAUTA_2:    .DB  #7,#0,#8,#0,#9,#0,#9,#0,#8,#0,#7,#0,#6,#0,#129
PAUTA_3:    .DB  #45,#0,#12,#0,#12,#0,#11,#0,#11,#0,#10,#0,#10,#0,#9,#0,#129
PAUTA_4:    .DB  #7,#0,#8,#0,#8,#0,#8,#0,#7,#0,#6,#0,#6,#0,#6,#0,#6,#0,#6,#0,#5,#0,#5,#0,#5,#0,#5,#0,#5,#0,#138
PAUTA_5:    .DB  #7,#0,#8,#0,#9,#0,#8,#0,#7,#0,#6,#0,#129
PAUTA_6:    .DB  #77,#0,#12,#0,#11,#0,#10,#0,#9,#0,#8,#0,#7,#0,#9,#0,#8,#0,#7,#0,#129


SONIDO0:    .DB  #23,#63,#0,#116,#110,#0,#255
SONIDO1:    .DB  #162,#47,#0,#23,#93,#9,#255
SONIDO2:    .DB  #0,#10,#5,#255
SONIDO3:    .DB  #186,#58,#0,#0,#102,#0,#162,#131,#0,#255


_TABLA_EFECTOS:
        .dw _EFECTO0
        .dw _EFECTO1
        .dw _EFECTO2
        .dw _EFECTO3


_EFECTO0:                

.db #0x3E,#0x0F
.db #0x4B,#0x0E
.db #0x71,#0x0E
.db #0xA3,#0x0D
.db #0xEE,#0x0C
.db #0x2D,#0x1C
.db #0x2E,#0x1C
.db #0x3A,#0x1B
.db #0x92,#0x1A
.db #0xB7,#0x19
.db #0xD0,#0x18
.db #0xF6,#0x18

.db #0xFF

_EFECTO1:                

.db #0xD5,#0x0C
.db #0xC9,#0x0D
.db #0xAF,#0x0E
.db #0x8A,#0x0F
.db #0x7D,#0x0E
.db #0x64,#0x0D
.db #0x4B,#0x0C
.db #0x3E,#0x0B
.db #0x3E,#0x0A
.db #0x3D,#0x09
.db #0x3E,#0x08
.db #0x3F,#0x07
.db #0x3E,#0x06
.db #0x3D,#0x05

.db #0xFF


_EFECTO2:               

.db #0xE2,#0x0F
.db #0x7D,#0x0F
.db #0x32,#0x0F
.db #0x26,#0x0F
.db #0x25,#0x0F
.db #0x32,#0x0F
.db #0x25,#0x0F
.db #0x26,#0x0F
.db #0x3E,#0x0F
.db #0x3F,#0x0F
.db #0x4B,#0x0F
.db #0x64,#0x0F
.db #0x7D,#0x0F
.db #0xC9,#0x0F
.db #0xFF

_EFECTO3:                

.db #0x25,#0x0F
.db #0x25,#0x0D
.db #0x25,#0x0B
.db #0x25,#0x09
.db #0x25,#0x07
.db #0x25,#0x05
.db #0x25,#0x03
.db #0x25,#0x01

.db #0xFF

__endasm;
}


const unsigned char CANCION[] = {
    0x05, 0x07, 0x00, 0x00, 0x3f, 0x03, 0xba, 0x01, 0x01, 0xba, 0x01, 0x01, 0xba, 0x01, 0x01, 0x73, 
    0x78, 0x7a, 0x7b, 0x7a, 0x78, 0x76, 0xba, 0x01, 0x01, 0xba, 0x01, 0x01, 0x7a, 0x7e, 0x01, 0x73, 
    0xbd, 0xbb, 0xba, 0x76, 0xb8, 0x01, 0x01, 0xb8, 0x01, 0x01, 0xb8, 0x01, 0x01, 0x71, 0x73, 0x7b, 
    0x79, 0x78, 0x76, 0x74, 0xb8, 0x01, 0x01, 0xb8, 0x01, 0x01, 0x78, 0x7e, 0x01, 0x71, 0xbb, 0xb9, 
    0xb8, 0x74, 0x00, 0xc1, 0x00, 0x3f, 0x00, 0x56, 0x4f, 0x4f, 0x56, 0x4f, 0x4f, 0x56, 0x4f, 0x4f, 
    0x4f, 0x54, 0x56, 0x57, 0x56, 0x54, 0x52, 0x56, 0x4f, 0x4f, 0x56, 0x4f, 0x4f, 0x56, 0x4f, 0x4f, 
    0x8f, 0x97, 0x96, 0x52, 0x54, 0x4d, 0x4d, 0x54, 0x4d, 0x4d, 0x54, 0x4d, 0x4d, 0x4d, 0x52, 0x54, 
    0x55, 0x54, 0x52, 0x50, 0x54, 0x4d, 0x4d, 0x54, 0x4d, 0x4d, 0x54, 0x7e, 0x01, 0x4d, 0x97, 0x95, 
    0x94, 0x50, 0x00, 0xc1, 0x00, 0x00
};