// Copyright (c) 2014 "Vortex"
// "Super Retro Robot Rampage", a game for Amastrad CPC 464
//
// This file is part of "Super Retro Robot Rampage".
// 
// "Super Retro Robot Rampage" is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// "Super Retro Robot Rampage" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with "Super Retro Robot Rampage".  If not, see <http://www.gnu.org/licenses/>.

#include <cpcrslib.h>
#include <time.h>
#include "math.h"
#include <stdlib.h>
#include <stdio.h>
#include "cpcwyzlib.h"
#include "graphics.h"
#include "sound.h"

typedef enum { false, true } bool;

#define NUM_COLORS  16
#define BORDE 		 0

#define WIDTHCHAR    4 //ancho de las "figuritas" 
#define HEIGHTCHAR   8 //alto de las "figuritas"

//CAMBIADOS
#define MIN_X        4
#define MAX_X       72
#define MIN_Y       47
#define MAX_Y      182

#define FRAME_LIMIT 400
#define ENEMY_FRAME_LIMIT 4
#define SPAWNER_FRAME_LIMIT 30

#define ALTERNA_FRAME 4
#define ALTERNA_FRAME_DISPARO 1

#define MAX_DISPAROS 3
#define DISPARO_VEL 1
#define DISPARO_PERIODO 5

#define COOLDOWN_LIMIT 60

//KEYS
#define KEY_LEFT  	 1
#define KEY_RIGHT 	 2
#define KEY_UP       3
#define KEY_DOWN     4
#define KEY_W        5
#define KEY_A        6
#define KEY_S        7
#define KEY_D  	     8
#define KEY_1        9
#define KEY_2       10
#define KEY_3       11
#define KEY_ESC     12

//ROOM
#define ROOMSIZE    20
#define ROOMLEFT     0
#define ROOMUP       5

#define NUMOBSTACULOS	20


//GAME STATES
#define GAME_STATE_MENU        2
#define GAME_STATE_HELP        3
#define GAME_STATE_GAME        4
#define GAME_STATE_EXIT        5
#define GAME_STATE_WIN         6
#define GAME_STATE_GAMEOVER    7
#define GAME_STATE_CREDITS     8
#define INITIAL_GAME_STATE     GAME_STATE_MENU

//CJ-> phantom: constantes
#define PH_VIDA 2

//K-> constante vyl
#define VYL_RANGE 500
#define VYL_MAXIMO_DISPAROS 6

int PH_CONT_POS;
int PH_CONT_AVISO;
int PH_TIEMPO_APAR;

int frames; //para limitar los frames
int contFrameDibujar; //Contador para alternar frames
int frameDibujar;
int contFrameDibujarDisparo; //Contador para alternar frames
int frameDibujarDisparo;
int enemyFrameLimit;
int spawnerFrameLimit;
char state;

int puntuacion; //Puntuacion conseguida
int nivel;      //Nivel actual
char bufpunt[8];
char bufnivel[4];

//Sprite del jugador
struct Sprite {
  unsigned char x,y,preX,preY;
  int dir; //0 = Arriba, 1 = Abajo, 2 = Derecha, 3 = Izquierda
  int disparo;
  int periodoDisparo;
  int address;
  int toques;		//toques del personaje, la vida INTERFAZ
  int disparosDisp;	//numero de disparos disponibles INTERFAZ
  int cooldown;     //tiempo de invencibilidad tras recibir un golpe
};
struct Sprite player;

//Disparos del Jugador
struct Disparo {
  unsigned char x,y,preX,preY;
  int dir; //0 = Arriba, 1 = Abajo, 2 = Derecha, 3 = Izquierda
  int activo;
  int address;
};
struct Disparo disparos[MAX_DISPAROS]; //Array de disparos

//CJ-> phantom: estrucura para maquina de estados
struct Phantom {
  unsigned char x, y, preX, preY;
  unsigned char posJugX, posJugY;
  int dirX, dirY;
  int contVida, contPosAct, contAviso, contAparicion;
  bool visible, fijado, aviso, isDead;
};
struct Phantom fantasma;

struct Zombie{
	unsigned char x,y,preX,preY;
	float attackCounter;
	int vidaTotal, vidaActual;
	int id;
};
struct Zombie zombi[3];

struct Doppel {							//DOPPELGANGER
  unsigned char x, y, preX, preY;
  int dop_vida;
  struct Disparo dispdoppel[MAX_DISPAROS];
  int disparo;
  int disparosDisp;	//numero de disparos disponibles
};
struct Doppel doppel;

struct Vyl{
	unsigned char x,y,preX,preY;
	float attackCounter;
	int vidaTotal, vidaActual;
	int numeroDisparosVyl;
	int recarga;
	struct Disparo disparosVyl[VYL_MAXIMO_DISPAROS];
};
struct Vyl vyl;

char roomaux[ROOMSIZE][ROOMSIZE];

const unsigned char room[ROOMSIZE][ROOMSIZE] = { //IZQUIERDA ES ARRIBA Y DERECHA ES ABAJO, ARRIBA ES IZQUIERDA Y ABAJO ES DERECHA (WTF!!)
	{5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
	{7, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8},
};


int obstaculos[NUMOBSTACULOS][2];


int zombies;			//Variables para la cantidad de enemigos del nivel
int doppels;
int fantasmas;
int vyls;
int totalEnemies;


void setPalette(char *pPalette) { //Asigna la paleta
	char nColor;
	for(nColor = 0; nColor < NUM_COLORS; ++nColor) {
		cpc_SetInk(nColor, pPalette[nColor]);
	}
}

int coincide(int x, int y){ //devuelve 0 si no coincide, y 1 o mas si coincide
	int wx, hy, wox, hoy, res, i;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;
	
	for (i=0; i<NUMOBSTACULOS; i++) {
		wox = obstaculos[i][0] + WIDTHCHAR-1; hoy = obstaculos[i][1] + HEIGHTCHAR-2;
		if((wox < x) || (wx < obstaculos[i][0]) || (hoy < y) || (hy < obstaculos[i][1])){}else res++;
	}

	if(x < MIN_X || MAX_X < x || y < MIN_Y-1 || MAX_Y < y) res++;
	
	return res;
}

int coincideConPlayer(int x, int y){ //devuelve 0 si no coincide, y 1 o mas si coincide
	int wx, hy, wox, hoy, res;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;
	
	wox = player.x + WIDTHCHAR-1; hoy = player.y + HEIGHTCHAR-1;
	if((wox < x) || (wx < player.x) || (hoy < y) || (hy < player.y)){}else res++;

	//if(x < MIN_X || MAX_X < x || y < MIN_Y || MAX_Y < y) res++;
	
	if(res > 0 && player.cooldown == 0) {
		player.toques--;
		drawCorazones();
		cpc_WyzStartEffect(1,1);	//Reproducir en el canal 2 efecto de dañado (efecto 2)
		player.cooldown = COOLDOWN_LIMIT; //cooldown se iguala al limite y empieza a disminuir
	}

	return res;
}

int coincideConEnemigo(int x, int y, int id){ //devuelve 0 si no coincide, y 1 o mas si coincide con alguno
	int wx, hy, wox, hoy, res, i;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;

	for(i = 0; i < 3 && res == 0; i++){
		wox = zombi[i].x + WIDTHCHAR-1; hoy = zombi[i].y + HEIGHTCHAR-1;
		if(zombi[i].vidaActual > 0 && zombi[i].id != id){
			if((wox < x) || (wx < zombi[i].x) || (hoy < y) || (hy < zombi[i].y)){}else res++;
		}
	}

	if(res == 0){
		wox = vyl.x + WIDTHCHAR-1; hoy = vyl.y + HEIGHTCHAR-1;

		if(vyl.vidaActual > 0){
			if((wox < x) || (wx < vyl.x) || (hoy < y) || (hy < vyl.y)){}else res++;
		}

		wox = doppel.x + WIDTHCHAR-1; hoy = doppel.y + HEIGHTCHAR-1;

		if(doppel.dop_vida > 0){
			if((wox < x) || (wx < doppel.x) || (hoy < y) || (hy < doppel.y)){}else res++;		
		}

		wox = fantasma.x + WIDTHCHAR-1; hoy = fantasma.y + HEIGHTCHAR-1;

		if(fantasma.contVida > 0){
			if((wox < x) || (wx < fantasma.x) || (hoy < y) || (hy < fantasma.y)){}else res++;		
		}		
	}

	return res;
}

int coincideConDisparo(int x, int y){ //DISPAROS DEL JUGADOR, devuelve 0 si no coincide, y 1 o mas si coincide
	int wx, hy, wox, hoy, res, i;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;
	
	for (i=0; i<MAX_DISPAROS; i++) {
		if(disparos[i].activo == 1) {
			wox = disparos[i].x + WIDTHCHAR-1; hoy = disparos[i].y + HEIGHTCHAR-1;
			if((wox < x) || (wx < disparos[i].x) || (hoy < y) || (hy < disparos[i].y)){}
			else { 
				res++;
				disparos[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
				player.disparosDisp++;
				drawDisparos();
			}
		}
	}

	
	return res;
}

int coincideConDisparoDoppel(int x, int y){ //DISPAROS DEL DOPPEL, devuelve 0 si no coincide, y 1 o mas si coincide
	int wx, hy, wox, hoy, res, i;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;
	
	for (i=0; i<MAX_DISPAROS; i++) {
		if(doppel.dispdoppel[i].activo == 1) {
			wox = doppel.dispdoppel[i].x + WIDTHCHAR-1; hoy = doppel.dispdoppel[i].y + HEIGHTCHAR-1;
			if((wox < x) || (wx < doppel.dispdoppel[i].x) || (hoy < y) || (hy < doppel.dispdoppel[i].y)){}
			else { 
				res++;
				doppel.dispdoppel[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x, doppel.dispdoppel[i].y));
				doppel.disparosDisp++;
			}
		}
	}
	
	return res;
}

int coincideConDisparoVyl(int x, int y){ //DISPAROS DEL VYL, devuelve 0 si no coincide, y 1 o mas si coincide
	int wx, hy, wox, hoy, res, i;
	wx = x + WIDTHCHAR-1; hy = y + HEIGHTCHAR-1; res=0;
	
	for (i=0; i<VYL_MAXIMO_DISPAROS; i++) {
		if(vyl.disparosVyl[i].activo == 1) {
			wox = vyl.disparosVyl[i].x + WIDTHCHAR-1; hoy = vyl.disparosVyl[i].y + HEIGHTCHAR-1;
			if((wox < x) || (wx < vyl.disparosVyl[i].x) || (hoy < y) || (hy < vyl.disparosVyl[i].y)){}
			else { 
				res++;
				vyl.disparosVyl[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x, vyl.disparosVyl[i].y));
				vyl.numeroDisparosVyl++;
			}
		}
	}
	
	return res;
}

void initSpawner(){  //Spawner de enemigos
	zombies=0;			//Variables para la cantidad de enemigos del nivel
	doppels=0;
	fantasmas=0;
	vyls=0;

	zombi[0].vidaActual=-10;
	zombi[1].vidaActual=-10;
	zombi[2].vidaActual=-10;
	vyl.vidaActual=-10;
	fantasma.contVida=-10;
	fantasma.isDead=true;
	doppel.dop_vida=-10;

		switch(nivel%10){
			case 1:
				zombies=5;
			break;
			case 2:
				zombies=4;
				vyls=2;
			break;
			case 3:
				zombies=6;
				fantasmas=2;
			break;
			case 4:
				zombies=4;
				doppels=1;
			break;
			case 5:
				fantasmas=3;
				doppels=2;
			break;
			case 6:
				zombies=4;
				vyls=5;
				fantasmas=1;
			break;
			case 7:
				zombies=5;
				vyls=2;
				fantasmas=2;
				doppels=1;
			break;
			case 8:
				zombies=16;
				vyls=5;
			break;
			case 9:
				zombies=5;
				vyls=3;
				doppels=3;
			break;
			case 0:
				zombies=12;
				vyls=7;
				fantasmas=5;
				doppels=3;
			break;
		}
	totalEnemies=zombies+vyls+doppels+fantasmas;
}


void draw(int opcion) { //Dibuja lo que le digas
	int i;

	switch(opcion) {
		case 1:
			cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(player.preX,player.preY));
			switch(player.dir) {
				case 0: 
					if(frameDibujar == 0) cpc_PutSp(S_HEROE_ARRIBA_F1_data,8,4,cpc_GetScrAddress(player.x,player.y));
					else if(frameDibujar == 1 && player.cooldown == 0) cpc_PutSp(S_HEROE_ARRIBA_F2_data,8,4,cpc_GetScrAddress(player.x,player.y));
				break;
				case 1: 
					if(frameDibujar == 0) cpc_PutSp(S_HEROE_ABAJO_F1_data,8,4,cpc_GetScrAddress(player.x,player.y));
					else if(frameDibujar == 1 && player.cooldown == 0) cpc_PutSp(S_HEROE_ABAJO_F2_data,8,4,cpc_GetScrAddress(player.x,player.y));
				break;
				case 2: 
					if(frameDibujar == 0) cpc_PutSp(S_HEROE_DERECHA_F1_data,8,4,cpc_GetScrAddress(player.x,player.y));
					else if(frameDibujar == 1 && player.cooldown == 0) cpc_PutSp(S_HEROE_DERECHA_F2_data,8,4,cpc_GetScrAddress(player.x,player.y));
				break;
				case 3: 
					if(frameDibujar == 0) cpc_PutSp(S_HEROE_IZQUIERDA_F1_data,8,4,cpc_GetScrAddress(player.x,player.y));
					else if(frameDibujar == 1 && player.cooldown == 0) cpc_PutSp(S_HEROE_IZQUIERDA_F2_data,8,4,cpc_GetScrAddress(player.x,player.y));
				break;
			}
		break;
		case 2:
			for(i=0; i<MAX_DISPAROS; i++) {
				if(disparos[i].activo == 1) {
					cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(disparos[i].preX,disparos[i].preY));
					switch(disparos[i].dir) {
						case 0:
							if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_ARRIBA_F1_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
							else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_ARRIBA_F2_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
						break;
						case 1:
							if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
							else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_ABAJO_F2_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
						break;
						case 2:
							if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_DERECHA_F1_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
							else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_DERECHA_F2_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
						break;
						case 3:
							if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_IZQUIERDA_F1_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
							else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_IZQUIERDA_F2_data,8,4,cpc_GetScrAddress(disparos[i].x,disparos[i].y));
						break;
					}
				}
			}
		break;
		case 3:
			//CJ-> Aviso: dibujado del aviso del fantasma
			cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(fantasma.preX,fantasma.preY));
			//if(fantasma.aviso== true){
				
				//cpc_PutSp(S_SIGNAL_data,8,4,cpc_GetScrAddress(player.x, player.y-4));
			//}
			//CJ-> Phantom: dibujado del fantasma (FALLA EL BORRADO DESPUÉS DE ESTAR VISIBLE)
			if(fantasma.visible== true){
				if(frameDibujar == 0) cpc_PutSp(S_ENEMIGO04_F1_data,8,4,cpc_GetScrAddress(fantasma.x,fantasma.y));
				else if(frameDibujar == 1) cpc_PutSp(S_ENEMIGO04_F2_data,8,4,cpc_GetScrAddress(fantasma.x,fantasma.y));
				
			}
		break;
		case 4:
			for (i=0; i<3; i++){
				if (zombi[i].vidaActual>0){
					cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(zombi[i].preX,zombi[i].preY));
					if(frameDibujar == 0) cpc_PutSp(S_ENEMIGO01_F1_data,8,4,cpc_GetScrAddress(zombi[i].x,zombi[i].y));
					else if(frameDibujar == 1) cpc_PutSp(S_ENEMIGO01_F2_data,8,4,cpc_GetScrAddress(zombi[i].x,zombi[i].y));
				}
			}
		break;
		case 5:
			cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.preX,vyl.preY));
			if(vyl.vidaActual>0) {
				if(frameDibujar == 0) cpc_PutSp(S_ENEMIGO02_F1_data,8,4,cpc_GetScrAddress(vyl.x,vyl.y));
				else if(frameDibujar == 1) cpc_PutSp(S_ENEMIGO02_F2_data,8,4,cpc_GetScrAddress(vyl.x,vyl.y));
			}
		break;
		case 6:
			cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(doppel.preX, doppel.preY));
			if(doppel.dop_vida>0) {
				if(frameDibujar == 0) cpc_PutSp(S_ENEMIGO03_F1_data,8,4,cpc_GetScrAddress(doppel.x, doppel.y));
				else if(frameDibujar == 1) cpc_PutSp(S_ENEMIGO03_F2_data,8,4,cpc_GetScrAddress(doppel.x, doppel.y));
			}
		break;
		
		case 7: //DISPAROS DOPPEL
			for(i=0; i<MAX_DISPAROS; i++) {
				if(doppel.dispdoppel[i].activo == 1) {
					cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].preX,doppel.dispdoppel[i].preY));
					if(doppel.dop_vida > 0) {
						switch(doppel.dispdoppel[i].dir) {
							case 0: 
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_ARRIBA_F1_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_ARRIBA_F2_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
							break;
							case 1: 
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_ABAJO_F2_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
							break;
							case 2:	
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_DERECHA_F1_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_DERECHA_F2_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
							break;
							case 3: 
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_IZQUIERDA_F1_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_IZQUIERDA_F2_data,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y));
							break;
						}
					}
				}
			}
		break;
		
		case 8: //DISPAROS VYL
			for(i=0; i<VYL_MAXIMO_DISPAROS; i++) {
				if(vyl.disparosVyl[i].activo == 1) {
					cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].preX,vyl.disparosVyl[i].preY));
					if(vyl.vidaActual > 0) {
						switch(vyl.disparosVyl[i].dir) {
							case 0:	
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_VYL_ARRIBA_F1_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_VYL_ARRIBA_F2_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
							break;
							case 1:	
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_VYL_ABAJO_F1_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_VYL_ABAJO_F2_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
							break;
							case 2:	
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_VYL_DERECHA_F1_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_VYL_DERECHA_F2_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
							break;
							case 3:	
								if(frameDibujarDisparo == 0) cpc_PutSp(S_DISPARO_VYL_IZQUIERDA_F1_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
								else if(frameDibujarDisparo == 1) cpc_PutSp(S_DISPARO_VYL_IZQUIERDA_F2_data,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y));
							break;
						}
					}
				}
			}
		break;
	}
}

void createInitialRoom(){ //Crea la habitacion inicial
	int i, j;
	int n = 0;
	
	//copiar matriz a auxiliar
	for(i=0; i < ROOMSIZE; i++) for(j=0; j < ROOMSIZE; j++) roomaux[j][i] = room[i][j];	
	
	for(i=0; i<18; i++){
		    	for(j=0; j<11; j++){
		    			if (rand() % 100<5&&n<NUMOBSTACULOS){
		    				obstaculos[n][0]=4+(i*4);
		    				obstaculos[n][1]=47+(j*8);
		    				n++;
		    			}
		    		}
		    	}
}

void reiniciarPuntuacion() {
	puntuacion = 0;
	nivel = 1;
	player.toques = 6;
}

void drawRoom(){ //Dibuja la habitacion
	int x, y, i, j;
	
	for(i=0; i < ROOMSIZE; i++) for(j=0; j < ROOMSIZE; j++){
		x = (ROOMLEFT+i)*WIDTHCHAR;
		y = (ROOMUP+j)*HEIGHTCHAR;
		
		switch(roomaux[i][j]){
			case 1: cpc_PutSp(S_PARED_SUPERIOR_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 2: cpc_PutSp(S_PARED_INFERIOR_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 3: cpc_PutSp(S_PARED_IZQUIERDA_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 4: cpc_PutSp(S_PARED_DERECHA_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 5: cpc_PutSp(S_PARED_ESQUINA1_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 6: cpc_PutSp(S_PARED_ESQUINA2_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 7: cpc_PutSp(S_PARED_ESQUINA3_data,8,4,cpc_GetScrAddress(x,y)); break;
			case 8: cpc_PutSp(S_PARED_ESQUINA4_data,8,4,cpc_GetScrAddress(x,y)); break;
		}
	}

	for (i=0; i<NUMOBSTACULOS; i++) {
		cpc_PutSp(S_PIEDRA_data,8,4,cpc_GetScrAddress(obstaculos[i][0],obstaculos[i][1]));
	}

	/*
	cpc_PutSp(S_PIEDRA_data,8,4,cpc_GetScrAddress(obs1[0],obs1[1]));
	cpc_PutSp(S_PIEDRA_data,8,4,cpc_GetScrAddress(obs2[0],obs2[1]));
	cpc_PutSp(S_PIEDRA_data,8,4,cpc_GetScrAddress(obs3[0],obs3[1]));
	cpc_PutSp(S_PIEDRA_data,8,4,cpc_GetScrAddress(obs4[0],obs4[1]));
	*/
}

//INTERFAZ
void drawInterface() {
	int i;

	//Pintar los separadores
	cpc_PutSp(S_SEPARADOR_DERECHA_data,8,4,cpc_GetScrAddress(19*4,8));
	cpc_PutSp(S_SEPARADOR_DERECHA_data,8,4,cpc_GetScrAddress(19*4,16));
	cpc_PutSp(S_SEPARADOR_DERECHA_data,8,4,cpc_GetScrAddress(19*4,24));
	cpc_PutSp(S_SEPARADOR_IZQUIERDA_data,8,4,cpc_GetScrAddress(0,8));
	cpc_PutSp(S_SEPARADOR_IZQUIERDA_data,8,4,cpc_GetScrAddress(0,16));
	cpc_PutSp(S_SEPARADOR_IZQUIERDA_data,8,4,cpc_GetScrAddress(0,24));
	for(i = 1; i < 19; i++) {	//separadores de arriba y de abajo
		cpc_PutSp(S_SEPARADOR_ARRIBA_data,8,4,cpc_GetScrAddress(i*4,0));
		cpc_PutSp(S_SEPARADOR_ABAJO_data,8,4,cpc_GetScrAddress(i*4,28));
	}
	cpc_PutSp(S_SEPARADOR_ESQUINA1_data,8,4,cpc_GetScrAddress(0,0));
	cpc_PutSp(S_SEPARADOR_ESQUINA2_data,8,4,cpc_GetScrAddress(19*4,0));
	cpc_PutSp(S_SEPARADOR_ESQUINA3_data,8,4,cpc_GetScrAddress(19*4,28));
	cpc_PutSp(S_SEPARADOR_ESQUINA4_data,8,4,cpc_GetScrAddress(0,28));

	//Se llaman para pintar los corazones y los disparos
	drawCorazones();
	drawDisparos();

	//Pintar texto DISPAROS
	cpc_SetInkGphStr(1, 10);
	cpc_SetInkGphStr(2, 10);
	cpc_SetInkGphStr(3, 10);
	cpc_PrintGphStrXY("VIDA:", 4, 8);
	cpc_SetInkGphStr(1, 34);
	cpc_SetInkGphStr(2, 34);
	cpc_SetInkGphStr(3, 34);
	cpc_PrintGphStrXY("DISPAROS:", 4, 21);
	cpc_SetInkGphStr(1, 32);
	cpc_SetInkGphStr(2, 32);
	cpc_SetInkGphStr(3, 32);
	cpc_PrintGphStrXY("PUNTUACION:", 40, 8);
	cpc_SetInkGphStr(1, 42);
	cpc_SetInkGphStr(2, 42);
	cpc_SetInkGphStr(3, 42);
	cpc_PrintGphStrXY("NIVEL:", 50, 21);
}

void drawCorazones() {
	//Pintar corazones segun el dano del personaje
	switch(player.toques) {
		case 0:
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 1:
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 2:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 3:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 4:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 5:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(23, 7));
		break;
		case 6:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(15, 7));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(19, 7));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(23, 7));
		break;
	}
}

void drawCorazonesWin() {
	//Pintar corazones segun el dano del personaje en la pantalla SIGUIENTE NIVEL
	switch(player.toques) {
		case 0:
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 1:
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 2:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 3:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 4:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON3_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 5:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON2_data,8,4,cpc_GetScrAddress(43, 105));
		break;
		case 6:
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(35, 105));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(39, 105));
			cpc_PutSp(S_CORAZON1_data,8,4,cpc_GetScrAddress(43, 105));
		break;
	}
}

void drawDisparos() {
	switch(player.disparosDisp) {
		case 0:
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(23, 20));
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(27, 20));
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(31, 20));
		break;
		case 1:
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(23, 20));
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(27, 20));
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(31, 20));
		break;
		case 2:
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(23, 20));
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(27, 20));
			cpc_PutSp(S_DISPARO_INACTIVO_F1_data,8,4,cpc_GetScrAddress(31, 20));
		break;
		case 3:
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(23, 20));
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(27, 20));
			cpc_PutSp(S_DISPARO_ABAJO_F1_data,8,4,cpc_GetScrAddress(31, 20));
		break;
	}
}

void drawNiveles(int x, int y) { //x=70, y=21
	cpc_SetInkGphStr(1, 128);
	cpc_SetInkGphStr(2, 128);
	cpc_SetInkGphStr(3, 128);
	sprintf(bufnivel, "%d", nivel);
	if(nivel<100) {
		if(nivel<10) {
			bufnivel[2] = bufnivel[0];
			bufnivel[1] = '0';
			bufnivel[0] = '0';
		}
		else {
			bufnivel[2] = bufnivel[1];
			bufnivel[1] = bufnivel[0];
			bufnivel[0] = '0';
		}
	}
	cpc_PrintGphStrXY(bufnivel, x, y);
}

int potencia(int exp) {
	int res;
	if(exp>0) {
		res = 10; exp--;
		while(exp > 0) {
			res = res * 10;
			exp--;
		}
	}
	else {
		res = 0;
	}
	return res;
}

void drawPuntuacion(int x, int y) { //x=62, y=8
	int i, j, salir;
	cpc_SetInkGphStr(1, 128);
	cpc_SetInkGphStr(2, 128);
	cpc_SetInkGphStr(3, 128);
	sprintf(bufpunt, "%d", puntuacion);
	salir = 0;
	for (i=0; i<6 && salir == 0; i++) {
		if(puntuacion < potencia(i)) {
			salir = 1;
			i--;
			for (j=6; j>=0; j--) {
				if(i>=0) {
					bufpunt[j] = bufpunt[i];
					i--;
				}
				else {
					bufpunt[j] = '0';
				}
			}
		}
	}
	cpc_PrintGphStrXY(bufpunt, x, y);
}
//////// FIN INTERFAZ ////////

void updateDisparosVyl() { //Actualiza los disparos
	int i, hay, dispcol;
	hay = 0;

	for(i=0; i<VYL_MAXIMO_DISPAROS; i++) {
		if(vyl.disparosVyl[i].activo == 1) {
			dispcol = 0;
			hay = 1;
			
			switch(vyl.disparosVyl[i].dir) {
				case 0: vyl.disparosVyl[i].preY = vyl.disparosVyl[i].y;
						vyl.disparosVyl[i].y-=DISPARO_VEL*2;
					break;
				case 1: vyl.disparosVyl[i].preY = vyl.disparosVyl[i].y;
						vyl.disparosVyl[i].y+=DISPARO_VEL*2;
					break;
				case 2: vyl.disparosVyl[i].preX = vyl.disparosVyl[i].x;
						vyl.disparosVyl[i].x+=DISPARO_VEL;
					break;
				case 3: vyl.disparosVyl[i].preX = vyl.disparosVyl[i].x;
						vyl.disparosVyl[i].x-=DISPARO_VEL;
					break;
			}
			
			if(vyl.disparosVyl[i].y < MIN_Y || vyl.disparosVyl[i].y > MAX_Y || vyl.disparosVyl[i].x < MIN_X || vyl.disparosVyl[i].x > MAX_X
				|| coincide(vyl.disparosVyl[i].x,vyl.disparosVyl[i].y) != 0){
				vyl.disparosVyl[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.disparosVyl[i].preX,vyl.disparosVyl[i].preY));
				vyl.numeroDisparosVyl++;
			}
		}
	}

	if(hay == 1) {
			draw(8);
	}
}

void dispararVyl(int ndir, int nx, int ny) { //Activa un disparo del ENEMIGO
	int i, pos, salir;
	salir = 0;
	
	for(i=vyl.numeroDisparosVyl; i<vyl.numeroDisparosVyl+3 && salir == 0; i++) {
		pos = i;
		if(i>=VYL_MAXIMO_DISPAROS){	 //El for y este if buscan un disparo que no haya sido disparado
			pos -= VYL_MAXIMO_DISPAROS;
		}

		if(vyl.disparosVyl[pos].activo == 0 && coincide(vyl.x+nx,vyl.y+ny)==0){
			vyl.numeroDisparosVyl--;		//numero de disparos disponibles
			
			cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1)
			vyl.disparosVyl[pos].activo = 1;
			vyl.disparosVyl[pos].dir = ndir;
			vyl.disparosVyl[pos].x = vyl.x+nx;
			vyl.disparosVyl[pos].y = vyl.y+ny;
			vyl.disparosVyl[pos].preX = vyl.x+nx;
			vyl.disparosVyl[pos].preY = vyl.y+ny;
			vyl.numeroDisparosVyl++;
			salir = 1;
			if(vyl.numeroDisparosVyl >= VYL_MAXIMO_DISPAROS) {
				vyl.numeroDisparosVyl = 0;
			}
		}
	}
}

void updateDisparosDoppel() { //Actualiza los disparos
	int i, hay, dispcol;
	hay = 0;

	for(i=0; i<MAX_DISPAROS; i++) {
		if(doppel.dispdoppel[i].activo == 1) {
			dispcol = 0;
			hay = 1;
			
			switch(doppel.dispdoppel[i].dir) {
				case 0: doppel.dispdoppel[i].preY = doppel.dispdoppel[i].y;
						doppel.dispdoppel[i].y-=DISPARO_VEL*2;
					break;
				case 1: doppel.dispdoppel[i].preY = doppel.dispdoppel[i].y;
						doppel.dispdoppel[i].y+=DISPARO_VEL*2;
					break;
				case 2: doppel.dispdoppel[i].preX = doppel.dispdoppel[i].x;
						doppel.dispdoppel[i].x+=DISPARO_VEL;
					break;
				case 3: doppel.dispdoppel[i].preX = doppel.dispdoppel[i].x;
						doppel.dispdoppel[i].x-=DISPARO_VEL;
					break;
			}
			
			if(doppel.dispdoppel[i].y < MIN_Y || doppel.dispdoppel[i].y > MAX_Y || doppel.dispdoppel[i].x < MIN_X || doppel.dispdoppel[i].x > MAX_X
				|| coincide(doppel.dispdoppel[i].x,doppel.dispdoppel[i].y) != 0){
				doppel.dispdoppel[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(doppel.dispdoppel[i].preX,doppel.dispdoppel[i].preY));
				doppel.disparosDisp++;
			}
		}
	}

	if(hay == 1) {
		draw(7);
	}
}

void dispararDoppel(int ndir, int nx, int ny) { //Activa un disparo del ENEMIGO
	int i, pos, salir;
	salir = 0;
	
	for(i=doppel.disparo; i<doppel.disparo+3 && salir == 0; i++) {
		pos = i;
		if(i>=MAX_DISPAROS){	 //El for y este if buscan un disparo que no haya sido disparado
			pos -= MAX_DISPAROS;
		}

		if(doppel.dispdoppel[pos].activo == 0 && coincide(doppel.x+nx,doppel.y+ny)==0){
			doppel.disparosDisp--;		//numero de disparos disponibles
			cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1)
			doppel.dispdoppel[pos].activo = 1;
			doppel.dispdoppel[pos].dir = ndir;
			doppel.dispdoppel[pos].x = doppel.x+nx;
			doppel.dispdoppel[pos].y = doppel.y+ny;
			doppel.dispdoppel[pos].preX = doppel.x+nx;
			doppel.dispdoppel[pos].preY = doppel.y+ny;
			doppel.disparo++;
			salir = 1;
			if(doppel.disparo >= MAX_DISPAROS) {
				doppel.disparo = 0;
			}
		}
	}
}

void updateDisparos() { //Actualiza los disparos
	int i, hay, dispcol;
	hay = 0;

	for(i=0; i<MAX_DISPAROS; i++) {
		if(disparos[i].activo == 1) {
			dispcol = 0;
			hay = 1;
			
			switch(disparos[i].dir) {
				case 0: disparos[i].preY = disparos[i].y;
						disparos[i].y-=DISPARO_VEL*2;
					break;
				case 1: disparos[i].preY = disparos[i].y;
						disparos[i].y+=DISPARO_VEL*2;
					break;
				case 2: disparos[i].preX = disparos[i].x;
						disparos[i].x+=DISPARO_VEL;
					break;
				case 3: disparos[i].preX = disparos[i].x;
						disparos[i].x-=DISPARO_VEL;
					break;
			}
			
			if(disparos[i].y < MIN_Y || disparos[i].y > MAX_Y || disparos[i].x < MIN_X || disparos[i].x > MAX_X
				|| coincide(disparos[i].x,disparos[i].y) != 0){
				disparos[i].activo = 0;
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(disparos[i].preX,disparos[i].preY));
				player.disparosDisp++;
				drawDisparos();
			}
		}
	}

	if(hay == 1) {
		draw(2);
	}
	
	if(doppel.dop_vida>0) updateDisparosDoppel();
	if(vyl.vidaActual>0) {
		updateDisparosVyl();
	}
	else {
		//draw(8);
	}
}


void disparar(int ndir, int nx, int ny) { //Activa un disparo
	int i, pos, salir;
	salir = 0;

	for(i=player.disparo; i<player.disparo+3 && salir == 0; i++) {
		pos = i;
		if(i>=MAX_DISPAROS){	 //El for y este if buscan un disparo que no haya sido disparado
			pos -= MAX_DISPAROS;
		}

		if(disparos[pos].activo == 0 && coincide(player.x+nx,player.y+ny)==0){
			player.disparosDisp--;		//numero de disparos disponibles INTERFAZ
			drawDisparos();
			cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1)
			disparos[pos].activo = 1;
			disparos[pos].dir = ndir;
			disparos[pos].x = player.x+nx;
			disparos[pos].y = player.y+ny;
			disparos[pos].preX = player.x+nx;
			disparos[pos].preY = player.y+ny;
			player.disparo++;
			player.periodoDisparo = DISPARO_PERIODO;
			salir = 1;
			
			if(doppel.dop_vida>0) 	switch(ndir){
										case 0: dispararDoppel(1, -nx, -ny); break;
										case 1: dispararDoppel(0, -nx, -ny); break;
										case 2: dispararDoppel(3, -nx, -ny); break;
										case 3: dispararDoppel(2, -nx, -ny); break;
									}
			
			if(player.disparo >= MAX_DISPAROS) {
				player.disparo = 0;
			}
		}
	}
}


void initMenu() { //Al INICIAR la partida
	cpc_SetModo(0);

	setPalette(palette);
	setPalette(palette);
	setPalette(palette);
	setPalette(palette);

	state = INITIAL_GAME_STATE;

	//Aqui iria la carga de las ANIMACIONES

	//Asignacion de las TECLAS
	cpc_AssignKey(KEY_LEFT,0x4101);
  	cpc_AssignKey(KEY_RIGHT,0x4002);
  	cpc_AssignKey(KEY_DOWN,0x4004);
  	cpc_AssignKey(KEY_UP,0x4001);
  	cpc_AssignKey(KEY_1,0x4801);
    cpc_AssignKey(KEY_2,0x4802);
    cpc_AssignKey(KEY_3,0x4702);
    //cpc_AssignKey(KEY_4,0x4701);
    cpc_AssignKey(KEY_ESC,0x4804);
    cpc_AssignKey(KEY_W,0x4708);
    cpc_AssignKey(KEY_A,0x4820);
    cpc_AssignKey(KEY_S,0x4710);
    cpc_AssignKey(KEY_D,0x4720);	

    //Inicialización y carga del reproductor de sonido
    cpc_WyzInitPlayer(TABLA_SONIDOS, TABLA_PAUTAS, TABLA_EFECTOS, TABLA_CANCION);
	cpc_WyzLoadSong(0);
	cpc_WyzSetPlayerOn();
}



void initPhantom(){

	int puede; 
	puede = 1;

	PH_CONT_POS = 15/ENEMY_FRAME_LIMIT;
	PH_CONT_AVISO = 50/ENEMY_FRAME_LIMIT;
	PH_TIEMPO_APAR = 100/ENEMY_FRAME_LIMIT;

	while(puede != 0){

		fantasma.x= rand()%MAX_X+MIN_X;
		fantasma.y= rand()%MAX_Y+MIN_Y;
		fantasma.preX = fantasma.x;
		fantasma.preY = fantasma.y;
		puede = coincide(fantasma.x, fantasma.y);
	}

	fantasma.posJugX= player.x;
	fantasma.posJugY= player.y;
	fantasma.contVida= PH_VIDA*(((nivel-1)/10)+1);
	fantasma.contPosAct= 0;
	fantasma.contAviso= 0;
	fantasma.aviso= false;
	fantasma.fijado= false;
	fantasma.contAparicion= PH_TIEMPO_APAR;
	fantasma.visible= true;
	fantasma.isDead= false;
}

void initZombie(int n){
	int puede; 
	puede = 1;

	while(puede != 0){
		zombi[n].x= rand()%MAX_X+MIN_X;
		zombi[n].y= rand()%MAX_Y+MIN_Y;
		zombi[n].preX = zombi[n].x;
		zombi[n].preY = zombi[n].y;
//		puede = coincide(zombi[n].x, zombi[n].y);

		puede = coincide(zombi[n].x, zombi[n].y);
	}
	
	zombi[n].vidaTotal = 3*(((nivel-1)/10)+1);
	zombi[n].vidaActual = 3*(((nivel-1)/10)+1);
	zombi[n].id = n;
}

void initVyl(){
	int puede; 
	puede = 1;

	while(puede != 0){
		vyl.x= rand()%MAX_X+MIN_X;
		vyl.y= rand()%MAX_Y+MIN_Y;
		vyl.preX = vyl.x;
		vyl.preY = vyl.y;
		puede = coincide(vyl.x, vyl.y);
	}
	
	vyl.disparosVyl[0].activo = 0;
	vyl.disparosVyl[1].activo = 0;
	vyl.disparosVyl[2].activo = 0;

	vyl.vidaTotal = 4*(((nivel-1)/10)+1);
	vyl.vidaActual = 4*(((nivel-1)/10)+1);
	vyl.numeroDisparosVyl = 3;
	vyl.recarga = 3;
}

void initDoppel(){
	int puede; 
	puede = 1;

	while(puede != 0){
		doppel.x= rand()%MAX_X+MIN_X;
		doppel.y= rand()%MAX_Y+MIN_Y;
		puede = coincide(doppel.x, doppel.y);
	}
	
	doppel.dop_vida = 2*(((nivel-1)/10)+1);
	doppel.preX = doppel.x;
	doppel.preY = doppel.y;
	doppel.dispdoppel[0].activo = 0;
	doppel.dispdoppel[1].activo = 0;
	doppel.dispdoppel[2].activo = 0;
	doppel.disparo = 0;
	doppel.disparosDisp = MAX_DISPAROS;
}

void initGame() { //Inicializa las variable de Game
	frames = 0;
	contFrameDibujar = 0;
	contFrameDibujarDisparo= 0;
	enemyFrameLimit = ENEMY_FRAME_LIMIT;
	spawnerFrameLimit = SPAWNER_FRAME_LIMIT;

    createInitialRoom();
	
	/*
		============ ZONA DE CREACION Y MANIPULACION DE ENEMIGOS INICIALES EN CADA NIVEL ================
	*/

    player.x = 37;
	player.y = 170;
	player.dir = 1; //Empieza mirando hacia abajo
	frameDibujar = 0;  //Primer frame de la animacion
	frameDibujarDisparo = 0;  //Primer frame de la animacion
	player.disparo = 0;
	player.periodoDisparo = 0;
	player.address = cpc_GetScrAddress(player.x,player.y);
	player.disparosDisp = MAX_DISPAROS;
	player.cooldown = 0;

	disparos[0].activo = 0;
	disparos[1].activo = 0;
	disparos[2].activo = 0;

	initSpawner();
}

char Menu() {
	char eleccion = -1;	//empieza sin seleccionar nada

	cpc_ClrScr();
	cpc_SetBorder(BORDE);

	//Dibujar las letras del menu
	cpc_SetInkGphStr(0, 0);
	cpc_SetInkGphStr(1, 8);
	cpc_SetInkGphStr(2, 8);
	cpc_SetInkGphStr(3, 8);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 16);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 11*16);
	cpc_SetInkGphStr(1, 32);
	cpc_SetInkGphStr(2, 34);
	cpc_SetInkGphStr(3, 32);
	cpc_PrintGphStrXY("SUPER;;RETRO;;ROBOT", 22, 2*18);
	cpc_SetInkGphStr(1, 10);
	cpc_SetInkGphStr(3, 10);
	cpc_PrintGphStrXY("RAMPAGE",  34, 3*16);
	cpc_SetInkGphStr(1, 42);
	cpc_SetInkGphStr(2, 42);
	cpc_SetInkGphStr(3, 42);
	cpc_PrintGphStrXY("1;JUGAR", 33, 5*16+5);
	cpc_PrintGphStrXY("2;AYUDA", 33, 6*16+5);
	cpc_PrintGphStrXY("3;CREDITOS", 30, 7*16+5);
	cpc_PrintGphStrXY("ESC;SALIR", 31, 8*16+5);
	/*cpc_PrintGphStrXY("1;JUGAR", 33, 6*16);
	cpc_PrintGphStrXY("2;AYUDA", 33, 7*16);
	cpc_PrintGphStrXY("ESC;SALIR", 31, 8*16);*/
	cpc_SetInkGphStr(1, 138);
	cpc_SetInkGphStr(2, 138);
	cpc_SetInkGphStr(3, 138);
	cpc_PrintGphStrXY("VORTEX;2014;;AMSTRAD;GAME", 15, 10*16);
	
	while (eleccion == -1) {
	    cpc_ScanKeyboard();

	    if (cpc_TestKeyF(KEY_1) == 1) {
	    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1)
			eleccion = GAME_STATE_GAME;
			reiniciarPuntuacion();
		}
	    if (cpc_TestKeyF(KEY_2) == 1) {
	    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 
	        eleccion = GAME_STATE_HELP;
	    }
	    if (cpc_TestKeyF(KEY_3) == 1) {
	    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 
	        eleccion = GAME_STATE_CREDITS;
	    }
	    if (cpc_TestKeyF(KEY_ESC) == 1) {
	    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 
	        eleccion = GAME_STATE_EXIT;
	    }
	}

	return eleccion; 
}

char Help() {
	cpc_ClrScr();

	cpc_PutSp(S_HEROE_ABAJO_F1_data,8,4,cpc_GetScrAddress(7, 63));
	cpc_PutSp(S_HEROE_IZQUIERDA_F1_data,8,4,cpc_GetScrAddress(5, 79));
	cpc_PutSp(S_HEROE_DERECHA_F1_data,8,4,cpc_GetScrAddress(9, 79));
	cpc_PutSp(S_HEROE_DERECHA_F1_data,8,4,cpc_GetScrAddress(5, 95));
	cpc_PutSp(S_DISPARO_DERECHA_F1_data,8,4,cpc_GetScrAddress(9, 95));
	cpc_PutSp(S_ENEMIGO01_F1_data,8,4,cpc_GetScrAddress(31, 8*16));
	cpc_PutSp(S_ENEMIGO02_F1_data,8,4,cpc_GetScrAddress(36, 8*16));
	cpc_PutSp(S_ENEMIGO03_F1_data,8,4,cpc_GetScrAddress(41, 8*16));
	cpc_PutSp(S_ENEMIGO04_F1_data,8,4,cpc_GetScrAddress(46, 8*16));

	cpc_SetInkGphStr(1, 34);
	cpc_SetInkGphStr(2, 34);
	cpc_SetInkGphStr(3, 34);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 16);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 11*16);
	cpc_SetInkGphStr(1, 8);
	cpc_SetInkGphStr(2, 8);
	cpc_SetInkGphStr(3, 8);
	cpc_PrintGphStrXY("COMO;SE;JUEGA:", 27, 2*16);
	cpc_SetInkGphStr(1, 10);
	cpc_SetInkGphStr(2, 10);
	cpc_SetInkGphStr(3, 10);
	cpc_PrintGphStrXY("ESTE;ERES;TU", 15, 4*16);
	cpc_PrintGphStrXY("MUEVETE;CON;LAS;TECLAS;W;A;S;D", 15, 5*16);
	cpc_PrintGphStrXY("DISPARA;CON;LAS;FLECHAS", 15, 6*16);
	cpc_SetInkGphStr(1, 160);
	cpc_SetInkGphStr(2, 160);
	cpc_SetInkGphStr(3, 160);
	cpc_PrintGphStrXY("DERROTA;A;TANTOS;ENEMIGOS;COMO;PUEDAS", 3, 7*16);
	cpc_SetInkGphStr(1, 138);
	cpc_SetInkGphStr(2, 138);
	cpc_SetInkGphStr(3, 138);
	cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;VOLVER", 7, 10*16);

	while (!cpc_AnyKeyPressed());
	while (cpc_AnyKeyPressed());

	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 

	return GAME_STATE_MENU;
}

char GameOver() {
	char eleccionGO = -1;
	cpc_ClrScr();

	cpc_SetInkGphStr(1, 32);
	cpc_SetInkGphStr(2, 32);
	cpc_SetInkGphStr(3, 32);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 16);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 11*16);
	cpc_PrintGphStrXY("PUNTUACION:", 22, 4*16+5);
	cpc_SetInkGphStr(1, 160);
	cpc_SetInkGphStr(2, 160);
	cpc_SetInkGphStr(3, 160);
	cpc_PrintGphStrXY("GAME;OVER", 32, 3*16);
	cpc_SetInkGphStr(1, 42);
	cpc_SetInkGphStr(2, 42);
	cpc_SetInkGphStr(3, 42);
	cpc_PrintGphStrXY("NIVEL:", 22, 5*16+5);
	cpc_SetInkGphStr(1, 128);
	cpc_SetInkGphStr(2, 128);
	cpc_SetInkGphStr(3, 128);
	drawNiveles(52, 5*16+5);
	drawPuntuacion(44, 4*16+5);
	cpc_SetInkGphStr(1, 138);
	cpc_SetInkGphStr(2, 138);
	cpc_SetInkGphStr(3, 138);
	cpc_PrintGphStrXY("1;REINTENTAR", 25, 6*16+15);
	cpc_SetInkGphStr(1, 8);
	cpc_SetInkGphStr(2, 8);
	cpc_SetInkGphStr(3, 8);
	cpc_PrintGphStrXY("2;VOLVER;AL;MENU", 25, 7*16+15);
	
	cpc_PutSp(S_HEROE_MUERTO_F1_data,8,4,cpc_GetScrAddress(38, 9*16+10));
	

	while (eleccionGO == -1) {
		if(frames > FRAME_LIMIT) {
			if(contFrameDibujar>=ALTERNA_FRAME) {
	    		if(frameDibujar == 0) frameDibujar = 1;
	    		else frameDibujar = 0;
	    		
	    		if(frameDibujar == 0) {
	    			cpc_PutSp(S_ENEMIGO03_F1_data,8,4,cpc_GetScrAddress(26, 9*16+10));
					cpc_PutSp(S_ENEMIGO01_F1_data,8,4,cpc_GetScrAddress(32, 9*16+10));
					cpc_PutSp(S_ESTRELLA_F1_data,8,4,cpc_GetScrAddress(38, 134+10));
					cpc_PutSp(S_ENEMIGO02_F1_data,8,4,cpc_GetScrAddress(44, 9*16+10));
					cpc_PutSp(S_ENEMIGO04_F1_data,8,4,cpc_GetScrAddress(50, 9*16+10));
	    		}
	    		else {
	    			cpc_PutSp(S_ENEMIGO03_F2_data,8,4,cpc_GetScrAddress(26, 9*16+10));
					cpc_PutSp(S_ENEMIGO01_F2_data,8,4,cpc_GetScrAddress(32, 9*16+10));
					cpc_PutSp(S_ESTRELLA_F2_data,8,4,cpc_GetScrAddress(38, 134+10));
					cpc_PutSp(S_ENEMIGO02_F2_data,8,4,cpc_GetScrAddress(44, 9*16+10));
					cpc_PutSp(S_ENEMIGO04_F2_data,8,4,cpc_GetScrAddress(50, 9*16+10));
	    		}

	    		contFrameDibujar = 0;
	    	}
	    	else {
				contFrameDibujar++;
	    	}

		    cpc_ScanKeyboard();

		    if (cpc_TestKeyF(KEY_1) == 1)  {
		    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 
				eleccionGO = GAME_STATE_GAME;
				reiniciarPuntuacion();
			}
		    if (cpc_TestKeyF(KEY_2) == 1){
		    	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 
		        eleccionGO = GAME_STATE_MENU;
		    }
		    frames = 0;
		}
		else {
			frames++;
		}
	}

	return eleccionGO;
}

//CJ-> phantom: logica de IA
void getDamagePhantom(){
  if(fantasma.visible== true){
    fantasma.visible= false;
    fantasma.fijado= false;
    fantasma.contPosAct=0;
    fantasma.contAviso= 0;
    fantasma.contVida--;
    if(fantasma.contVida<=0){
    	puntuacion+=30*(((nivel-1)/10)+1);
    	drawPuntuacion(62, 8);
    	cpc_WyzStartEffect(2,2); //Reproducir en el canal 3 efecto de enemigo derrotado (efecto 3)
      fantasma.isDead= true;
    }
  }
}

void updatePhantom(){
	int puede;
	int puede2;

    if(fantasma.isDead==false){
	    //cuando esta oculto
	    if(fantasma.visible== false){
	      //comprobacion posicion jugador hasta que queda fijado
	      if(fantasma.fijado== false){
	        if(player.x==fantasma.posJugX && player.y==fantasma.posJugY){
	          fantasma.contPosAct+=(((nivel-1)/10)+1);
	        }
	        else{
	          fantasma.contPosAct= 0;
	          fantasma.posJugX= player.x;
	          fantasma.posJugY= player.y;
	        }
	        //cuando se llena el contador avisa y fija la posicion del jugador
	        if(fantasma.contPosAct>= PH_CONT_POS){
	          fantasma.x = player.x;
			  fantasma.y = player.y;
	          fantasma.fijado= true;
	          fantasma.aviso= true;
	        }
	      }
	      if(fantasma.aviso==true){
	        fantasma.contAviso++;
	        if (fantasma.contAviso==1 || fantasma.contAviso==(PH_CONT_AVISO-7) || fantasma.contAviso==(PH_CONT_AVISO-4) || fantasma.contAviso==(PH_CONT_AVISO-2) || fantasma.contAviso==(PH_CONT_AVISO-1) || fantasma.contAviso==PH_CONT_AVISO){
	       		cpc_WyzStartEffect(1,3); //Reproducir en el canal 1 efecto de aviso (efecto 4)
	    	}
	      }
	      //cuando acaba el aviso ataca en la posicion fijada
	      if(fantasma.contAviso== PH_CONT_AVISO){
	        fantasma.contAparicion= PH_TIEMPO_APAR;
	        fantasma.aviso= false;
	        fantasma.visible= true;
	      }
	    }
	    else{
	    	//posicion anterior para el borrado del sprite
	    	fantasma.preX= fantasma.x;
	    	fantasma.preY= fantasma.y;
	      //cuando está visible (tiempo de aparicion>0)
	      //movimiento
	      //direccion aleatoria
		  fantasma.dirX = (rand()%3)-1;    //rand()%3-> de 0 a 2 (-1)= [-1,1]
		  fantasma.dirY = (rand()%3)-1;
		  puede = 1;
		  puede2 = 1;
		  puede = coincide(fantasma.x+fantasma.dirX, fantasma.y+fantasma.dirY);
		  puede2 = coincideConPlayer(fantasma.x+fantasma.dirX, fantasma.y+fantasma.dirY);

		  if(puede == 0 && puede2 == 0) {
		  	//arreglos bordes pantalla
		      if((fantasma.x<MAX_X && fantasma.dirX>0) || (fantasma.x>MIN_X && fantasma.dirX<0)){
		        fantasma.x= fantasma.x+fantasma.dirX;
		      }
		      if((fantasma.y<MAX_Y && fantasma.dirY>0) || (fantasma.y>MIN_Y && fantasma.dirY<0)){
		        fantasma.y= fantasma.y+fantasma.dirY;
		      }
		  }

		  if(coincideConDisparo(fantasma.x, fantasma.y) > 0) {
		  	getDamagePhantom();
		  }
	      
	      //se descuenta el tiempo
	      fantasma.contAparicion--;
	      if(fantasma.contAparicion==0){
	        fantasma.visible= false;
	        fantasma.fijado= false;
	        fantasma.contPosAct=0;
	        fantasma.contAviso= 0;
	        fantasma.aviso= false;
	       }
	    draw(3);
    	}
  	}
}

void updateVyl(){
	int iDisp;
	
	if (vyl.vidaActual>0){

		int yOffset = (player.y - vyl.y)/3;
		int xOffset = (player.x - vyl.x);
		float separation = xOffset*xOffset+yOffset*yOffset;
		int seMueveEnX = 0;
		int seMueveEnY = 0;

		if(separation <= VYL_RANGE){
			if(yOffset < 0){
				yOffset = 2;
			}

			else if(yOffset > 0){
				yOffset = -2;
			}

			if(xOffset < 0){
				xOffset = 1;
			}
			else if(xOffset > 0){
				xOffset = -1;
			}
		}
		else{
			if(yOffset < 0 && vyl.x != player.x){
				yOffset = -2;
			}
			else if(yOffset > 0 && vyl.x != player.x){
				yOffset = 2;
			}
			else{
				yOffset = 0;
			}

			if(coincide(vyl.x, vyl.y + yOffset) == 1 && yOffset != 0){
				if(xOffset < 0){
					xOffset = -1;
				}
				else if(xOffset > 0){
					xOffset = 1;
				}
				else
					xOffset = 0;
			}
			else{
				xOffset = 0;
			}
		}
/*		else{
			yOffset = 0;
			xOffset = 0;
		}
*/
		if(xOffset != 0)
			if(coincide(vyl.x + xOffset, vyl.y) == 0){
				if(vyl.x + xOffset < (MAX_X-2) && vyl.x + xOffset > (MIN_X+2)){
					seMueveEnX = 1;
					vyl.preY = vyl.y;
					vyl.preX = vyl.x;
					vyl.x += xOffset;
				}
			}

		if(yOffset != 0)
			if(coincide(vyl.x, vyl.y + yOffset) == 0){
				if(vyl.y + yOffset < (MAX_Y-4) && vyl.y + yOffset > (MIN_Y+4)){
					seMueveEnY = 1;
				if(seMueveEnX == 0){
					vyl.preX = vyl.x;
					vyl.preY = vyl.y;
				}
				vyl.y += yOffset;
			}
		}

			
			//encontrar jugador alineado
			if(vyl.recarga < 3) vyl.recarga++;
			if(vyl.recarga == 3){
				if(abs(player.x-vyl.x) < WIDTHCHAR){
					if(player.y < vyl.y) dispararVyl(0, 0, -8);
					if(player.y > vyl.y) dispararVyl(1, 0, 8);
					vyl.recarga = 0;
				}
				if(abs(player.y-vyl.y) < WIDTHCHAR){
					if(player.x < vyl.x) dispararVyl(3, -4, 0);
					if(player.x > vyl.x) dispararVyl(2, 4, 0);
					vyl.recarga = 0;
				}
			}


		coincideConPlayer(vyl.x, vyl.y);

		if(coincideConDisparo(vyl.x, vyl.y) > 0) {
			vyl.vidaActual--;
			if (vyl.vidaActual<=0)
			{
				puntuacion+=20*(((nivel-1)/10)+1);
				drawPuntuacion(62, 8);
				cpc_WyzStartEffect(2,2); //Reproducir en el canal 3 efecto de enemigo derrotado (efecto 3)
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.preX,vyl.preY));
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(vyl.x,vyl.y));
				updateDisparosVyl();
				iDisp = 0;
				for(iDisp = 0; iDisp<VYL_MAXIMO_DISPAROS; iDisp++) {
					vyl.disparosVyl[iDisp].activo = 0;
				}
			}
		}

		if(coincideConDisparoVyl(player.x, player.y) > 0){
			player.toques--;
			cpc_WyzStartEffect(1,1);	//Reproducir en el canal 2 efecto de dañado (efecto 2)
			drawCorazones();
			player.cooldown = COOLDOWN_LIMIT; //cooldown se iguala al limite y empieza a disminuir
		}

		draw(5);
	}
}

void updateEnemy(){
	int i;
	for (i = 0; i < 3; i++)	{
	
	if (zombi[i].vidaActual>0){

	//if(player.preX != zombi.x || player.preY != zombi.y){
		//CALCULO DISTANCIA JUGADOR-ZOMBIE
		int yOffset = (player.y - zombi[i].y);
		int xOffset = (player.x - zombi[i].x);
		int seMueveEnX = 0;
		int seMueveEnY = 0;

		//SEGUN SEA NEGATIVA O POSITIVA, LO MUEVO EN UNA DIRECCION U OTRA
		if(yOffset < 0){
			yOffset = -2;
		}
		else if(yOffset > 0){
			yOffset = 2;
		}

		if(xOffset < 0){
			xOffset = -1;
		}
		else if(xOffset > 0){
			xOffset = 1;
		}
		

		//CALCULO PARA CADA EJE SI COLISIONA CON UN OSTACULO, SI LO HACE NO SE MUEVE
		if(xOffset != 0) {
			if(coincide(zombi[i].x + xOffset, zombi[i].y) == 0 && coincideConEnemigo(zombi[i].x + xOffset, zombi[i].y, zombi[i].id) == 0){
				seMueveEnX = 1;
				zombi[i].preY = zombi[i].y;
				zombi[i].preX = zombi[i].x;
				zombi[i].x += xOffset;
			}
		}
		if(yOffset != 0) {
			if(coincide(zombi[i].x, zombi[i].y + yOffset) == 0 && coincideConEnemigo(zombi[i].x, zombi[i].y + yOffset, zombi[i].id) == 0){
				seMueveEnY = 1;
				if(seMueveEnX == 0){
					zombi[i].preY = zombi[i].y;
					zombi[i].preX = zombi[i].x;
				}
				zombi[i].y += yOffset;
			}
		}

		if(coincideConPlayer(zombi[i].x, zombi[i].y) > 0) {
			zombi[i].x -= xOffset;
			zombi[i].y -= yOffset;
		}

		if(coincideConDisparo(zombi[i].x, zombi[i].y) > 0 ) {
			zombi[i].vidaActual--;

			if (zombi[i].vidaActual<=0)
			{
				puntuacion+=10*(((nivel-1)/10)+1);
				drawPuntuacion(62, 8);
				cpc_WyzStartEffect(2,2); //Reproducir en el canal 3 efecto de enemigo derrotado (efecto 3)
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(zombi[i].preX,zombi[i].preY));
			}
		}
		


		}
		
	//	}
	if (i==2) draw(4); //Pinta a los 3 zombies al actualizar el tercero
	}
	
}

void updateDoppel(int masx, int masy) {
	if (doppel.dop_vida>0){
		doppel.x += masx;
		doppel.y += masy;

	if(coincide(doppel.x, doppel.y) > 0 || coincideConPlayer(doppel.x, doppel.y) > 0) {
		doppel.x -= masx;
		doppel.y -= masy;
	}

	if(coincideConDisparo(doppel.x, doppel.y) > 0 ) {

			doppel.dop_vida--;
			if (doppel.dop_vida<=0)
			{
				puntuacion+=50*(((nivel-1)/10)+1);
				drawPuntuacion(62, 8);
				cpc_WyzStartEffect(2,2); //Reproducir en el canal 3 efecto de enemigo derrotado (efecto 3)
				cpc_PutSp(S_BLANK,8,4,cpc_GetScrAddress(doppel.preX,doppel.preY));
				updateDisparosDoppel();
			}

	}

	if(coincideConDisparoDoppel(player.x, player.y) > 0) {
		player.toques-=2;
		cpc_WyzStartEffect(1,1);	//Reproducir en el canal 2 efecto de dañado (efecto 2)
		drawCorazones();
		player.cooldown = COOLDOWN_LIMIT;
	}

	draw(6);
	}
}


void checkSpawner(){		//Se encarga de spawnear los enemigos y también de comprobar si has ganado

totalEnemies=zombies+vyls+doppels+fantasmas;

	if (totalEnemies<=0)
		{
			if (zombi[0].vidaActual<=0 && zombi[1].vidaActual<=0 && zombi[2].vidaActual<=0 && vyl.vidaActual<=0 && fantasma.contVida<=0 && doppel.dop_vida<=0)
			{
				state=GAME_STATE_WIN;		//Pasar al siguiente nivel
			}
				
		}
	else
		{
			if (zombies>0)
			{
				if (zombi[0].vidaActual<=0)
				{
					zombies--;
					initZombie(0);
				}
				else if (zombi[1].vidaActual<=0)
				{
					zombies--;
					initZombie(1);
				}
				else if (zombi[2].vidaActual<=0)
				{
					zombies--;
					initZombie(2);
				}
			}

			if (vyls>0)
			{
				if (vyl.vidaActual<=0)
				{
					vyls--;
					initVyl();
				}
			}

			if (fantasmas>0)
			{
				if (fantasma.contVida<=0)
				{
					fantasmas--;
					initPhantom();
				}
			}

			if (doppels>0)
			{
				if (doppel.dop_vida<=0)
				{
					doppels--;
					initDoppel();
				}
			}
		}
}


char Game() { //Juego
	int pulsadoDisparo;

	pulsadoDisparo = 0;
	
    initGame();
    cpc_ClrScr();

    drawRoom();
    draw(1);
    drawInterface();
    drawPuntuacion(62, 8);
	drawNiveles(70, 21);

	while (state == GAME_STATE_GAME) { //Bucle del juego

	    if(frames>FRAME_LIMIT) {
	    	//CJ-> phantom: logica
		    if(enemyFrameLimit <= 0){	
	   			updatePhantom();
				updateEnemy();
				updateDoppel(0, 0);
				updateVyl();
				enemyFrameLimit = ENEMY_FRAME_LIMIT-((nivel-1)/10);
			}
			else{
				enemyFrameLimit--;
			}


	    	if(contFrameDibujar>=ALTERNA_FRAME) {
	    		if(frameDibujar == 0) frameDibujar = 1;
	    		else frameDibujar = 0;
	    		draw(1);
	    		contFrameDibujar = 0;
	    	}
	    	else{
				contFrameDibujar++;
	    	}

	    	if(contFrameDibujarDisparo>=ALTERNA_FRAME_DISPARO) {
	    		if(frameDibujarDisparo == 0) frameDibujarDisparo = 1;
	    		else frameDibujarDisparo = 0;
	    		draw(1);
	    		if(doppels > 0) {
	    			if(doppel.dop_vida > 0) {
	    				draw(7);
	    			}
	    		}
	    		if(vyls > 0) {
	    			if(vyl.vidaActual > 0) {
	    				draw(8);
	    			}
	    		}
	    		contFrameDibujarDisparo = 0;
	    	}
	    	else{
				contFrameDibujarDisparo++;
	    	}

	    	//Actualiza el cooldown si se ha recibido golpe
	    	if(player.cooldown > 0) {
	    		player.cooldown --;
	    		if(player.cooldown < 0) player.cooldown = 0; //Por si se pasa aunque ahora de 1 en 1 es imposible
	    	}

			player.preX=player.x;
	    	player.preY=player.y;

	    	cpc_ScanKeyboard();

	    	doppel.preX = doppel.x;
			doppel.preY = doppel.y;

			if (cpc_TestKey(KEY_D)==1 && player.x<MAX_X && coincide(player.x+1,player.y) == 0) {
				player.x++;
				updateDoppel(-1, 0);
				player.dir = 2;
				draw(1);
			}
			else if (cpc_TestKey(KEY_A)==1 && player.x>MIN_X && coincide(player.x-1,player.y) == 0) {
				player.x--;
				updateDoppel(1, 0);
				player.dir = 3;
				draw(1);
			}
			else if (cpc_TestKey(KEY_W)==1 && player.y>MIN_Y && coincide(player.x,player.y-2) == 0) {
				player.y-=2;
				updateDoppel(0, 2);
				player.dir = 0;
				draw(1);
			}
			else if (cpc_TestKey(KEY_S)==1 && player.y<MAX_Y && coincide(player.x,player.y+2) == 0) {
				player.y+=2;
				updateDoppel(0, -2);
				player.dir = 1;
				draw(1);
			}

			if(player.periodoDisparo > 0) {
				player.periodoDisparo--;
				if(player.periodoDisparo < 0) player.periodoDisparo = 0;
			}

			if (cpc_TestKey(KEY_UP)==1) {
				if(pulsadoDisparo == 0) {
					if(player.periodoDisparo <= 0) {
						disparar(0, 0, -8);
					}
					pulsadoDisparo = 1;
					//nivel++;		//PRUEBA QUITAR LUEGO
					//drawNiveles(70, 21);
				}
			}
			else if (cpc_TestKey(KEY_DOWN)==1) {
				if(pulsadoDisparo == 0) {
					if(player.periodoDisparo <= 0) {
						disparar(1, 0, 8);
					}
					pulsadoDisparo = 1;
					//puntuacion++;
					//drawPuntuacion(62, 8);
				}
			}
			else if (cpc_TestKey(KEY_RIGHT)==1) {
				if(pulsadoDisparo == 0) {
					if(player.periodoDisparo <= 0) {
						disparar(2, 4, 0);
					}
					pulsadoDisparo = 1;
				}
			}
			else if (cpc_TestKey(KEY_LEFT)==1) {
				if(pulsadoDisparo == 0) {
					if(player.periodoDisparo <= 0) {
						disparar(3, -4, 0);
					}
					pulsadoDisparo = 1;
				}
			}
			else {
				pulsadoDisparo = 0;
			}


			if(spawnerFrameLimit <= 0){	
	   			checkSpawner();
	   			spawnerFrameLimit = SPAWNER_FRAME_LIMIT;
			}
			else{
				spawnerFrameLimit--;
			}

			updateDisparos();

			frames = 0;

			if (cpc_TestKey(KEY_ESC)==1) {
				state = GAME_STATE_MENU;
			}

			if(player.toques <= 0) {
				state = GAME_STATE_GAMEOVER;
				//state = GAME_STATE_WIN;
			}
			
			//if ALGO ---------> state = GAME_STATE_WIN
		}else{
			frames++;
		}
	}
	return state; 
}

char Win(){
	cpc_ClrScr();

	cpc_SetInkGphStr(1, 42);
	cpc_SetInkGphStr(2, 42);
	cpc_SetInkGphStr(3, 42);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 16);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 11*16);
	cpc_PrintGphStrXY("NIVEL:", 22, 5*16+5);
	cpc_SetInkGphStr(1, 10);
	cpc_SetInkGphStr(2, 10);
	cpc_SetInkGphStr(3, 10);
	cpc_PrintGphStrXY("SIGUIENTE;NIVEL", 26, 3*16);	
	cpc_SetInkGphStr(1, 32);
	cpc_SetInkGphStr(2, 32);
	cpc_SetInkGphStr(3, 32);
	cpc_PrintGphStrXY("PUNTUACION:", 22, 4*16+5);
	cpc_SetInkGphStr(1, 128);
	cpc_SetInkGphStr(2, 128);
	cpc_SetInkGphStr(3, 128);
	drawNiveles(52, 5*16+5);
	drawPuntuacion(44, 4*16+5);
	cpc_SetInkGphStr(1, 138);
	cpc_SetInkGphStr(2, 138);
	cpc_SetInkGphStr(3, 138);
	cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;SEGUIR", 7, 10*16);

	nivel++;
	
	drawCorazonesWin();
	cpc_PutSp(S_HEROE_ABAJO_F1_data,8,4,cpc_GetScrAddress(39, 8*16));

	while (!cpc_AnyKeyPressed());
	while (cpc_AnyKeyPressed());

	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 

	initGame();
	return GAME_STATE_GAME;
}

char Credits(){
	cpc_ClrScr();

	cpc_SetInkGphStr(1, 10);
	cpc_SetInkGphStr(2, 10);
	cpc_SetInkGphStr(3, 10);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 16);
	cpc_PrintGphStrXY("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO", 5, 11*16);
	cpc_SetInkGphStr(1, 42);
	cpc_SetInkGphStr(2, 42);
	cpc_SetInkGphStr(3, 42);
	cpc_PrintGphStrXY("GRUPO;VORTEX", 28, 2*16);	
	cpc_SetInkGphStr(1, 32);
	cpc_SetInkGphStr(2, 32);
	cpc_SetInkGphStr(3, 32);
	cpc_PrintGphStrXY("DAVID;GIRON", 6, 3*16+5);
	cpc_PrintGphStrXY("SANDRA;GARZON", 48, 3*16+5);
	cpc_PrintGphStrXY("CARLOS;J;LOPEZ", 6, 4*16);
	cpc_PrintGphStrXY("KEVIN;FOLGAR", 50, 4*16);
	cpc_PrintGphStrXY("ASIER;GARAY", 6, 5*16-5);
	cpc_PrintGphStrXY("NIMA;LEDGARD", 50, 5*16-5);
	cpc_PrintGphStrXY("CPCRSLIB;DE;RAUL;SIMARRO", 15, 8*16);
	cpc_SetInkGphStr(1, 8);
	cpc_SetInkGphStr(2, 8);
	cpc_SetInkGphStr(3, 8);
	cpc_PrintGphStrXY("IDEA;CODIGO;GRAFICOS;Y;AUDIO", 12, 6*16);
	cpc_PrintGphStrXY("POR;VORTEX", 30, 7*16-5);
	cpc_SetInkGphStr(1, 138);
	cpc_SetInkGphStr(2, 138);
	cpc_SetInkGphStr(3, 138);
	cpc_PrintGphStrXY("PULSA;CUALQUIER;TECLA;PARA;VOLVER", 7, 10*16);

	while (!cpc_AnyKeyPressed());
	while (cpc_AnyKeyPressed());

	cpc_WyzStartEffect(0,0);  //Reproducir en el canal 1 efecto de disparo (efecto 1) 

	return GAME_STATE_MENU;
}

int main() {
	srand(time(NULL));
	cpc_SetBorder(BORDE);
	initMenu();	//iniciacilizamos partida

  	while (state != GAME_STATE_EXIT) {
	    switch(state) {
			case GAME_STATE_MENU:
				state = Menu();
			break;

			case GAME_STATE_HELP:
				state = Help();
			break;

			case GAME_STATE_GAME:
				state = Game();
			break;

			case GAME_STATE_WIN:
				state = Win();
			break;

			case GAME_STATE_GAMEOVER:
				state = GameOver();
			break;

			case GAME_STATE_CREDITS:
				state = Credits();
			break;

			default:
				state = GAME_STATE_EXIT;
			break;
	    }
  	}
  	return 0;
}