// Archivos compartidos del juego

/*******
 Defines
 *******/

// Teclas:

#define KEY_IZQ 		0
#define KEY_DER 		1
#define KEY_ARR 		2
#define KEY_ABA 		3
#define KEY_FIR 		4
#define KEY_MUS 		5
#define KEY_ESC 		6

// Defines para cambiar rapidito cosas:

#define WYZ_CANAL_EFECTOS	2

// Durezas:

#define T_VACIO 		0
#define T_MATA			1
#define T_PLATAFORMA	2
#define T_OBSTACULO 	3

// Structs

typedef struct {
	unsigned char x, y, cx, cy;
	unsigned char sal, nu;
	unsigned char status, ct;
	unsigned char *next_frame;
	unsigned char step, frame;
	unsigned char facing, hjump;
	unsigned char pant, orgpant;
	char jmx;
	unsigned char score;
	char vidas;
} PERZONAE;

typedef struct {
	unsigned char frame;
	unsigned char count;
	unsigned char *current_frame, *next_frame;
	unsigned char x, y, mx, my;
} ANIMADO;

// Globales

PERZONAE mari;
ANIMADO en_an [3];

unsigned char halflife = 0;
unsigned char paleta [] = {20, 4, 24, 21, 29, 31, 27, 5, 7, 15, 13, 22, 26, 3, 14, 11};
unsigned char map_buffer [150]; 
unsigned char enoffs;	
unsigned char music_on = 1;
unsigned char m_pressed;

// Extern globals

extern char asm_number [1];

// Extern data

#asm
	._asm_number 
		defb 0
#endasm

/********************
 Funciones auxiliares
 ********************/

unsigned char my_strlen (unsigned char *cad) {
	unsigned char res = 0;
	
	while (*cad != 0) {
		cad ++;
		res ++;
	}
	
	return res;
}
 
unsigned char rand () {
	unsigned char res;

	#asm
	._Rand8 ld	a,0 	; Seed is usually 0
			ld	b,a
			add a,a
			add a,a
			add a,b
			inc a		; another possibility is ADD A,7
			;add a, 7
			ld (_Rand8+1),a
			;ld a,r
			
			ld (_asm_number), a
	#endasm

	res = asm_number [0];

	return res;
}

void set_text_inks (unsigned char i1,unsigned char i2,unsigned char i3,unsigned char i4) {
	// Definimos el color del texto
	// Color Valor
	// 0	0
	// 1	128
	// 2	8
	// 3	136
	// 4	32
	// 5	160
	// 6	40
	// 7	168
	// 8	2
	// 9	130
	// 10	10
	// 11	138
	// 12	34
	// 13	162
	// 14	42
	// 15	170 	
	cpc_SetInkGphStr ((unsigned char *) (0), (unsigned char *) (i1));
	cpc_SetInkGphStr ((unsigned char *) (1), (unsigned char *) (i2));
	cpc_SetInkGphStr ((unsigned char *) (2), (unsigned char *) (i3));
	cpc_SetInkGphStr ((unsigned char *) (3), (unsigned char *) (i4));
}

void espera_activa (unsigned int times) {
	unsigned int i;
	
	for (i = 0; i < times; i ++) {
		#asm
			halt
		#endasm
		if (cpc_AnyKeyPressed ())
			break;	
	}
}

void wait_for_key (void) {
	while (cpc_AnyKeyPressed ());
	while (!cpc_AnyKeyPressed ());	
}

void clear_palette (void) {
	unsigned char i;
	
	for (i = 0; i < 16; i ++)
		cpc_SetColour (i, 20);	
}

void set_palette (unsigned char *pal) {
	
	// Establece la paleta del juego.
	
	unsigned char i;
	
	for (i = 0; i < 16; i ++) 
		cpc_SetColour (i, pal [i]);
}

void halt_me (void) {
	#asm
		halt				;unas esperas para que se actualicen los colores
		halt
		halt
		halt
		halt
	#endasm
}

void interrupciones(void) {
	// Manejador de interrupciones por Artaburu
	
	#asm
		di
		ld hl,($0039)
		ld (_int_original),HL	//guardo el salto original

		ld HL,_interrupcion
		ld ($0039),HL
		ei
		jp term
	._int_original	
		defw 0
	._interrupcion
		ei
		ret
	.term
	#endasm
}

/******************
 Funciones de juego
 ******************/
 
void draw_lives () {
	cpc_PutTile4x16 ( (unsigned int *) (g_numbers [mari.vidas / 10]), (unsigned char *) (64), (unsigned char *) (184));
	cpc_PutTile4x16 ( (unsigned int *) (g_numbers [mari.vidas % 10]), (unsigned char *) (68), (unsigned char *) (184));
}
 
void draw_screen (char pant) {
	unsigned int idx = (unsigned int) 150 * (unsigned int) (pant);
	unsigned char i, c;
	unsigned char x = 0, y = 0;
	
	for (i = 0; i < 150; i ++) {
		c = map_data [idx];
		map_buffer [i] = tile_c [c];
		
		c = c << 2;
		
		cpc_SetTile (x	  , y	 , c	);
		cpc_SetTile (x + 1, y	 , c + 1);
		cpc_SetTile (x	  , y + 1, c + 2);
		cpc_SetTile (x + 1, y + 1, c + 3);
		
		idx ++;
		x += 2;
		if (x == 30) {
			x = 0;
			y += 2;
		}	
	}

	// Special features
	
	special_features_show_screen (pant);
	
	cpc_ResetTouchedTiles ();
	cpc_ShowTileMap (0);
		
	// Movemos y cambiamos a los enemigos segn el tipo que tengan
	
	enoffs = pant * 3;
	
	for (i = 0; i < 3; i ++) {
		en_an [i].frame = 0;
		en_an [i].count = 0;
		en_an [i].x = malotes [enoffs + i].x;
		en_an [i].y = malotes [enoffs + i].y;
		en_an [i].mx = malotes [enoffs + i].mx;
		en_an [i].my = malotes [enoffs + i].my;
		en_an [i].next_frame = g_malo [((malotes [enoffs + i].t - 1) << 1)];
	}
	
	mari.pant = pant;
}

void clear_playground () {
	unsigned char i, x = 0, y = 0;
	
	for (i = 0; i < 150; i ++) {	
		cpc_SetTile (x	  , y	 , 0);
		cpc_SetTile (x + 1, y	 , 0);
		cpc_SetTile (x	  , y + 1, 0);
		cpc_SetTile (x + 1, y + 1, 0);
		
		x += 2;
		if (x == 30) {
			x = 0;
			y += 2;
		}
	}
	
	cpc_ResetTouchedTiles ();
	cpc_ShowTileMap (0);
}

void mueve () {
	unsigned char x, y, falling;
	unsigned char precalc;
	unsigned char moved = 0;

	// Coordenadas en el tilemap	
	
	x = mari.x >> 4;
	y = mari.y >> 4;
	
	precalc = (y << 3) + (y << 2) + (y << 1) + y + x;	// precalc = 15 * y + x = 8 * y + 4 * y + 2 * y + y + x;

	// Tile que mata:
	
	if ((mari.y & 15) != 0) {
		if ((mari.x & 15) == 0) {
			if (map_buffer [precalc + 15] == T_MATA)
				mari.status = 1;
		} else {
			if (map_buffer [precalc + 15] == T_MATA || map_buffer [precalc + 16] == T_MATA)
				mari.status = 1;
		}
	}
		
	// Caer
	
	falling = 0;
	
	if (!mari.sal) {
		if ((mari.y & 15) == 0) {
			if ((mari.x & 15) == 0) {
				if (map_buffer [precalc + 15] < T_PLATAFORMA) {
					mari.y += 2;
					falling = 1;
				}
			} else {
				if (map_buffer [precalc + 15] < T_PLATAFORMA && map_buffer [precalc + 16] < T_PLATAFORMA) {
					mari.y += 2;
					falling = 1;
				}
			}
		} else {
			mari.y += 2;
			falling = 1;	
		}
	}	
	
	// Movimiento horizontal y salto
	
	if (!falling) {
		if (!mari.sal) {
			// Grabo la posicin para el respawn:
			if (mari.pant != mari.orgpant) {
				mari.cx = mari.x;
				mari.cy = mari.y;
				mari.orgpant = mari.pant;
			}
			
			if (cpc_TestKey (KEY_FIR)) {
				mari.sal = 1;
				mari.nu = 0;
				if (cpc_TestKey (KEY_IZQ) || cpc_TestKey (KEY_DER)) {
					mari.hjump = 1;
				} else {
					mari.hjump = 0;
				}
				cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 0);
			}
			
			if (cpc_TestKey (KEY_IZQ) && mari.x > 0) {
				mari.facing = 1;
				moved = 1;
				if ((mari.x & 15) == 0) {
					if ((mari.y & 15) == 0) {
						if (map_buffer [precalc - 1] < T_OBSTACULO) {
							mari.x -= 2;
						}
					} else {
						if (map_buffer [precalc - 1] < T_OBSTACULO && map_buffer [precalc + 14] < T_OBSTACULO) {
							mari.x -= 2;
						}
					}
				} else {
					mari.x -= 2;
				}
			} else if (cpc_TestKey (KEY_DER) && mari.x < 224) {
				mari.facing = 0;
				moved = 1;
				if ((mari.x & 15) == 0) {
					if ((mari.y & 15) == 0) {
						if (map_buffer [precalc + 1] < T_OBSTACULO) {
							mari.x += 2;
						}
					} else {
						if (map_buffer [precalc + 1] < T_OBSTACULO && map_buffer [precalc + 16] < T_OBSTACULO) {
							mari.x += 2;
						}
					}
				} else {
					mari.x += 2;
				}				
			}
		} else {
			
			// Condicin "aterrizar" en medio del salto
			
			if (mari.nu > 0) {
				if ((mari.y & 15) == 0) {
					if ((mari.x & 15) == 0) {
						if (map_buffer [precalc + 15] >= T_PLATAFORMA) {
							mari.sal = 0;
						}
					} else {
						if (map_buffer [precalc + 15] >= T_PLATAFORMA || map_buffer [precalc + 16] >= T_PLATAFORMA) {
							mari.sal = 0;
						}
					}
				}
			}
			
			// Vertical
			
			if (mari.nu < 16) {
				if (mari.y > 0) {
					if ((mari.y & 15) == 0) {
						if ((mari.x & 15) == 0) {
							if (map_buffer [precalc - 15] < T_OBSTACULO) {
								mari.y -= 2;
							}
						} else {
							if (map_buffer [precalc - 15] < T_OBSTACULO && map_buffer [precalc - 14] < T_OBSTACULO) {
								mari.y -= 2;
							}
						}
					} else {
						mari.y -= 2;
					}
				}
			} else {
				if ((mari.y & 15) == 0) {
					if ((mari.x & 15) == 0) {
						if (map_buffer [precalc + 15] < T_PLATAFORMA) {
							mari.y += 2;
						}
					} else {
						if (map_buffer [precalc + 15] < T_PLATAFORMA && map_buffer [precalc + 16] < T_PLATAFORMA) {
							mari.y += 2;
						}
					}
				} else {
					mari.y += 2;
				}
			}	
			
			y = mari.y >> 4;
			precalc = (y << 3) + (y << 2) + (y << 1) + y + x;
			
			// Horizontal
			
			if (mari.hjump) {
				if (mari.facing && mari.x > 0) {
					if ((mari.x & 15) == 0) {
						if ((mari.y & 15) == 0) {
							if (map_buffer [precalc - 1] < T_OBSTACULO) {
								mari.x -= 2;
							}
						} else {
							if (map_buffer [precalc - 1] < T_OBSTACULO && map_buffer [precalc + 14] < T_OBSTACULO) {
								mari.x -= 2;
							}
						}
					} else {
						mari.x -= 2;
					}
				} else if (mari.x < 224) {
					if ((mari.x & 15) == 0) {
						if ((mari.y & 15) == 0) {
							if (map_buffer [precalc + 1] < T_OBSTACULO) {
								mari.x += 2;
							}
						} else {
							if (map_buffer [precalc + 1] < T_OBSTACULO && map_buffer [precalc + 16] < T_OBSTACULO) {
								mari.x += 2;
							}
						}
					} else {
						mari.x += 2;
					}	
				}
			}
						
			mari.nu ++;
			if (mari.nu == 32)
				mari.sal = 0;
		}
	}
	
	// Control de animacin continua saltona
	
	if (music_on || moved) {
		mari.step ++;
		if (mari.step == 4) {
			mari.step = 0;
			mari.frame = (mari.frame + 1) & 3;
		}
	}
	
	mari.next_frame = g_mari [(mari.facing << 2) + mari.frame];
}

void mueve_bicharracos () {
	// Vamos a mover un frame todos los bicharracos activos.
	
	unsigned char i, enoffsmasi;
	
	for (i = 0; i < 3; i ++) {
		enoffsmasi = enoffs + i;
		
		// Esta es la versin original de la rutina tal y como se escribi
		// para los juegos de la serie "Tales". De esta forma, las posiciones
		// de los enemigos en cada pantalla son consistentes y se recuerdan
		// tras salir y volver a entrar en la pantalla, pero para este juego
		// no sirve, as que la comentamos... Y la reescribimos, ver ms abajo.
		
		/*
		if (malotes [enoffsmasi].t != 0) {
			malotes [enoffsmasi].x += malotes [enoffsmasi].mx;
			if (malotes [enoffsmasi].x == malotes [enoffsmasi].x1 || malotes [enoffsmasi].x == malotes [enoffsmasi].x2)
				malotes [enoffsmasi].mx = -malotes [enoffsmasi].mx;
			malotes [enoffsmasi].y += malotes [enoffsmasi].my;
			if (malotes [enoffsmasi].y == malotes [enoffsmasi].y1 || malotes [enoffsmasi].y == malotes [enoffsmasi].y2)
				malotes [enoffsmasi].my = -malotes [enoffsmasi].my;
				
			en_an [i].count ++; 
			if (en_an [i].count == 4) {
				en_an [i].count = 0;
				en_an [i].frame = !en_an [i].frame;
				en_an [i].next_frame = g_malo [((malotes [enoffsmasi].t - 1) << 1) + en_an [i].frame];
			}
		}
		*/
		
		// Esta modificacin es para que la posicin de los enemigos no
		// se mantenga, sino que se reinicie cada vez que se repinta la pantalla.
		
		// Esto es lo ms adecuado para los juegos tipo JSW / Profanation en 
		// los que un contacto con un enemigo supone perder una vida y volver
		// a empezar la pantalla.
		
		// Smplemente he movido .x y .y a la estructura en_an:
		
		if (malotes [enoffsmasi].t != 0) {
			en_an [i].x += en_an [i].mx;
			if (en_an [i].x == malotes [enoffsmasi].x1 || en_an [i].x == malotes [enoffsmasi].x2)
				en_an [i].mx = -en_an [i].mx;
			en_an [i].y += en_an [i].my;
			if (en_an [i].y == malotes [enoffsmasi].y1 || en_an [i].y == malotes [enoffsmasi].y2)
				en_an [i].my = -en_an [i].my;
				
			en_an [i].count ++; 
			if (en_an [i].count == 4) {
				en_an [i].count = 0;
				en_an [i].frame = !en_an [i].frame;
				en_an [i].next_frame = g_malo [((malotes [enoffsmasi].t - 1) << 1) + en_an [i].frame];
			}
		}
	}
}

void game_over () {
	while (cpc_TestKey (KEY_ESC));

	cpc_UnExo ((unsigned int *) (song_2), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (2);
	cpc_WyzSetPlayerOn ();
	
	cpc_PutSpTr ( (unsigned int *) (g_letreros [0]), (unsigned char *) (16), (unsigned char *) (16), (unsigned int *) (0xd398));
	espera_activa (2000);
	
	cpc_WyzSetPlayerOff ();
}

void respawn () {
	mari.x = mari.cx;
	mari.y = mari.cy;
	mari.pant = mari.orgpant;
	mari.sal = 0;
}

void main_game () {
	unsigned char i, j, x, y;
	unsigned char flag1 = 0;
	unsigned char flag2 = 0;
	unsigned char dying;
	unsigned char pant, npant;
	unsigned char changing, win, aux;

	struct sprite { 			// estructura mnima para usar la librera de dibujar sprites capturando el fondo.
		int sp0;				// 2 bytes	01
		int sp1;				// 2 bytes	23
		int coord0; 			// 2 bytes	45	 posicin en superbuffer
		int coord1; 			// 2 bytes	67	 posicin anterior en superbuffer
		unsigned char cx, cy;	// 2 bytes	89	 coordenadas nuevas
		unsigned char ox, oy;	// 2 bytes	AB	 coordenadas actuales
		unsigned char move; 	// 1 byte	 C	  si NO es 0, el sprite se mueve.
		unsigned char move1;	// 1 byte	 D	  si NO es 0, el sprite se mueve.
		// Si es 8 en cuanto se mueva se pone a 0 y ya no se mueve ms hasta nueva orden.
	} ;

	struct sprite sp_mari;
	struct sprite sp_enem_1;
	struct sprite sp_enem_2;
	struct sprite sp_enem_3;
	struct sprite sp_efectos;
	
	interrupciones ();
	halt_me (); 
	clear_palette ();
	halt_me ();
	cpc_SetMode (0);

	// Inicializamos el player de wyz:
	
	cpc_WyzInitPlayer ((int) (wyz_sound_table), (int) (wyz_pattern_table), (int) (wyz_effects_table), (int) (wyz_song_table));
	
	// Batera por el canal C:
	
	cpc_WyzConfigurePlayer (0);
	
	// Ponemos el buffer en un sitio adecuado:
	
	cpc_WyzSetBuffer (0xA000);
		
	// UEAH
	
	cpc_SetColour (16, 20);
	
	// Redefinimos las teclas
	
	cpc_AssignKey (KEY_IZQ, 0x4101);		// CUR LEFT
	cpc_AssignKey (KEY_DER, 0x4002);		// CUR RIGHT
	cpc_AssignKey (KEY_ARR, 0x4001);		// CUR UP
	cpc_AssignKey (KEY_ABA, 0x4004);		// CUR DOWN
	cpc_AssignKey (KEY_FIR, 0x4580);		// SPACE
	cpc_AssignKey (KEY_ESC, 0x4804);		// ESC
	cpc_AssignKey (KEY_MUS, 0x4440);		// M

	clear_palette ();
	cpc_UnExo ((unsigned int *) (s_marco), (unsigned int *) (0xc000));
	set_palette (paleta);
		
	while (1) {
		titulo ();
		   
		pant = MAPDATA_INITSCR;
		
		// Valores del sprite de mari:
	
		mari.x = mari.cx = MAPDATA_XSTART;
		mari.y = mari.cy = MAPDATA_YSTART;
		mari.sal = 0;
		mari.nu = 0;
		mari.frame = 0;
		mari.step = 0;
		mari.facing = 0;
		mari.vidas = 15;
		mari.status = 0;
		mari.score = 0;
		
		sp_mari.sp0 = (int) (g_mari [0]);
		sp_mari.sp1 = (int) (g_mari [0]);
		sp_mari.move = 0;
		sp_mari.cx = sp_mari.ox = mari.x >> 2;
		sp_mari.cy = sp_mari.oy = mari.y;
		
		// Valores de los sprites de los bisharracos:
		
		sp_enem_1.sp0 = (int) (g_sprite_8);
		sp_enem_1.sp1 = (int) (g_sprite_8);
		sp_enem_1.cx = 0;
		sp_enem_1.cy = 0;
		sp_enem_1.ox = 0;
		sp_enem_1.oy = 0;
		sp_enem_1.move = 0;
		
		sp_enem_2.sp0 = (int) (g_sprite_8);
		sp_enem_2.sp1 = (int) (g_sprite_8);
		sp_enem_2.cx = 0;
		sp_enem_2.cy = 0;
		sp_enem_2.ox = 0;
		sp_enem_2.oy = 0;
		sp_enem_2.move = 0;
		
		sp_enem_3.sp0 = (int) (g_sprite_8);
		sp_enem_3.sp1 = (int) (g_sprite_8);
		sp_enem_3.cx = 0;
		sp_enem_3.cy = 0;
		sp_enem_3.ox = 0;
		sp_enem_3.oy = 0;
		sp_enem_3.move = 0; 
		
		npant = pant;			// Para detectar un cambio de pantallas.
		win = 0;				// win se pondr a 1 al llegar al final de la carga.
		m_pressed = 0;			// Control "keyclick" de la tecla M
		flag1 = 0;
		
		// Empezamos
		
		draw_screen (pant);
		draw_lives ();
		
		// Descomprimimos la cancin en el buffer de tiles

		if (music_on) {
			cpc_UnExo ((unsigned int *) (song_0), (unsigned int *) (0x0100));
			cpc_WyzLoadSong (0);
		} else {
			cpc_UnExo ((unsigned int *) (song_3), (unsigned int *) (0x0100));
			cpc_WyzLoadSong (3);
		}
		
		cpc_WyzSetPlayerOn ();	
		
		while (!flag1) {
			
			// Teclas especiales
			
			if (cpc_TestKey (KEY_ESC) || mari.vidas == 0) {
				flag1 = 1;
				goto guarro;
			}
				
			if (cpc_TestKey (KEY_MUS)) {
				if (!m_pressed) {
					if (music_on) {
						music_on = 0;
						cpc_WyzSetPlayerOff ();	
						cpc_UnExo ((unsigned int *) (song_3), (unsigned int *) (0x0100));
						cpc_WyzLoadSong (3);
					} else {
						music_on = 1;
						cpc_WyzSetPlayerOff ();	
						cpc_UnExo ((unsigned int *) (song_0), (unsigned int *) (0x0100));
						cpc_WyzLoadSong (0);
					}
					
					cpc_WyzSetPlayerOn ();
					m_pressed = 1;
				}
			} else {
				m_pressed = 0;
			}
			
			// Move stuff around:
			
			mueve ();
			mueve_bicharracos ();
			
			// Do checks:
			
			// Special features
			
			special_features_ingame (pant);
			
			// Final del juego: pantalla n 35, x <= 8
			if (pant == MAPDATA_ENDSCR && mari.x MAPDATA_OPERATION MAPDATA_XVALUE) {
				win = 1;
				flag1 = 1;
			}
			
			// Cambio de pantalla
			
			if (((mari.sal && mari.facing) || cpc_TestKey (KEY_IZQ)) && mari.x == 0) {
				pant = pant - 1;
				mari.x = 224;
			}
			
			if (((mari.sal && !mari.facing) || cpc_TestKey (KEY_DER)) && mari.x == 224) {
				pant = pant + 1;
				mari.x = 0;
			}
			
			if (mari.sal && mari.y == 0 && pant > MAPDATA_WIDTH && mari.nu < 14) {
				pant -= MAPDATA_WIDTH;
				mari.y = 144;
			}
			
			if (!mari.sal && mari.y == 144 && pant < MAPDATA_LASTROW_FIRSTSCRINDEX) {
				pant += MAPDATA_WIDTH;
				mari.y = 0;
			}
			
			if (pant != npant) {
				draw_screen (pant);
				draw_lives ();	
				npant = pant;
			}
			
			// Colisin con tile mata (resuelto en la funcin mueve. Pone mari.status a 1
			
			// Colisin con enemigo
			
			for (i = 0; i < 3; i ++) {
				if (mari.x >= en_an [i].x - 13 && mari.x <= en_an [i].x + 13 && mari.y >= en_an [i].y - (en_an [i].y ? 13 : 0) && mari.y <= en_an [i].y + 13) {
					mari.status = 1;
				}	
			}
			
			// Mostrar ouch?
			
			if (mari.status) {
				
				// Mostrar ouch:
				
				sp_efectos.sp0 = (int) (g_sprite_16);
				sp_efectos.sp1 = (int) (g_sprite_16);
				sp_efectos.cx = (mari.x >> 2) + 4;
				if (sp_efectos.cx > 56)
					sp_efectos.cx = 56;
				sp_efectos.cy = mari.y - 12;
				if (sp_efectos.cy < 0)
					sp_efectos.cy = 0;
				sp_efectos.ox = 0;
				sp_efectos.oy = 0;
				sp_efectos.move = 0; 
			}
			
			// Render:
			
			sp_mari.sp0 = (int) (mari.next_frame);
			sp_mari.cx = mari.x >> 2;
			sp_mari.cy = mari.y;
			
			sp_enem_1.sp0 = (int) (en_an [0].next_frame);	
			sp_enem_1.cx = (en_an [0].x) >> 2;
			sp_enem_1.cy = en_an [0].y;
			
			sp_enem_2.sp0 = (int) (en_an [1].next_frame);	
			sp_enem_2.cx = (en_an [1].x) >> 2;
			sp_enem_2.cy = en_an [1].y;
			
			sp_enem_3.sp0 = (int) (en_an [2].next_frame);	
			sp_enem_3.cx = (en_an [2].x) >> 2;
			sp_enem_3.cy = en_an [2].y;
			
			cpc_PutSpTileMap ((int) (sp_mari));
			cpc_PutSpTileMap ((int) (sp_enem_1));
			cpc_PutSpTileMap ((int) (sp_enem_2));
			cpc_PutSpTileMap ((int) (sp_enem_3));
			if (mari.status)
				cpc_PutSpTileMap ((int) (sp_efectos));
			
			cpc_UpdScr ();
			 
			cpc_PutTrSp8x16TileMap2b ((int) (sp_mari));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_1));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_2));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_3));
			if (mari.status)
				cpc_PutTrSp8x16TileMap2b ((int) (sp_efectos));
			
			// Update
			
			cpc_ShowTouchedTiles ();
			cpc_ResetTouchedTiles ();
			
			// Morir?
			
			if (mari.status) {
				cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 3);
				
				// Lgica
				
				mari.vidas --;
								
				espera_activa (150);
								
				respawn ();
				npant = pant = mari.pant;
				draw_screen (pant);
				draw_lives ();
				
				mari.status = 0;
			}	
			
			guarro:
		}
		
		cpc_WyzSetPlayerOff ();
		
		if (!win) {
			game_over ();	
		} else {
			final ();
		}
	}	
}

