; TILEMAPCONF PARA PLATFORMER MEDLEY / CPC
; (C) 2009 THE MOJON TWINS

	XLIB TileMapConf
	
	XDEF tiles
	XDEF pantalla_juego
	XDEF tiles_tocados
	XDEF posiciones_pantalla
	XDEF posiciones_super_buffer
	
	XDEF posicion_inicial_area_visible
	XDEF posicion_inicial_superbuffer
	XDEF ancho_pantalla_bytes
	XDEF alto_pantalla_bytes
	XDEF ancho_pantalla_bytes_visible
	
	XDEF tile11

	XDEF mascara1
	XDEF mascara2
	
	; Voy a definir como mscara de los sprites el color 11
	
	; 0: $00, $00
	; 1: $80, $40
	; 2: $04, $08
	; 3: $44, $88
	; 4: $10, $20
	; 5: $50, $A0
	; 6: $14, $28
	; 7: $54, $A8
	; 8: $01, $02
	; 9: $41, $82
	; 10: $05, $0A
	; 11: $45, $8A
	; 12: $11, $22
	
	defc mascara1 = $45 ;
	defc mascara2 = $8A ;
	
; VALORES QUE DEFINEN EL BUFFER Y LA PANTALLA

	defc posicion_inicial_area_visible = $c100 ;		(1, 8) en chars, (32, 24) en pxels.
	defc posicion_inicial_superbuffer = $100
	
	defc T_WIDTH = 	30 ;32 ;28 ;32 ;28 ;16			;max=40		;dimensiones de la pantalla en tiles
	defc T_HEIGHT = 20 ;16							;max=20
		
	defc ancho_pantalla_bytes = 2*T_WIDTH ; 2*T_WIDTH;		; El ancho de pantalla influye determinantemente en 
															; numerosas rutinas que hay que actualizar si se cambia
															; OJO con el modo
	defc alto_pantalla_bytes = 8*T_HEIGHT ;
	
	defc ancho_pantalla_bytes_visible = 2*T_WIDTH ;32  ; 64;		;dentro del area definida, cuanto se debe mostrar. 2*T_WIDTH

;El tamao del buffer es ancho_pantalla_bytes*alto_pantalla_bytes


.TileMapConf
;Con la definicin del mapeado hay que tener en cuenta que las coordenadas son:
;ANCHO=64 bytes (128 pixels en modo 0)
;ALTO=128 pixels

;el mximo que entra en el CPC es 20 lneas
;SI NO SE VAN A USAR TODAS LAS LINEAS, PARA AHORRA MEMORIA ES INTERESANTE COMENTARLAS

.posiciones_pantalla		;Posiciones en las que se dibujan los tiles
	defw posicion_inicial_area_visible+$50*0
	defw posicion_inicial_area_visible+$50*1  
	defw posicion_inicial_area_visible+$50*2
	defw posicion_inicial_area_visible+$50*3
	defw posicion_inicial_area_visible+$50*4
	defw posicion_inicial_area_visible+$50*5 
	defw posicion_inicial_area_visible+$50*6 
	defw posicion_inicial_area_visible+$50*7 
	defw posicion_inicial_area_visible+$50*8 
	defw posicion_inicial_area_visible+$50*9 
	defw posicion_inicial_area_visible+$50*10 
	defw posicion_inicial_area_visible+$50*11 
	defw posicion_inicial_area_visible+$50*12 
	defw posicion_inicial_area_visible+$50*13 
	defw posicion_inicial_area_visible+$50*14 
	defw posicion_inicial_area_visible+$50*15
	defw posicion_inicial_area_visible+$50*16
	defw posicion_inicial_area_visible+$50*17
	defw posicion_inicial_area_visible+$50*18
	defw posicion_inicial_area_visible+$50*19

.posiciones_super_buffer	;muestra el inicio de cada lnea (son 10 tiles de 8x16 de alto)

	;defw $1000, $1200, $1400, $1600, $1800, $1a00, $1c00, $1e00, $2000, $2200, $2400, $2600, $2800, $2a00, $2c00, $2f00
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*0
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*1
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*2
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*3
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*4
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*5
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*6
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*7
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*8
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*9
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*10
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*11
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*12
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*13
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*14
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*15
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*16
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*17
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*18
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*19
	
	;defw $1000, $1480, $1900, $1d80, $2200, $2680, $2b00, $2f80, $3400, $3880
	
;Rutinas para transferir bloques independientes a la pantalla

;Se busca el subbloque de 8x8 correspondiente a las coordenadas x,y
;el bloque se calcula dividiendo la coordenada x /8

.pantalla_actual 
	defw 0

.pantalla_juego  ;en tiles
	defs T_WIDTH*T_HEIGHT
	defb $FF	;Este byte es importante, marca el fin de la pantalla.

.tiles_tocados defs 150 ;150	;cuando un tile es tocado, se marca en esta tabla para luego restaurarlo. Es una tabla sin duplicados.

.tiles ;Son de 2x8 bytes

._pm_l1_tile_0

._pm_l1_tile_0_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_1

._pm_l1_tile_1_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_2

._pm_l1_tile_2_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_3

._pm_l1_tile_3_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_4

._pm_l1_tile_4_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_5

._pm_l1_tile_5_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_6

._pm_l1_tile_6_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_7

._pm_l1_tile_7_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_8

._pm_l1_tile_8_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $7D
	defb $B4, $FF
	defb $F0, $7D
	defb $F0, $F0
	defb $F0, $B4
	defb $F0, $7D
._pm_l1_tile_9

._pm_l1_tile_9_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $78, $7D
	defb $BE, $FF
	defb $FF, $FF
	defb $7D, $FF
	defb $FF, $BE
	defb $FF, $3C
._pm_l1_tile_10

._pm_l1_tile_10_DATA
	defb $F0, $7D
	defb $F0, $BE
	defb $F0, $7D
	defb $B4, $3C
	defb $78, $3C
	defb $F0, $B4
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_11

._pm_l1_tile_11_DATA
	defb $FF, $BE
	defb $FF, $FF
	defb $7D, $7D
	defb $BE, $BE
	defb $3C, $3C
	defb $B4, $7D
	defb $B4, $3C
	defb $F0, $3C
._pm_l1_tile_12

._pm_l1_tile_12_DATA
	defb $F0, $F0
	defb $F0, $B4
	defb $BE, $F5
	defb $FF, $7D
	defb $FF, $FF
	defb $7D, $FF
	defb $FF, $FF
	defb $FF, $FF
._pm_l1_tile_13

._pm_l1_tile_13_DATA
	defb $7D, $78
	defb $FF, $FA
	defb $FF, $BE
	defb $FF, $FF
	defb $FF, $FF
	defb $FF, $FF
	defb $BE, $FF
	defb $3C, $7D
._pm_l1_tile_14

._pm_l1_tile_14_DATA
	defb $FF, $BE
	defb $7D, $7D
	defb $BE, $3C
	defb $FF, $FF
	defb $FF, $BE
	defb $FF, $3C
	defb $3C, $78
	defb $3C, $F0
._pm_l1_tile_15

._pm_l1_tile_15_DATA
	defb $BE, $FF
	defb $3C, $BE
	defb $7D, $FF
	defb $FF, $FF
	defb $BE, $BE
	defb $7D, $7D
	defb $F0, $3C
	defb $F0, $F0
._pm_l1_tile_16

._pm_l1_tile_16_DATA
	defb $F0, $F0
	defb $BE, $F0
	defb $FF, $3C
	defb $FF, $FF
	defb $BE, $BE
	defb $FF, $3C
	defb $FF, $FF
	defb $FF, $FF
._pm_l1_tile_17

._pm_l1_tile_17_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $3C, $F0
	defb $FF, $78
	defb $BE, $78
	defb $78, $F0
	defb $78, $F0
	defb $BE, $F0
._pm_l1_tile_18

._pm_l1_tile_18_DATA
	defb $7D, $7D
	defb $3C, $BE
	defb $3C, $7D
	defb $FF, $FF
	defb $BE, $BE
	defb $3C, $78
	defb $3C, $78
	defb $3C, $F0
._pm_l1_tile_19

._pm_l1_tile_19_DATA
	defb $FF, $BE
	defb $FF, $BE
	defb $BE, $F0
	defb $78, $F0
	defb $78, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
._pm_l1_tile_20

._pm_l1_tile_20_DATA
	defb $F0, $B0
	defb $F0, $24
	defb $B0, $C
	defb $A4, $C
	defb $24, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_21

._pm_l1_tile_21_DATA
	defb $70, $F0
	defb $18, $F0
	defb $C, $70
	defb $C, $58
	defb $C, $18
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_22

._pm_l1_tile_22_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_23

._pm_l1_tile_23_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_24

._pm_l1_tile_24_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_25

._pm_l1_tile_25_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_26

._pm_l1_tile_26_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_27

._pm_l1_tile_27_DATA
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
	defb $C, $C
._pm_l1_tile_28

._pm_l1_tile_28_DATA
	defb $C, $C
	defb $C, $C
	defb $24, $C
	defb $98, $C
	defb $60, $30
	defb $90, $90
	defb $C0, $60
	defb $C0, $C0
._pm_l1_tile_29

._pm_l1_tile_29_DATA
	defb $C, $C
	defb $C, $30
	defb $18, $64
	defb $30, $30
	defb $60, $60
	defb $90, $C0
	defb $C0, $C0
	defb $90, $C0
._pm_l1_tile_30

._pm_l1_tile_30_DATA
	defb $C0, $60
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._pm_l1_tile_31

._pm_l1_tile_31_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._pm_l1_tile_32

._pm_l1_tile_32_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $80
	defb $80, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_33

._pm_l1_tile_33_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $40, $40
	defb $0, $80
	defb $0, $0
	defb $0, $0
._pm_l1_tile_34

._pm_l1_tile_34_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_35

._pm_l1_tile_35_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_36

._pm_l1_tile_36_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $80, $80
	defb $80, $40
	defb $80, $C0
	defb $0, $40
	defb $0, $0
	defb $0, $0
._pm_l1_tile_37

._pm_l1_tile_37_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $40
	defb $40, $80
	defb $80, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_38

._pm_l1_tile_38_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_39

._pm_l1_tile_39_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_40

._pm_l1_tile_40_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $0, $C4
	defb $C4, $98
	defb $40, $98
	defb $0, $C0
._pm_l1_tile_41

._pm_l1_tile_41_DATA
	defb $0, $0
	defb $0, $C0
	defb $90, $30
	defb $64, $64
	defb $CC, $CC
	defb $C4, $C4
	defb $60, $C8
	defb $CC, $CC
._pm_l1_tile_42

._pm_l1_tile_42_DATA
	defb $0, $0
	defb $C4, $C4
	defb $44, $98
	defb $40, $CC
	defb $0, $C0
	defb $0, $40
	defb $0, $40
	defb $0, $40
._pm_l1_tile_43

._pm_l1_tile_43_DATA
	defb $98, $CC
	defb $30, $70
	defb $98, $F0
	defb $64, $70
	defb $CC, $98
	defb $C4, $C4
	defb $C0, $C0
	defb $0, $C0
._pm_l1_tile_44

._pm_l1_tile_44_DATA
	defb $40, $80
	defb $D0, $F0
	defb $30, $B0
	defb $30, $30
	defb $98, $98
	defb $CC, $CC
	defb $C8, $C8
	defb $C0, $C4
._pm_l1_tile_45

._pm_l1_tile_45_DATA
	defb $0, $40
	defb $C0, $70
	defb $30, $30
	defb $64, $64
	defb $CC, $98
	defb $CC, $CC
	defb $C8, $C8
	defb $CC, $CC
._pm_l1_tile_46

._pm_l1_tile_46_DATA
	defb $CC, $CC
	defb $64, $64
	defb $B0, $CC
	defb $70, $64
	defb $B0, $30
	defb $64, $64
	defb $C8, $98
	defb $C0, $C4
._pm_l1_tile_47

._pm_l1_tile_47_DATA
	defb $CC, $CC
	defb $64, $C4
	defb $CC, $C8
	defb $64, $CC
	defb $30, $CC
	defb $64, $CC
	defb $CC, $C8
	defb $C4, $C0
._pm_l1_tile_48

._pm_l1_tile_48_DATA
	defb $C0, $0
	defb $F0, $F0
	defb $B0, $B0
	defb $64, $64
	defb $CC, $98
	defb $CC, $CC
	defb $C8, $C8
	defb $C0, $C0
._pm_l1_tile_49

._pm_l1_tile_49_DATA
	defb $0, $40
	defb $C0, $64
	defb $B0, $64
	defb $64, $CC
	defb $E4, $CC
	defb $CC, $C4
	defb $C8, $C8
	defb $C0, $C4
._pm_l1_tile_50

._pm_l1_tile_50_DATA
	defb $98, $98
	defb $CC, $64
	defb $CC, $CC
	defb $C4, $C4
	defb $C8, $C8
	defb $C4, $CC
	defb $C0, $98
	defb $C0, $C4
._pm_l1_tile_51

._pm_l1_tile_51_DATA
	defb $30, $98
	defb $64, $64
	defb $98, $30
	defb $CC, $64
	defb $C8, $98
	defb $64, $70
	defb $30, $F0
	defb $64, $70
._pm_l1_tile_52

._pm_l1_tile_52_DATA
	defb $C0, $0
	defb $98, $80
	defb $70, $60
	defb $98, $E4
	defb $C4, $CC
	defb $CC, $CC
	defb $98, $98
	defb $64, $30
._pm_l1_tile_53

._pm_l1_tile_53_DATA
	defb $0, $0
	defb $0, $C0
	defb $C8, $98
	defb $C0, $CC
	defb $C8, $C4
	defb $64, $C0
	defb $30, $C0
	defb $64, $80
._pm_l1_tile_54

._pm_l1_tile_54_DATA
	defb $98, $98
	defb $64, $CC
	defb $C8, $C8
	defb $64, $C0
	defb $30, $CC
	defb $70, $64
	defb $F0, $B0
	defb $70, $64
._pm_l1_tile_55

._pm_l1_tile_55_DATA
	defb $CC, $C8
	defb $CC, $D0
	defb $C8, $30
	defb $C4, $64
	defb $CC, $CC
	defb $64, $64
	defb $98, $C8
	defb $60, $C0
._pm_l1_tile_56

._pm_l1_tile_56_DATA
	defb $0, $0
	defb $0, $0
	defb $80, $40
	defb $20, $80
	defb $C8, $C0
	defb $80, $80
	defb $0, $80
	defb $0, $0
._pm_l1_tile_57

._pm_l1_tile_57_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_58

._pm_l1_tile_58_DATA
	defb $0, $0
	defb $E0, $0
	defb $B0, $60
	defb $64, $C0
	defb $C8, $0
	defb $CC, $40
	defb $C4, $80
	defb $0, $80
._pm_l1_tile_59

._pm_l1_tile_59_DATA
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $40, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_60

._pm_l1_tile_60_DATA
	defb $0, $40
	defb $0, $40
	defb $0, $0
	defb $0, $40
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $0, $0
._pm_l1_tile_61

._pm_l1_tile_61_DATA
	defb $0, $80
	defb $0, $0
	defb $0, $80
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_62

._pm_l1_tile_62_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_63

._pm_l1_tile_63_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_64

._pm_l1_tile_64_DATA
	defb $40, $C0
	defb $40, $C0
	defb $40, $C0
	defb $0, $C0
	defb $0, $C0
	defb $0, $C0
	defb $0, $40
	defb $0, $40
._pm_l1_tile_65

._pm_l1_tile_65_DATA
	defb $C0, $C0
	defb $40, $80
	defb $C0, $0
	defb $80, $0
	defb $0, $0
	defb $80, $0
	defb $80, $0
	defb $C0, $0
._pm_l1_tile_66

._pm_l1_tile_66_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_67

._pm_l1_tile_67_DATA
	defb $C0, $40
	defb $C0, $C4
	defb $C0, $C8
	defb $C4, $C4
	defb $C0, $C8
	defb $C4, $CC
	defb $98, $CC
	defb $C4, $98
._pm_l1_tile_68

._pm_l1_tile_68_DATA
	defb $C0, $C0
	defb $80, $40
	defb $C0, $40
	defb $C0, $40
	defb $40, $0
	defb $40, $40
	defb $40, $C0
	defb $C0, $C4
._pm_l1_tile_69

._pm_l1_tile_69_DATA
	defb $CC, $98
	defb $C0, $C0
	defb $40, $0
	defb $0, $40
	defb $40, $88
	defb $C0, $0
	defb $40, $0
	defb $40, $0
._pm_l1_tile_70

._pm_l1_tile_70_DATA
	defb $C0, $88
	defb $C4, $0
	defb $C8, $0
	defb $80, $0
	defb $C8, $40
	defb $CC, $C4
	defb $CC, $80
	defb $C8, $0
._pm_l1_tile_71

._pm_l1_tile_71_DATA
	defb $40, $0
	defb $40, $40
	defb $C0, $80
	defb $C8, $0
	defb $80, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_72

._pm_l1_tile_72_DATA
	defb $98, $CC
	defb $C0, $C0
	defb $40, $0
	defb $80, $0
	defb $0, $0
	defb $80, $0
	defb $80, $0
	defb $80, $0
._pm_l1_tile_73

._pm_l1_tile_73_DATA
	defb $80, $40
	defb $80, $40
	defb $80, $40
	defb $0, $40
	defb $80, $0
	defb $0, $40
	defb $0, $0
	defb $0, $0
._pm_l1_tile_74

._pm_l1_tile_74_DATA
	defb $80, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_75

._pm_l1_tile_75_DATA
	defb $0, $0
	defb $0, $40
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_76

._pm_l1_tile_76_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_77

._pm_l1_tile_77_DATA
	defb $40, $90
	defb $40, $CC
	defb $40, $90
	defb $40, $CC
	defb $40, $90
	defb $40, $64
	defb $40, $90
	defb $C4, $64
._pm_l1_tile_78

._pm_l1_tile_78_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $0, $44
	defb $0, $C4
	defb $0, $CC
	defb $40, $C8
._pm_l1_tile_79

._pm_l1_tile_79_DATA
	defb $C0, $98
	defb $C4, $64
	defb $90, $98
	defb $CC, $64
	defb $C8, $98
	defb $C0, $90
	defb $C8, $64
	defb $C4, $C0
._pm_l1_tile_80

._pm_l1_tile_80_DATA
	defb $98, $80
	defb $30, $80
	defb $98, $80
	defb $30, $80
	defb $98, $80
	defb $30, $88
	defb $98, $88
	defb $64, $60
._pm_l1_tile_81

._pm_l1_tile_81_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_82

._pm_l1_tile_82_DATA
	defb $98, $60
	defb $CC, $64
	defb $98, $CC
	defb $64, $30
	defb $CC, $98
	defb $CC, $30
	defb $CC, $98
	defb $C4, $90
._pm_l1_tile_83

._pm_l1_tile_83_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $40, $80
	defb $80, $40
	defb $60, $40
	defb $30, $60
	defb $CC, $C4
._pm_l1_tile_84

._pm_l1_tile_84_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $40, $0
	defb $0, $C0
	defb $C8, $70
	defb $0, $B0
._pm_l1_tile_85

._pm_l1_tile_85_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $E0, $0
	defb $CC, $0
	defb $64, $80
	defb $C8, $C4
._pm_l1_tile_86

._pm_l1_tile_86_DATA
	defb $0, $64
	defb $10, $CC
	defb $44, $88
	defb $C8, $CC
	defb $C8, $70
	defb $44, $98
	defb $40, $CC
	defb $44, $C4
._pm_l1_tile_87

._pm_l1_tile_87_DATA
	defb $C8, $80
	defb $C8, $80
	defb $C0, $80
	defb $C0, $C0
	defb $CC, $C0
	defb $C8, $C0
	defb $C4, $C0
	defb $C0, $80
._pm_l1_tile_88

._pm_l1_tile_88_DATA
	defb $40, $0
	defb $40, $80
	defb $0, $80
	defb $0, $C0
	defb $0, $40
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_89

._pm_l1_tile_89_DATA
	defb $80, $0
	defb $80, $0
	defb $C4, $0
	defb $CC, $C8
	defb $C0, $CC
	defb $C0, $C4
	defb $0, $C0
	defb $0, $0
._pm_l1_tile_90

._pm_l1_tile_90_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_91

._pm_l1_tile_91_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_92

._pm_l1_tile_92_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $98, $B0
	defb $C4, $64
	defb $C8, $C8
	defb $C0, $C0
._pm_l1_tile_93

._pm_l1_tile_93_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $B0, $C8
	defb $64, $CC
	defb $C8, $C8
	defb $C0, $C0
._pm_l1_tile_94

._pm_l1_tile_94_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_95

._pm_l1_tile_95_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_96

._pm_l1_tile_96_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $98, $98
	defb $C4, $C4
	defb $C8, $C8
	defb $C0, $C0
._pm_l1_tile_97

._pm_l1_tile_97_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $98, $C8
	defb $C4, $64
	defb $C0, $CC
	defb $C0, $C0
._pm_l1_tile_98

._pm_l1_tile_98_DATA
	defb $44, $0
	defb $40, $0
	defb $40, $0
	defb $44, $0
	defb $0, $88
	defb $0, $44
	defb $0, $0
	defb $0, $0
._pm_l1_tile_99

._pm_l1_tile_99_DATA
	defb $0, $0
	defb $40, $0
	defb $40, $0
	defb $40, $0
	defb $40, $0
	defb $80, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_100

._pm_l1_tile_100_DATA
	defb $40, $C4
	defb $C0, $CC
	defb $C0, $C4
	defb $40, $0
	defb $0, $C0
	defb $40, $C4
	defb $40, $C8
	defb $0, $C4
._pm_l1_tile_101

._pm_l1_tile_101_DATA
	defb $90, $C4
	defb $70, $64
	defb $98, $C8
	defb $CC, $C4
	defb $C0, $98
	defb $C4, $70
	defb $98, $98
	defb $CC, $CC
._pm_l1_tile_102

._pm_l1_tile_102_DATA
	defb $40, $CC
	defb $C0, $C4
	defb $C0, $C8
	defb $C0, $C4
	defb $40, $40
	defb $0, $C0
	defb $0, $40
	defb $0, $0
._pm_l1_tile_103

._pm_l1_tile_103_DATA
	defb $CC, $C8
	defb $C4, $C4
	defb $CC, $C8
	defb $80, $C0
	defb $C0, $40
	defb $C0, $40
	defb $80, $0
	defb $0, $0
._pm_l1_tile_104

._pm_l1_tile_104_DATA
	defb $CC, $CC
	defb $C8, $CC
	defb $CC, $98
	defb $64, $C4
	defb $30, $98
	defb $64, $70
	defb $C8, $98
	defb $CC, $C4
._pm_l1_tile_105

._pm_l1_tile_105_DATA
	defb $98, $CC
	defb $70, $64
	defb $98, $CC
	defb $CC, $C4
	defb $C8, $C8
	defb $64, $C4
	defb $C8, $CC
	defb $C4, $CC
._pm_l1_tile_106

._pm_l1_tile_106_DATA
	defb $CC, $CC
	defb $CC, $CC
	defb $C8, $98
	defb $C4, $C4
	defb $C0, $C8
	defb $C0, $80
	defb $C0, $40
	defb $0, $0
._pm_l1_tile_107

._pm_l1_tile_107_DATA
	defb $CC, $C0
	defb $70, $64
	defb $B0, $CC
	defb $30, $64
	defb $98, $C8
	defb $C4, $40
	defb $C0, $80
	defb $C0, $0
._pm_l1_tile_108

._pm_l1_tile_108_DATA
	defb $CC, $CC
	defb $CC, $C8
	defb $98, $CC
	defb $70, $64
	defb $98, $30
	defb $64, $64
	defb $C0, $C0
	defb $CC, $64
._pm_l1_tile_109

._pm_l1_tile_109_DATA
	defb $C0, $0
	defb $C8, $80
	defb $C0, $0
	defb $80, $80
	defb $C8, $C0
	defb $C4, $C0
	defb $40, $80
	defb $80, $0
._pm_l1_tile_110

._pm_l1_tile_110_DATA
	defb $98, $B0
	defb $98, $64
	defb $CC, $C8
	defb $C4, $80
	defb $C8, $C0
	defb $C0, $C0
	defb $40, $80
	defb $0, $0
._pm_l1_tile_111

._pm_l1_tile_111_DATA
	defb $C8, $80
	defb $C4, $80
	defb $C8, $80
	defb $C0, $80
	defb $40, $80
	defb $40, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_112

._pm_l1_tile_112_DATA
	defb $C8, $CC
	defb $CC, $C4
	defb $C8, $98
	defb $64, $C4
	defb $30, $98
	defb $64, $70
	defb $C8, $98
	defb $CC, $C4
._pm_l1_tile_113

._pm_l1_tile_113_DATA
	defb $98, $CC
	defb $70, $64
	defb $98, $CC
	defb $CC, $C4
	defb $C8, $C8
	defb $64, $C4
	defb $C8, $CC
	defb $C4, $CC
._pm_l1_tile_114

._pm_l1_tile_114_DATA
	defb $CC, $CC
	defb $CC, $CC
	defb $C8, $98
	defb $C4, $C4
	defb $C0, $C8
	defb $C0, $C4
	defb $C8, $C0
	defb $C4, $C4
._pm_l1_tile_115

._pm_l1_tile_115_DATA
	defb $CC, $C0
	defb $70, $64
	defb $B0, $CC
	defb $30, $64
	defb $98, $C8
	defb $C4, $C0
	defb $C0, $C0
	defb $C4, $C4
._pm_l1_tile_116

._pm_l1_tile_116_DATA
	defb $0, $40
	defb $0, $40
	defb $0, $C8
	defb $C4, $CC
	defb $CC, $C0
	defb $C8, $C0
	defb $C0, $0
	defb $0, $0
._pm_l1_tile_117

._pm_l1_tile_117_DATA
	defb $0, $80
	defb $40, $80
	defb $40, $0
	defb $C0, $0
	defb $80, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_118

._pm_l1_tile_118_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_119

._pm_l1_tile_119_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_120

._pm_l1_tile_120_DATA
	defb $C4, $C4
	defb $C4, $CC
	defb $40, $64
	defb $C4, $64
	defb $C4, $CC
	defb $C0, $98
	defb $44, $98
	defb $C4, $64
._pm_l1_tile_121

._pm_l1_tile_121_DATA
	defb $C8, $C0
	defb $C0, $C0
	defb $C8, $C8
	defb $C4, $C0
	defb $C8, $80
	defb $C4, $C0
	defb $C8, $C0
	defb $C0, $C0
._pm_l1_tile_122

._pm_l1_tile_122_DATA
	defb $C4, $CC
	defb $C4, $CC
	defb $C4, $64
	defb $C4, $64
	defb $C4, $CC
	defb $44, $64
	defb $90, $98
	defb $C4, $64
._pm_l1_tile_123

._pm_l1_tile_123_DATA
	defb $C8, $C0
	defb $C0, $80
	defb $C8, $C0
	defb $C4, $C0
	defb $C8, $C0
	defb $C0, $C0
	defb $C8, $C0
	defb $C4, $C0
._pm_l1_tile_124

._pm_l1_tile_124_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $30, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $B4
	defb $F0, $F0
._pm_l1_tile_125

._pm_l1_tile_125_DATA
	defb $0, $0
	defb $0, $0
	defb $B0, $0
	defb $F0, $B0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $B4, $F0
._pm_l1_tile_126

._pm_l1_tile_126_DATA
	defb $F0, $F0
	defb $F0, $F0
	defb $B4, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $78, $F0
	defb $F0, $F0
._pm_l1_tile_127

._pm_l1_tile_127_DATA
	defb $78, $78
	defb $B4, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $F0
	defb $F0, $B4
	defb $F0, $78
	defb $F0, $B4
._pm_l1_tile_128

._pm_l1_tile_128_DATA
	defb $0, $1
	defb $0, $53
	defb $1, $F3
	defb $51, $F3
	defb $F9, $F3
	defb $A9, $F3
	defb $53, $F3
	defb $A9, $53
._pm_l1_tile_129

._pm_l1_tile_129_DATA
	defb $2, $0
	defb $A3, $0
	defb $F3, $2
	defb $F7, $A2
	defb $F7, $A3
	defb $F3, $A3
	defb $F3, $F3
	defb $F3, $F3
._pm_l1_tile_130

._pm_l1_tile_130_DATA
	defb $53, $F3
	defb $FC, $3
	defb $A9, $F3
	defb $FC, $A9
	defb $54, $3
	defb $54, $FC
	defb $0, $A9
	defb $0, $54
._pm_l1_tile_131

._pm_l1_tile_131_DATA
	defb $F3, $F3
	defb $53, $F3
	defb $F3, $A3
	defb $53, $A3
	defb $F3, $2
	defb $3, $A8
	defb $56, $0
	defb $A8, $0
._pm_l1_tile_132

._pm_l1_tile_132_DATA
	defb $0, $14
	defb $0, $14
	defb $0, $30
	defb $0, $78
	defb $50, $78
	defb $50, $30
	defb $10, $78
	defb $B0, $78
._pm_l1_tile_133

._pm_l1_tile_133_DATA
	defb $A0, $0
	defb $A0, $0
	defb $30, $0
	defb $B0, $0
	defb $30, $20
	defb $30, $20
	defb $B0, $20
	defb $F0, $30
._pm_l1_tile_134

._pm_l1_tile_134_DATA
	defb $B0, $78
	defb $B0, $78
	defb $B0, $78
	defb $B0, $78
	defb $B0, $30
	defb $F0, $78
	defb $70, $B0
	defb $30, $30
._pm_l1_tile_135

._pm_l1_tile_135_DATA
	defb $30, $30
	defb $F0, $30
	defb $B0, $30
	defb $F0, $30
	defb $30, $30
	defb $F0, $30
	defb $30, $30
	defb $30, $30
._pm_l1_tile_136

._pm_l1_tile_136_DATA
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
._pm_l1_tile_137

._pm_l1_tile_137_DATA
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
._pm_l1_tile_138

._pm_l1_tile_138_DATA
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
	defb $0, $14
._pm_l1_tile_139

._pm_l1_tile_139_DATA
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
._pm_l1_tile_140

._pm_l1_tile_140_DATA
	defb $45, $CF
	defb $CF, $CF
	defb $CF, $9B
	defb $CF, $67
	defb $9B, $9B
	defb $CF, $67
	defb $CF, $9B
	defb $CF, $67
._pm_l1_tile_141

._pm_l1_tile_141_DATA
	defb $CF, $CF
	defb $CF, $67
	defb $9B, $9B
	defb $67, $CF
	defb $33, $9B
	defb $67, $33
	defb $33, $33
	defb $33, $33
._pm_l1_tile_142

._pm_l1_tile_142_DATA
	defb $9B, $9B
	defb $CF, $33
	defb $CF, $9B
	defb $CF, $67
	defb $CF, $9B
	defb $CF, $67
	defb $9B, $9B
	defb $67, $33
._pm_l1_tile_143

._pm_l1_tile_143_DATA
	defb $33, $33
	defb $33, $33
	defb $33, $73
	defb $33, $B3
	defb $33, $73
	defb $33, $B3
	defb $73, $73
	defb $B3, $F3
._pm_l1_tile_144

._pm_l1_tile_144_DATA
	defb $CF, $CF
	defb $67, $CF
	defb $9B, $9B
	defb $67, $67
	defb $33, $9B
	defb $67, $67
	defb $33, $33
	defb $33, $67
._pm_l1_tile_145

._pm_l1_tile_145_DATA
	defb $CF, $CF
	defb $CF, $67
	defb $9B, $9B
	defb $67, $CF
	defb $33, $9B
	defb $67, $33
	defb $33, $33
	defb $33, $33
._pm_l1_tile_146

._pm_l1_tile_146_DATA
	defb $33, $33
	defb $33, $33
	defb $33, $73
	defb $B3, $B3
	defb $33, $73
	defb $33, $33
	defb $B3, $F3
	defb $F3, $F3
._pm_l1_tile_147

._pm_l1_tile_147_DATA
	defb $33, $33
	defb $33, $33
	defb $33, $73
	defb $B3, $B3
	defb $33, $73
	defb $73, $B3
	defb $F3, $F3
	defb $F3, $F3
._pm_l1_tile_148

._pm_l1_tile_148_DATA
	defb $CF, $CF
	defb $67, $CF
	defb $9B, $9B
	defb $67, $67
	defb $33, $9B
	defb $67, $67
	defb $33, $33
	defb $67, $67
._pm_l1_tile_149

._pm_l1_tile_149_DATA
	defb $CF, $8A
	defb $CF, $CF
	defb $CF, $CF
	defb $67, $CF
	defb $9B, $CF
	defb $67, $67
	defb $9B, $CF
	defb $67, $CF
._pm_l1_tile_150

._pm_l1_tile_150_DATA
	defb $33, $33
	defb $33, $33
	defb $33, $73
	defb $B3, $B3
	defb $33, $73
	defb $33, $33
	defb $B3, $F3
	defb $F3, $F3
._pm_l1_tile_151

._pm_l1_tile_151_DATA
	defb $9B, $CF
	defb $67, $67
	defb $33, $CF
	defb $B3, $67
	defb $33, $CF
	defb $B3, $67
	defb $F3, $33
	defb $F3, $B3
._pm_l1_tile_152

._pm_l1_tile_152_DATA
	defb $40, $E0
	defb $44, $6C
	defb $14, $3C
	defb $0, $A0
	defb $0, $28
	defb $0, $28
	defb $0, $28
	defb $0, $A0
._pm_l1_tile_153

._pm_l1_tile_153_DATA
	defb $0, $0
	defb $0, $0
	defb $40, $E0
	defb $44, $6C
	defb $14, $3C
	defb $0, $A0
	defb $0, $28
	defb $0, $28
._pm_l1_tile_154

._pm_l1_tile_154_DATA
	defb $0, $28
	defb $0, $A0
	defb $0, $20
	defb $0, $A0
	defb $0, $20
	defb $AD, $D3
	defb $74, $E9
	defb $74, $FC
._pm_l1_tile_155

._pm_l1_tile_155_DATA
	defb $0, $A0
	defb $0, $28
	defb $0, $A0
	defb $0, $20
	defb $0, $A0
	defb $FF, $F3
	defb $E9, $5B
	defb $FC, $D3
._pm_l1_tile_156

._pm_l1_tile_156_DATA
	defb $30, $30
	defb $FC, $FC
	defb $7E, $7E
	defb $17, $BD
	defb $3F, $3F
	defb $83, $83
	defb $3F, $3F
	defb $2B, $2B
._pm_l1_tile_157

._pm_l1_tile_157_DATA
	defb $30, $30
	defb $FC, $FC
	defb $7E, $7E
	defb $BD, $3F
	defb $3F, $3F
	defb $83, $2B
	defb $3F, $3F
	defb $83, $83
._pm_l1_tile_158

._pm_l1_tile_158_DATA
	defb $3F, $3F
	defb $2B, $3F
	defb $43, $3
	defb $3F, $3F
	defb $17, $7E
	defb $3F, $BD
	defb $FC, $FC
	defb $30, $30
._pm_l1_tile_159

._pm_l1_tile_159_DATA
	defb $3F, $3F
	defb $17, $17
	defb $2B, $3F
	defb $3F, $2B
	defb $3F, $3F
	defb $BD, $BD
	defb $FC, $FC
	defb $30, $30
._pm_l1_tile_160

._pm_l1_tile_160_DATA
	defb $AD, $D3
	defb $74, $E9
	defb $74, $FC
	defb $30, $FC
	defb $74, $74
	defb $30, $B8
	defb $74, $74
	defb $30, $30
._pm_l1_tile_161

._pm_l1_tile_161_DATA
	defb $FF, $F3
	defb $E9, $5B
	defb $FC, $D3
	defb $FC, $FD
	defb $FC, $D7
	defb $FC, $FD
	defb $FC, $D7
	defb $30, $5F
._pm_l1_tile_162

._pm_l1_tile_162_DATA
	defb $AD, $D3
	defb $74, $5F
	defb $74, $D3
	defb $30, $FD
	defb $74, $D3
	defb $30, $F9
	defb $74, $D3
	defb $30, $5F
._pm_l1_tile_163

._pm_l1_tile_163_DATA
	defb $FF, $FB
	defb $4B, $E9
	defb $74, $FC
	defb $74, $FC
	defb $30, $FC
	defb $74, $74
	defb $30, $B8
	defb $30, $30
._pm_l1_tile_164

._pm_l1_tile_164_DATA
	defb $FF, $FB
	defb $4B, $E9
	defb $74, $FC
	defb $30, $FC
	defb $74, $74
	defb $30, $B8
	defb $74, $74
	defb $30, $30
._pm_l1_tile_165

._pm_l1_tile_165_DATA
	defb $FF, $F3
	defb $E9, $5B
	defb $FC, $D3
	defb $FC, $FD
	defb $FC, $D7
	defb $FC, $FD
	defb $FC, $D7
	defb $30, $5F
._pm_l1_tile_166

._pm_l1_tile_166_DATA
	defb $FB, $FB
	defb $E9, $5F
	defb $FC, $D3
	defb $FC, $FD
	defb $FC, $D3
	defb $FC, $F9
	defb $FC, $D3
	defb $30, $5F
._pm_l1_tile_167

._pm_l1_tile_167_DATA
	defb $FF, $FB
	defb $4B, $E9
	defb $74, $FC
	defb $74, $FC
	defb $30, $FC
	defb $74, $74
	defb $30, $B8
	defb $30, $30
._pm_l1_tile_168

._pm_l1_tile_168_DATA
	defb $FF, $FB
	defb $4B, $E9
	defb $74, $FC
	defb $30, $FC
	defb $74, $74
	defb $30, $B8
	defb $74, $74
	defb $30, $30
._pm_l1_tile_169

._pm_l1_tile_169_DATA
	defb $FF, $F3
	defb $E9, $5B
	defb $FC, $D3
	defb $FC, $FD
	defb $FC, $D7
	defb $FC, $FD
	defb $FC, $D7
	defb $30, $5F
._pm_l1_tile_170

._pm_l1_tile_170_DATA
	defb $FB, $FB
	defb $E9, $5F
	defb $FC, $D3
	defb $FC, $FD
	defb $FC, $D3
	defb $FC, $F9
	defb $FC, $D3
	defb $30, $5F
._pm_l1_tile_171

._pm_l1_tile_171_DATA
	defb $FF, $FB
	defb $4B, $5F
	defb $74, $D3
	defb $25, $FD
	defb $74, $D3
	defb $30, $F9
	defb $25, $D3
	defb $30, $71
._pm_l1_tile_172

._pm_l1_tile_172_DATA
	defb $40, $CA
	defb $91, $FB
	defb $9B, $F3
	defb $CF, $33
	defb $CF, $CF
	defb $D0, $33
	defb $40, $9B
	defb $0, $E5
._pm_l1_tile_173

._pm_l1_tile_173_DATA
	defb $CF, $C5
	defb $67, $CF
	defb $67, $33
	defb $9B, $FB
	defb $77, $B3
	defb $73, $F3
	defb $B3, $B3
	defb $67, $67
._pm_l1_tile_174

._pm_l1_tile_174_DATA
	defb $0, $D0
	defb $0, $40
	defb $0, $C5
	defb $0, $E5
	defb $40, $D0
	defb $40, $C0
	defb $0, $C0
	defb $0, $0
._pm_l1_tile_175

._pm_l1_tile_175_DATA
	defb $9B, $9B
	defb $CF, $73
	defb $67, $9B
	defb $CF, $E5
	defb $CA, $CA
	defb $D0, $CF
	defb $40, $A0
	defb $0, $0
._pm_l1_tile_176

._pm_l1_tile_176_DATA
	defb $80, $0
	defb $67, $C5
	defb $F3, $67
	defb $F3, $67
	defb $33, $CF
	defb $67, $67
	defb $9B, $B3
	defb $67, $67
._pm_l1_tile_177

._pm_l1_tile_177_DATA
	defb $C5, $CF
	defb $9B, $CF
	defb $B3, $9B
	defb $33, $9B
	defb $67, $CF
	defb $CF, $67
	defb $9B, $FB
	defb $9B, $F3
._pm_l1_tile_178

._pm_l1_tile_178_DATA
	defb $9B, $DA
	defb $67, $62
	defb $B3, $CA
	defb $67, $C0
	defb $CA, $C0
	defb $C5, $CA
	defb $E5, $DA
	defb $50, $A0
._pm_l1_tile_179

._pm_l1_tile_179_DATA
	defb $CF, $67
	defb $E5, $9B
	defb $C5, $C0
	defb $9B, $CA
	defb $E5, $CA
	defb $D0, $C5
	defb $C0, $50
	defb $0, $0
._pm_l1_tile_180

._pm_l1_tile_180_DATA
	defb $C5, $CF
	defb $33, $CF
	defb $FB, $67
	defb $F3, $67
	defb $33, $CF
	defb $CF, $9B
	defb $9B, $CF
	defb $CF, $67
._pm_l1_tile_181

._pm_l1_tile_181_DATA
	defb $C5, $80
	defb $CF, $CF
	defb $73, $CA
	defb $CF, $80
	defb $67, $CA
	defb $B3, $CF
	defb $67, $67
	defb $9B, $CA
._pm_l1_tile_182

._pm_l1_tile_182_DATA
	defb $67, $45
	defb $C5, $DB
	defb $C5, $9B
	defb $D0, $C5
	defb $CA, $C0
	defb $67, $50
	defb $CF, $40
	defb $A0, $0
._pm_l1_tile_183

._pm_l1_tile_183_DATA
	defb $CF, $CF
	defb $33, $CF
	defb $67, $67
	defb $9B, $CA
	defb $CA, $0
	defb $67, $0
	defb $E0, $0
	defb $0, $0
._pm_l1_tile_184

._pm_l1_tile_184_DATA
	defb $0, $0
	defb $0, $54
	defb $0, $4
	defb $0, $84
	defb $0, $C0
	defb $40, $84
	defb $C0, $C0
	defb $4, $C
._pm_l1_tile_185

._pm_l1_tile_185_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $A8, $0
	defb $8, $0
	defb $84, $0
	defb $48, $8
	defb $18, $0
._pm_l1_tile_186

._pm_l1_tile_186_DATA
	defb $40, $C0
	defb $40, $E2
	defb $40, $E2
	defb $40, $6A
	defb $40, $C0
	defb $40, $C0
	defb $40, $C0
	defb $C0, $C0
._pm_l1_tile_187

._pm_l1_tile_187_DATA
	defb $90, $10
	defb $E6, $4
	defb $E6, $10
	defb $6E, $44
	defb $C0, $C4
	defb $C4, $C0
	defb $C0, $C4
	defb $C0, $C0
._pm_l1_tile_188

._pm_l1_tile_188_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._pm_l1_tile_189

._pm_l1_tile_189_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $8, $0
	defb $0, $0
	defb $A8, $0
._pm_l1_tile_190

._pm_l1_tile_190_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $0, $40
	defb $0, $C0
	defb $40, $C0
	defb $0, $C
	defb $C0, $C0
._pm_l1_tile_191

._pm_l1_tile_191_DATA
	defb $8, $0
	defb $8, $0
	defb $5C, $0
	defb $84, $0
	defb $48, $8
	defb $84, $84
	defb $C, $8
	defb $C0, $C0
._pm_l1_tile_192

._pm_l1_tile_192_DATA
	defb $0, $0
	defb $4, $A8
	defb $40, $20
	defb $40, $88
	defb $51, $20
	defb $15, $88
	defb $40, $20
	defb $40, $88
._pm_l1_tile_193

._pm_l1_tile_193_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $5C, $0
	defb $90, $0
	defb $C4, $0
	defb $90, $0
._pm_l1_tile_194

._pm_l1_tile_194_DATA
	defb $40, $80
	defb $40, $88
	defb $40, $C0
	defb $40, $C0
	defb $40, $E2
	defb $40, $E2
	defb $40, $6A
	defb $C0, $C0
._pm_l1_tile_195

._pm_l1_tile_195_DATA
	defb $C4, $0
	defb $90, $0
	defb $C4, $0
	defb $C0, $8
	defb $E6, $24
	defb $E2, $98
	defb $6E, $C4
	defb $C0, $98
._pm_l1_tile_196

._pm_l1_tile_196_DATA
	defb $14, $3C
	defb $14, $78
	defb $14, $B4
	defb $50, $78
	defb $14, $F0
	defb $50, $92
	defb $50, $F0
	defb $50, $92
._pm_l1_tile_197

._pm_l1_tile_197_DATA
	defb $3C, $A0
	defb $78, $20
	defb $B0, $20
	defb $F0, $20
	defb $B0, $20
	defb $70, $20
	defb $F0, $20
	defb $70, $20
._pm_l1_tile_198

._pm_l1_tile_198_DATA
	defb $50, $B0
	defb $50, $70
	defb $50, $F0
	defb $50, $30
	defb $50, $70
	defb $50, $61
	defb $50, $64
	defb $DA, $9A
._pm_l1_tile_199

._pm_l1_tile_199_DATA
	defb $F0, $20
	defb $70, $20
	defb $F0, $20
	defb $70, $20
	defb $98, $20
	defb $98, $20
	defb $98, $8A
	defb $65, $65
._pm_l1_tile_200

._pm_l1_tile_200_DATA
	defb $50, $78
	defb $B4, $B0
	defb $78, $30
	defb $B0, $F3
	defb $79, $71
	defb $B0, $E6
	defb $B0, $F3
	defb $F0, $65
._pm_l1_tile_201

._pm_l1_tile_201_DATA
	defb $E4, $80
	defb $70, $C8
	defb $70, $CC
	defb $E7, $CC
	defb $71, $CC
	defb $E7, $CC
	defb $F2, $C8
	defb $30, $CC
._pm_l1_tile_202

._pm_l1_tile_202_DATA
	defb $B0, $B0
	defb $F0, $30
	defb $B0, $B0
	defb $F0, $30
	defb $B0, $B0
	defb $E5, $70
	defb $F0, $9A
	defb $F0, $DA
._pm_l1_tile_203

._pm_l1_tile_203_DATA
	defb $70, $C8
	defb $70, $CC
	defb $70, $C8
	defb $70, $C4
	defb $70, $C8
	defb $70, $C0
	defb $B0, $CD
	defb $DA, $CA
._pm_l1_tile_204

._pm_l1_tile_204_DATA
	defb $80, $C0
	defb $45, $CF
	defb $CF, $33
	defb $9B, $73
	defb $CF, $33
	defb $9B, $DB
	defb $C5, $9B
	defb $40, $C5
._pm_l1_tile_205

._pm_l1_tile_205_DATA
	defb $80, $0
	defb $CD, $33
	defb $9B, $73
	defb $73, $B3
	defb $F3, $67
	defb $B3, $9B
	defb $67, $67
	defb $33, $CF
._pm_l1_tile_206

._pm_l1_tile_206_DATA
	defb $0, $40
	defb $0, $0
	defb $0, $80
	defb $40, $48
	defb $4, $84
	defb $40, $9
	defb $4, $6
	defb $40, $9
._pm_l1_tile_207

._pm_l1_tile_207_DATA
	defb $9B, $CA
	defb $C5, $80
	defb $45, $0
	defb $40, $0
	defb $80, $40
	defb $48, $84
	defb $6, $48
	defb $9, $9
._pm_l1_tile_208

._pm_l1_tile_208_DATA
	defb $40, $C0
	defb $CE, $C0
	defb $F3, $33
	defb $B3, $DB
	defb $67, $33
	defb $9B, $DB
	defb $67, $9B
	defb $CA, $C5
._pm_l1_tile_209

._pm_l1_tile_209_DATA
	defb $80, $0
	defb $CD, $33
	defb $9B, $73
	defb $73, $B3
	defb $F3, $67
	defb $B3, $9B
	defb $67, $67
	defb $33, $CF
._pm_l1_tile_210

._pm_l1_tile_210_DATA
	defb $80, $40
	defb $0, $0
	defb $80, $80
	defb $48, $48
	defb $C, $84
	defb $C, $9
	defb $6, $6
	defb $3, $3
._pm_l1_tile_211

._pm_l1_tile_211_DATA
	defb $9B, $CA
	defb $C5, $80
	defb $45, $0
	defb $40, $0
	defb $80, $40
	defb $48, $84
	defb $6, $48
	defb $9, $9
._pm_l1_tile_212

._pm_l1_tile_212_DATA
	defb $40, $C0
	defb $CE, $C0
	defb $F3, $33
	defb $B3, $DB
	defb $67, $33
	defb $9B, $DB
	defb $67, $9B
	defb $CA, $C5
._pm_l1_tile_213

._pm_l1_tile_213_DATA
	defb $80, $40
	defb $CD, $8A
	defb $9B, $67
	defb $73, $B3
	defb $F3, $67
	defb $B3, $9B
	defb $67, $67
	defb $33, $CF
._pm_l1_tile_214

._pm_l1_tile_214_DATA
	defb $80, $40
	defb $0, $0
	defb $80, $80
	defb $48, $48
	defb $C, $84
	defb $C, $9
	defb $6, $6
	defb $3, $3
._pm_l1_tile_215

._pm_l1_tile_215_DATA
	defb $9B, $CA
	defb $C5, $80
	defb $45, $0
	defb $40, $0
	defb $80, $0
	defb $48, $80
	defb $6, $80
	defb $9, $8
._pm_l1_tile_216

._pm_l1_tile_216_DATA
	defb $40, $D7
	defb $D0, $B4
	defb $C0, $E0
	defb $84, $94
	defb $D4, $58
	defb $84, $D0
	defb $C0, $50
	defb $84, $D0
._pm_l1_tile_217

._pm_l1_tile_217_DATA
	defb $3C, $96
	defb $D0, $68
	defb $E8, $A4
	defb $FC, $D4
	defb $FC, $FC
	defb $AC, $AC
	defb $C, $48
	defb $A4, $80
._pm_l1_tile_218

._pm_l1_tile_218_DATA
	defb $40, $E1
	defb $D0, $94
	defb $C0, $E8
	defb $84, $FC
	defb $D4, $FC
	defb $84, $AC
	defb $84, $C
	defb $84, $84
._pm_l1_tile_219

._pm_l1_tile_219_DATA
	defb $BE, $E1
	defb $78, $D0
	defb $E0, $F8
	defb $84, $F8
	defb $5C, $58
	defb $AC, $D0
	defb $48, $50
	defb $84, $D0
._pm_l1_tile_220

._pm_l1_tile_220_DATA
	defb $BE, $D7
	defb $E0, $B4
	defb $D4, $D0
	defb $AC, $BC
	defb $5C, $58
	defb $AC, $D0
	defb $48, $50
	defb $84, $D0
._pm_l1_tile_221

._pm_l1_tile_221_DATA
	defb $3C, $96
	defb $D0, $68
	defb $E8, $A4
	defb $FC, $D4
	defb $FC, $FC
	defb $AC, $AC
	defb $C, $48
	defb $A4, $80
._pm_l1_tile_222

._pm_l1_tile_222_DATA
	defb $69, $E1
	defb $D0, $94
	defb $E8, $E8
	defb $FC, $FC
	defb $FC, $FC
	defb $AC, $AC
	defb $C, $C
	defb $84, $84
._pm_l1_tile_223

._pm_l1_tile_223_DATA
	defb $BE, $E1
	defb $78, $D0
	defb $E0, $F8
	defb $84, $F8
	defb $5C, $58
	defb $AC, $D0
	defb $48, $50
	defb $84, $D0
._pm_l1_tile_224

._pm_l1_tile_224_DATA
	defb $BE, $D7
	defb $E0, $B4
	defb $D4, $D0
	defb $AC, $BC
	defb $5C, $58
	defb $AC, $D0
	defb $48, $50
	defb $84, $D0
._pm_l1_tile_225

._pm_l1_tile_225_DATA
	defb $3C, $80
	defb $D0, $68
	defb $E8, $E0
	defb $AC, $C0
	defb $FC, $48
	defb $AC, $48
	defb $C, $48
	defb $A4, $C0
._pm_l1_tile_226

._pm_l1_tile_226_DATA
	defb $69, $E1
	defb $D0, $94
	defb $E8, $E8
	defb $FC, $FC
	defb $FC, $FC
	defb $AC, $AC
	defb $C, $C
	defb $84, $84
._pm_l1_tile_227

._pm_l1_tile_227_DATA
	defb $BE, $80
	defb $78, $48
	defb $E0, $48
	defb $84, $E8
	defb $5C, $48
	defb $AC, $C0
	defb $48, $48
	defb $84, $80
._pm_l1_tile_228

._pm_l1_tile_228_DATA
	defb $BE, $3C
	defb $3C, $78
	defb $B4, $F0
	defb $F0, $30
	defb $0, $0
	defb $90, $C0
	defb $30, $60
	defb $B0, $B0
._pm_l1_tile_229

._pm_l1_tile_229_DATA
	defb $B4, $A0
	defb $78, $A0
	defb $F0, $A0
	defb $60, $80
	defb $0, $0
	defb $C0, $80
	defb $60, $80
	defb $90, $80
._pm_l1_tile_230

._pm_l1_tile_230_DATA
	defb $30, $60
	defb $B0, $B0
	defb $30, $30
	defb $BE, $3C
	defb $3C, $78
	defb $3C, $B4
	defb $F0, $30
	defb $0, $0
._pm_l1_tile_231

._pm_l1_tile_231_DATA
	defb $60, $80
	defb $90, $80
	defb $60, $80
	defb $3C, $A0
	defb $78, $28
	defb $F0, $A0
	defb $60, $80
	defb $0, $0
._pm_l1_tile_232

._pm_l1_tile_232_DATA
	defb $FF, $57
	defb $AB, $AB
	defb $FF, $56
	defb $56, $AC
	defb $0, $0
	defb $84, $C0
	defb $C, $48
	defb $AC, $AC
._pm_l1_tile_233

._pm_l1_tile_233_DATA
	defb $56, $2
	defb $A9, $A8
	defb $FC, $A8
	defb $C, $8
	defb $0, $0
	defb $C0, $80
	defb $48, $80
	defb $84, $80
._pm_l1_tile_234

._pm_l1_tile_234_DATA
	defb $C, $48
	defb $AC, $AC
	defb $C, $C
	defb $FF, $57
	defb $AB, $AB
	defb $FF, $56
	defb $3, $FC
	defb $0, $0
._pm_l1_tile_235

._pm_l1_tile_235_DATA
	defb $48, $80
	defb $84, $80
	defb $48, $80
	defb $56, $2
	defb $A9, $A8
	defb $FC, $A8
	defb $C, $8
	defb $0, $0
._pm_l1_tile_236

._pm_l1_tile_236_DATA
	defb $FB, $F3
	defb $F3, $B3
	defb $73, $33
	defb $33, $CF
	defb $0, $0
	defb $C5, $C0
	defb $CF, $CA
	defb $67, $67
._pm_l1_tile_237

._pm_l1_tile_237_DATA
	defb $73, $22
	defb $B3, $22
	defb $33, $22
	defb $CA, $80
	defb $0, $0
	defb $C0, $80
	defb $CA, $80
	defb $C5, $80
._pm_l1_tile_238

._pm_l1_tile_238_DATA
	defb $CF, $CA
	defb $67, $67
	defb $CF, $CF
	defb $FB, $F3
	defb $F3, $B3
	defb $F3, $73
	defb $33, $CF
	defb $0, $0
._pm_l1_tile_239

._pm_l1_tile_239_DATA
	defb $CA, $80
	defb $C5, $80
	defb $CA, $80
	defb $F3, $22
	defb $B3, $A2
	defb $33, $22
	defb $CA, $80
	defb $0, $0
._pm_l1_tile_240

._pm_l1_tile_240_DATA
	defb $C0, $C0
	defb $D5, $B2
	defb $D1, $38
	defb $D1, $38
	defb $D1, $78
	defb $D1, $78
	defb $D1, $FA
	defb $D0, $70
._pm_l1_tile_241

._pm_l1_tile_241_DATA
	defb $C0, $80
	defb $FB, $80
	defb $B6, $80
	defb $B6, $80
	defb $B6, $80
	defb $B6, $80
	defb $F7, $80
	defb $70, $80
._pm_l1_tile_242

._pm_l1_tile_242_DATA
	defb $D5, $F2
	defb $D1, $78
	defb $D1, $78
	defb $D1, $78
	defb $D1, $78
	defb $D1, $FA
	defb $C0, $C0
	defb $0, $0
._pm_l1_tile_243

._pm_l1_tile_243_DATA
	defb $FB, $80
	defb $B6, $80
	defb $B6, $80
	defb $B6, $80
	defb $B6, $80
	defb $F7, $80
	defb $C0, $80
	defb $0, $0
._pm_l1_tile_244

._pm_l1_tile_244_DATA
	defb $4, $C
	defb $5D, $87
	defb $49, $F
	defb $C, $C
	defb $5D, $87
	defb $49, $F
	defb $C, $C
	defb $5D, $87
._pm_l1_tile_245

._pm_l1_tile_245_DATA
	defb $4, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
._pm_l1_tile_246

._pm_l1_tile_246_DATA
	defb $49, $F
	defb $C, $C
	defb $5D, $87
	defb $49, $F
	defb $C, $C
	defb $5D, $87
	defb $49, $F
	defb $C, $C
._pm_l1_tile_247

._pm_l1_tile_247_DATA
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
._pm_l1_tile_248

._pm_l1_tile_248_DATA
	defb $4, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
._pm_l1_tile_249

._pm_l1_tile_249_DATA
	defb $4, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
._pm_l1_tile_250

._pm_l1_tile_250_DATA
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
._pm_l1_tile_251

._pm_l1_tile_251_DATA
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
._pm_l1_tile_252

._pm_l1_tile_252_DATA
	defb $4, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
._pm_l1_tile_253

._pm_l1_tile_253_DATA
	defb $4, $8
	defb $49, $AC
	defb $AD, $AC
	defb $AC, $C
	defb $49, $AC
	defb $AD, $AC
	defb $AC, $C
	defb $49, $AC
._pm_l1_tile_254

._pm_l1_tile_254_DATA
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
	defb $5D, $87
	defb $E9, $F
	defb $AC, $C
._pm_l1_tile_255

._pm_l1_tile_255_DATA
	defb $AD, $AC
	defb $AC, $C
	defb $49, $AC
	defb $AD, $AC
	defb $AC, $C
	defb $49, $AC
	defb $AD, $AC
	defb $AC, $C
	
	