	XLIB TileMapConf
	
	XDEF tiles
	XDEF pantalla_juego
	XDEF tiles_tocados
	XDEF posiciones_pantalla
	XDEF posiciones_super_buffer
	
	XDEF posicion_inicial_area_visible
	XDEF posicion_inicial_superbuffer
	XDEF ancho_pantalla_bytes
	XDEF alto_pantalla_bytes
	XDEF ancho_pantalla_bytes_visible
	
	XDEF tile11

	XDEF mascara1
	XDEF mascara2
	
	; Voy a definir como mscara de los sprites el color 2
	
	; 0: $00, $00
	; 1: $80, $40
	; 2: $04, $08
	; 3: $44, $88
	; 4: $10, $20
	; 5: $50, $A0
	; 6: $14, $28
	; 7: $54, $A8
	; 8: $01, $02
	; 9: $41, $82
	; 10: $05, $0A
	; 11: $45, $8A
	; 12: $11, $22
	
	defc mascara1 = $04 ;
	defc mascara2 = $08 ;
	
; VALORES QUE DEFINEN EL BUFFER Y LA PANTALLA
	defc posicion_inicial_area_visible = $e05a ;$c0AA ;$d808 ; Del excel de arta, x = 16, y = 4		;$c0AA
	defc posicion_inicial_superbuffer = $100
	
	defc T_WIDTH = 	30 ;32 ;28 ;32 ;28 ;16			;max=40		;dimensiones de la pantalla en tiles
	defc T_HEIGHT = 18 ;16							;max=20
	
	
	defc ancho_pantalla_bytes = 2*T_WIDTH ; 2*T_WIDTH;		; El ancho de pantalla influye determinantemente en 
															; numerosas rutinas que hay que actualizar si se cambia
															; OJO con el modo
	defc alto_pantalla_bytes = 8*T_HEIGHT ;
	
	defc ancho_pantalla_bytes_visible = 2*T_WIDTH ;32  ; 64;		;dentro del area definida, cuanto se debe mostrar. 2*T_WIDTH

;El tamao del buffer es ancho_pantalla_bytes*alto_pantalla_bytes


.TileMapConf
;Con la definicin del mapeado hay que tener en cuenta que las coordenadas son:
;ANCHO=64 bytes (128 pixels en modo 0)
;ALTO=128 pixels

;el mximo que entra en el CPC es 20 lneas
;SI NO SE VAN A USAR TODAS LAS LINEAS, PARA AHORRA MEMORIA ES INTERESANTE COMENTARLAS

.posiciones_pantalla		;Posiciones en las que se dibujan los tiles
	defw posicion_inicial_area_visible+$50*0
	defw posicion_inicial_area_visible+$50*1  
	defw posicion_inicial_area_visible+$50*2
	defw posicion_inicial_area_visible+$50*3
	defw posicion_inicial_area_visible+$50*4
	defw posicion_inicial_area_visible+$50*5 
	defw posicion_inicial_area_visible+$50*6 
	defw posicion_inicial_area_visible+$50*7 
	defw posicion_inicial_area_visible+$50*8 
	defw posicion_inicial_area_visible+$50*9 
	defw posicion_inicial_area_visible+$50*10 
	defw posicion_inicial_area_visible+$50*11 
	defw posicion_inicial_area_visible+$50*12 
	defw posicion_inicial_area_visible+$50*13 
	defw posicion_inicial_area_visible+$50*14 
	defw posicion_inicial_area_visible+$50*15
	defw posicion_inicial_area_visible+$50*16
	defw posicion_inicial_area_visible+$50*17
	defw posicion_inicial_area_visible+$50*18
	defw posicion_inicial_area_visible+$50*19

.posiciones_super_buffer	;muestra el inicio de cada lnea (son 10 tiles de 8x16 de alto)

	;defw $1000, $1200, $1400, $1600, $1800, $1a00, $1c00, $1e00, $2000, $2200, $2400, $2600, $2800, $2a00, $2c00, $2f00
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*0
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*1
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*2
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*3
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*4
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*5
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*6
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*7
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*8
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*9
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*10
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*11
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*12
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*13
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*14
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*15
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*16
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*17
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*18
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*19
	
	;defw $1000, $1480, $1900, $1d80, $2200, $2680, $2b00, $2f80, $3400, $3880
	
;Rutinas para transferir bloques independientes a la pantalla

;Se busca el subbloque de 8x8 correspondiente a las coordenadas x,y
;el bloque se calcula dividiendo la coordenada x /8

.pantalla_actual 
	defw 0

.pantalla_juego  ;en tiles
	defs T_WIDTH*T_HEIGHT
	defb $FF	;Este byte es importante, marca el fin de la pantalla.

.tiles_tocados defs 150 ;150	;cuando un tile es tocado, se marca en esta tabla para luego restaurarlo. Es una tabla sin duplicados.

.tiles ;Son de 2x8 bytes

._tilescpc200

._tilescpc200_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc201

._tilescpc201_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc202

._tilescpc202_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc203

._tilescpc203_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
; Data from file tilescpc21.bmp (8x16)... Mode 0.
._tilescpc210

._tilescpc210_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C4, $48
	defb $90, $C8
	defb $C, $C
	defb $CC, $CC
._tilescpc211

._tilescpc211_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C4, $48
	defb $90, $C8
	defb $C, $C
	defb $CC, $CC
._tilescpc212

._tilescpc212_DATA
	defb $C, $C
	defb $90, $60
	defb $90, $C8
	defb $C4, $48
	defb $90, $C8
	defb $C4, $48
	defb $C4, $48
	defb $C4, $48
._tilescpc213

._tilescpc213_DATA
	defb $C, $C
	defb $90, $60
	defb $90, $C8
	defb $C4, $48
	defb $90, $C8
	defb $C4, $48
	defb $C4, $48
	defb $C4, $48
; Data from file tilescpc22.bmp (8x16)... Mode 0.
._tilescpc220

._tilescpc220_DATA
	defb $C0, $90
	defb $C0, $24
	defb $C0, $CC
	defb $90, $CC
	defb $C4, $4C
	defb $84, $8C
	defb $C4, $CC
	defb $84, $8C
._tilescpc221

._tilescpc221_DATA
	defb $30, $C0
	defb $8C, $60
	defb $C, $C8
	defb $8C, $18
	defb $4C, $4C
	defb $4C, $C
	defb $C, $4C
	defb $C, $C
._tilescpc222

._tilescpc222_DATA
	defb $90, $30
	defb $C4, $CC
	defb $90, $30
	defb $84, $8C
	defb $C4, $CC
	defb $84, $8C
	defb $C4, $CC
	defb $84, $8C
._tilescpc223

._tilescpc223_DATA
	defb $30, $30
	defb $CC, $4C
	defb $30, $30
	defb $C, $C
	defb $C, $4C
	defb $C, $C
	defb $C, $4C
	defb $C, $C
; Data from file tilescpc23.bmp (8x16)... Mode 0.
._tilescpc230

._tilescpc230_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C4
	defb $C0, $C8
._tilescpc231

._tilescpc231_DATA
	defb $90, $C0
	defb $24, $60
	defb $C, $48
	defb $90, $C0
	defb $C4, $C0
	defb $84, $C0
	defb $C, $C0
	defb $84, $C0
._tilescpc232

._tilescpc232_DATA
	defb $C0, $48
	defb $C0, $48
	defb $C0, $60
	defb $90, $98
	defb $C4, $4C
	defb $C4, $8C
	defb $C4, $C
	defb $90, $98
._tilescpc233

._tilescpc233_DATA
	defb $84, $C0
	defb $84, $C0
	defb $84, $C0
	defb $C4, $C0
	defb $90, $C0
	defb $CC, $48
	defb $8C, $48
	defb $CC, $48
	;
	;
	;
; Data from file tilescpc24.bmp (8x16)... Mode 0.
._tilescpc240

._tilescpc240_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc241

._tilescpc241_DATA
	defb $BC, $F0
	defb $BC, $A0
	defb $BC, $78
	defb $BC, $A0
	defb $FC, $78
	defb $BC, $A0
	defb $FC, $78
	defb $BC, $A0
._tilescpc242

._tilescpc242_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc243

._tilescpc243_DATA
	defb $FC, $78
	defb $BC, $A0
	defb $BC, $78
	defb $BC, $A0
	defb $BC, $F0
	defb $BC, $A0
	defb $BC, $A0
	defb $BC, $A0
	;
	;
	;
; Data from file tilescpc25.bmp (8x16)... Mode 0.
._tilescpc250

._tilescpc250_DATA
	defb $50, $F0
	defb $B4, $3C
	defb $F0, $78
	defb $B4, $B4
	defb $F0, $3C
	defb $B4, $B4
	defb $F0, $3C
	defb $50, $F0
._tilescpc251

._tilescpc251_DATA
	defb $50, $F0
	defb $A4, $FC
	defb $F4, $BC
	defb $F4, $F4
	defb $F4, $14
	defb $F4, $3C
	defb $B4, $BC
	defb $50, $F0
._tilescpc252

._tilescpc252_DATA
	defb $50, $F0
	defb $A4, $FC
	defb $F4, $BC
	defb $F4, $F4
	defb $F4, $14
	defb $F4, $3C
	defb $B4, $BC
	defb $0, $F0
._tilescpc253

._tilescpc253_DATA
	defb $50, $F0
	defb $B4, $3C
	defb $F0, $78
	defb $B4, $B4
	defb $F0, $3C
	defb $B4, $B4
	defb $F0, $3C
	defb $50, $F0
	;
	;
	;
; Data from file tilescpc26.bmp (8x16)... Mode 0.
._tilescpc260

._tilescpc260_DATA
	defb $50, $7C
	defb $A0, $B4
	defb $A0, $7C
	defb $A0, $B4
	defb $A0, $7C
	defb $A0, $B4
	defb $A0, $7C
	defb $0, $B4
._tilescpc261

._tilescpc261_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc262

._tilescpc262_DATA
	defb $0, $7C
	defb $A0, $7C
	defb $A0, $7C
	defb $A0, $B4
	defb $A0, $7C
	defb $A0, $B4
	defb $A0, $7C
	defb $0, $B4
._tilescpc263

._tilescpc263_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	;
	;
	;
; Data from file tilescpc27.bmp (8x16)... Mode 0.
._tilescpc270

._tilescpc270_DATA
	defb $B4, $3C
	defb $2C, $FC
	defb $1C, $F0
	defb $F8, $58
	defb $F8, $F0
	defb $F8, $C
	defb $F8, $F0
	defb $F8, $58
._tilescpc271

._tilescpc271_DATA
	defb $3C, $78
	defb $FC, $BC
	defb $F0, $7C
	defb $58, $F4
	defb $F0, $F4
	defb $F0, $F4
	defb $F0, $F4
	defb $F0, $F4
._tilescpc272

._tilescpc272_DATA
	defb $F8, $F0
	defb $BC, $F0
	defb $7C, $FC
	defb $B4, $3C
	defb $50, $50
	defb $0, $A0
	defb $0, $0
	defb $0, $A0
._tilescpc273

._tilescpc273_DATA
	defb $F0, $F4
	defb $F0, $7C
	defb $FC, $BC
	defb $3C, $78
	defb $50, $0
	defb $A0, $A0
	defb $0, $0
	defb $A0, $0
	;
	;
	;
; Data from file tilescpc28.bmp (8x16)... Mode 0.
._tilescpc280

._tilescpc280_DATA
	defb $3, $83
	defb $43, $43
	defb $43, $43
	defb $3, $83
	defb $3, $3
	defb $3, $3
	defb $3, $3
	defb $83, $83
._tilescpc281

._tilescpc281_DATA
	defb $3, $3
	defb $3, $3
	defb $3, $3
	defb $3, $83
	defb $3, $83
	defb $3, $3
	defb $3, $3
	defb $83, $83
._tilescpc282

._tilescpc282_DATA
	defb $3, $3
	defb $83, $83
	defb $43, $43
	defb $C3, $C3
	defb $E9, $C3
	defb $D6, $D6
	defb $E9, $E9
	defb $FC, $FC
._tilescpc283

._tilescpc283_DATA
	defb $3, $3
	defb $83, $83
	defb $43, $43
	defb $C3, $C3
	defb $C3, $C3
	defb $D6, $D6
	defb $E9, $E9
	defb $FC, $FC
	;
	;
	;
; Data from file tilescpc29.bmp (8x16)... Mode 0.
._tilescpc290

._tilescpc290_DATA
	defb $3, $3
	defb $43, $3
	defb $43, $3
	defb $3, $3
	defb $3, $3
	defb $3, $3
	defb $3, $3
	defb $83, $83
._tilescpc291

._tilescpc291_DATA
	defb $3, $3
	defb $43, $3
	defb $83, $83
	defb $83, $83
	defb $43, $3
	defb $3, $3
	defb $3, $3
	defb $83, $83
._tilescpc292

._tilescpc292_DATA
	defb $3, $3
	defb $83, $83
	defb $43, $43
	defb $C3, $C3
	defb $C3, $E9
	defb $C3, $C3
	defb $E9, $E9
	defb $D6, $FC
._tilescpc293

._tilescpc293_DATA
	defb $3, $3
	defb $83, $83
	defb $43, $43
	defb $C3, $C3
	defb $C3, $E9
	defb $D6, $D6
	defb $E9, $E9
	defb $FC, $FC
._tilescpc2100

._tilescpc2100_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $2D
	defb $AD, $F
	defb $0, $7C
	defb $0, $0
	defb $0, $0
._tilescpc2101

._tilescpc2101_DATA
	defb $0, $0
	defb $0, $14
	defb $2D, $D6
	defb $4B, $5E
	defb $C3, $96
	defb $C3, $D6
	defb $7C, $96
	defb $0, $50
._tilescpc2102

._tilescpc2102_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $2D
	defb $AD, $4B
	defb $0, $7C
	defb $0, $0
	defb $0, $0
._tilescpc2103

._tilescpc2103_DATA
	defb $0, $0
	defb $0, $14
	defb $69, $5E
	defb $87, $D6
	defb $C3, $96
	defb $C3, $D6
	defb $7C, $96
	defb $0, $50
; Data from file tilescpc211.bmp (8x16)... Mode 0.
._tilescpc2110

._tilescpc2110_DATA
	defb $0, $0
	defb $28, $0
	defb $E9, $1E
	defb $AD, $87
	defb $69, $C3
	defb $E9, $C3
	defb $69, $BC
	defb $A0, $0
._tilescpc2111

._tilescpc2111_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $1E, $0
	defb $F, $5E
	defb $BC, $0
	defb $0, $0
	defb $0, $0
._tilescpc2112

._tilescpc2112_DATA
	defb $0, $0
	defb $28, $0
	defb $AD, $96
	defb $E9, $4B
	defb $69, $C3
	defb $E9, $C3
	defb $69, $BC
	defb $A0, $0
._tilescpc2113

._tilescpc2113_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $1E, $0
	defb $87, $5E
	defb $BC, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc212.bmp (8x16)... Mode 0.
._tilescpc2120

._tilescpc2120_DATA
	defb $0, $7C
	defb $F0, $E9
	defb $A0, $7C
	defb $F0, $E9
	defb $A0, $7C
	defb $F0, $E9
	defb $A0, $7C
	defb $0, $E9
._tilescpc2121

._tilescpc2121_DATA
	defb $D6, $50
	defb $5E, $7C
	defb $D6, $3C
	defb $5E, $54
	defb $D6, $14
	defb $5E, $B4
	defb $D6, $3C
	defb $5E, $50
._tilescpc2122

._tilescpc2122_DATA
	defb $0, $7C
	defb $B0, $E9
	defb $B4, $7C
	defb $B4, $E9
	defb $B4, $7C
	defb $B4, $E9
	defb $F0, $7C
	defb $0, $E9
._tilescpc2123

._tilescpc2123_DATA
	defb $D6, $50
	defb $5E, $B4
	defb $D6, $F0
	defb $5E, $14
	defb $D6, $B4
	defb $5E, $14
	defb $D6, $B4
	defb $5E, $50
; Data from file tilescpc213.bmp (8x16)... Mode 0.
._tilescpc2130

._tilescpc2130_DATA
	defb $50, $F0
	defb $B4, $3C
	defb $F0, $78
	defb $B4, $B4
	defb $F0, $3C
	defb $B4, $F0
	defb $F0, $E4
	defb $50, $88
._tilescpc2131

._tilescpc2131_DATA
	defb $10, $50
	defb $24, $74
	defb $C, $1C
	defb $10, $54
	defb $44, $14
	defb $4, $B4
	defb $C, $3C
	defb $4, $50
._tilescpc2132

._tilescpc2132_DATA
	defb $50, $8
	defb $F0, $58
	defb $F0, $70
	defb $B0, $98
	defb $E4, $4C
	defb $44, $8C
	defb $E4, $C
	defb $10, $98
._tilescpc2133

._tilescpc2133_DATA
	defb $4, $50
	defb $A4, $B4
	defb $4, $F0
	defb $E4, $14
	defb $10, $B4
	defb $CC, $58
	defb $8C, $58
	defb $CC, $8
; Data from file tilescpc214.bmp (8x16)... Mode 0.
._tilescpc2140

._tilescpc2140_DATA
	defb $F, $F
	defb $A, $50
	defb $A, $50
	defb $A, $0
	defb $A, $54
	defb $A, $5
	defb $A, $1
	defb $A, $F
._tilescpc2141

._tilescpc2141_DATA
	defb $3, $3
	defb $B4, $A1
	defb $3C, $29
	defb $3, $29
	defb $16, $29
	defb $BC, $29
	defb $3C, $29
	defb $3, $29
._tilescpc2142

._tilescpc2142_DATA
	defb $A, $50
	defb $A, $50
	defb $A, $1
	defb $A, $5
	defb $A, $F8
	defb $A, $50
	defb $A, $0
	defb $F, $F
._tilescpc2143

._tilescpc2143_DATA
	defb $16, $29
	defb $BC, $29
	defb $3C, $29
	defb $3C, $29
	defb $3C, $29
	defb $3C, $29
	defb $B4, $A1
	defb $3, $3
; Data from file tilescpc215.bmp (8x16)... Mode 0.
._tilescpc2150

._tilescpc2150_DATA
	defb $0, $0
	defb $45, $0
	defb $1, $45
	defb $0, $B
	defb $5, $8A
	defb $1, $1
	defb $45, $1
	defb $4B, $C3
._tilescpc2151

._tilescpc2151_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $A
	defb $1, $8A
	defb $45, $0
	defb $B, $A
	defb $8B, $8A
	defb $C3, $D6
._tilescpc2152

._tilescpc2152_DATA
	defb $D6, $FC
	defb $D6, $38
	defb $D6, $74
	defb $D6, $30
	defb $D6, $74
	defb $D6, $38
	defb $D6, $BC
	defb $BC, $3C
._tilescpc2153

._tilescpc2153_DATA
	defb $74, $3C
	defb $30, $BC
	defb $74, $BC
	defb $30, $BC
	defb $74, $BC
	defb $30, $BC
	defb $74, $BC
	defb $3C, $78
; Data from file tilescpc216.bmp (8x16)... Mode 0.
._tilescpc2160

._tilescpc2160_DATA
	defb $0, $0
	defb $4, $4C
	defb $4, $98
	defb $44, $30
	defb $10, $CC
	defb $10, $98
	defb $10, $30
	defb $44, $30
._tilescpc2161

._tilescpc2161_DATA
	defb $0, $0
	defb $CC, $4C
	defb $20, $0
	defb $10, $50
	defb $70, $B0
	defb $20, $30
	defb $A0, $30
	defb $10, $98
._tilescpc2162

._tilescpc2162_DATA
	defb $44, $70
	defb $44, $0
	defb $44, $A0
	defb $10, $20
	defb $50, $20
	defb $0, $30
	defb $0, $CC
	defb $10, $98
._tilescpc2163

._tilescpc2163_DATA
	defb $14, $F0
	defb $14, $78
	defb $14, $F0
	defb $14, $A0
	defb $50, $A0
	defb $78, $28
	defb $78, $78
	defb $B4, $14
; Data from file tilescpc217.bmp (8x16)... Mode 0.
._tilescpc2170

._tilescpc2170_DATA
	defb $0, $0
	defb $4C, $98
	defb $30, $70
	defb $CC, $98
	defb $30, $30
	defb $70, $30
	defb $A0, $B0
	defb $50, $10
._tilescpc2171

._tilescpc2171_DATA
	defb $0, $0
	defb $CC, $CC
	defb $0, $0
	defb $A0, $10
	defb $20, $10
	defb $A0, $44
	defb $0, $10
	defb $88, $38
._tilescpc2172

._tilescpc2172_DATA
	defb $0, $F0
	defb $0, $78
	defb $50, $F0
	defb $14, $F0
	defb $14, $78
	defb $14, $B4
	defb $F0, $78
	defb $14, $F0
._tilescpc2173

._tilescpc2173_DATA
	defb $3C, $F0
	defb $F0, $A0
	defb $F0, $A0
	defb $A0, $A0
	defb $F0, $0
	defb $F0, $A0
	defb $B4, $F0
	defb $14, $F0
; Data from file tilescpc218.bmp (8x16)... Mode 0.
._tilescpc2180

._tilescpc2180_DATA
	defb $0, $0
	defb $8C, $8C
	defb $64, $98
	defb $64, $64
	defb $98, $70
	defb $98, $A0
	defb $70, $0
	defb $A0, $0
._tilescpc2181

._tilescpc2181_DATA
	defb $0, $0
	defb $9C, $0
	defb $78, $0
	defb $F0, $0
	defb $F0, $0
	defb $A0, $0
	defb $50, $0
	defb $F0, $0
._tilescpc2182

._tilescpc2182_DATA
	defb $50, $22
	defb $11, $D0
	defb $E0, $91
	defb $62, $91
	defb $62, $D0
	defb $B1, $22
	defb $0, $A0
	defb $50, $0
._tilescpc2183

._tilescpc2183_DATA
	defb $50, $0
	defb $14, $0
	defb $50, $0
	defb $50, $0
	defb $50, $0
	defb $F0, $0
	defb $F0, $0
	defb $A0, $0
; Data from file tilescpc219.bmp (8x16)... Mode 0.
._tilescpc2190

._tilescpc2190_DATA
	defb $E4, $70
	defb $64, $A0
	defb $30, $0
	defb $70, $0
	defb $30, $0
	defb $30, $0
	defb $30, $0
	defb $64, $A0
._tilescpc2191

._tilescpc2191_DATA
	defb $B4, $A0
	defb $F0, $0
	defb $A0, $50
	defb $0, $14
	defb $0, $B4
	defb $0, $B4
	defb $50, $78
	defb $14, $F0
._tilescpc2192

._tilescpc2192_DATA
	defb $E4, $64
	defb $10, $30
	defb $10, $70
	defb $10, $30
	defb $E4, $70
	defb $64, $30
	defb $64, $98
	defb $64, $30
._tilescpc2193

._tilescpc2193_DATA
	defb $78, $50
	defb $F0, $50
	defb $0, $0
	defb $A0, $0
	defb $0, $0
	defb $A0, $0
	defb $F0, $50
	defb $A0, $A0
; Data from file tilescpc220.bmp (8x16)... Mode 0.
._tilescpc2200

._tilescpc2200_DATA
	defb $50, $A0
	defb $50, $A0
	defb $78, $50
	defb $78, $A0
	defb $F0, $50
	defb $78, $0
	defb $A0, $0
	defb $11, $A0
._tilescpc2201

._tilescpc2201_DATA
	defb $50, $F0
	defb $50, $F0
	defb $50, $A0
	defb $50, $A0
	defb $0, $A0
	defb $50, $0
	defb $0, $A0
	defb $50, $0
._tilescpc2202

._tilescpc2202_DATA
	defb $E0, $22
	defb $62, $D0
	defb $62, $91
	defb $62, $C0
	defb $E0, $C0
	defb $11, $C0
	defb $50, $91
	defb $0, $50
._tilescpc2203

._tilescpc2203_DATA
	defb $50, $A0
	defb $50, $50
	defb $0, $A0
	defb $A0, $50
	defb $A0, $B4
	defb $A0, $14
	defb $0, $0
	defb $0, $50
; Data from file tilescpc221.bmp (8x16)... Mode 0.
._tilescpc2210

._tilescpc2210_DATA
	defb $0, $50
	defb $14, $3C
	defb $B4, $B4
	defb $3C, $78
	defb $B4, $F0
	defb $0, $28
	defb $F0, $F0
	defb $F0, $F0
._tilescpc2211

._tilescpc2211_DATA
	defb $0, $0
	defb $0, $0
	defb $A0, $0
	defb $A0, $0
	defb $A0, $0
	defb $0, $0
	defb $A0, $0
	defb $0, $0
._tilescpc2212

._tilescpc2212_DATA
	defb $A0, $0
	defb $14, $3C
	defb $3C, $B4
	defb $78, $F0
	defb $B4, $F0
	defb $78, $F0
	defb $0, $0
	defb $3C, $A0
._tilescpc2213

._tilescpc2213_DATA
	defb $0, $0
	defb $0, $0
	defb $28, $0
	defb $B4, $0
	defb $F0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc222.bmp (8x16)... Mode 0.
._tilescpc2220

._tilescpc2220_DATA
	defb $30, $70
	defb $64, $A0
	defb $B0, $0
	defb $44, $0
	defb $B0, $88
	defb $30, $70
	defb $30, $30
	defb $98, $50
._tilescpc2221

._tilescpc2221_DATA
	defb $0, $0
	defb $B1, $A0
	defb $62, $91
	defb $62, $91
	defb $62, $91
	defb $62, $91
	defb $B1, $D0
	defb $0, $0
._tilescpc2222

._tilescpc2222_DATA
	defb $78, $0
	defb $3C, $A0
	defb $78, $0
	defb $F0, $A0
	defb $F0, $0
	defb $14, $B4
	defb $50, $78
	defb $0, $0
._tilescpc2223

._tilescpc2223_DATA
	defb $A0, $0
	defb $F0, $50
	defb $0, $0
	defb $0, $A0
	defb $0, $F0
	defb $28, $A0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc223.bmp (8x16)... Mode 0.
._tilescpc2230

._tilescpc2230_DATA
	defb $A0, $0
	defb $F0, $0
	defb $B4, $F0
	defb $F0, $B4
	defb $50, $F0
	defb $50, $A0
	defb $50, $0
	defb $F0, $0
._tilescpc2231

._tilescpc2231_DATA
	defb $0, $B4
	defb $0, $B4
	defb $14, $B4
	defb $3C, $50
	defb $F0, $50
	defb $A0, $A0
	defb $0, $50
	defb $0, $A0
._tilescpc2232

._tilescpc2232_DATA
	defb $F0, $A0
	defb $50, $A0
	defb $A0, $0
	defb $A0, $0
	defb $50, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2233

._tilescpc2233_DATA
	defb $50, $50
	defb $0, $14
	defb $0, $F0
	defb $0, $78
	defb $3C, $A0
	defb $50, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc224.bmp (8x16)... Mode 0.
._tilescpc2240

._tilescpc2240_DATA
	defb $78, $78
	defb $F0, $A0
	defb $F0, $A0
	defb $28, $50
	defb $F0, $0
	defb $F0, $A0
	defb $F0, $0
	defb $A0, $0
._tilescpc2241

._tilescpc2241_DATA
	defb $50, $0
	defb $F0, $A0
	defb $F0, $A0
	defb $F0, $0
	defb $A0, $A0
	defb $50, $0
	defb $0, $0
	defb $0, $0
._tilescpc2242

._tilescpc2242_DATA
	defb $A0, $3C
	defb $B4, $78
	defb $78, $F0
	defb $B4, $A0
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2243

._tilescpc2243_DATA
	defb $28, $0
	defb $F0, $0
	defb $50, $0
	defb $A0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc225.bmp (8x16)... Mode 0.
._tilescpc2250

._tilescpc2250_DATA
	defb $0, $0
	defb $64, $4C
	defb $8C, $C
	defb $CC, $4C
	defb $64, $CC
	defb $30, $30
	defb $70, $70
	defb $B0, $A0
._tilescpc2251

._tilescpc2251_DATA
	defb $0, $0
	defb $B4, $0
	defb $70, $0
	defb $98, $0
	defb $70, $0
	defb $A0, $28
	defb $14, $F0
	defb $78, $A0
._tilescpc2252

._tilescpc2252_DATA
	defb $70, $A0
	defb $B0, $F0
	defb $F0, $A0
	defb $F0, $A0
	defb $F0, $14
	defb $50, $78
	defb $0, $B4
	defb $0, $50
._tilescpc2253

._tilescpc2253_DATA
	defb $B4, $F0
	defb $50, $A0
	defb $F0, $50
	defb $0, $0
	defb $3C, $A0
	defb $78, $0
	defb $A0, $A0
	defb $F0, $0
; Data from file tilescpc226.bmp (8x16)... Mode 0.
._tilescpc2260

._tilescpc2260_DATA
	defb $78, $50
	defb $A0, $B4
	defb $0, $78
	defb $A0, $B4
	defb $50, $50
	defb $0, $A0
	defb $F0, $0
	defb $A0, $0
._tilescpc2261

._tilescpc2261_DATA
	defb $F0, $50
	defb $3C, $A0
	defb $78, $28
	defb $F0, $A0
	defb $50, $0
	defb $A0, $B4
	defb $50, $F0
	defb $B4, $50
._tilescpc2262

._tilescpc2262_DATA
	defb $F0, $0
	defb $B4, $A0
	defb $78, $78
	defb $3C, $A0
	defb $F0, $50
	defb $A0, $A0
	defb $50, $0
	defb $A0, $0
._tilescpc2263

._tilescpc2263_DATA
	defb $3C, $F0
	defb $78, $F0
	defb $B4, $A0
	defb $F0, $50
	defb $78, $A0
	defb $F0, $0
	defb $F0, $A0
	defb $14, $0
; Data from file tilescpc227.bmp (8x16)... Mode 0.
._tilescpc2270

._tilescpc2270_DATA
	defb $0, $0
	defb $B4, $50
	defb $F0, $14
	defb $F0, $50
	defb $F0, $A0
	defb $F0, $A0
	defb $0, $A0
	defb $0, $0
._tilescpc2271

._tilescpc2271_DATA
	defb $0, $0
	defb $3C, $0
	defb $3C, $A0
	defb $78, $A0
	defb $F0, $A0
	defb $B4, $28
	defb $3C, $A0
	defb $78, $A0
._tilescpc2272

._tilescpc2272_DATA
	defb $0, $0
	defb $22, $A0
	defb $D0, $22
	defb $91, $80
	defb $C0, $D0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc2273

._tilescpc2273_DATA
	defb $0, $0
	defb $0, $0
	defb $50, $50
	defb $A0, $B1
	defb $50, $62
	defb $33, $C0
	defb $C0, $C0
	defb $C0, $C0
; Data from file tilescpc228.bmp (8x16)... Mode 0.
._tilescpc2280

._tilescpc2280_DATA
	defb $0, $0
	defb $44, $3C
	defb $9C, $78
	defb $3C, $B4
	defb $78, $F0
	defb $B4, $F0
	defb $78, $F0
	defb $F0, $F0
._tilescpc2281

._tilescpc2281_DATA
	defb $50, $A0
	defb $3C, $3C
	defb $F0, $F0
	defb $A0, $0
	defb $A0, $0
	defb $0, $50
	defb $A0, $F0
	defb $0, $50
._tilescpc2282

._tilescpc2282_DATA
	defb $50, $A0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $50, $A0
	defb $F0, $0
	defb $50, $A0
	defb $50, $0
._tilescpc2283

._tilescpc2283_DATA
	defb $50, $A0
	defb $50, $50
	defb $0, $A0
	defb $0, $0
	defb $B4, $50
	defb $78, $A0
	defb $50, $A0
	defb $0, $0
; Data from file tilescpc229.bmp (8x16)... Mode 0.
._tilescpc2290

._tilescpc2290_DATA
	defb $0, $0
	defb $3C, $3C
	defb $F0, $F0
	defb $50, $F0
	defb $0, $A0
	defb $A0, $0
	defb $78, $0
	defb $3C, $A0
._tilescpc2291

._tilescpc2291_DATA
	defb $0, $0
	defb $3C, $B4
	defb $78, $F0
	defb $F0, $50
	defb $A0, $14
	defb $0, $B4
	defb $0, $78
	defb $50, $3C
._tilescpc2292

._tilescpc2292_DATA
	defb $B4, $78
	defb $F0, $F0
	defb $0, $F0
	defb $50, $0
	defb $F0, $A0
	defb $50, $F0
	defb $B4, $A0
	defb $50, $A0
._tilescpc2293

._tilescpc2293_DATA
	defb $B4, $3C
	defb $50, $78
	defb $0, $A0
	defb $50, $F0
	defb $0, $A0
	defb $0, $F0
	defb $0, $50
	defb $0, $0
; Data from file tilescpc230.bmp (8x16)... Mode 0.
._tilescpc2300

._tilescpc2300_DATA
	defb $0, $0
	defb $3C, $3C
	defb $F0, $F0
	defb $0, $50
	defb $3C, $0
	defb $B4, $28
	defb $78, $28
	defb $F0, $A0
._tilescpc2301

._tilescpc2301_DATA
	defb $0, $0
	defb $78, $0
	defb $A0, $0
	defb $0, $0
	defb $0, $0
	defb $14, $0
	defb $78, $A0
	defb $F0, $0
._tilescpc2302

._tilescpc2302_DATA
	defb $78, $A0
	defb $F0, $0
	defb $A0, $0
	defb $0, $0
	defb $A0, $14
	defb $50, $14
	defb $A0, $0
	defb $0, $0
._tilescpc2303

._tilescpc2303_DATA
	defb $78, $A0
	defb $F0, $0
	defb $50, $A0
	defb $28, $0
	defb $F0, $0
	defb $A0, $A0
	defb $F0, $0
	defb $0, $0
; Data from file tilescpc231.bmp (8x16)... Mode 0.
._tilescpc2310

._tilescpc2310_DATA
	defb $0, $0
	defb $B0, $CC
	defb $64, $64
	defb $8C, $98
	defb $64, $64
	defb $98, $30
	defb $64, $70
	defb $98, $A0
._tilescpc2311

._tilescpc2311_DATA
	defb $0, $0
	defb $CC, $A0
	defb $30, $A0
	defb $A0, $0
	defb $70, $20
	defb $B0, $A0
	defb $50, $20
	defb $B0, $20
._tilescpc2312

._tilescpc2312_DATA
	defb $30, $70
	defb $30, $A0
	defb $B0, $70
	defb $30, $A0
	defb $B0, $44
	defb $50, $30
	defb $0, $F0
	defb $0, $0
._tilescpc2313

._tilescpc2313_DATA
	defb $50, $A0
	defb $0, $A0
	defb $0, $0
	defb $10, $0
	defb $70, $A0
	defb $F0, $0
	defb $A0, $0
	defb $0, $0
; Data from file tilescpc232.bmp (8x16)... Mode 0.
._tilescpc2320

._tilescpc2320_DATA
	defb $0, $0
	defb $A4, $80
	defb $62, $91
	defb $94, $62
	defb $91, $62
	defb $62, $91
	defb $40, $72
	defb $0, $0
._tilescpc2321

._tilescpc2321_DATA
	defb $0, $0
	defb $A4, $80
	defb $62, $91
	defb $94, $62
	defb $91, $62
	defb $62, $91
	defb $40, $72
	defb $0, $0
._tilescpc2322

._tilescpc2322_DATA
	defb $15, $3A
	defb $3F, $3F
	defb $9F, $E7
	defb $7B, $E5
	defb $F2, $F0
	defb $2A, $E5
	defb $3F, $15
	defb $3F, $3F
._tilescpc2323

._tilescpc2323_DATA
	defb $15, $3A
	defb $3F, $3F
	defb $CF, $CF
	defb $CF, $CF
	defb $F0, $E7
	defb $CF, $CF
	defb $6F, $6F
	defb $3F, $9F
; Data from file tilescpc233.bmp (8x16)... Mode 0.
._tilescpc2330

._tilescpc2330_DATA
	defb $0, $0
	defb $E5, $2
	defb $A3, $53
	defb $43, $A3
	defb $53, $A3
	defb $A3, $53
	defb $1, $F2
	defb $0, $0
._tilescpc2331

._tilescpc2331_DATA
	defb $0, $0
	defb $E5, $2
	defb $A3, $53
	defb $43, $A3
	defb $53, $A3
	defb $A3, $53
	defb $1, $F2
	defb $0, $0
._tilescpc2332

._tilescpc2332_DATA
	defb $15, $3A
	defb $3F, $3F
	defb $CF, $CF
	defb $CF, $CF
	defb $DB, $F0
	defb $CF, $CF
	defb $9F, $9F
	defb $3F, $3F
._tilescpc2333

._tilescpc2333_DATA
	defb $15, $3A
	defb $3F, $3F
	defb $DB, $6F
	defb $DA, $B7
	defb $F0, $F1
	defb $DA, $15
	defb $2A, $3F
	defb $3F, $9F
; Data from file tilescpc234.bmp (8x16)... Mode 0.
._tilescpc2340

._tilescpc2340_DATA
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $89, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
	defb $C0, $C0
._tilescpc2341

._tilescpc2341_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2342

._tilescpc2342_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2343

._tilescpc2343_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc235.bmp (8x16)... Mode 0.
._tilescpc2350

._tilescpc2350_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2351

._tilescpc2351_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2352

._tilescpc2352_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2353

._tilescpc2353_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc236.bmp (8x16)... Mode 0.
._tilescpc2360

._tilescpc2360_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2361

._tilescpc2361_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2362

._tilescpc2362_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tilescpc2363

._tilescpc2363_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
; Data from file tilescpc237.bmp (8x16)... Mode 0.
._tilescpc2370

._tilescpc2370_DATA
	defb $3F, $8B
	defb $50, $CF
	defb $0, $1
	defb $50, $8B
	defb $E5, $CF
	defb $8F, $CF
	defb $CF, $E5
	defb $CF, $DA
._tilescpc2371

._tilescpc2371_DATA
	defb $53, $A2
	defb $52, $0
	defb $0, $0
	defb $F2, $0
	defb $53, $A0
	defb $8B, $A2
	defb $3, $52
	defb $A3, $F2
._tilescpc2372

._tilescpc2372_DATA
	defb $47, $2
	defb $3, $2
	defb $53, $2
	defb $A3, $F2
	defb $F1, $51
	defb $1, $3
	defb $50, $53
	defb $0, $F3
._tilescpc2373

._tilescpc2373_DATA
	defb $F1, $F2
	defb $3, $F2
	defb $53, $A2
	defb $A3, $A2
	defb $53, $A0
	defb $F3, $0
	defb $52, $0
	defb $A2, $0
; Data from file tilescpc238.bmp (8x16)... Mode 0.
._tilescpc2380

._tilescpc2380_DATA
	defb $0, $0
	defb $44, $64
	defb $10, $B0
	defb $4C, $CC
	defb $CC, $C8
	defb $30, $31
	defb $50, $F0
	defb $11, $31
._tilescpc2381

._tilescpc2381_DATA
	defb $0, $0
	defb $91, $A0
	defb $72, $A0
	defb $C0, $72
	defb $C8, $F0
	defb $31, $72
	defb $F0, $A0
	defb $72, $22
._tilescpc2382

._tilescpc2382_DATA
	defb $10, $32
	defb $11, $B1
	defb $50, $50
	defb $CC, $C8
	defb $CC, $C4
	defb $30, $32
	defb $50, $F0
	defb $11, $11
._tilescpc2383

._tilescpc2383_DATA
	defb $33, $A0
	defb $72, $22
	defb $A0, $A0
	defb $C0, $72
	defb $C0, $F0
	defb $33, $72
	defb $F0, $A0
	defb $22, $A0
; Data from file tilescpc239.bmp (8x16)... Mode 0.
._tilescpc2390

._tilescpc2390_DATA
	defb $0, $0
	defb $11, $33
	defb $62, $62
	defb $11, $91
	defb $62, $62
	defb $11, $C0
	defb $33, $62
	defb $11, $91
._tilescpc2391

._tilescpc2391_DATA
	defb $0, $0
	defb $C0, $6F
	defb $95, $CF
	defb $C0, $6F
	defb $95, $95
	defb $C0, $6F
	defb $C0, $95
	defb $C0, $3F
._tilescpc2392

._tilescpc2392_DATA
	defb $0, $0
	defb $C0, $6F
	defb $95, $CF
	defb $C0, $6F
	defb $95, $95
	defb $C0, $6F
	defb $C0, $95
	defb $C0, $3F
._tilescpc2393

._tilescpc2393_DATA
	defb $0, $0
	defb $11, $33
	defb $62, $62
	defb $11, $91
	defb $62, $62
	defb $11, $C0
	defb $33, $62
	defb $11, $91
; Data from file tilescpc240.bmp (8x16)... Mode 0.
._tilescpc2400

._tilescpc2400_DATA
	defb $0, $0
	defb $54, $F
	defb $A5, $F
	defb $E1, $C3
	defb $A5, $C3
	defb $E1, $D2
	defb $A5, $A0
	defb $E1, $82
._tilescpc2401

._tilescpc2401_DATA
	defb $0, $0
	defb $4B, $A8
	defb $D6, $78
	defb $C3, $A8
	defb $D6, $F0
	defb $41, $A8
	defb $54, $F0
	defb $41, $A8
._tilescpc2402

._tilescpc2402_DATA
	defb $A5, $A0
	defb $E1, $D2
	defb $F4, $E9
	defb $E1, $FC
	defb $F4, $FC
	defb $F4, $A0
	defb $F0, $0
	defb $A0, $0
._tilescpc2403

._tilescpc2403_DATA
	defb $54, $F0
	defb $14, $28
	defb $C3, $A0
	defb $3C, $28
	defb $3C, $A0
	defb $0, $50
	defb $0, $0
	defb $0, $0
; Data from file tilescpc241.bmp (8x16)... Mode 0.
._tilescpc2410

._tilescpc2410_DATA
	defb $F, $F
	defb $F, $F
	defb $4B, $C3
	defb $4B, $69
	defb $4B, $E9
	defb $1E, $E9
	defb $5E, $C3
	defb $4B, $C3
._tilescpc2411

._tilescpc2411_DATA
	defb $4B, $4B
	defb $C3, $D6
	defb $FC, $F8
	defb $D6, $28
	defb $BC, $A8
	defb $D6, $28
	defb $FC, $A8
	defb $D6, $28
._tilescpc2412

._tilescpc2412_DATA
	defb $D6, $D6
	defb $4B, $7C
	defb $D6, $BC
	defb $5E, $FC
	defb $D6, $FC
	defb $D6, $FC
	defb $D2, $0
	defb $A8, $0
._tilescpc2413

._tilescpc2413_DATA
	defb $BC, $A8
	defb $7C, $A0
	defb $BC, $28
	defb $7C, $A0
	defb $BC, $28
	defb $3C, $A0
	defb $0, $50
	defb $0, $50
; Data from file tilescpc242.bmp (8x16)... Mode 0.
._tilescpc2420

._tilescpc2420_DATA
	defb $40, $A5
	defb $4F, $C5
	defb $9F, $2F
	defb $3F, $A0
	defb $3F, $72
	defb $95, $91
	defb $62, $3F
	defb $11, $33
._tilescpc2421

._tilescpc2421_DATA
	defb $DA, $22
	defb $9B, $6A
	defb $9F, $3F
	defb $50, $6A
	defb $B1, $3F
	defb $62, $6A
	defb $3F, $91
	defb $33, $22
._tilescpc2422

._tilescpc2422_DATA
	defb $5, $CF
	defb $45, $9F
	defb $5, $CF
	defb $45, $9F
	defb $40, $33
	defb $4F, $CF
	defb $CF, $9F
	defb $33, $33
._tilescpc2423

._tilescpc2423_DATA
	defb $CF, $2A
	defb $9F, $80
	defb $6F, $2A
	defb $3F, $80
	defb $33, $22
	defb $6F, $6A
	defb $9F, $91
	defb $33, $33
; Data from file tilescpc243.bmp (8x16)... Mode 0.
._tilescpc2430

._tilescpc2430_DATA
	defb $50, $67
	defb $45, $9F
	defb $5, $DA
	defb $45, $7A
	defb $5, $CF
	defb $45, $9F
	defb $15, $3B
	defb $50, $72
._tilescpc2431

._tilescpc2431_DATA
	defb $9B, $A0
	defb $6F, $80
	defb $E5, $2A
	defb $B5, $80
	defb $CF, $2A
	defb $3F, $80
	defb $62, $80
	defb $B1, $A0
._tilescpc2432

._tilescpc2432_DATA
	defb $CF, $CF
	defb $6F, $CF
	defb $11, $33
	defb $15, $3F
	defb $45, $CF
	defb $45, $CF
	defb $5, $CF
	defb $45, $9B
._tilescpc2433

._tilescpc2433_DATA
	defb $CF, $CF
	defb $CF, $9F
	defb $33, $22
	defb $3F, $2A
	defb $9F, $80
	defb $6F, $2A
	defb $9F, $80
	defb $62, $2A
; Data from file tilescpc244.bmp (8x16)... Mode 0.
._tilescpc2440

._tilescpc2440_DATA
	defb $0, $0
	defb $3, $3
	defb $F3, $F3
	defb $F0, $F0
	defb $3C, $3C
	defb $79, $B6
	defb $B4, $78
	defb $50, $A0
._tilescpc2441

._tilescpc2441_DATA
	defb $0, $0
	defb $3, $3
	defb $F3, $F3
	defb $F0, $F0
	defb $3C, $3C
	defb $79, $B6
	defb $B4, $78
	defb $50, $A0
._tilescpc2442

._tilescpc2442_DATA
	defb $0, $0
	defb $B4, $A2
	defb $0, $0
	defb $B4, $A2
	defb $0, $0
	defb $3, $53
	defb $F1, $F2
	defb $50, $A0
._tilescpc2443

._tilescpc2443_DATA
	defb $0, $0
	defb $B4, $A2
	defb $0, $0
	defb $B4, $A2
	defb $0, $0
	defb $3, $3
	defb $F1, $F2
	defb $50, $A0
; Data from file tilescpc245.bmp (8x16)... Mode 0.
._tilescpc2450

._tilescpc2450_DATA
	defb $41, $C3
	defb $87, $F
	defb $5E, $4B
	defb $87, $F
	defb $F, $4B
	defb $87, $F
	defb $F, $4B
	defb $87, $87
._tilescpc2451

._tilescpc2451_DATA
	defb $E9, $A8
	defb $C3, $D6
	defb $4B, $7C
	defb $C3, $D6
	defb $4B, $D6
	defb $C3, $D6
	defb $4B, $D6
	defb $C3, $D6
._tilescpc2452

._tilescpc2452_DATA
	defb $E9, $4B
	defb $C3, $C3
	defb $E9, $C3
	defb $69, $C3
	defb $E9, $C3
	defb $3C, $D6
	defb $E9, $E9
	defb $14, $3C
._tilescpc2453

._tilescpc2453_DATA
	defb $C3, $96
	defb $C3, $D6
	defb $C3, $96
	defb $D6, $D6
	defb $E9, $BC
	defb $D6, $F4
	defb $E9, $BC
	defb $3C, $28
; Data from file tilescpc246.bmp (8x16)... Mode 0.
._tilescpc2460

._tilescpc2460_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $50
	defb $0, $10
	defb $0, $E4
	defb $0, $64
	defb $70, $CC
	defb $F0, $64
._tilescpc2461

._tilescpc2461_DATA
	defb $0, $0
	defb $E4, $CC
	defb $8C, $CC
	defb $CC, $CC
	defb $CC, $CC
	defb $CC, $CC
	defb $C8, $4C
	defb $C4, $4E
._tilescpc2462

._tilescpc2462_DATA
	defb $50, $CC
	defb $70, $64
	defb $0, $64
	defb $0, $E4
	defb $0, $10
	defb $0, $D8
	defb $0, $20
	defb $0, $A0
._tilescpc2463

._tilescpc2463_DATA
	defb $CC, $4E
	defb $85, $48
	defb $C8, $C0
	defb $C0, $C0
	defb $C0, $62
	defb $C0, $91
	defb $E0, $C0
	defb $0, $F0
._tilescpc2470

._tilescpc2470_DATA
	defb $0, $0
	defb $CC, $D0
	defb $C8, $C0
	defb $CC, $C0
	defb $C8, $91
	defb $C4, $C0
	defb $84, $1B
	defb $8D, $C8
._tilescpc2471

._tilescpc2471_DATA
	defb $0, $0
	defb $0, $0
	defb $A0, $0
	defb $22, $0
	defb $D0, $0
	defb $33, $0
	defb $91, $B1
	defb $33, $F0
._tilescpc2472

._tilescpc2472_DATA
	defb $8D, $99
	defb $84, $1B
	defb $C0, $33
	defb $91, $62
	defb $62, $33
	defb $91, $62
	defb $C0, $D0
	defb $F0, $0
._tilescpc2473

._tilescpc2473_DATA
	defb $91, $A0
	defb $33, $B1
	defb $91, $0
	defb $72, $0
	defb $22, $0
	defb $B1, $0
	defb $10, $0
	defb $50, $0
	