; --------------------------------------------------------------------------- 
; Pac-Man Loader (c) SyX 2011
; --------------------------------------------------------------------------- 

    include 'hardware.i'
    include 'firmware.i'
    include 'constantes.i'
    include 'macros.i'
    include 'macros_pacman.i'

; --------------------------------------------------------------------------- 
inicio
    ; Save number of disk drive used to load the program
    LD   HL,(AMSDOS_RESERVED_AREA)
    LD   A,(HL)
    LD   (.sm_floppy_drive + 1),A
    
    LD   C,$FF                  ; Disable roms
    LD   HL,.real_start         ; Real program start address
    CALL MC_START_PROGRAM       ; Run program

.real_start
    CALL TXT_VDU_DISABLE        ; Hide initialize roms messages
    CALL KL_ROM_WALK            ; Initialize all the roms (not everybody has Parados in 7)
    CALL TXT_VDU_ENABLE         ; Unhide firmware messages
   
    ; When Amsdos is initialized, the default disk drive is 0. Because that
    ; we need to restore the number of the drive used to load the program.
.sm_floppy_drive
    LD   A,0
    LD   HL,(AMSDOS_RESERVED_AREA)
    LD   (HL),A

    ; Test if the CPC has at least 64 KBs of expansion RAM and let you use the special paging modes.
    CALL test_ram
    
    ; Show loading screen
    CALL set_loading_screen

    ; Load the Pac-Man arcade roms in the page 4 (0*)
    CALL load_pacman_roms

    ; Take System Before Decrunch!!! AF' is corrupted during decrunch :P
    DI

    ; Decrunch the CPC code in the page 6 (*2)
    SET_PAGE $C6
    LD   HL,cpc_code
    CALL decrunch_file

    ; Decrunch the CPC sprites in the page 7 (3*)
    SET_PAGE $C7
    LD   HL,cpc_sprites
    CALL decrunch_file

    ; Clear buffers used for saving background (sprites)
    LD   HL,SPRITE1_SAVE1 - $8000
    LD   DE,SPRITE1_SAVE1 - $8000 + 1
    LD   BC,SPRITE6_SAVE2 + 5 * 14 + 3 - SPRITE1_SAVE1 - 1
    LD   (HL),0
    LDIR
    
    ; Decrunch the CPC menu code in the second half of page 3
    SET_PAGE $C0
    LD   HL,cpc_menu
    LD   DE,$E000
    CALL decrunch

    ; Set stack
    LD   SP,$C000

    ; Copy the initialize code
    LD   HL,codigo_inicializacion
    LD   DE,$C000
    LD   BC,fin_codigo_inicializacion - codigo_inicializacion
    LDIR
    
    ; And launch it!!!
    JP   $C000
    
; ---------------------------------------------------------------------------
; Load Pac-Man roms
; ---------------------------------------------------------------------------
load_pacman_roms
    SET_PAGE $C4

    ; Load PACMAN.6E
    LD   A,'E'          ; Rom suffix
    LD   HL,$4000       ; Load address
    CALL load_rom_file

    ; Load PACMAN.6F
    LD   A,'F'
    LD   HL,$5000
    CALL load_rom_file

    ; Load PACMAN.6H
    LD   A,'H'
    LD   HL,$6000
    CALL load_rom_file

    ; Load PACMAN.6J
    LD   A,'J'
    LD   HL,$7000

; ---------------------------------------------------------------------------
; Load file using the firmware
; ---------------------------------------------------------------------------
load_rom_file
    LD   (fin_nombre_rom - 1),A
    LD   (.sm_load_address + 1),HL
    LD   HL,nombre_rom                  ; Filename address
    LD   B,fin_nombre_rom - nombre_rom  ; Length filename
    CALL CAS_IN_OPEN                    ; Open file
    JP   NC,rom_error                   ; File wasn't found (NC & Z)
.sm_load_address
    LD   HL,$4000                       ; HL = Loading address
    CALL CAS_IN_DIRECT                  ; Read file
    JP   CAS_IN_CLOSE                   ; Close file

nombre_rom
    DEFB 'PACMAN.6E'
fin_nombre_rom

; ---------------------------------------------------------------------------
; Decrunch and show loading screen
; ---------------------------------------------------------------------------
set_loading_screen
    ; Set mode 1 for the loading screen mode
    LD   A,1
    CALL SCR_SET_MODE

    ; Set black border
    LD   BC,0
    CALL SCR_SET_BORDER

    ; Set black palette
    CALL apagon

    ; Set screen dimensions
    CALL set_screen_dimensions

    ; Decrunch it
    LD   HL,loading_screen
    DI
    EX   AF,AF'
    PUSH AF
    CALL decrunch_file
    POP  AF
    EX   AF,AF'
    EI

    ; Set VRAM in $4000
    LD   A,$40
    CALL SCR_SET_BASE

    ; Mini fade
    LD   HL,paleta_pantalla_carga_01
    CALL set_palette_firmware

    ; Wait 3 frames + 2 frames for changing firmware palette
    LD   B,5-2
.loop_wait_frame
    HALT
    CALL MC_WAIT_FLYBACK
    DJNZ .loop_wait_frame

    ; Set loading screen palette
    LD   HL,paleta_pantalla_carga_02
    JP   set_palette_firmware

; ---------------------------------------------------------------------------
; Set loading screen dimensions and center it
; ---------------------------------------------------------------------------
set_screen_dimensions
    CALL MC_WAIT_FLYBACK
    LD   HL,.crtc_screen_datas
    LD   A,(.end_crtc_screen_datas - .crtc_screen_datas) / 2
    LD   BC,(>CRTC_SELECT + 1) * 256 + (>CRTC_WRITE + 1)
.loop_set_screen_dimensions
    OUTI                        ; CRTC Register
    LD   B,C
    OUTI                        ; Value
    DEC  A
    JR   NZ,.loop_set_screen_dimensions
    RET

.crtc_screen_datas
    DEFB REG_01,WIDTH_CRTC
    DEFB REG_06,HEIGHT_CRTC
    DEFB REG_02,HORIZONTAL_OFFSET
    DEFB REG_07,VERTICAL_OFFSET_PAL
    DEFB REG_04,VERTICAL_TOTAL_PAL
    DEFB REG_05,VERTICAL_ADJUST_PAL
.end_crtc_screen_datas

; ---------------------------------------------------------------------------
; Set palette using the firmware
; Entry:
;    HL: Pointer to the palette
; ---------------------------------------------------------------------------
set_palette_firmware
    XOR  A
.loop_set_palette_firmware
    PUSH HL
    PUSH AF
    LD   B,(HL)
    LD   C,B
    CALL SCR_SET_INK
    POP  AF
    POP  HL
    INC  HL
    INC  A
    CP   4
    JR   NZ,.loop_set_palette_firmware

    ; Wait 2 frames for the ink flashing
    HALT
    CALL MC_WAIT_FLYBACK
    HALT
    CALL MC_WAIT_FLYBACK
    RET

; ---------------------------------------------------------------------------
; Set black palette using the firmware
; ---------------------------------------------------------------------------
apagon
    LD   HL,paleta_de_negro
    CALL set_palette_firmware
    RET
    
; ---------------------------------------------------------------------------
; Palettes
paleta_de_negro
    DEFS 4,fNEGRO
fin_paleta_de_negro

paleta_pantalla_carga_01
    DEFB fNEGRO,fAMARILLO,fROJO,fBLANCO
fin_paleta_pantalla_carga_01

paleta_pantalla_carga_02
    DEFB fNEGRO,fAMARILLO_BRILLANTE,fROJO_BRILLANTE,fBLANCO_BRILLANTE
fin_paleta_pantalla_carga_02

; ---------------------------------------------------------------------------
; Decrunch files
; ---------------------------------------------------------------------------
decrunch_file
    LD   DE,$4000
decrunch
    include 'aplib_cpc.s'

; ---------------------------------------------------------------------------
codigo_inicializacion
    incbin 'codigo_inicializacion.bin'
fin_codigo_inicializacion

; --------------------------------------------------------------------------- 
; Test if the CPC support the special ram modes needed ($C1 & $C3)
; --------------------------------------------------------------------------- 
test_ram
    ; Disable Upper rom
    CALL KL_U_ROM_DISABLE

    ; Set normal RAM config
    SET_PAGE $C0
    
    ; Mark pages 1 and 3
    LD   HL,$7FFE
    LD   (HL),'S'
    INC  L
    LD   (HL),'1'
    LD   HL,$FFFE
    LD   (HL),'S'
    INC  L
    LD   (HL),'2'
    
    ; Set config for update VRAM1
    SET_PAGE UPDATE_VRAM1
    
    ; Test if the machine support this config (page 1 is 1)
    LD   HL,$7FFE
    LD   A,'S'
    CP   (HL)
    JR   NZ,ram_error
    INC  L
    LD   A,'1'
    CP   (HL)
    JR   NZ,ram_error

    ; Page 7 is not 3
    LD   HL,$FFFE
    LD   A,'S'
    CP   (HL)
    JR   NZ,.mark_page_7
    INC  L
    LD   A,'2'
    CP   (HL)
    JR   Z,ram_error
    DEC  L
.mark_page_7
    LD   (HL),'P'
    INC  L
    LD   (HL),'7'

    ; Set config for update VRAM2
    SET_PAGE UPDATE_VRAM2
    
    ; Test if the machine support this config, too (page 3 is not 1)
    LD   HL,$7FFE
    LD   A,'S'
    CP   (HL)
    JR   NZ,ram_error
    INC  L
    LD   A,'2'
    CP   (HL)
    JR   NZ,ram_error

    ; (page 7 is not 3)
    LD   HL,$FFFE
    LD   A,'P'
    CP   (HL)
    JR   NZ,ram_error
    INC  L
    LD   A,'7'
    CP   (HL)
    JR   NZ,ram_error

    ; Set normal RAM config
    SET_PAGE $C0

    ; Delete RAM Marks
    LD  HL,$0000
    LD  ($7FFE),HL
    LD  ($FFFE),HL
    
    RET

; --------------------------------------------------------------------------- 
; Show guru meditation
; --------------------------------------------------------------------------- 
rom_error
    LD   HL,guru_colours
    JR   print_error

ram_error
    LD   HL,texto_guru_ram
print_error
    LD   A,(HL)
.loop_print_text
    CALL TXT_OUTPUT
    INC  HL
    LD   A,(HL)
    CP   $FF
    JR   NZ,.loop_print_text

.infinite_loop
    JR   .infinite_loop

texto_guru_ram
    DEFB $1C,$00,fNEGRO,fNEGRO          ; INK 0,0,0
    DEFB $1C,$01,fNEGRO,fNEGRO          ; INK 1,0,0
    DEFB $1D,fNEGRO,fNEGRO              ; BORDER 0,0
    DEFB $04,$01                        ; MODE 1
    DEFB $0F,$01
    DEFB $1F,12,$0A,$87
    DEFS 15,$83
    DEFB $8B
    DEFB $1F,12,$0B,$85,"  SORRY, BUT   ",$8A
sm_error_text
    DEFB $1F,12,$0C,$85," PAC-MAN NEEDS ",$8A
    DEFB $1F,12,$0D,$85,"   A 6128 OR   ",$8A
    DEFB $1F,12,$0E,$85,"  A COMPATIBLE ",$8A
    DEFB $1F,12,$0F,$85," RAM EXPANSION ",$8A
    DEFB $1F,12,$10,$8D
    DEFS 15,$8C
    DEFB $8E
guru_colours
    DEFB $1C,$00,fROJO_BRILLANTE,fROJO  ; INK 0,6,3
    DEFB $1C,$01,fROJO,fROJO_BRILLANTE  ; INK 1,3,6
    DEFB $1D,fROJO_BRILLANTE,fROJO      ; BORDER 6,3
    DEFB $FF

; --------------------------------------------------------------------------- 
; Include files for idjits can rest in peace :P
cpc_menu
    incbin 'menu.apk'

cpc_sprites
    incbin 'recursos/cpc_sprites.apk'

cpc_code
    incbin 'code.apk'

loading_screen
    incbin 'recursos/loading_screen.apk'

; --------------------------------------------------------------------------- 
    END
