; --------------------------------------------------------------------------- 
; Pac-Man CPC Sprite Code - Save Backgrounds (c) SyX 2012
; --------------------------------------------------------------------------- 

; --------------------------------------------------------------------------- 
; Save the background screen behind locations we're about to draw active sprites
; --------------------------------------------------------------------------- 
do_save
    SET_VRAM_PAGE           ; Put the VRAM page in $4000 (BC, IXH)

    BIT  1,C
    JR   NZ,.save_second_buffer
.save_first_buffer    
    LD   HL,(SPRITE6_XPOS)
    LD   DE,SPRITE6_SAVE1
    LD   BC,(SPRITE6_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE5_XPOS)
    LD   DE,SPRITE5_SAVE1
    LD   BC,(SPRITE5_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE4_XPOS)
    LD   DE,SPRITE4_SAVE1
    LD   BC,(SPRITE4_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE3_XPOS)
    LD   DE,SPRITE3_SAVE1
    LD   BC,(SPRITE3_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE2_XPOS)
    INC  L                  ; Offset 1 pixel left the Sprite
    LD   DE,SPRITE2_SAVE1
    LD   BC,(SPRITE2_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE1_XPOS)
    INC  L                  ; Offset 1 pixel left the Sprite
    LD   DE,SPRITE1_SAVE1
    LD   BC,(SPRITE1_ATRB)
    CALL save_sprite

    JR   .end_do_save

.save_second_buffer    
    LD   HL,(SPRITE6_XPOS)
    LD   DE,SPRITE6_SAVE2
    LD   BC,(SPRITE6_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE5_XPOS)
    LD   DE,SPRITE5_SAVE2
    LD   BC,(SPRITE5_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE4_XPOS)
    LD   DE,SPRITE4_SAVE2
    LD   BC,(SPRITE4_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE3_XPOS)
    LD   DE,SPRITE3_SAVE2
    LD   BC,(SPRITE3_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE2_XPOS)
    INC  L                  ; Offset 1 pixel left the Sprite
    LD   DE,SPRITE2_SAVE2
    LD   BC,(SPRITE2_ATRB)
    CALL save_sprite

    LD   HL,(SPRITE1_XPOS)
    INC  L                  ; Offset 1 pixel left the Sprite
    LD   DE,SPRITE1_SAVE2
    LD   BC,(SPRITE1_ATRB)
    CALL save_sprite

.end_do_save
    SET_PAGE RUN_CODE

    RET

; --------------------------------------------------------------------------- 
; Save a single sprite-sized block, if visible
; Entry:
;     HL: Coord Y, X in pixels
;     DE: Save Background Address
;     B : Palette
;     C : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
; --------------------------------------------------------------------------- 
save_sprite
    LD   A,H
    CP   MIN_SPR_Y
    RET  C                  ; Off bottom of screen

    LD   A,L
    CP   MIN_SPR_X          ; Save trim right
    RET  C                  ; Off right of screen
    
    CP   MAX_SPR_X          ; Save trim left
    RET  NC                 ; Off left of screen
    
    ; Convert the arcade coords
    NEG                     ; Make the 2-complement of CX
    LD   L,A

    LD   A,H
    NEG                     ; Make the 2-complement of CY
    INC  A                  ; Shift sprites one pixel down
    LD   H,A

    ; Map an arcade tile number to our tile number, allowing for attribute differences
    ; and any tiles we've mapped to different locations (we have no fruit tiles)
    LD   A,B
    EX   AF,AF'             ; Save palette of sprite (only for the ghosts)
    LD   A,C
    AND  %11111100
    RRCA                    ; Sprite pattern number * 2
    LD   IXL,C              ; Save Flips
   
    LD   B,>arcade2cpc_save_sprites
    ADD  A,<arcade2cpc_save_sprites
    JR   NC,.espero_no_estar_en_mitad_pagina_01    ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina_01
    LD   C,A
    LD   A,(BC)
    LD   IYL,A
    INC  BC                                     ; *** REVISAR *** INC C
    LD   A,(BC)
    LD   IYH,A
    LD   B,IXL              ; Restore Flips

    JP   (IY)               ; Jump to the print routine

; ---------------------------------------------------------------------------
; Conversion table from Arcade sprite numbers to CPC (for saving backgrounds)
; ---------------------------------------------------------------------------
arcade2cpc_save_sprites
    ; Fruits
    DEFW save_fruit_spr_00,save_fruit_spr_01,save_fruit_spr_02,save_fruit_spr_03
    DEFW save_fruit_spr_04,save_fruit_spr_05,save_fruit_spr_06,save_fruit_spr_07
    
    ; Intermission Ghost
    DEFW save_ighost_spr_08,save_ighost_spr_09,save_ighost_spr_10,save_ighost_spr_11
    DEFW save_ighost_spr_12,save_ighost_spr_13,save_blank_spr,save_blank_spr

    ; Big Pac-Man
    DEFW save_blank_spr,save_bigpac_spr,save_blank_spr,save_blank_spr   ; 0, 1*, 4, 5
    DEFW save_blank_spr,save_bigpac_spr,save_blank_spr,save_blank_spr   ; 0, 2*, 4, 6
    DEFW save_blank_spr,save_bigpac_spr,save_blank_spr,save_blank_spr   ; 0, 3*, 4, 7

    ; Scare Ghost
    DEFW save_sghost_spr_28,save_sghost_spr_29,save_blank_spr,save_blank_spr
    
    ; Ghost
    DEFW save_ghost_spr_32,save_ghost_spr_33,save_ghost_spr_34,save_ghost_spr_35
    DEFW save_ghost_spr_36,save_ghost_spr_37,save_ghost_spr_38,save_ghost_spr_39

    ; Score
    DEFW save_score_spr_40,save_score_spr_41,save_score_spr_42,save_score_spr_43
    
    ; Pac-Man
    DEFW save_pacman_spr_44,save_pacman_spr_45,save_pacman_spr_46,save_pacman_spr_47
    
    ; Pac-Man Ball, Explosion (blank) and Ghost bitten
    DEFW save_pacman_spr_48,save_blank_spr,save_eghost_spr_50,save_eghost_spr_51
    
    ; Pac-Man Death
    DEFW save_pacdeath_spr_52,save_pacdeath_spr_53,save_pacdeath_spr_54,save_pacdeath_spr_55
    DEFW save_pacdeath_spr_56,save_pacdeath_spr_57,save_pacdeath_spr_58,save_pacdeath_spr_59
    DEFW save_pacdeath_spr_60,save_pacdeath_spr_61,save_pacdeath_spr_62,save_blank_spr

; --------------------------------------------------------------------------- 
; Entry:
;     HL : Coord Y, X in pixels
;     DE : Save Background Address
;     B  : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
;     A' : Palette
; Exit:
;     HL : Coord Y, X in pixels (Y offset added)
;     DE : Save Background Address
;     A' : %00hhhhxx (h = Sprite Height | x = preshift frame 0 - 3
; --------------------------------------------------------------------------- 

; Tiles 8-13
save_ighost_spr_08
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_HEIGHT << 2  ; (Height << 2) | (CX & %00000011)
    EX   AF,AF'             ; %00hhhhxx
    JP   fast_save_sprite

save_ighost_spr_09
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

save_ighost_spr_10
    ; CY + 4
    INC  H
    INC  H
    INC  H
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   IGHOST_BLUE_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

save_ighost_spr_11
    ; CY + 4
    INC  H
    INC  H
    INC  H
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   IGHOST_BLUE_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

save_ighost_spr_12
    ; CY + 11
    LD   A,H
    ADD  11                 ; Offset Y
    LD   H,A
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   IGHOST_RED12_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

save_ighost_spr_13
    ; CY + 12
    LD   A,H
    ADD  12                 ; Offset Y
    LD   H,A
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   IGHOST_RED13_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

; Tiles  14, 15, 30, 31, 63
save_blank_spr
   RET

; --------------------------------------------------------------------------- 
; Entry:
;     HL : Coord Y, X in pixels
;     DE : Save Background Address
;     B  : %ttttttxy (t = Sprite Tile Number | x = Flip X | y = Flip Y)
;     A' : Palette
; Exit:
;     HL : Coord Y, X in pixels (Y offset added)
;     DE : Save Background Address
;     A' : %00hhhhxx (h = Sprite Height | x = preshift frame 0 - 3
; --------------------------------------------------------------------------- 
; Tiles 16 - 27 (only consider up-right tiles 17, 21 and 25)
save_bigpac_spr
    ; Update X Coord
    LD   A,L
    CP   32                 ; Right
    RET  C

    CP   224                ; Left
    RET  NC
    SUB  16
    LD   L,A

    ; Get sprite height and preshift frame
    AND  %00000011 
    OR   BIGPAC_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

; Tiles 28 - 29
save_sghost_spr_28
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h14
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h14
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_sghost_spr_29
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h14
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h14
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

; Tiles 32 - 39
save_ghost_spr_32
save_ghost_spr_33
save_ghost_spr_36
save_ghost_spr_37
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
;    EX   AF,AF'
    LD   A,L
    AND  %00000011
    OR   GHOST_HEIGHT << 2      ; Sprite Height
    EX   AF,AF'                 ; Restore palette of sprite
    CP   9                      ; If (((palette - 1) >> 1) - 3) > 0 then eyes
    JR   NC,.eyes_only

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h14
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h14
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite
.eyes_only
    ; CY + 4 (3 + 1)
    INC  H
    INC  H
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_EYES_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h5
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h5
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_ghost_spr_34
save_ghost_spr_35
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
;    EX   AF,AF'
    LD   A,L
    AND  %00000011
    OR   GHOST_HEIGHT << 2      ; Sprite Height
    EX   AF,AF'                 ; Restore palette of sprite
    CP   9                      ; If (((palette - 1) >> 1) - 3) > 0 then eyes
    JR   NC,.eyes_only
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h14
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h14
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite
.eyes_only
    ; CY + 5 (4 + 1)
    INC  H
    INC  H
    INC  H
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_EYES_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h5
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h5
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_ghost_spr_38
save_ghost_spr_39
    ; CY + 1
    INC  H
    
    ; Get sprite height and preshift frame
;    EX   AF,AF'
    LD   A,L
    AND  %00000011
    OR   GHOST_HEIGHT << 2      ; Sprite Height
    EX   AF,AF'                 ; Restore palette of sprite
    CP   9                      ; If (((palette - 1) >> 1) - 3) > 0 then eyes
    JR   NC,.eyes_only

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h14
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h14
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite
.eyes_only
    ; CY + 2 (1 + 1)
    INC  H
    
    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_EYES_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h5
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h5
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite
    
; Tiles 40 - 43
save_score_spr_40
save_score_spr_41
save_score_spr_42
save_score_spr_43
    ; CY + 4
    INC  H
    INC  H
    INC  H
    INC  H

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   SCORE_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h7
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h7
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite

; Tiles 44 - 48
save_pacman_spr_44
save_pacman_spr_46
    ; CY + 1
    INC  H

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PACMAN44_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h13
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h13
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite
;.pacman_left
;    ; CY + 2 (1 + 1)
;    INC  H
;    JP   slow_save_sprite

save_pacman_spr_45
    ; CY + 1
    INC  H

    ; Get sprite height and preshift frame (hardcode to offset 0)
;    LD   A,L
;    AND  %00000011 
;    OR   PACMAN45_HEIGHT << 2
    LD   A,PACMAN45_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h9
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h9
    LD   (sm_table_save_low + 1),A
    
    BIT  0,B
;    JR   NZ,.pacman_up
.pacman_down
    JP   Z,slow_save_sprite
;    JP   slow_save_sprite
.pacman_up
    ; CY + 6 (5 + 1)
    LD   A,H
    ADD  5              ; Offset Y
    LD   H,A
    JP   slow_save_sprite

save_pacman_spr_47
    ; CY + 1
    INC  H

    ; Get sprite height and preshift frame (hardcode to offset 0)
;    LD   A,L
;    AND  %00000011 
;    OR   PACMAN47_HEIGHT << 2
    LD   A,PACMAN47_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h12
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h12
    LD   (sm_table_save_low + 1),A
    
    BIT  0,B
;    JR   NZ,.pacman_up
.pacman_down
;    JP   slow_save_sprite
    JP   Z,slow_save_sprite
.pacman_up
    ; CY + 3 (2 + 1)
    INC  H
    INC  H
    JP   slow_save_sprite

save_pacman_spr_48
    ; CY + 1
    INC  H

    ; Get sprite height and preshift frame (Fix pac-ball column align)
    ; Pacball uses only offsets 0 or 1.
    ; $x4, $x5, $xC and $xD in vertical movement.
    ; $x0, $x1, $x8 and $x9 in horizontal movement.
    LD   A,L
    AND  %00001111
    CP   $0C
    JR   Z,.fix_l
    CP   $04
    JR   NZ,.after_fix_l
.fix_l
    SET  0,L                        ; $C -> $D or $4 -> $5 (vertical)
    LD   A,L
.after_fix_l
    AND  %00000011 
    OR   PACMAN44_HEIGHT << 2
    EX   AF,AF'
    
    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h13
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h13
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite

; Tile 49 (Big Explosion, not used)
;save_explosion_spr
;    RET

; Tiles 50 - 51
save_eghost_spr_50
save_eghost_spr_51
    ; CY + 1
    INC  H

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   GHOST_HEIGHT << 2
    EX   AF,AF'
    JP   fast_save_sprite

; Tile 52 - 62 
save_pacdeath_spr_52
    ; CY + 3
    INC  H
    INC  H
    INC  H

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH52_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h10
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h10
    LD   (sm_table_save_low + 1),A
    
    JP   slow_save_sprite

save_pacdeath_spr_53
    ; CY + 4
    INC  H
    INC  H
    INC  H
    INC  H

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH53_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h8
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h8
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_54
    ; CY + 6
    LD   A,H
    ADD  6                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH54_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h6
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h6
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_55
    ; CY + 7
    LD   A,H
    ADD  7                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH55_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h5
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h5
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_56
    ; CY + 8
    LD   A,H
    ADD  8                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH56_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h5
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h5
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_57
save_pacdeath_spr_61
    ; CY + 8
    LD   A,H
    ADD  8                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH57_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h6
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h6
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_58
save_pacdeath_spr_59
save_pacdeath_spr_60
    ; CY + 8
    LD   A,H
    ADD  8                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH58_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h7
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h7
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

save_pacdeath_spr_62
    ; CY + 6
    LD   A,H
    ADD  6                      ; Offset Y
    LD   H,A

    ; Get sprite height and preshift frame
    LD   A,L
    AND  %00000011 
    OR   PAC_DEATH62_HEIGHT << 2
    EX   AF,AF'

    ; Set save table for this sprite height
    LD   A,>table_save_backgrounds_h10
    LD   (sm_table_save_high + 1),A
    LD   A,<table_save_backgrounds_h10
    LD   (sm_table_save_low + 1),A

    JP   slow_save_sprite

; --------------------------------------------------------------------------- 
; Entry:
;     HL : Coord Y, X in pixels (Y offset added)
;     DE : Save Background Address
;     A' : %00hhhhxx (h = Sprite Height | x = preshift frame 0 - 3
; --------------------------------------------------------------------------- 
; Fast version doesn't save the Background (it's black)
fast_save_sprite
    ; Convert from coords to screen address
    RRC  H                  ; H = %yyyy ybbb
    RRC  H
    RRC  H                  ; H = %bbby yyyy
    LD   A,L
    SCF                     ; Carry = 1
    RR   H                  ; H = %1bbb yyyy
    RRA
    SRL  H                  ; H = %01bb byyy
    RRA                     ; A = %yyxx xxxx
    LD   L,A                ; HL = Screen Address

    EX   DE,HL
    LD   (HL),E             ; Save address low
    INC  L
    LD   (HL),D             ; Save address high
    INC  L
    EX   AF,AF'
    ; Mark bit for fast restoring %0fhhhhxx 
    ; (f = Fast Mode | h = Sprite Height | x = Preshift Frame 0 - 3)
    SET  6,A
    LD   (HL),A             ; Save Sprite Height
    RET

slow_save_sprite
    ; Convert from coords to screen address
    LD   B,H                ; Save CY (%yyyy ybbb)
    RRC  H
    RRC  H
    RRC  H                  ; H = %bbby yyyy
    LD   A,L
    SCF                     ; Carry = 1
    RR   H                  ; H = %1bbb yyyy
    RRA
    SRL  H                  ; H = %01bb byyy
    RRA                     ; A = %yyxx xxxx
    LD   L,A                ; HL = Screen Address

    EX   DE,HL
    LD   (HL),E             ; Save address low
    INC  L
    LD   (HL),D             ; Save address high
    INC  L
    EX   AF,AF'
    ; %00hhhhxx (h = Sprite Height | x = Preshift Frame 0 - 3)
    LD   (HL),A             ; Save Sprite Height
    INC  L
    EX   DE,HL

    LD   A,B                ; Restore CY
sm_table_save_high
    LD   B,>table_save_backgrounds_h14
    AND  %00000111          ; Mask the scanline
    RLCA                    ; A * 2
sm_table_save_low
    ADD  A,<table_save_backgrounds_h14
    JR   NC,.espero_no_estar_en_mitad_pagina    ; *** REVISAR *** NO Carry
    INC  B
.espero_no_estar_en_mitad_pagina
    LD   C,A
    LD   A,(BC)
    LD   IYL,A
    INC  BC                                     ; *** REVISAR *** INC C
    LD   A,(BC)
    LD   IYH,A

    JP   (IY)               ; Jump to the print routine

; --------------------------------------------------------------------------- 
    include 'cpc_save_scanlines.s'

; --------------------------------------------------------------------------- 
