/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#ifndef _NIVELES_H_
#define _NIVELES_H_

#define NUM_NIVELES	15
#define MAX_NUM_SALIDAS 3
#define MAX_NUM_ENT 5
#define MAX_NUM_FLECHAS 6

//La primera posicion siempre sera la del personaje
// Las posiciones se determinan en tiles, tenemos un mpaa de 20x12, aunque 
// descontando el rectangulo de muro, utiles son 18x10

typedef struct posEntidades {
	unsigned char tipoEntidad;
	unsigned char direccion;
	unsigned char posX, posY;
} TPosEntidades;


typedef struct posSalidas {
	unsigned char nivelAlQueLleva;
	unsigned char dirPuerta;
	unsigned char posX, posY;
	
} TSalidas;

typedef struct posAlarma{
	unsigned char posX, posY;
	unsigned char dirAlarma;
} TPosAlarma;

typedef struct nivel {
	unsigned char*	mapa;
	unsigned char* 	tiles;
	unsigned char numSalidas; // Numero de salidas del nivel, para no recorrer todas
	unsigned char numEntidades; // Numero de entidades del nivel, para no recorrer todas
	unsigned char hayAlarma; // Variable que indica si en el nivel hay alarma
	TSalidas	  posSalidas[MAX_NUM_SALIDAS]; // Conjunto de salidas del nivel y donde llevan
	TPosEntidades posEnt [MAX_NUM_ENT]; // Conjunto de enemigos y personajes en el nivel, y el tipo
	TPosAlarma alarma; // Donde se encuentra la alarma del nivel
} TNivel;


extern TNivel NIVELES_JUEGO[NUM_NIVELES];
void inicializarNiveles();

#endif