/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include "niveles.h"
#include "../sprites/sprite.h"
#include "mapas.h"
#include "../sprites/entidad.h"

// Los niveles son estructuras definidas, por lo que se tienen que rellenar
// enteras aunque no vayamos a usar la totalidad de los datos.
// Al hacerlo asi sabemos en que posicion de memoria en un array empieza y acaba
// la definicion de cada nivel.Con una estructura de memoria no definida no lo sabriamos a priori.
// Tenemos del 1-18 en ancho ya que 0 y 19 son muros y del 1-10 en alto ya que 0 y 11 son muros
/*

   * Direccion donde apunta
   * 0 Arriba ( Puertas miran hacia abajo )
   * 1 Izquierda ( Puertas miran hacia derecha )
   * 2 Abajo ( Puertas miran hacia arriba )
   * 3 Derecha ( Puertas miran hacia izquierda )
   
*/

void inicializarNiveles() {
__asm

.globl _NIVELES_JUEGO
_NIVELES_JUEGO::
	;// Niveles
	.dw _mapaPrueba, _tilesMapa
	.db 0 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 0 ,0 ,0 ,0 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,2 ,9 ,3 ;//Entidad 0: Personaje
	.db 5 ,1 ,7 ,6 ;//Entidad 1
	.db 3 ,1 ,8 ,6 ;//Entidad 2
	.db 3 ,2 ,9 ,6 ;//Entidad 3
	.db 2 ,2 ,10 ,6 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 0,0,0;//Alarma
	
	;// NIVEL 1
	.dw _mapa1, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ;direccion en la que mira ; posTileX ; PosTileY
	.db ORCO ,0 ,9 ,0 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,0 ,9 ,10 ;//Entidad 0: Personaje
	.db ORCO ,2 ,9 ,1 ;//Entidad 1
	.db INSECTO ,1 ,17 ,6 ;//Entidad 2
	.db INSECTO ,3 ,3 ,6 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 0,0,0;//Alarma
	
	;// NIVEL 2
	.dw _mapa2, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 3 ,3 ,19 ,5 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,0 ,9 ,10 ;//Entidad 0: Personaje
	.db ORCO ,3 ,15 , 9;//Entidad 1
	.db INSECTO ,2 ,17 ,3 ;//Entidad 2
	.db INSECTO ,0 ,2 ,7 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 19,9,3;//Alarma
	
	;// NIVEL 3
	.dw _mapa3, _tilesMapa
	.db 3 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 4 ,0 ,14 ,0 ;// salida 0
	.db 6 ,2 ,3 ,10 ;// salida 1
	.db 10 ,3 ,19 ,9 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,3 ,1 ,5 ;//Entidad 0: Personaje
	.db INSECTO ,2 ,13 ,4 ;//Entidad 1
	.db ORCOA ,3 ,7 ,9 ;//Entidad 2
	.db ORCO ,1 ,17 ,5 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 10,11,2;//Alarma
	
	;// NIVEL 4
	.dw _mapa4, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 5 ,1 ,0 ,2 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,0 ,14 ,10 ;//Entidad 0: Personaje
	.db INSECTO ,2 ,10 ,5 ;//Entidad 1
	.db ORCOA ,3 ,3 ,3 ;//Entidad 2
	.db ORCO ,1 ,18 ,5 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 8,11,2;//Alarma
	
	;// NIVEL 5
	.dw _mapa5, _tilesMapa
	.db 1 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 1 ,1 ,0 ,5 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,1 ,18 ,2 ;//Entidad 0: Personaje
	.db ORCOA ,3 ,5 ,2 ;//Entidad 1
	.db ORCOA ,1 ,16 ,10 ;//Entidad 2
	.db ORCOJEFE ,0 ,2 ,5 ;//Entidad 3
	.db INSECTO ,0 ,12 ,6 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 0,9,1;//Alarma
	
	;// NIVEL 6
	.dw _mapa6, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 7 ,2 ,4 ,10 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,2 ,3 ,1 ;//Entidad 0: Personaje
	.db INSECTO ,1 ,8 ,5 ;//Entidad 1
	.db INSECTO ,3 ,10 ,9 ;//Entidad 2
	.db ORCOA ,3 ,8 ,10 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 0,0,0;//Alarma
	
	;// NIVEL 7
	.dw _mapa7, _tilesMapa
	.db 2 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 8 ,1 ,0 ,8 ;// salida 0
	.db 9 ,3 ,19 ,8 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,2 ,4 ,1 ;//Entidad 0: Personaje
	.db ORCOA ,1 ,15 ,1 ;//Entidad 1
	.db ORCOA ,0 ,10 ,7 ;//Entidad 2
	.db ORCO ,2 ,2 ,7 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 9,11,2;//Alarma
	
	;// NIVEL 8
	.dw _mapa8, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 1 ,1 ,0 ,5 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,1 ,18 ,8 ;//Entidad 0: Personaje
	.db ORCOJEFE ,0 ,4 ,7 ;//Entidad 1
	.db ORCOA ,1 ,16 ,2 ;//Entidad 2
	.db ORCOA ,3 ,13 ,9 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 12,0,0;//Alarma
	
	;// NIVEL 9
	.dw _mapa9, _tilesMapa
	.db 1 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 1 ,3 ,19 ,5 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,3 ,1 ,8 ;//Entidad 0: Personaje
	.db INSECTO ,2 ,17 ,3 ;//Entidad 1
	.db INSECTO ,3 ,8 ,8 ;//Entidad 2
	.db ORCO ,1 ,5 ,2 ;//Entidad 3
	.db ORCOJEFE ,0 ,18 ,8 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 14,0,0;//Alarma
	
	;// NIVEL 10
	.dw _mapa10, _tilesMapa
	.db 1 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 11 ,0 ,4 ,0 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,3 ,1 ,9 ;//Entidad 0: Personaje
	.db INSECTO ,2 ,10 ,10 ;//Entidad 1
	.db INSECTO ,2 ,16 ,10 ;//Entidad 2
	.db INSECTO ,3 ,15 ,2 ;//Entidad 3
	.db INSECTO ,0 ,4 ,3 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 0,0,0;//Alarma
	
	;// NIVEL 11
	.dw _mapa11, _tilesMapa
	.db 2 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 12 ,3 ,19 ,5 ;// salida 0
	.db 13 ,0 ,9 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,0 ,4 ,10 ;//Entidad 0: Personaje
	.db ORCOA ,1 ,9 ,3 ;//Entidad 1
	.db ORCOA ,3 ,12 ,10 ;//Entidad 2
	.db ORCO ,2 ,17 ,4 ;//Entidad 3
	.db 0 ,0 ,0 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 19,2,3;//Alarma
	
	;// NIVEL 12
	.dw _mapa12, _tilesMapa
	.db 1 ; //numero de salidas
	.db 4 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 1 ,3 ,19 ,5 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,3 ,1 ,5 ;//Entidad 0: Personaje
	.db ORCOA ,3 ,15 ,1 ;//Entidad 1
	.db ORCOA ,1 ,5 ,10 ;//Entidad 2
	.db ORCOJEFE ,0 ,10 ,7 ;//Entidad 3
	.db INSECTO ,9 ,5 ,0 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 9,0,0;//Alarma
	
	;// NIVEL 13
	.dw _mapa13, _tilesMapa
	.db 1 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 1; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 14 ,3 ,19 ,9 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,0 ,9 ,10 ;//Entidad 0: Personaje
	.db ORCO ,3 ,6 ,7 ;//Entidad 1
	.db ORCOA ,0 ,15 ,4 ;//Entidad 2
	.db INSECTO ,0 ,17 ,9 ;//Entidad 3
	.db INSECTO ,2 ,2 ,1 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 11,0,0 ;//Alarma
	
	;// NIVEL 14
	.dw _mapa14, _tilesMapa
	.db 1 ; //numero de salidas
	.db 5 ;//numero de entidades
	.db 0; // variable que indica si hay alarma
	;// SALIDAS	(3 total)   nivelAlQueLlevan ; direccion en la que mira ; posTileX ; PosTileY
	.db 0 ,0 ,0 ,0 ;// salida 0
	.db 0 ,0 ,0 ,0 ;// salida 1
	.db 0 ,0 ,0 ,0 ;// salida 2
	;// ENTIDADES -( 8 total)  tipo ; direccion ; posTileX ; posTileY
	.db 0 ,3 ,1 ,9 ;//Entidad 0: Personaje
	.db ORCOJEFE ,1 ,8 ,2 ;//Entidad 1
	.db INSECTO ,2 ,2 ,1 ;//Entidad 2
	.db ORCOA ,2 ,12 ,10 ;//Entidad 3
	.db ORCOA ,1 ,18 ,6 ;//Entidad 4
	;//ALARMA - Posicion de la alarma.
	.db 10,0,2;//Alarma
	
__endasm;

}
