/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include <cpcrslib.h>
#include "mapas.h"

// Size of a tile in bytes
#define	TILESIZE			(4*16)


unsigned char* g_tilemap; 		 // Puntero a un vector de ANCHO_MAPAS*ALTO_MAPAS
unsigned char* g_tileset; 		 // puntero a un numero indeterminado de tiles 4*16

void mapa_cargarMapa(unsigned char *tilemap){
	g_tilemap = tilemap; 
}

void mapa_cargarTiles(unsigned char *tileset) {
	g_tileset = tileset;
}

void mapa_dibujarMapa(int mem_dir) {
	unsigned char i, j, t;
	
	mem_dir += 80;
	
	for(i=0; i < ALTO_MAPAS; i++) {
		for(j=0; j < ANCHO_MAPAS; j++) {
			t = g_tilemap[ANCHO_MAPAS*i + j];
			cpc_PutSp((g_tileset + TILESIZE*t), 16, 4, mem_dir);
			mem_dir += 4;
		}
			mem_dir += 80;
	}
}
