/***********************************************************/
	//GNU GENERAL PUBLIC LICENSE - Version 3, 29 June 2007
	//For more info, read LICENSE.txt on source's root directory
/************************************************************/
#include <cpcrslib.h>
#include "jugar.h"

void setColors(unsigned char colors[17]) 
{
    unsigned char i;
	cpc_SetBorder(colors[0]);
    for (i=0; i<16; i++)  
		cpc_SetInk(i, colors[i+1]);
}

void CambiarColoresTexto(unsigned char f, unsigned char c1, unsigned char c2, unsigned char c3)
{
	cpc_SetInkGphStr(0,f);
	cpc_SetInkGphStr(1,c1);
	cpc_SetInkGphStr(2,c2);	
	cpc_SetInkGphStr(3,c3);
}


void pintarNivelActual(unsigned char nivAct)
{
	switch(nivAct)
	{
		case 0 : cpc_PrintGphStrXY("DE;PRUEBA",12,0);
			break;
		case 1 : cpc_PrintGphStrXY("1",12,0);
			break;
		case 2 : cpc_PrintGphStrXY("2",12,0);
			break;
		case 3 : cpc_PrintGphStrXY("3",12,0);
			break;
		case 4 : cpc_PrintGphStrXY("4",12,0);
			break;
		case 5 : cpc_PrintGphStrXY("5",12,0);
			break;
		case 6 : cpc_PrintGphStrXY("6",12,0);
			break;
		case 7 : cpc_PrintGphStrXY("7",12,0);
			break;
		case 8 : cpc_PrintGphStrXY("8",12,0);
			break;
		case 9 : cpc_PrintGphStrXY("9",12,0);
			break;
		case 10 : cpc_PrintGphStrXY("10",12,0);
			break;
		case 11 : cpc_PrintGphStrXY("11",12,0);
			break;
		case 12 : cpc_PrintGphStrXY("12",12,0);
			break;
		case 13 : cpc_PrintGphStrXY("13",12,0);
			break;
		case 14 : cpc_PrintGphStrXY("14",12,0);
			break;			
		default:  cpc_PrintGphStrXY("UNDEFINED",12,0);
			break;
	}
}

unsigned char jugarExterno()
{
	unsigned char nivelActual = 1 , vidas = 3, golpe=0; 
	unsigned char contadorMov = 0, movido = 0; 
	unsigned char cuchilloLanzado = 0;
	unsigned char contadorMele = 0;
	unsigned char numEntidadesNivel = 0, contEntidades = 0;
	int i = 0;

	tEntidad ENTIDADES[MAX_NUM_ENT];
	tEntidad cuchillo; // Solo va a haber un cuchillo por pantalla
	tEntidad mele; // Ataque de tipo mele


	// Iniciamos la musica
	play(CANCION_JUEGO);
	CambiarColoresTexto(170, 34, 10, 34);

	// Bucle de niveles
	do 
	{
		niv	= &(NIVELES_JUEGO[nivelActual]);
		alarma=0;
		
		// Sonidos
		if(nivelActual != 1)
			playEffect(2,5);
		else
			if(numEntidadesNivel != 0)
				playEffect(2,3);
		
		numEntidadesNivel = niv->numEntidades;
		contEntidades = numEntidadesNivel;
		
		// Inicializar y dibujar mapa actual
		mapa_cargarMapa(niv->mapa);
		mapa_cargarTiles(niv->tiles);
		interfaz_dibujarInterfaz(vidas);
		RellenarMapaColisiones();
		mapa_dibujarMapa(0xC000);

		cpc_PrintGphStrXY("NIVEL",0,0);
		pintarNivelActual(nivelActual);

		//Cargar todas las entidades
		for(i = 0; i <  numEntidadesNivel; i++)
		{
			TPosEntidades* tpos = &niv->posEnt[i];
			IniciarEntidad(&ENTIDADES[i],tpos->tipoEntidad,tpos->posX<<2,tpos->posY<<4,tpos->direccion);
			PintarEntidad(&ENTIDADES[i]);
		}
		jugador = &ENTIDADES[0];
		cuchilloLanzado = 0;
		contadorMele = 0;
		numFlechas = 0;
		
		// Bucle de juego
		do 
		{
			//Escanear teclado
			cpc_ScanKeyboard();
			
			if (cpc_TestKeyF(KEYID_SALIR)) 		goto salir;

			// Seccion de Musica On/Off
			/*if (cpc_TestKeyF(KEYID_SONIDO)) 
			{
				if(sonido == 0)
				{
					resume();
					sonido = 1;
				}else
				{
					pause();
					sonido = 0;
				}
			}	*/		
			
			// Teclas para explorar niveles, avanzar y retroceder
				if (cpc_TestKeyF(KEYID_AVANZAR) && nivelActual < NUM_NIVELES-1){
					nivelActual++; 
					goto initniveles;
				}
				if (cpc_TestKeyF(KEYID_RETROCEDER) && nivelActual > 0){
					nivelActual--;
					goto initniveles;
				}	
			
			// Bloque de Movimiento pj/comprobacion de entrar puertas
			if( contadorMov > (15*(MAX_NUM_ENT-contEntidades) ) + 15 )
			{			
				// MOVIMIENTO DEL PJ
				if(contadorMele == 0  || contadorMele > 3)
					if (cpc_TestKeyF(KEYID_ARRIBA))
						movido = MoverEntidad(jugador,0);
					else if (cpc_TestKeyF(KEYID_ABAJO))
							movido = MoverEntidad(jugador,2);
						else if (cpc_TestKeyF(KEYID_IZQUIERDA))
								movido = MoverEntidad(jugador,1);
							else if (cpc_TestKeyF(KEYID_DERECHA) )
									movido = MoverEntidad(jugador,3);
			
			//ATAQUE MELEE 
				if(contadorMele > 0)
				{
					if(contadorMele > 3)
					{
						if(contadorMele == 12)
							contadorMele =0;
						else
							contadorMele++;
					}else
					{
						if(contadorMele == 3)
						{
							PintarTrozoManchado(&mele);
							contadorMele ++;
						}else
						{
							if(MoverEntidad(&mele, CalcularMele(jugador->direccion)))
							{
								mele.direccion = jugador->direccion;
								PintarEntidad(&mele);
								contadorMele++;
							}else
								PintarTrozoManchado(&mele);						
						}
					}
				}
			//MELE : INIT
				if(cpc_TestKeyF(KEYID_MELE) && contadorMele == 0)
				{
					IniciarEntidad(&mele, ENT_MELE,jugador->nueva.x,jugador->nueva.y,jugador->direccion);
					if(SePuedeMover(&mele))
					{
						contadorMele = 1;
						playEffect(2,2);
					}else
						contadorMele = 0;
				}
							
			//CUCHILLO : MOVIMIENTO e INICIALIZACION	
				// Movimiento del cuchillo
				if(cuchilloLanzado)
				{
					if(!MoverEntidad(&cuchillo, cuchillo.direccion))
					{
						PintarTrozoManchado(&cuchillo);
						cuchilloLanzado = 0;
					}
				}else if(cpc_TestKeyF(KEYID_DISTANCIA) && contadorMele == 0)
				{					
					// Importante que este despues de mover el cuchillo, asi no se mueve dos veces si se inicializa.   
					IniciarEntidad(&cuchillo, ENT_CUCHILLO, jugador->nueva.x,jugador->nueva.y,jugador->direccion);
					
					if(MoverEntidad(&cuchillo, cuchillo.direccion))
					{
						cuchilloLanzado = 1;
						playEffect(2,1);
					}
					else
						cuchilloLanzado = 0;
				}
				
				// FLECHAS : MOVIMIENTO (INICIALIZACION EN ENTIDADES MOVER IA)
				for(i = 0 ; i < numFlechas ; i++)
				{
					if(!MoverEntidad(&FLECHAS[i], FLECHAS[i].direccion))
					{
						PintarTrozoManchado(&FLECHAS[i]);
						numFlechas--;
						if(numFlechas)
						{
							CopiarEntidad(&FLECHAS[i], &FLECHAS[numFlechas]);	
							i--;
						}						
					}
				}
							
					
				// COMPROBACION DE CHOQUES CON PUERTA			
				//Comprobacion de choque con alguna puerta si el pj se ha movido
				if(movido)
					for( i = 0; i < niv->numSalidas ;i++ )
						if(ComprobarPuertas( &ENTIDADES[0] , niv->posSalidas[i].posX, niv->posSalidas[i].posY, niv->posSalidas[i].dirPuerta) )
						{
							if(niv->posSalidas[i].nivelAlQueLleva!=50)
							{
								nivelActual = niv->posSalidas[i].nivelAlQueLleva;
								goto initniveles;
							}
							else
							{
								//Ir al final
								goto fin;
							}
						}		
		
				RellenarMapaNumero(jugador->ant.x, jugador->ant.y, jugador->width, jugador->height, 0);						
				RellenarMapaNumero(jugador->nueva.x, jugador->nueva.y, jugador->width, jugador->height, 6);

				//IA Enemiga
				for(i = 1 ; i <  numEntidadesNivel ;i++)
					if(ENTIDADES[i].estado != MUERTO )
						MoverEntidadIA(&ENTIDADES[i]);
						
				if(cuchilloLanzado)
				{
					for(i=1; i<numEntidadesNivel && cuchilloLanzado; i++)
						if(ENTIDADES[i].estado != MUERTO && ColisionEntidades(&cuchillo, &ENTIDADES[i]))
						{
							cuchilloLanzado = 0;
							PintarTrozoManchado(&cuchillo);
							PintarTrozoManchado(&ENTIDADES[i]);
							ENTIDADES[i].estado = MUERTO;
							contEntidades--;
							playEffect(2,0);								
							break;
						}
				}
					
				
					// Se compruba por cada flecha si hay colision con el cuchillo o el jugador
				for(i=0; i<numFlechas  ; i++)
				{
					if(cuchilloLanzado && ColisionEntidades(&cuchillo, &FLECHAS[i]))
					{
						cuchilloLanzado = 0;
						PintarTrozoManchado(&cuchillo);
						PintarTrozoManchado(&FLECHAS[i]);
						numFlechas--;
						playEffect(2,0);
						if(numFlechas)
							CopiarEntidad(&FLECHAS[i], &FLECHAS[numFlechas]);								
						
					}
					if( ColisionEntidades(&ENTIDADES[0] , &FLECHAS[i]) )
					{
						golpe = 1;
						break;
					}
				}
					
				// Comprobacion de ataque mele
				if(contadorMele > 0 && contadorMele < 4 && !golpe)
				{
					for(i=1; i<numEntidadesNivel; i++)
						if(ENTIDADES[i].estado != MUERTO && ColisionEntidades(&mele, &ENTIDADES[i]))
						{
							PintarTrozoManchado(&ENTIDADES[i]);							
							ENTIDADES[i].estado = MUERTO;
							contEntidades--;
							playEffect(2,0);
							break;
						}
				}				
				
				for(i=1; i<numEntidadesNivel; i++)
					if(ENTIDADES[i].estado != MUERTO && ColisionEntidades(&ENTIDADES[0], &ENTIDADES[i]))
					{	golpe=1; break;}

				if(golpe)
				{
					golpe=0;
					if(vidas==0)
						goto gameover;
					else
					{
						vidas--;
						goto initniveles;
					}
				}					

				// Bucle de pintado de entidades
				for(i = 0 ; i <  numEntidadesNivel ;i++){
					if(ENTIDADES[i].estado != MUERTO ){
						PintarEntidad(&ENTIDADES[i]);
						RellenarMapaNumero(ENTIDADES[i].nueva.x, ENTIDADES[i].nueva.y, ENTIDADES[i].width, ENTIDADES[i].height, 0);
					}
				}

				for(i = 0 ; i <  numFlechas ;i++)
					PintarEntidad(&FLECHAS[i]);
				
				if(cuchilloLanzado)
					PintarEntidad(&cuchillo);
				
				interfaz_dibujarCuchillo(cuchilloLanzado);
				
				if(contadorMele>0 && contadorMele <3)
					PintarEntidad(&mele);
				
				interfaz_dibujarMele(contadorMele);
				
				movido = 0;
				contadorMov = 0;
				
			}
			//Sumamos uno al contador del movimiento(restriccion al input)
			contadorMov++;
		} while (1);
		initniveles:
	} while (1);
		
	gameover:
		return E_GO;
	salir:
		return E_MENU;
	fin:
		return E_FINAL;
}