nolist
write "ktris"
run #be80,newpiece
org #100
limit #4ff

.start
ld c,#42
ld h,#03
ld d,l
ld e,l
call #be89
.restart
ld hl,start2
ld c,#ff
jp #bd16

list
.tilecols
;db 1,2,    3,4,     5,6,     7,8,     9,A,     B,C,     D,E
db #c0,#0c, #cc,#30, #f0,#3c, #fc,#03, #c3,#0f, #cf,#33, #f3,#3f

.rotmask  ;Rotation masks
db 1,1,1,3,3,3,0

.pieces
dw %0000001101100000, %0000001000110001
dw %0000111100000000, %0010001000100010
dw %0000110001100000, %0000010011001000
dw %0000111010000000, %0100010001100000, %0010111000000000, %1100010001000000
dw %0000011100010000, %0011001000100000, %0100011100000000, %0010001001100000
dw %0000111001000000, %0100011001000000, %0100111000000000, %0100110001000000
dw %0000011001100000

.levels
;Number of rows required to reach next level, Score for drop, Drop delay
db 11,4,#20, 18,6,#1e, 25,8,#1b, 32,10,#18, 40,14,#14, 50,18,#10
db 60,22,#0d, 70,28,#0a, 80,34,#07, 100,40,#05, 120,48,#03, 0,56,#02

.scores
db #01,#03,#06,#10

nolist
.start2
xor a
call #bc0e
ld bc,0
call #bc38
ld hl,inks
xor a
.lpink
ld c,(hl)
inc hl
ld b,c
push af
push hl
call #bc32
pop hl
pop af
inc a
cp #10
jr nz,lpink
ld a,15
call #bb90
ld hl,#f851
ld bc,#14a2
call box
ld hl,#fb51
ld bc,#0822
call box
.newgame
call #bb18
cp " "
jr nz,newgame
call game
jr newgame

.game
xor a
call setlevel
call clrdat
call newpiece
.tiles
.pos equ $ + 1
ld hl,0
ld de,(piece)
ld a,d
set 7,a
call drawpiece
call drawblocks

.loop
call move
call #bd19
jr tiles

.box
push bc
push bc
push hl
push bc
ld b,c
ld c,#11
call dovert
;#11 for left, #aa for right, #ff for bottom, #33 for top
inc hl
pop bc
ld c,#ff
call clrhl
pop hl
pop bc
inc hl
ld c,#33
call clrhl
pop bc
ld b,c
ld c,#aa

.dovert
ld (hl),c
call #bc26
djnz dovert
jp #bc29

.drawblocks
ld ix,data1
ld iy,data2
ld hl,#c0a2
ld c,20
.nextrow
ld b,10
.nextcol
push bc
ld a,(ix + 0)
and #7f
inc ix
cp (iy + 0)
ld (iy + 0),a
inc iy
jr z,same
ld bc,#0000
or a
jr z,clrblock
add a
add tilecols - 2
ld c,a
ld b,1
ld a,(bc)
inc bc
ld e,a
ld a,(bc)
ld c,e
ld b,#ff
.clrblock
call drawblock
.same
inc hl
inc hl
pop bc
djnz nextcol
ld de,#3c
add hl,de
dec c
jr nz,nextrow
ret

.clrdat
ld hl,data1
ld bc,#c800
call clrhl
ld bc,#a01
call clrhl
ld bc,#700
.clrhl
ld (hl),c
inc hl
djnz clrhl
ret

.checkright
ld hl,data1 + 9
.check
ld b,20
ld de,10
.checklp
bit 7,(hl)
ret nz
add hl,de
djnz checklp
ret

.testpiece
push bc
push de
push hl
xor a
ld bc,#c0be
call testdraw
pop hl
pop de
pop bc
ret

.drawpiece ;H = X, L = Y, D = Piece, E = rotation, A = data
ld bc,#0077  ;ld (hl),a, nop
.testdraw
ld (smc1),bc
ld c,a
ld b,0
.ofloop
bit 7,h
jr z,nooff
inc b
inc h
jr ofloop
.nooff
ld a,l
add a
add a
add l
add a
add h
ld l,a
ld h,5
.dodrawtest
push hl
ld h,1
ld a,d
dec a
add a
cp 8
jr c,less8
add a
sub 6
.less8
add e
add a
add pieces
ld l,a
ld e,(hl)
inc hl
ld d,(hl)
pop hl
inc b
.shift
dec b
jr z,noshift
sla e
rl d
jr shift
.noshift
ld a,c
ld c,4
.loopv
ld b,4
.looph
sla e
rl d
jr nc,noblock
.smc1
cp (hl)
ret nz
.noblock
inc hl
djnz looph
inc hl:inc hl:inc hl:inc hl:inc hl:inc hl
dec c
jr nz,loopv
ret

;Bright is white
.drawblock    ;H = X, L = Y, A = normal pix, C = dark, B = bright
push hl
and #55
ld e,a
add a
ld d,a
ld (hl),b     ; Row 0
inc l
ld a,b
and #aa
ld b,a
ld a,c
or b
ld (hl),a
set 3,h
ld a,e
or b
ld b,a
ld a,c
and #55
or d
ld d,a
ld e,8
ld (hl),d     ; Row 1
dec l
ld (hl),b
ld a,h
add e
ld h,a
ld (hl),b     ; Row 2
inc l
ld (hl),d
add e
ld h,a
ld (hl),d     ; Row 3
dec l
ld (hl),b
add e
ld h,a
ld (hl),b     ; Row 4
inc l
ld (hl),d
add e
ld h,a
ld (hl),d     ; Row 5
dec l
ld (hl),b
add e
ld h,a
ld (hl),b     ; Row 6
inc l
ld (hl),d
add e
ld h,a
ld (hl),c
dec l
ld (hl),c
pop hl
ret

.inks
db 0,1,2,3, 6,9,18,12, 24,4,8,10, 13,14,23,26

.keys
db 8,1,0,2

.move
ld de,keys
ld b,#10
.keyloop
ld a,(de)
inc de
call #bb1e
jr z,nopress
scf
.nopress
rl b
jr nc,keyloop
.kdown equ $ + 1
ld a,0
cpl
and b
ld c,a
ld a,b
ld (kdown),a
bit 3,c
jr z,noleft1
ld hl,data1
call check
jr z,noleft1
res 3,c
.noleft1
bit 2,c
jr z,noright1
call checkright
jr z,noright1
res 2,c
.noright1
;Clear current piece
xor a
ld hl,data1
ld b,200
.clrlp
bit 7,(hl)
jr z,noclr
ld (hl),a
.noclr
inc hl
djnz clrlp

ld hl,(pos)
.piece equ $ + 1
ld de,#0100
bit 3,c
jr z,noleft2
dec h
call testpiece
jr z,noleft2
inc h
.noleft2
bit 2,c
jr z,noright2
inc h
call testpiece
jr z,noright2
dec h
.noright2
bit 0,c
jr z,nodown1
xor a
ld (steps),a
.nodown1
bit 1,c
jr z,norot
;Check rotation
.chkrot
bit 7,h
jr z,notneg
ld a,h
inc a
jr nz,norot
ld a,d
cp 5
jr z,dorot
dec a
jr nz,norot
jr dorot
.notneg
ld a,h
cp 7
jr c,dorot
jr nz,norot
ld a,d
cp 5
jr z,norot
cp 3
jr c,norot
.dorot
ld a,d
add rotmask - 1
ld c,a
ld b,1
ld a,(bc)
or a
jr z,norot
ld b,e
inc e
and e
ld e,a
call testpiece
jr z,norot
ld e,b
.norot
.steps equ $ + 1
ld b,#30
.step equ $ + 1
ld a,#00
inc a
cp b
jp c,nodown2
inc l
call testpiece
jr nz,enddown
.movedown
ld a,b
or a
jp nz,nodown3
ld a,(downscore)
inc a
daa
ld (downscore),a
jp nodown3
.enddown
dec l
ld a,d
call drawpiece
;Check for filled rows
ld de,#1401
ld hl,data1 - 1
.rowlp
xor a
ld bc,#0a0b
.collp
inc hl
cp (hl)
jr z,nodec
dec c
.nodec
djnz collp
dec c
call z,delrow
dec d
jr nz,rowlp
dec e
jr z,nobeep
ld hl,lines + 1
ld d,e
or a
call addbcd2
ld hl,(numlines)
ld d,0
add hl,de
ld (numlines),hl
push hl
ld hl,scores - 1
add hl,de
ld e,d
ld d,(hl)
call addscore
ld a,7
call #bb5a
pop hl
ld a,h
or a
jr nz,nobeep
ld a,l
.need equ $ + 1
cp 0
call nc,nextlevel
.nobeep
.downscore equ $ + 1
ld de,0
call addscore
.newpiece
.dropscore equ $ + 1
ld a,0
ld (downscore),a
call dispscore
ld hl,#0c08
ld de,lines
ld b,2
call dodisp
.defstep equ $ + 1
ld a,#30
ld (steps),a
.nextpiece equ $ + 2
ld de,#0300
push de
ld a,r
.test7
sub 7
jr nc,test7
add 8
ld (nextpiece),a
ld d,a
;Draw piece preview
ld hl,#0077
ld (smc1),hl
ld hl,preview1
push hl
push hl
ld bc,#2800
call clrhl
pop hl
ld c,d
call dodrawtest
pop ix
ld iy,preview2
ld hl,#c3a2
ld c,4
call nextrow
pop de
ld hl,#0300
call testpiece
jr z,nodown3
call drawblocks
.wait
pop hl
ret

.nodown3
xor a
.nodown2
ld (step),a
ld (pos),hl
ld (piece),de
ret

.delrow   ;Delete the row ending at HL. Assumes B is zero
push hl
push de
ld e,l
ld d,h
ld a,l
sub 10
ld l,a
ld c,a
inc c
lddr
pop de
pop hl
inc e
ret

.dispscore
ld hl,#0a06
ld de,score
ld b,3
.dodisp
call #bb75
.scorelp
ld a,(de)
inc de
call dispbcd
djnz scorelp
ret

.addscore  ;Add DE to score
ld hl,score + 2
ld a,(hl)
add e
daa
ld (hl),a
dec hl
.addbcd2
ld a,(hl)
adc d
daa
ld (hl),a
dec hl
ld a,(hl)
adc 0
daa
ld (hl),a
ret
list

.nextlevel
.level equ $ + 1
ld a,0
cp 12
ret z
.setlevel
inc a
ld c,a
ld (level),a
add a
add c
add levels - 3
ld l,a
ld h,1
ld a,(hl)
ld (need),a
inc hl
ld a,(hl)
ld (dropscore),a
inc hl
ld a,(hl)
ld (defstep),a
ld hl,#0e0a
call #bb75
ld a,c
add 0
daa

.dispbcd
push af
rra:rra:rra:rra
call digit
pop af
.digit
and #0f
add 48
jp #bb5a

.end
nolist

org #500
limit #ffff

.data1
ds 210   ;Extra 4 rows for preview

.score
ds 3

.lines
ds 2

.numlines
dw 0

.data2
ds 210   ;Extra 4 rows for preview

.preview1
ds 40

.preview2
ds 40

org #be80
limit #bfff
push hl
push de
push bc
push af
push ix
push iy
call #b909
call restart
ld b,1
.waitffb
call #bd19
djnz waitffb
call #b906
pop iy
pop ix
pop af
pop bc
pop de
pop hl
ret
