/**
 * @file  sprites.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef PLAYERS_H_
#define PLAYERS_H_


extern const unsigned char PlayerPalette[]={
		 0, 8, 6, 3, 20, 26, 11, 15, 10, 25, 9, 12, 22, 18, 23, 14
};

enum s_State{
	Static_Right=0, Static_Left, Walk_Right, Walk_Left, Jump_Right, Jump_Left, Attack_Right, Attack_Left, Max_States
};

unsigned char *PlayerKeyFrames[Max_States][3];

struct s_Sprite{
    unsigned char *sp0;		//2 bytes 	01
    unsigned char *sp1;		//2 bytes	23
    int coord0;		//2 bytes	45	current superbuffer address
    int coord1;		//2 bytes	67  old superbuffer address
    unsigned char cx, cy;	//2 bytes 89 	current coordinates
    unsigned char ox, oy;	//2 bytes 1011  old coordinates
    unsigned char move1;	// los bits 4,3,2 definen el tipo de dibujo!!
    unsigned char move;		// 	in this example, to know the movement direction of the sprite
    unsigned char isJumping;
	int xSpeed;
    int ySpeed;
    unsigned int gravity;
    unsigned char frameSpeed;
    unsigned char actualFrame;
    unsigned char lastMoveTime;
    enum s_State state;
    enum s_State lastState;
	unsigned char tilX;
	unsigned char tilY;
	char acumX;
	char acumY;
	int gatheredGems;
	unsigned char invincible;
	unsigned char currentImprovement[3];

	//GEMAS
    char xDirection;
    char yDirection;
    unsigned char yMov;
    unsigned char value;

};



typedef struct s_Sprite s_Sprite;
void *p_sprites[2];
s_Sprite player1, player2;
s_Sprite sprites[2];

void *p_boosts[2];
s_Sprite boosts[2];
unsigned char speedBoostTime = 0;
unsigned char invulnerabilityBoostTime = 0;
unsigned char punchBoostTime = 0;
unsigned char timeLimit = 50;
unsigned char respawnTime = 90;
unsigned char restart;
unsigned char numSprite = 0;
unsigned int lastInvincible[2]={0,0};

extern const unsigned char PlayerSpriteTransparent[]={
		 6,20
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00

};

extern unsigned char PlayerSpriteStatic[242];
extern unsigned char PlayerSpriteStaticL[242];
extern unsigned char PlayerSpriteWalk1[242];
extern unsigned char PlayerSpriteWalk1L[242];
extern unsigned char PlayerSpriteWalk2[242];
extern unsigned char PlayerSpriteWalk2L[242];
extern unsigned char PlayerSpriteJump[230];
extern unsigned char PlayerSpriteJumpL[230];
extern unsigned char PlayerSpriteAttack[242];
extern unsigned char PlayerSpriteAttackL[242];

void data(void){
__asm
	_PlayerSpriteStatic:
		.db #6, #20, #0xFF, #0x00, #0xAA
		.db #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0x00, #0xFC, #0x00
		.db #0xAD, #0x00, #0x0F, #0x00, #0xA5, #0x00, #0x5A, #0xAA, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA
		.db #0x50, #0x00, #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x45, #0x00, #0x8A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xED, #0x00, #0x5E, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xCF, #0x55, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xCF, #0x55, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xCF, #0x55, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00
	_PlayerSpriteStaticL:
		.db #6, #20, #0xFF, #0x00, #0x55
		.db #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x55, #0x00, #0x00
		.db #0xA5, #0x00, #0x5A, #0x00, #0x0F, #0x00, #0x5E, #0x00, #0xFC, #0x00, #0xFC, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA, #0x50, #0x00
		.db #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x45, #0x00, #0x8A, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xAD, #0x00, #0xDE, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x05, #0x00, #0xCF, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x05, #0x00, #0xCF, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x05, #0x00, #0xCF, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00
	_PlayerSpriteWalk1:
		.db #6, #20, #0xFF, #0x00, #0xAA
		.db #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0x00, #0xFC, #0x00
		.db #0xAD, #0x00, #0x0F, #0x00, #0xA5, #0x00, #0x5A, #0xAA, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA
		.db #0x50, #0x00, #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x05, #0x00, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xAD, #0x00, #0xDE, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x05, #0x00, #0x4F, #0x00, #0xCF, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0x0F, #0xFF, #0x00, #0x00, #0xCF, #0x55, #0x8A, #0x55, #0xA8, #0xFF, #0x00, #0x00
		.db #0xAD, #0xFF, #0x00, #0xAA, #0x45, #0x00, #0xDE, #0x55, #0xA8, #0xFF, #0x00, #0x00
		.db #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x55, #0xA8, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00
	_PlayerSpriteWalk1L:
		.db #6, #20, #0xFF, #0x00, #0x55
		.db #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x55, #0x00, #0x00
		.db #0xA5, #0x00, #0x5A, #0x00, #0x0F, #0x00, #0x5E, #0x00, #0xFC, #0x00, #0xFC, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA, #0x50, #0x00
		.db #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x05, #0x00, #0x0A, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xED, #0x00, #0x5E, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xCF, #0x00, #0x8F, #0x55, #0x0A, #0xFF, #0x00, #0xAA, #0x54, #0xAA
		.db #0x45, #0x00, #0xCF, #0xFF, #0x00, #0x00, #0x0F, #0xFF, #0x00, #0xAA, #0x54, #0x00
		.db #0xED, #0x55, #0x8A, #0xFF, #0x00, #0x00, #0x5E, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00
	_PlayerSpriteWalk2:
		.db	#6, #20, #0xFF, #0x00, #0xAA
		.db #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0x00, #0xFC, #0x00
		.db #0xAD, #0x00, #0x0F, #0x00, #0xA5, #0x00, #0x5A, #0xAA, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA
		.db #0x50, #0x00, #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x00, #0x00, #0x05, #0x00, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x00, #0xAD, #0x00, #0x5E, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x45, #0x00, #0x8F, #0x00, #0x0F, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xCF, #0xFF, #0x00, #0x00, #0x0F, #0x55, #0x0A, #0x55, #0xA8, #0xFF, #0x00, #0x00
		.db #0xED, #0xFF, #0x00, #0xAA, #0x05, #0x00, #0x5E, #0x55, #0xA8, #0xFF, #0x00, #0x00
		.db #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0x55, #0xA8, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00 
	_PlayerSpriteWalk2L:
		.db #6, #20, #0xFF, #0x00, #0x55
		.db #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x55, #0x00, #0x00
		.db #0xA5, #0x00, #0x5A, #0x00, #0x0F, #0x00, #0x5E, #0x00, #0xFC, #0x00, #0xFC, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA, #0x50, #0x00
		.db #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x05, #0x00, #0x0A, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0xAD, #0x00, #0x5E, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0x00, #0x0F, #0x00, #0x4F, #0x55, #0x8A, #0xFF, #0x00, #0xAA, #0x54, #0xAA
		.db #0x05, #0x00, #0x0F, #0xFF, #0x00, #0x00, #0xCF, #0xFF, #0x00, #0xAA, #0x54, #0x00
		.db #0xAD, #0x55, #0x0A, #0xFF, #0x00, #0x00, #0xDE, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x00, #0xFC, #0xFF, #0x00, #0xFF, #0x00, #0xAA
		.db #0x54, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00
	_PlayerSpriteJump:
		.db #6, #19, #0xFF, #0x00, #0xAA, #0x54
		.db #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54
		.db #0x55, #0xA8, #0xFF, #0x00, #0x00, #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0xAA, #0x54
		.db #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x55, #0x00, #0x00, #0xFC, #0x00, #0xAD
		.db #0x00, #0x0F, #0x00, #0xA5, #0x00, #0x5A, #0x00, #0x00, #0xFF, #0x00, #0x00, #0xFC
		.db #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA, #0x50
		.db #0x00, #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xFF, #0x00
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xAA, #0x00, #0x00, #0x00
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0x00, #0x00, #0x00, #0x00
		.db #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0x00, #0xFF, #0x00
		.db #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00
		.db #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00
		.db #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00
		.db #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00, #0xFF, #0x00
		.db #0x00, #0x0F, #0x00, #0x4F, #0x00, #0xCF, #0x55, #0xA8, #0xFF, #0x00, #0xAA, #0x05
		.db #0x00, #0x0F, #0x00, #0xCF, #0x00, #0xCF, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0x0F
		.db #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0x0A
		.db #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00
		.db #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00
		.db #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00
	_PlayerSpriteJumpL:
		.db #6, #19, #0xFF, #0x00, #0x55
		.db #0xA8, #0xFF, #0x00, #0xFF, #0x00, #0x55, #0xA8, #0xFF, #0x00, #0xAA, #0x54, #0x00
		.db #0xFC, #0xFF, #0x00, #0xAA, #0x54, #0x55, #0xA8, #0xFF, #0x00, #0xAA, #0x00, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x55, #0xA8, #0xFF, #0x00, #0x00, #0x00, #0x00
		.db #0xA5, #0x00, #0x5A, #0x00, #0x0F, #0x00, #0x5E, #0x00, #0xFC, #0x00, #0xFC, #0x00
		.db #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0x00, #0xFC, #0xFF, #0x00, #0xAA, #0x50, #0x00
		.db #0xF0, #0x00, #0xF0, #0x00, #0xF0, #0x55, #0xA0, #0xFF, #0x00, #0xAA, #0x00, #0x00
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00
		.db #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0x55, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xAA, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF, #0x00, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0xFF
		.db #0x00, #0xAA, #0x00, #0x00, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0x00
		.db #0xCF, #0x00, #0x8F, #0x00, #0x0F, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54, #0x00
		.db #0xCF, #0x00, #0xCF, #0x00, #0x0F, #0x55, #0x0A, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00, #0x0F, #0xFF, #0x00, #0xFF, #0x00, #0xFF
		.db #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x05, #0x55, #0xA8, #0xFF, #0x00, #0xFF
		.db #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0x00, #0xFC, #0xFF, #0x00, #0xFF
		.db #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xFF, #0x00, #0xAA, #0x54
	_PlayerSpriteAttack:
		.db #6,#20
		.db #0xFF,#0x00,#0xAA,#0x54,#0xFF,#0x00,#0xFF,#0x00,#0xAA,#0x54,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x54,#0x55,#0xA8,#0xFF,#0x00,#0x00,#0xFC,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x54,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00
		.db #0x00,#0xFC,#0x00,#0xAD,#0x00,#0x0F,#0x00,#0xA5,#0x00,#0x5A,#0xAA,#0x00
		.db #0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC
		.db #0xFF,#0x00,#0xAA,#0x50,#0x00,#0xF0,#0x00,#0xF0,#0x00,#0xF0,#0x55,#0xA0
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0x04,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0xAC,#0x00,#0x30,#0x55,#0x20
		.db #0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0x00,#0xAC,#0x00,#0x3C,#0x00,#0x3C
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xCF,#0x00,#0x0E,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xCF,#0x55,#0x0A,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xCF,#0x55,#0x0A,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xCF,#0x55,#0x0A,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00,#0xFF,#0x00
	_PlayerSpriteAttackL:
		.db #6,#20
		.db #0xFF,#0x00,#0x55,#0xA8,#0xFF,#0x00,#0xFF,#0x00,#0x55,#0xA8,#0xFF,#0x00
		.db #0xFF,#0x00,#0x00,#0xFC,#0xFF,#0x00,#0xAA,#0x54,#0x55,#0xA8,#0xFF,#0x00
		.db #0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0x55,#0xA8,#0xFF,#0x00
		.db #0x55,#0x00,#0x00,#0xA5,#0x00,#0x5A,#0x00,#0x0F,#0x00,#0x5E,#0x00,#0xFC
		.db #0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00
		.db #0xAA,#0x50,#0x00,#0xF0,#0x00,#0xF0,#0x00,#0xF0,#0x55,#0xA0,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0xAA,#0x00,#0x00,#0x00,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x00,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x00,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x00,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x00,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x08,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xAA,#0x10,#0x00,#0x30,#0x00,#0x5C,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0x00,#0x3C,#0x00,#0x3C,#0x00,#0x5C,#0x00,#0x00,#0x55,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0x0D,#0x00,#0xCF,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0xAA,#0x05,#0x00,#0xCF,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0xAA,#0x05,#0x00,#0xCF,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0xAA,#0x05,#0x00,#0xCF,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00,#0xFF,#0x00
		.db #0xFF,#0x00,#0xFF,#0x00,#0x00,#0xFC,#0x00,#0xFC,#0xFF,#0x00,#0xFF,#0x00
__endasm;
}



extern const unsigned char Cero[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0x50, 0x50, 0x50
       ,0x50, 0x50, 0x50, 0x50, 0x50, 0xF0, 0x00, 0x00
};

extern const unsigned char Uno[]={
        0x00, 0x00, 0x00, 0xDA, 0x45, 0xF0, 0x00, 0x50
       ,0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x00
};

extern const unsigned char Dos[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0x50, 0x00, 0x50
       ,0x00, 0xCF, 0x45, 0xA0, 0x50, 0xF0, 0x00, 0x00
};

extern const unsigned char Tres[]={
        0x00, 0x00, 0x50, 0xF0, 0x00, 0x50, 0x00, 0xF0
       ,0x00, 0x50, 0x50, 0x50, 0x45, 0xF0, 0x00, 0x00
};

extern const unsigned char Cuatro[]={
        0x00, 0x00, 0x00, 0xDA, 0x00, 0xF0, 0x45, 0xF0
       ,0x50, 0xDA, 0xDA, 0xF0, 0x00, 0xDA, 0x00, 0x00
};

extern const unsigned char Cinco[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0x8A, 0x50, 0xF0
       ,0x00, 0x50, 0x50, 0x50, 0x45, 0xF0, 0x00, 0x00
};

extern const unsigned char Seis[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0x00, 0x50, 0xF0
       ,0x50, 0x50, 0x50, 0x50, 0x45, 0xF0, 0x00, 0x00
};

extern const unsigned char Siete[]={
        0x00, 0x00, 0x50, 0xF0, 0x00, 0x50, 0x00, 0xCF
       ,0x00, 0xA0, 0x00, 0xA0, 0x45, 0xA0, 0x00, 0x00
};

extern const unsigned char Ocho[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0xDA, 0x45, 0xF0
       ,0x50, 0x50, 0x50, 0x50, 0x45, 0xF0, 0x00, 0x00
};

extern const unsigned char Nueve[]={
        0x00, 0x00, 0x45, 0xF0, 0x50, 0x50, 0x50, 0x50
       ,0x45, 0xF0, 0x00, 0x50, 0x50, 0xF0, 0x00, 0x00
};

#endif /* PLAYERS_H_ */
