/**
 * @file  gems.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef GEMS_H_
#define GEMS_H_

#include <cpcrslib.h>
#include "sprites.h"

#define MAX_GEMS 		50
#define GEMS_PER_HIT 	10
#define MAX_GEMS_ARRAY 	5

#define VALUE_GREEN_GEM 1
#define VALUE_RED_GEM 	5
#define VALUE_BLUE_GEM 	10

unsigned char gemsMask[] = { 0,0,0,0,0 };
s_Sprite gems[MAX_GEMS_ARRAY];
void *p_gems[MAX_GEMS_ARRAY];

unsigned char spawningGemsMask;
s_Sprite spawningGem;
void *p_spawningGem;

unsigned int lastSpawn;
unsigned int nextSpawn;

extern const unsigned char greenGemData[]={
 4,10
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00
, 0xAA,0x00,0x00,0xF3,0x00,0x0F,0x55,0x00
, 0x00,0x50,0x00,0xF3,0x00,0xA7,0x00,0x0A
, 0x00,0x50,0x00,0xF3,0x00,0xF3,0x00,0x0A
, 0xAA,0x00,0x00,0xF1,0x00,0xA7,0x55,0x00
, 0xFF,0x00,0x00,0x50,0x00,0x0A,0xFF,0x00
, 0xFF,0x00,0xAA,0x00,0x55,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
};

extern const  unsigned char blueGemData[]={
 4,10
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00
, 0xAA,0x00,0x00,0x30,0x00,0x3C,0x55,0x00
, 0x00,0x50,0x00,0x30,0x00,0x34,0x00,0x28
, 0x00,0x50,0x00,0x30,0x00,0x30,0x00,0x28
, 0xAA,0x00,0x00,0xB0,0x00,0x34,0x55,0x00
, 0xFF,0x00,0x00,0x50,0x00,0x28,0xFF,0x00
, 0xFF,0x00,0xAA,0x00,0x55,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00


};

extern const  unsigned char redGemData[]={
 4,10
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00
, 0xAA,0x00,0x00,0x0C,0x00,0xCC,0x55,0x00
, 0x00,0x50,0x00,0x0C,0x00,0x4C,0x00,0x88
, 0x00,0x50,0x00,0x0C,0x00,0x0C,0x00,0x88
, 0xAA,0x00,0x00,0xA4,0x00,0x4C,0x55,0x00
, 0xFF,0x00,0x00,0x50,0x00,0x88,0xFF,0x00
, 0xFF,0x00,0xAA,0x00,0x55,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
};

extern const unsigned char notShowingGem[]={
		4,10
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
		, 0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00
};

#endif /* GEMS_H_ */
