/**
 * @file  core.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef CORE_H
#define CORE_H
#include "sprites.h"

/*
 *  Function to update player's score
 */
void actScoreP1(char value);

/*
 *  Function to update player's score
 */
void actScoreP2(char value);

/*
 *  Function to update the current time
 */
void actTime(void);

/*
 *  Function to exit from the game
 */
void c_exit(void);

/*
 *  Function to draw the time
 */
void drawTime(void);

/*
 *  Function to draw the score of player2
 */
void drawScoreP2(void);

/*
 *  Function to draw the score of player1
 */
void drawScoreP1(void);

/*
 *  Function to pause the game
 */
void pause(void);

/*
 *  Function to chage the colors according to a palette
 */
void setColours(void);

/*
 *  Function to finish the game
 */
unsigned char endGame();

/*
 *  Functíon to set the tilemap according to a matrix
 */
void setTilemap(void);

/*
 *  Function to get the current time
 */
unsigned int c_getTime(void);

/*
 *  Function to change the state of one player to jumping 
 */
void s_jump(struct s_Sprite * sprite);

/*
 *  Function to check if player can move and act accordingly
 */
int t_canMove(struct s_Sprite *pSprite, unsigned char tileX, unsigned char tileY);   

/*
 *  Function to check if player can move on x-axis or not and move him accordingly
 */
void s_moveX(struct s_Sprite *pSprite, int direction);

/*
 *  Function to check if player can jump or not and move him accordingly
 */
void s_canJump(struct s_Sprite *pSprite);

/*
 *  Function to show menu
 */
void Show_Menu(void);

/*
 *  Function to make the game wait few seconds
 */
void Wait(void);

/*
 *  Function to init the player controls
 */
void init_keyboard(void);

/*
 *  Function to initiate the game menu controls
 */
void init_numbers_keys(void);

/*
 *  Function to redefine keys, player can change default keys
 */
void redefine_keys(void);

/*
 *  Function to disable blink when some time has elapsed after a player recieve an attack
 */
void s_disableBlink();

/*
 *  Function to initiate all the game system
 */
void g_initGemsSystem(void) ;

/*
 *  Function to throw gems when player recieve an attack
 */
void g_throwGems(unsigned char value, s_Sprite *target);

/*
 *  Function to reset gems
 */
void g_resetGems(void);

/*
 *  Function to obtain a pseudo-random number
 */
unsigned char g_random(unsigned char n);

/*
 *  Function to make appear gems
 */
void g_spawnGem(unsigned char type);

/*
 *  Function to update gems situation
 */
void g_updateGems(void);

/*
 *  Function to change some colors from sprite. On this way we have to load just one sprite in memory.
 */
void s_colorizePlayerData(unsigned char * data, unsigned char direction, unsigned char playerIndex);

/*
 *  Function to make all the necessary initializations
 */
void initGame(void);

/*
 *  Function to calculate the distance between player's position and enemy's position
 */
unsigned char calculateDistance(unsigned char n);

#endif
