/**
 * @file  audio.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef AUDIO_H_
#define AUDIO_H_

extern const int EFFECT_TABLE[];
extern const int SONG_TABLE_1[];
extern const int RULE_TABLE_1[];
extern const int SOUND_TABLE_1[];


const unsigned char SONG_1[] = {
	0x03, 0x07, 0x00,0x00, 0x3f,0x00, 0x0f,0x81, 0xbe,0x01, 0xcf,0x17, 0x81,0xbe, 0x01,0x97,
	0xbe,0x41 ,0x00,0x3f, 0x00,0x59, 0x7e,0x13, 0x81,0xbe, 0x01,0x13, 0x81,0xbe, 0x01,0x13,
		0x81,0xbe ,0x01,0x93, 0x01,0x00, 0xc1,0x00, 0xc1,0x00, 0x00 
	};

void asm_data_audio(void) {

	// Music Player requiered data
	__asm

		_SONG_TABLE_1:
			.dw _SONG_1

		_RULE_TABLE_1: 
			.dw PAUTA_0
			
		_SOUND_TABLE_1: 
			.dw SONIDO_0
			
		PAUTA_0:	
			.db	14,0,13,0,12,0,11,0,129
		SONIDO_0: 	
			.db 1711,1614,1524,1438,1358,1281,1210,1142,1078,1017,960,906,855,807,762,719,679,641,605,571,539,509,480,453,428,404,381,360,339,320,302,285,269,254,240,227,214,202,190,180,170,160,151,143,135,127,120,113,107,101,95,90,85,80,76,71,67,64,60,57

		// SFX
		_EFFECT_TABLE:
			.dw _EFECTO0
			.dw _EFECTO1
			.dw _EFECTO2
			.dw _EFECTO3
		_EFECTO0:
			.db #0x58,#0x0D
			.db #0x34,#0x0B
			.db #0x47,#0x0A
			.db #0x3E,#0x06
			.db #0x35,#0x03
			.db #0x50,#0x09
			.db #0xFF,#0x0A
			.db #0x3E,#0x07
			.db #0xFF

		_EFECTO1:
			.db #0x58,#0x0C
			.db #0x5D,#0x0D
			.db #0x61,#0x0E
			.db #0x66,#0x0F
			.db #0x6A,#0x0E
			.db #0x6F,#0x0D
			.db #0x7A,#0x0C
			.db #0x78,#0x0B
			.db #0x7C,#0x0A
			.db #0x85,#0x09
			.db #0x8E,#0x08
			.db #0x97,#0x07
			.db #0xA0,#0x06
			.db #0xA9,#0x05
			.db #0xFF

		_EFECTO2:
			.db #0x1F,#0x0B
			.db #0x1A,#0x0C
			.db #0x1F,#0x0D
			.db #0x16,#0x0E
			.db #0x1F,#0x0E
			.db #0x0D,#0x0D
			.db #0x1F,#0x0C
			.db #0x0D,#0x0B
			.db #0x00,#0x00
			.db #0x00,#0x00
			.db #0x1F,#0x08
			.db #0x1A,#0x09
			.db #0x1F,#0x0A
			.db #0x16,#0x0B
			.db #0x1F,#0x0B
			.db #0x0D,#0x0A
			.db #0x1F,#0x09
			.db #0x0D,#0x07
			.db #0x00,#0x00
			.db #0x00,#0x00
			.db #0x1F,#0x06
			.db #0x1A,#0x07
			.db #0x1F,#0x08
			.db #0x16,#0x08
			.db #0x1F,#0x07
			.db #0x0D,#0x06
			.db #0x1F,#0x05
			.db #0xFF

		_EFECTO3:
			.db #0x1A,#0x0E
			.db #0x1A,#0x0E
			.db #0x00,#0x00
			.db #0x1A,#0x0A
			.db #0x1A,#0x0A
			.db #0x00,#0x00
			.db #0x1A,#0x0C
			.db #0x1A,#0x0C
			.db #0x00,#0x00
			.db #0x1A,#0x08
			.db #0x1A,#0x08
			.db #0xFF
	__endasm;
}

#endif




