MAX_PIPE_VOID equ 15
MAX_ENERGY equ 64
ORIGINAL_SHIP_POINTER equ 198
SPRITE_BAR_START equ &4100
SPRITE_LVL_START equ &4500
SPRITE_SCR0_START equ &4600
SPRITE_SCR1_START equ &4700
BLOCKS_TO_LEVEL_END equ 4

org &2000
run &2000
nolist

xor a
call &bc0e

call unlockASIC

call pageInAsic
call loadSprites
call drawFullEnergy

call vsyncSafe
call initIntRoutine

call loadLevelColors
ld a,1:call copyNumberToLevel

call emptyCollisionData

ld hl,&3fff
ld sp,hl

ld hl,&8000
ld de,&8001
ld (hl),0
ld bc,16384
ldir

mainloop:
;	cpu_performance_bar_end
;;	ld hl,&0000:ld (&6420),hl

	call vsyncSafe
	ld hl,(colore):ld (&6420),hl

;	cpu_performance_bar_start
;;	ld hl,&0f00:ld (&6420),hl

	ld a,(scrollX):and 3:ld e,a:ld a,3:sub e
	add a,a:add a,a
	set 7,a
	ld (&6804),a

	; low vram byte
	ld a,(wordX)
	ld bc,&bc0d
	out (c),c
	inc b
	out (c),a

	; high vram byte
	dec b:dec c:out (c),c
	inc b
	ld a,(wordX+1):and 3
	or 44
	out (c),a

	call writePipe

	ld hl,(scrollX):inc hl:ld (scrollX),hl
	push hl
	ld a,l:and 1:jr nz,noIncByteX
		ld hl,(byteX):inc hl:ld (byteX),hl
	noIncByteX:
	pop hl
	ld a,l:and 3:jr nz,noIncWordX
		ld hl,(wordX):inc hl:ld (wordX),hl
	noIncWordX:

	call keyboard_script
	call moveSprite
	call checkCollision

	call drawScore

	ld hl,(scrollX)
	ld a,h
afto:
	cp BLOCKS_TO_LEVEL_END
	jr nz,nolevelend
	ld a,1:ld (levelEnd),a
	ld a,l:cp 192:jr c,nolevelend
	xor a,a:ld (levelEnd),a
	ld a,(levelNum):inc a:and 7:ld (levelNum),a:ld b,a

	or a,a:jr nz,noRestartLevels
	ld a,BLOCKS_TO_LEVEL_END:ld (afto+1),a
	jr noReduceLevelLength
noRestartLevels:
	cp 5:jr c,noReduceLevelLength
	ld hl,afto+1:dec (hl)
noReduceLevelLength:

	ld a,MAX_PIPE_VOID:sub b:ld (pipeVoid),a
	inc b:ld a,b:call copyNumberToLevel
	call gameover
	call loadLevelColors
nolevelend:

	ld hl,(nframe):inc hl:ld (nframe),hl
	ld a,l:and 1:call z,scoreInc
jp mainloop

levelEnd:
db 0

levelNum:
db 0

pipeVoid:
db MAX_PIPE_VOID

scrollX:
dw 0

byteX:
dw 0
wordX:
dw 0

drawScore:
	ld a,(digits):ld bc,SPRITE_SCR0_START + 7:call copyNumberToScore
	ld a,(digits+1):ld bc,SPRITE_SCR0_START + 12:call copyNumberToScore
	ld a,(digits+2):ld bc,SPRITE_SCR1_START + 2:call copyNumberToScore
	ld a,(digits+3):ld bc,SPRITE_SCR1_START + 7:call copyNumberToScore
	ld a,(digits+4):ld bc,SPRITE_SCR1_START + 12:call copyNumberToScore
ret

scoreDigits:

digits:
ds 5,0

scoreInc:
	ld hl,digits+4
	ld a,(hl):inc a:ld (hl),a:cp 10:ret nz:xor a,a:ld (hl),a:dec hl
	ld a,(hl):inc a:ld (hl),a:cp 10:ret nz:xor a,a:ld (hl),a:dec hl
	ld a,(hl):inc a:ld (hl),a:cp 10:ret nz:xor a,a:ld (hl),a:dec hl
	ld a,(hl):inc a:ld (hl),a:cp 10:ret nz:xor a,a:ld (hl),a:dec hl
	ld a,(hl):inc a:ld (hl),a:cp 10:ret nz:xor a,a:ld (hl),a
ret


loadLevelColors:

	ld de,&6400
	ld hl,colours
	ld bc,32
	ldir

	ld b,16
	ld hl,colours
rotateCols:
	ld e,(hl):inc hl:ld d,(hl)
	ex de,hl
	ld a,l:rra:rra:rra:rra:ld l,a

	ex de,hl:ld (hl),d:dec hl:ld (hl),e:inc hl:inc hl
	dec b
	jr nz,rotateCols

;	call vsyncSafe
;;	ld a,(levelNum):add a:add a:ld (rasterline),a
ret

writeVertical:
; e = chars num
; ix = block

	loopPipeY:
		ld bc,2048
		ld a,(ix):ld (hl),a:add hl,bc
		ld a,(ix+1):ld (hl),a:add hl,bc
		ld a,(ix+2):ld (hl),a:add hl,bc
		ld a,(ix+3):ld (hl),a:add hl,bc
		ld a,(ix+4):ld (hl),a:add hl,bc
		ld a,(ix+5):ld (hl),a:add hl,bc
		ld a,(ix+6):ld (hl),a:add hl,bc
		ld a,(ix+7):ld (hl),a:ld bc,-14336+80
		ld a,h:cp &bf:jr nz,noLastLine
		ld a,l:cp 176:jr c,noLastLine
		ld bc,80
noLastLine:
		add hl,bc
	dec e
	jr nz,loopPipeY


ret

writePipe:
	ld a,(byteX):ld c,a
	ld a,(byteX+1):and 7:ld b,a
dec bc
	ld a,(pipePointer)
	ld h,pipes / 256
	ld l,a

	ld a,(scrollX):and 1:jr nz,noRightSide
	ld a,(pipePointer):inc a:ld (pipePointer),a
	ld a,(shipPointer):inc a:ld (shipPointer),a
noRightSide:

	ld a,(hl):inc a:or a,a:ret z

	ld h,collisionUp / 256
	ld e,a

	ld a,(levelEnd):dec a
	jr nz,nolevelEnd1
	ld e,1
nolevelEnd1:

	ld a,(pipePointer):ld l,a:ld a,e:add a:add a:add a
	sub 10
	jr nc,noUnder
	xor a,a
noUnder:
	ld (hl),a:ld d,a

	ld a,(pipeVoid):ld l,a
	ld a,26:sub e:sub l:;sub oldPipeVoid:ld iyl,a

	ld hl,&8000
	add hl,bc
	ld ix,block1
	call writeVertical
	ld e,a:ld a,r:and 50:add a,e
	add l:add h:add b:add c:add d:add e:add e:add e:and 3:ld e,a:;ld a,oldPipeVoid:ld a,(pipeVoid):add e:ld e,a

	ld a,(levelEnd):dec a
	jr nz,nolevelEnd2
	ld e,32
nolevelEnd2:
	ld a,e

	push hl
	add a:add a:add a:add d:sub 13:ld d,a
	ld h,collisionDown / 256
	ld a,(pipePointer):ld l,a:ld (hl),d
	pop hl


	ld ix,block0
	call writeVertical

	ld a,(levelEnd):dec a
	jr nz,nolevelEnd3
	ld e,1
	jr posdoulevei
nolevelEnd3:
	ld e,iyl
posdoulevei:
	ld ix,block1
	call writeVertical
ret

pipePointer:
db 0

shipPointer:
db ORIGINAL_SHIP_POINTER

vsyncSafe:
	push af:push bc

	ld b,&f5
	vsync1:
		in a,(c)
		rra
	jr nc,vsync1

	vsync2:
		in a,(c)
		rra
	jr c,vsync2

	pop bc:pop af
ret

moveSprite:

	ld hl,(spriteX)
	ld (&6000),hl

	ld hl,(velocY):ex de,hl
	ld hl,(spriteY):add hl,de:ld (spriteY),hl

	ld a,h:cp a,4
	jr nc,notTouchedCeiling
	ld h,4
	ld (spriteY),hl
notTouchedCeiling:
	
	ld a,h:cp 184
	jr c,notTouchedFloor
	ld l,184
	xor a,a:ld (velocY),a:ld (velocY+1),a
	jr touchedFloor
notTouchedFloor:
	ld l,h:ld h,0:ld (&6002),hl
	ld hl,(accelY):ex de,hl:add hl,de:ld (velocY),hl
touchedFloor:
ret

checkCollision:
	ld a,(shipPointer):ld l,a:ld h,collisionUp/256:ld b,(hl):inc h:ld c,(hl)
	ld hl,(spriteY):ld a,h
	cp b
	jr c,collided
	cp c
	jr nc,collided
	jr noCollide

collided:
	ld hl,(colore):ld bc,128:add hl,bc:ld h,0:ld (colore),hl
	ld hl,energy:ld a,(hl):dec a:ld (hl),a
	jr nz,stillAlive
	call gameOver
	call moreGameOver
stillAlive:
	cp 62
	jr c,noclamp62
	ld a,62
noclamp62:

	ld b,0
	call drawEnergyVertical
	ret
noCollide:
	ld hl,&0000:ld (colore),hl
ret

emptyCollisionData:
ld hl,collisionUp:ld (hl),0:ld de,collisionUp+1:ld bc,255:ldir
ld hl,collisionDown:ld (hl),255:ld de,collisionDown+1:ld bc,255:ldir
ret

reInit:
di
ld a,MAX_ENERGY:ld (energy),a
ld a,ORIGINAL_SHIP_POINTER:ld (shipPointer),a
xor a,a:ld (pipePointer),a
ld (levelEnd),a


ld hl,0
ld (nframe),hl
ld (scrollX),hl
ld (byteX),hl
ld (wordX),hl
ld (velocY),hl

ld hl,160:ld (spriteX),hl
ld hl,40*256:ld (spriteY),hl
ld hl,32:ld (accelY),hl

call emptyCollisionData

ld hl,&8000:ld de,&8001:ld (hl),0:ld bc,32767:ldir

ret

gameOver:
call reInit
call drawFullEnergy
ret

moreGameOver:
	xor a,a:ld (levelNum),a
	ld hl,digits
	ld (hl),a:inc hl
	ld (hl),a:inc hl
	ld (hl),a:inc hl
	ld (hl),a:inc hl
	ld (hl),a:inc hl
	inc a:call copyNumberToLevel
	ld hl,coloursLvl1:ld de,colours:ld bc,32:ldir
	ld hl,colours:ld de,&6400:ld bc,32:ldir
	ld a,BLOCKS_TO_LEVEL_END:ld (afto+1),a
	call drawFullEnergy
ret

drawEnergyVertical:
; a = column
; b = color

	ld h,SPRITE_BAR_START / 256
	ld l,a:srl a:srl a:srl a:srl a:add SPRITE_BAR_START / 256:ld h,a
	ld a,l:and 15:ld l,a

	ld c,12
	ld de,16:add hl,de:add hl,de
	drawVerticalColumn:
		ld (hl),b:add hl,de
		dec c
	jr nz,drawVerticalColumn
ret

drawFullEnergy:

ld b,2:ld c,62
drawEnergyColumns:
	push bc
	ld a,b:ld d,a:srl b:srl b
	ld a,b:or a,a:jr nz,nozerobar
	ld a,1
nozerobar:
	ld b,a:ld a,d
	call drawEnergyVertical
	pop bc
	inc b
	ld a,b:cp c
jr nz,drawEnergyColumns

ret

energy:
db MAX_ENERGY

colore:
dw &0000

loadSprites:

; UFO
	ld b,0
	ld c,0
	ld de,&4000
	ld hl,sprite
	loopSprite:
		ld a,(hl):inc hl
		cp 4
		jr nc,okis
		xor a,a
okis:
		ld (de),a
		inc de
		dec b
	jr nz,loopSprite

	ld hl,sprite_colours
	ld de,&6422
	ld bc,15*2
	ldir

	call moveSprite

	ld a,%1001
	ld (&6004),a

;BARS
	ld hl,spriteBarLeft
	ld de,SPRITE_BAR_START
	ld bc,512
	ldir
	dec h
	ld bc,512
	ldir

	ld a,%1101
	ld (&600c),a
	ld (&6014),a
	ld (&601c),a
	ld (&6024),a

	ld hl,320+48:ld (&6008),hl:ld hl,8:ld (&600a),hl
	ld hl,320+48 + 64:ld (&6010),hl:ld hl,8:ld (&6012),hl
	ld hl,320+48 + 128:ld (&6018),hl:ld hl,8:ld (&601a),hl
	ld hl,320+48 + 192:ld (&6020),hl:ld hl,8:ld (&6022),hl

; LVL

	ld hl,spriteLevel
	ld de,SPRITE_LVL_START
	ld bc,256
	ldir

	ld a,%1110
	ld (&602c),a
	ld hl,20:ld (&6028),hl:ld hl,6:ld (&602a),hl

; SCORE
	ld hl,SPRITE_SCR0_START
	ld de,SPRITE_SCR0_START+1
	ld (hl),0
	ld bc,511
	ldir

	ld a,%1110
	ld (&6034),a
	ld (&603c),a
	ld hl,504:ld (&6030),hl:ld hl,180:ld (&6032),hl
	ld hl,504+64:ld (&6038),hl:ld hl,180:ld (&603a),hl

ret

copyNumberToLevel:
;a = number

dec a
add a:add a:add a:add a:add a
ld h,numbers/256
ld l,a

ld de,SPRITE_LVL_START + 12

ld b,8
writeNumberLoop:
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,e:add 12:ld e,a
	dec b
jr nz,writeNumberLoop

ret

copyNumberToScore:
;a = number
;bc = offset
ld h,0:ld l,a:add hl,hl:add hl,hl:add hl,hl:add hl,hl:add hl,hl
ld de,numbers0
add hl,de

ld d,b:ld e,c

ld b,8
writeNumberLoop2:
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,(hl):ld (de),a:inc l:inc e
	ld a,e:add 12:ld e,a
	dec b
jr nz,writeNumberLoop2

ret

spriteX:
dw 160
spriteY:
dw 40*256

velocY:
dw 0
accelY:
dw 32

; ===== CPC Input functions =====

keyboard_script:
call keyscan
ld ix,keymap

bit 7,(IX+5)		; check Space
call z,keyActionSpace	; if pressed do action

bit 1,(IX)			; check Right Arrow
call z,keyActionRightArrow	; if pressed do action

ret


keyActionSpace:
ld hl,-480: ld (velocY),hl
ret

keyActionRightArrow:
ld hl,(spriteX):inc hl:ld (spriteX),hl
ret


; ---- Keyboard Scan ----
; Changes A, BC, DE

keyscan:
di
ld hl,keymap
ld bc,#f782:out (c),c
ld bc,#f40e:ld e,b:out (c),c
ld bc,#f6c0:ld d,b:out (c),c
ld c,0:out (c),c
ld bc,#f792:out (c),c

ld a,#40:ld c,#4a
keyscan_loop:
ld b,d:out (c),a
ld b,e:ini
inc a:cp c
jr c,keyscan_loop
ld bc,#f782:out (c),c
ei
ret

keymap:
ds 10,0	; 10 lines

;;Line 	7 	6 	5 	4 	3 	2 	1 	 0
;;&40 	F Dot 	ENTER 	F3 	F6 	F9 	CURDOWN CURRIGHT CURUP
;;&41 	F0 	F2 	F1 	F5 	F8 	F7 	COPY 	CURLEFT
;;&42 	CTRL 	\ 	SHIFT 	F4 	] 	RETURN 	[ 	CLR
;;&43 	. 	/ 	 : 	 ; 	P 	@ 	- 	^
;;&44 	, 	M 	K 	L 	I 	O 	9 	0
;;&45 	SPACE 	N 	J 	H 	Y 	U 	7 	8
;;&46 	V 	B 	F 	G 	T 	R 	5 	6
;;&47 	X 	C 	D 	S 	W 	E 	3 	4
;;&48 	Z 	CAPSLOCK 	A 	TAB 	Q 	ESC 	2 	1
;;&49 	DEL 	- 	- 	- 	- 	- 	- 	- 


unlockASIC:
	di
	ld b,&bc
	ld hl,sequence
	ld e,17
	seq:
		ld a,(hl)
		out (c),a
		inc hl
		dec e
	jr nz,seq
	ei
ret

pageInAsic:
	ld bc,&7fb8:out (c),c
ret

sequence:
db &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee

nframe:
dw 0

list
malaka:
nolist

org &2600

pipes:
;db 0,0,0,0,3,2,3,3,0,0,0,0,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,4,4,0,0,0,0,5,6,3,4,0,0,0,0,3,4,3,2,0,0,0,0,3,3,3,3
;db 0,0,0,0,3,3,2,3,0,0,0,0,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,4,4,0,0,0,0,4,4,3,4,0,0,0,0,3,4,3,2,0,0,0,0,3,3,3,3
;db 0,0,0,0,3,2,3,3,0,0,0,0,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,4,4,0,0,0,0,4,3,3,4,0,0,0,0,3,4,3,2,0,0,0,0,3,3,3,3
;db 0,0,0,0,3,3,2,3,0,0,0,0,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,4,4,0,0,0,0,3,3,3,3,0,0,0,0,3,4,3,2,0,0,0,0,3,3,3,3

db 0,0,0,0,1,2,3,3,0,0,0,0,6,6,7,7,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,6,7,5,6,0,0,0,0,5,6,3,4,0,0,0,0,4,7,8,8,0,0,0,0,3,4,6,2
db 0,0,0,0,1,3,2,3,0,0,0,0,6,6,6,7,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,6,7,5,6,0,0,0,0,4,4,3,4,0,0,0,0,4,7,8,7,0,0,0,0,3,4,6,2
db 0,0,0,0,1,2,3,3,0,0,0,0,5,5,5,7,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,6,7,5,5,0,0,0,0,4,3,3,4,0,0,0,0,4,7,8,6,0,0,0,0,3,4,6,2
db 0,0,0,0,1,3,2,3,0,0,0,0,4,5,4,6,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,6,6,5,4,0,0,0,0,3,3,3,3,0,0,0,0,3,7,7,5,0,0,0,0,3,4,6,2


sprite_colours:
defw &0111
defw &0222
defw &0333
defw &0444
defw &0555
defw &0666
defw &0777
defw &0888
defw &0999
defw &0aaa
defw &0bbb
defw &0ccc
defw &0ddd
defw &0eee
defw &0fff

block0:
db 0,0,0,0,0,0,0,0

block1:
db 15,15,56,23,127,111,56,23

colours:
defw &0000
defw &0131
defw &0262
defw &0383

defw &0483
defw &0483
defw &0593
defw &0594

defw &0694
defw &0795
defw &08a5
defw &09b6

defw &0ac7
defw &0ad8
defw &0ae9
defw &0afa

coloursLvl1:
defw &0000
defw &0131
defw &0262
defw &0383

defw &0483
defw &0483
defw &0593
defw &0594

defw &0694
defw &0795
defw &08a5
defw &09b6

defw &0ac7
defw &0ad8
defw &0ae9
defw &0afa


sprite:
db 0,0,0,0, 0,0,1,1, 1,1,0,0, 0,0,0,0
db 0,0,0,0, 1,1,2,3, 3,2,1,1, 0,0,0,0
db 0,0,0,1, 2,4,4,4, 4,4,4,2, 1,0,0,0
db 0,0,1,3, 5,5,6,6, 6,6,5,5, 3,1,0,0
db 0,1,3,4, 5,6,7,8, 8,7,6,5, 4,3,1,0
db 0,1,2,5, 6,7,9,10,10,9,7,6, 5,2,1,0
db 1,2,3,6, 8,10,11,12, 12,11,10,8, 6,3,2,1
db 1,2,4,8, 10,13,14,15, 15,14,13,10, 8,4,2,1

db 1,2,4,8, 10,13,14,15, 15,14,13,10, 8,4,2,1
db 1,2,3,6, 8,10,11,12, 12,11,10,8, 6,3,2,1
db 0,1,2,5, 6,7,9,10, 10,9,7,6, 5,2,1,0
db 0,1,3,4, 5,6,7,8, 8,7,6,5, 4,3,1,0
db 0,0,1,3, 5,5,6,6, 6,6,5,5, 3,1,0,0
db 0,0,0,1, 2,4,4,4, 4,4,4,2, 1,0,0,0
db 0,0,0,0, 1,1,2,3, 3,2,1,1, 0,0,0,0
db 0,0,0,0, 0,0,1,1, 1,1,0,0, 0,0,0,0

spriteBarLeft:
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0

db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9

spriteBarCenter:
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0

db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9

spriteBarRight:
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9

db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9
db 9,9,9,9, 9,9,9,9, 9,9,9,9, 9,9,9,9

spriteLevel:
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	10,0,10,0, 10,0,0,0, 	0,0,0,0
db 0,10,0,0,	0,10,0,0, 10,0,0,0, 	0,0,0,0
db 0,10,10,10, 0,10,0,0, 10,10,10,0, 0,0,0,0

db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0
db 0,0,0,0,	0,0,0,0, 0,0,0,0, 	0,0,0,0

rasterline:
db 0

initIntRoutine:
	di
	xor a,a:ld (&6800),a
	ld hl,intRoutineEnd
	ld bc,intRoutineStart
	sbc hl,bc
	ld b,h:ld c,l
	ld hl,intRoutineStart
	ld de,&38
	ldir
	ei
ret

intRoutineStart:
	push af:push bc
	ld a,(rasterline)
	ld b,a
	rlca:rlca:rlca:rlca:ld c,a
	nop:nop:nop:nop:nop:nop:nop:nop
	nop:nop:nop:nop

	ld a,(levelNum):and 1:jr z,case1
	ld a,b
case1:
	or c
nocase:
	ld c,a
	ld a,(levelNum):and 3:jr nz,case3
	ld a,b
	jr spatali
case3:
	ld a,c
spatali:
	ld (&6400),a
	ld a,(rasterline):add a,16:ld (rasterline),a:ld (&6800),a
	pop bc:pop af
	ei
	ret
intRoutineEnd:

list
thend:
nolist


org &2ce0
numbers0:

db 0,15,15,0
db 15,0,0,15
db 15,0,0,15
db 15,0,0,15
db 15,0,0,15
db 15,0,0,15
db 15,0,0,15
db 0,15,15,0

org &2d00
numbers:

db 0,0,0,15
db 0,0,15,15
db 0,15,0,15
db 0,0,0,15
db 0,0,0,15
db 0,0,0,15
db 0,0,0,15
db 0,0,0,15

db 0,15,15,0
db 15,0,0,15
db 0,0,0,15
db 0,0,0,15
db 0,0,15,0
db 0,15,0,0
db 15,0,0,0
db 15,15,15,15

db 0,15,15,0
db 15,0,0,15
db 0,0,0,15
db 0,15,15,0
db 0,0,0,15
db 0,0,0,15
db 15,0,0,15
db 0,15,15,0

db 15,0,15,0
db 15,0,15,0
db 15,0,15,0
db 15,0,15,0
db 15,15,15,15
db 0,0,15,0
db 0,0,15,0
db 0,0,15,0

db 15,15,15,15
db 15,0,0,0
db 15,0,0,0
db 15,15,15,0
db 0,0,0,15
db 0,0,0,15
db 0,0,0,15
db 15,15,15,0

db 0,0,15,15
db 0,15,0,0
db 15,0,0,0
db 15,0,0,0
db 15,15,15,0
db 15,0,0,15
db 15,0,0,15
db 0,15,15,0

db 15,15,15,15
db 0,0,0,15
db 0,0,0,15
db 0,0,15,0
db 0,0,15,0
db 0,15,0,0
db 0,15,0,0
db 0,15,0,0

db 0,15,15,0
db 15,0,0,15
db 15,0,0,15
db 0,15,15,0
db 15,0,0,15
db 15,0,0,15
db 15,0,0,15
db 0,15,15,0

db 0,15,15,0
db 15,0,0,15
db 15,0,0,15
db 0,15,15,15
db 0,0,0,15
db 0,0,0,15
db 0,0,15,0
db 15,15,0,0

list
theend:
nolist

org &3800
collisionUp:
;ds 256,0
org &3900
collisionDown:
;ds 256,255
