nolist

.amstrad		equ 1
.reverse		equ 1
.disable_collision	equ 0
.no_object_bug		equ 0
.bonus_sector		equ 9
.extra_delay		equ 8000

if amstrad
  read "inks.asm"
endif

macro hl_scr x,y
  if amstrad
    if y = 21
      ld hl,y * #3c + x + x + #c006 - #78
    elseif y = 22
      ld hl,y * #3c + x + x + #c00a - #78
    else
      ld hl,y * #3c + x + x + #c000 - #78
    endif
  else
    .@y7 equ y and 7 * #20
    .@y8 equ y / 8 * #800
    ld hl,@y7 + @y8 + x + #4000
  endif
endm

macro sound_reg r, n
  ifnot 'c' = 'n'
    ld c,n
  endif
  ifnot 'a' = 'r'
    ld a,r
  endif
  rst #18
endm

if amstrad
  org #57dd
  run move
  write direct "a:death"
else
  org #5b00
endif

if amstrad

  ; Spectrum Character set
  .exp_char_orig
  ds #23, #ff

  .norm_char_orig
  db #00,#00,#00,#00,#00,#00,#00,#00
  db #00,#10,#10,#10,#10,#00,#10,#00
  db #00,#24,#24,#00,#00,#00,#00,#00
  db #00,#24,#7e,#24,#24,#7e,#24,#00
  db #00,#08,#3e,#28,#3e,#0a,#3e,#08
  db #00,#62,#64,#08,#10,#26,#46,#00
  db #00,#10,#28,#10,#2a,#44,#3a,#00
  db #00,#08,#10,#00,#00,#00,#00,#00
  db #00,#04,#08,#08,#08,#08,#04,#00
  db #00,#20,#10,#10,#10,#10,#20,#00
  db #00,#00,#14,#08,#3e,#08,#14,#00
  db #00,#00,#08,#08,#3e,#08,#08,#00
  db #00,#00,#00,#00,#00,#08,#08,#10
  db #00,#00,#00,#00,#3e,#00,#00,#00
  db #00,#00,#00,#00,#00,#18,#18,#00
  db #00,#00,#02,#04,#08,#10,#20,#00
  db #00,#3c,#46,#4a,#52,#62,#3c,#00
  db #00,#18,#28,#08,#08,#08,#3e,#00
  db #00,#3c,#42,#02,#3c,#40,#7e,#00
  db #00,#3c,#42,#0c,#02,#42,#3c,#00
  db #00,#08,#18,#28,#48,#7e,#08,#00
  db #00,#7e,#40,#7c,#02,#42,#3c,#00
  db #00,#3c,#40,#7c,#42,#42,#3c,#00
  db #00,#7e,#02,#04,#08,#10,#10,#00
  db #00,#3c,#42,#3c,#42,#42,#3c,#00
  db #00,#3c,#42,#42,#3e,#02,#3c,#00
  db #00,#00,#00,#10,#00,#00,#10,#00
  db #00,#00,#10,#00,#00,#10,#10,#20
  db #00,#00,#04,#08,#10,#08,#04,#00
  db #00,#00,#00,#3e,#00,#3e,#00,#00
  db #00,#00,#10,#08,#04,#08,#10,#00
  db #00,#3c,#42,#04,#08,#00,#08,#00
  db #00,#3c,#4a,#56,#5e,#40,#3c,#00
  db #00,#3c,#42,#42,#7e,#42,#42,#00
  db #00,#7c,#42,#7c,#42,#42,#7c,#00
  db #00,#3c,#42,#40,#40,#42,#3c,#00
  db #00,#78,#44,#42,#42,#44,#78,#00
  db #00,#7e,#40,#7c,#40,#40,#7e,#00
  db #00,#7e,#40,#7c,#40,#40,#40,#00
  db #00,#3c,#42,#40,#4e,#42,#3c,#00
  db #00,#42,#42,#7e,#42,#42,#42,#00
  db #00,#3e,#08,#08,#08,#08,#3e,#00
  db #00,#02,#02,#02,#42,#42,#3c,#00
  db #00,#44,#48,#70,#48,#44,#42,#00
  db #00,#40,#40,#40,#40,#40,#7e,#00
  db #00,#42,#66,#5a,#42,#42,#42,#00
  db #00,#42,#62,#52,#4a,#46,#42,#00
  db #00,#3c,#42,#42,#42,#42,#3c,#00
  db #00,#7c,#42,#42,#7c,#40,#40,#00
  db #00,#3c,#42,#42,#52,#4a,#3c,#00
  db #00,#7c,#42,#42,#7c,#44,#42,#00
  db #00,#3c,#40,#3c,#02,#42,#3c,#00
  db #00,#fe,#10,#10,#10,#10,#10,#00
  db #00,#42,#42,#42,#42,#42,#3c,#00
  db #00,#42,#42,#42,#42,#24,#18,#00
  db #00,#42,#42,#42,#42,#5a,#24,#00
  db #00,#42,#24,#18,#18,#24,#42,#00
  db #00,#82,#44,#28,#10,#10,#10,#00
  db #00,#7e,#04,#08,#10,#20,#7e,#00
  db #00,#0e,#08,#08,#08,#08,#0e,#00
  db #00,#00,#40,#20,#10,#08,#04,#00
  db #00,#70,#10,#10,#10,#10,#70,#00
  db #00,#10,#38,#54,#10,#10,#10,#00
  db #00,#00,#00,#00,#00,#00,#00,#ff
  db #00,#1c,#22,#78,#20,#20,#7e,#00
  db #00,#00,#38,#04,#3c,#44,#3c,#00
  db #00,#20,#20,#3c,#22,#22,#3c,#00
  db #00,#00,#1c,#20,#20,#20,#1c,#00
  db #00,#04,#04,#3c,#44,#44,#3c,#00
  db #00,#00,#38,#44,#78,#40,#3c,#00
  db #00,#0c,#10,#18,#10,#10,#10,#00
  db #00,#00,#3c,#44,#44,#3c,#04,#38
  db #00,#40,#40,#78,#44,#44,#44,#00
  db #00,#10,#00,#30,#10,#10,#38,#00
  db #00,#04,#00,#04,#04,#04,#24,#18
  db #00,#20,#28,#30,#30,#28,#24,#00
  db #00,#10,#10,#10,#10,#10,#0c,#00
  db #00,#00,#68,#54,#54,#54,#54,#00
  db #00,#00,#78,#44,#44,#44,#44,#00
  db #00,#00,#38,#44,#44,#44,#38,#00
  db #00,#00,#78,#44,#44,#78,#40,#40
  db #00,#00,#3c,#44,#44,#3c,#04,#06
  db #00,#00,#1c,#20,#20,#20,#20,#00
  db #00,#00,#38,#40,#38,#04,#78,#00
  db #00,#10,#38,#10,#10,#10,#0c,#00
  db #00,#00,#44,#44,#44,#44,#38,#00
  db #00,#00,#44,#44,#28,#28,#10,#00
  db #00,#00,#44,#54,#54,#54,#28,#00
  db #00,#00,#44,#28,#10,#28,#44,#00
  db #00,#00,#44,#44,#44,#3c,#04,#38
  db #00,#00,#7c,#08,#10,#20,#7c,#00
  db #00,#0e,#08,#30,#08,#08,#0e,#00
  db #00,#08,#08,#08,#08,#08,#08,#00
  db #00,#70,#10,#0c,#10,#10,#70,#00
  db #00,#14,#28,#00,#00,#00,#00,#00
  db #3c,#42,#99,#a1,#a1,#99,#42,#3c
else
  org #5b00
endif

.new_tree_buff	ds #100		; Must be page-aligned

if amstrad
.tree_addr 	dw tree_code
                ds #34
		dw zero_column
endif

ds #5cb0 - $
.random_seed	dw 0

ds #10e

.vars_start
.drawn_attr		db 0	; 5dc0
.drawn_lean		db 0	; 5dc1 - Lean of enemy bike (-1, 0, 1)
.enemy1_mv_cnt		db 0	; 5dc2 - Count for enemy direction change
.enemy2_mv_cnt		db 0	; 5dc3
.enemy1_lean		db 0	; 5dc4
.enemy2_lean		db 0	; 5dc5
.enemy1_x		db 0	; 5dc6
.enemy2_x		db 0	; 5dc7
.active_enemies		db 0	; 5dc8

.kempston		db 0	; 5dc9
.object_x		db 0	; 5dca - X of heli or tank
.object_flags		db 0	; 5dcb - 0=Draw left, 1=Draw right, 5=Existing, 7=Exploding
.object_count		db 0	; 5dcc - Count until object displayed or exploded
.obj_scr_index		dw 0	; 5dcd - Index into screen row base table

.random_base		dw 0	; 5dcf

.sector			db 0	; 5dd1
.enemy_count		db 0	; 5dd2
.day_night		db 0	; 5dd3

.unused1		db 0	; 5dd4

.range_count		db 0	; 5dd5 - Number of frames to move range
.enemy_dist		db 0	; 5dd6

.shooting		db 0	; 5dd7
.shot_x			db 0	; 5dd8
.shot_count		db 0	; 5dd9
.shot_scr_index		dw 0	; 5dda - Index into screen row base table
.shot_source		dw 0	; 5ddc

.enemy_exploding	db 0	; 5dde

.handle_pos		db 0	; 5ddf

.explosion_cnt		db 0	; 5de0
.explosion_offs		db 0	; 5de1
.explosion_src		dw 0	; 5de2
.explosion_scr_addr	dw 0	; 5de4

.tree_clear_bytes	dw 0	; 5de6

.is_moving		db 0	; 5de8
.sector_dec		db 0	; 5de9

.unused2		db 0	; 5dea

.reset_check		db 0	; 5deb
.speed_delay		db 0	; 5dec


;; Only used on Amstrad version
.enemy_shown		db 0	; 5ded
.drawn_enemy1_x		db 0	; 5dee
.drawn_enemy2_x		db 0	; 5def

.drawn_obj_left		db 0	; 5df0
.drawn_obj_right	db 0	; 5df1
.drawn_obj_index	db 0	; 5df2

ds #0e

.move_trees
ld a,(is_moving)
dec a
ret nz
ld a,(new_tree_seq)
and a
rrca
ld (new_tree_seq),a
jr nc,l5e21
call random
ld h,new_tree_buff / #100
and #7f
add #20
ld l,a
ld de,next_tree_row + 30
ld bc,30
lddr

.l5e21
ld hl,end_trees - #21
.tree_scroll_ofs equ $ + 1
ld de,end_trees - 1
ld bc,end_trees - tree_buffer
lddr
xor a

; Move some trees left at bottom
ld b,#0d
ld hl,end_trees - #40 + 2	; 2 rows back
ld de,end_trees - #40 + 1
.tree_rows_left equ $ + 1
ld a,#0e			; Number of bytes - 1 to move left
.l5e37
push bc
push de
ld b,#00
ld c,a
ldir
dec l
ld (hl),#00
pop hl
ld de,-#20
add hl,de
push hl
inc hl
pop de
pop bc
bit 1,b
jr z,l5e51
dec a
jr z,l5e53
.l5e51
djnz l5e37

; Move some trees right at bottom
.l5e53
ld b,#0d
ld hl,end_trees - #40 + 29
ld de,end_trees - #40 + 30
.tree_rows_right equ $ + 1
ld a,#0d			; Number of bytes - 1 to move right
.l5e5d
push bc
push de
ld b,#00
ld c,a
lddr
inc l
ld (hl),#00
pop hl
ld de,-#20
add hl,de
push hl
dec hl
pop de
pop bc
bit 1,b
jr z,l5e77
dec a
jr z,l5e79
.l5e77
djnz l5e5d

.l5e79
xor a
ld b,#06
ld hl,next_tree_row
ld de,next_tree_row + 1
ld (hl),a
ld bc,31
ldir

; Move trees 3 rows up extra left
ld hl,end_trees - #60 + 2
ld de,end_trees - #60 + 1
.extra_trees_left equ $ + 1
ld bc,#000e
ldir
ld (de),a

; Move trees 2 rows up extra left
ld de,end_trees - #40 + 1
ld hl,end_trees - #40 + 2
ld bc,#000e
ldir
ld (de),a

; Move trees 2 rows up extra right
ld hl,end_trees - #40 + 29
ld de,end_trees - #40 + 30
ld bc,#000d
lddr
ld (de),a

; Remove existing right tree sections
ld hl,end_trees - #60
ld bc,#0040
.l5eb2
ld a,#40
cpir
dec hl
ld (hl),#00
inc hl
ld a,b
or c
jr nz,l5eb2

; Add the right tree sections
ld hl,end_trees - #60
ld bc,#0040
.l5ec4
ld a,#20
cpir
ld (hl),#40
ld a,b
or c
jr nz,l5ec4

; Final (nearest row is double-width)
; Move left extra 4 times
xor a
ld b,#04
.l5ed1
push bc
ld hl,end_trees - #20 + 1
ld de,end_trees - #20
ld bc,#000f
ldir
ld (de),a
pop bc
djnz l5ed1

; Replace #20 with #20, #20, #40, #40
ld bc,#0020
ld a,#20
ld hl,end_trees - #20
.l5ee9
cpir
ld (hl),#20
inc hl
ld (hl),#40
inc hl
ld (hl),#40
ld de,end_trees - 2
ex de,hl
and a
sbc hl,de
ex de,hl
jr nc,l5ee9
ret

.test_left_right
ld hl,tree_scroll_ofs
ld ix,handle_offs
ld a,(kempston)
if amstrad
  or a
  jr z,l5f18
  ld a,(ktab + 9)
  bit 3,a
  jr z,handle_right
  bit 2,a
  jr z,handle_left
else
  bit 0,a
  jr z,l5f18
  in a,(#1f)
  bit 0,a
  jr nz,handle_right
  bit 1,a
  jr nz,handle_left
endif
jr handle_straight

.l5f18
if amstrad
  ld a,(ktab + 8)
  bit 7,a
  jr z,handle_left
  ld a,(ktab + 7)
  bit 7,a
else
  ld a,#f7	; Key row 3
  in a,(#fe)
  bit 0,a		; Key 1
  jr z,handle_left
  ld a,#ef	; Key row 4
  in a,(#fe)
  bit 0,a		; Key 0
endif
jr nz,handle_straight

.handle_right
ld a,(handle_pos)
cp #01
ret z
ld a,end_trees - 2
ld (hl),a
if amstrad
  inc hl
  ld (hl),end_trees - 2 / 256
  ld (ix + 1),tile_handle_right / 256
endif
ld (ix+#00),tile_handle_right
ld hl,tree_rows_right
ld (hl),5
ld a,#01
ld (handle_pos),a
ld a,30
ld (extra_trees_left),a
jp draw_handle_bars

.handle_left
ld a,(handle_pos)
cp #ff
ret z
ld a,end_trees
ld (hl),a
if amstrad
  inc hl
  ld (hl),end_trees / 256
  ld (ix + 1),tile_handle_left / 256
endif
ld (ix+#00),tile_handle_left
ld hl,tree_rows_left
ld (hl),8
ld a,-1
ld (handle_pos),a
ld a,2
ld (extra_trees_left),a
jp draw_handle_bars

.handle_straight
ld a,(handle_pos)
cp #00
ret z
ld a,end_trees - 1
ld (hl),a
if amstrad
  inc hl
  ld (hl),end_trees - 1 / 256
  ld (ix + 1),tile_handle_straight / 256
endif
ld (ix+#00),tile_handle_straight
ld hl,tree_rows_left
ld (hl),14
ld hl,tree_rows_right
ld (hl),13
ld a,14
ld (extra_trees_left),a
xor a
ld (handle_pos),a
jp draw_handle_bars

.draw_trees
if amstrad
  ld hl,extra_delay
  .slow_down
  dec hl
  ld a,h
  or l
  jr nz,slow_down

  ld (enemy_shown),a
  ld (drawn_obj_left),hl

  ld hl,(enemy1_x)
  ld (drawn_enemy1_x),hl

  ld a,(speed_delay)
  add a
  add 4
  sound_reg 3,a

  ld ix,tree_addr + 6
else
  ld ix,left_tree_table
endif
ld de,-#20
ld hl,end_trees - #20 + 1
ld bc,30 * #100 + 1	; 30 chars wide
.l5f96
push ix
push de
push hl
push bc
push bc
ld c,#01
ld a,(speed_delay)
ld b,a
.l5fa2
dec bc
ld a,b
or c
jr nz,l5fa2
pop bc
ld b,24			; 24 depth buffer
.l5faa
ld a,(hl)
cp #20
jr nc,l5fb8
add hl,de
inc ix
inc ix
ifnot amstrad
  inc ix
endif
djnz l5faa

.l5fb8
cp #40		; Two chars wide?
jr z,tree_right
if amstrad
  ld l,(ix + 0)
  ld h,(ix + 1)
  jr l5fe6
else
  ld a,(ix+#00)
  cp #00
  jr z,l5fd8
  ld l,(ix+#01)
  ld h,(ix+#02)
  push bc
  ld bc,6 * 9		; 6 chars high
  ld de,tree_col_buff
  ldir
  pop bc
  ld de,tree_6_col	; 5 chars above are blank
  jr l5fe6

  .l5fd8
  ld e,(ix+#01)
  ld d,(ix+#02)
  jr l5fe6
endif

.tree_right
if amstrad
  ld l,(ix - 6)
  ld h,(ix - 5)
else
  ld e,(ix-#08)
  ld d,(ix-#07)
endif

.l5fe6
if amstrad
  ld hy,0
  ld a,c
  sub #0d
  cp #14 - #0d
  jr nc,l5ff7
  inc hy
else
  ld b,18
  ld ix,scr_row_2_addr
  ld a,c
  cp #0d
  jr c,l5ff7
  cp #14
  jr nc,l5ff7
  ld b,16
endif

.l5ff7
if amstrad
  ld a,c
  add a
  ld e,a
  ld d,#c0
  ld bc,#c83c
  xor a
  call call_hl
else
  push bc
  ld a,c
  add (ix+#00)
  ld l,a
  ld h,(ix+#02)
  ld a,(de)
  ld (hl),a
  inc de
  ld h,(ix+#01)
  ld b,#08
  .l6008
  ld a,(de)
  ld (hl),a
  inc h
  inc de
  djnz l6008
  ex af,af'
  xor #10
  out (#fe),a
  ex af,af'
  pop bc
  inc ix
  inc ix
  inc ix
  djnz l5ff7
endif

pop bc
push bc
if amstrad
  xor a
  ld ly,a
endif
ld a,(enemy1_x)
cp c
jr nz,l6033
ld a,(enemy1_lean)
ld (drawn_lean),a
if amstrad
  ld a,2
else
  ld a,#06
endif
ld (drawn_attr),a
call draw_enemy_bike

.l6033
pop bc
push bc
if amstrad
  ld a,ly
  add a
  ld ly,a
endif
ld a,(enemy2_x)
cp c
jr nz,l6049
ld a,(enemy2_lean)
ld (drawn_lean),a
if amstrad
  xor a
else
  ld a,#01
endif
ld (drawn_attr),a
call draw_enemy_bike

.l6049
ld hl,enemy_shown
ld a,(hl):or ly:ld (hl),a

ld a,(object_flags)
bit 1,a
call nz,draw_obj_right
pop bc
push bc
ld a,(object_flags)
bit 0,a
call nz,draw_obj_left
if amstrad
  ld a,(obj_scr_index)
  ld (drawn_obj_index),a
endif
pop bc
push bc
ld a,(shooting)
bit 0,a
call nz,draw_shot_in_col
pop bc
pop hl
pop de
pop ix
inc hl
inc c
xor a
dec b
or b
jp nz,l5f96
ret

ld h,b

.show_new_sector
ld a,(sector)
cp bonus_sector
jr nz,show_sector
call do_bonus
ld a,#01
ld (sector),a
ret

.show_sector
ld de,msg_sector
hl_scr 11,14	; 48cb
ld b,#07
call print_b
ld a,(sector)
add #30
ld (sector_dec),a
ld de,sector_dec
ld b,#01
hl_scr 18,14	;#48d2
call print_b
ret

.msg_sector
db "SECTOR "

.l60aa
if amstrad
  sound_reg 7,#3d
  sound_reg 3,0
endif
ex af,af'
ld d,#64
ld e,#14
.l60af
if amstrad
  ld a,e
  add #40
  ld l,a
  adc 0
  sub l
  ld h,a
  sound_reg 3,h
  sound_reg 2,l
endif
ld h,#0a
.l60b1
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld b,e
.l60b6
djnz l60b6
dec h
jr nz,l60b1
dec e
dec d
jr nz,l60af
ex af,af'
if amstrad
  sound_reg 7,#3f
endif
ret

.show_day_patrol
ld b,#05
ld c,#01
ld hl,sector
inc (hl)
ld hl,#5841
.l60cc
push bc
push hl
ld a,c
cp #04
jr z,l60f2
if amstrad
  ld b,ink_tab / 256
  ld a,(bc)
  ld (top_background),a
else
  sla c
  sla c
  sla c
  ld b,10
  .l60db
  push bc
  push hl
  ld b,30
  .l60df
  ld a,(hl)
  and #c7
  or c
  ld (hl),a
  inc hl
  djnz l60df
  pop hl
  ld de,#0020
  add hl,de
  pop bc
  djnz l60db
endif
call l60aa
.l60f2
pop hl
pop bc
inc c
djnz l60cc
ld c,#28
call modify_trees
if amstrad
  ld a,ink_1
  ld (bottom_ink3),a
endif
ld a,(sector)
cp #01
ret z
call show_new_sector
ld de,msg_day_patrol
if amstrad
ld a,ink_1
endif

.l6108
if amstrad
  push af
endif
hl_scr 10,12	; 488a
ld b,#0c
call print_b
if amstrad
  call l60aa
  pop af
  ld (bottom_ink3),a
  ret
else
  jp l60aa
endif

.show_night_patrol
ld b,#05
ld c,#04
ld hl,#5841
.l611a
push bc
push hl
ld a,c
cp #04
jr z,l6140
if amstrad
  ld b,ink_tab / #100
  ld a,(bc)
  ld (top_background),a
else
  sla c
  sla c
  sla c
  ld b,10
  .l6129
  push bc
  push hl
  ld b,30
  .l612d
  ld a,(hl)
  and #c7
  or c
  ld (hl),a
  inc hl
  djnz l612d
  pop hl
  ld de,#0020
  add hl,de
  pop bc
  djnz l6129
endif
call l60aa
.l6140
pop hl
pop bc
dec c
djnz l611a
ld c,#00
call modify_trees
ld de,msg_night_patrol
ld a,ink_2
jp l6108

; Draw an item on the screen
.draw_enemy_bike
if amstrad
  ld a,#58
  ld b,#c2
  add c
  add c
  ld c,a
else
  ld a,#60
  ld h,#48
  add c
  ld l,a
endif
ld a,(enemy_dist)
ld de,spr_bike_small
if amstrad
  sub #02
else
  cp #02
endif
jp m,l616a
if amstrad
  cp #02
else
  cp #04
endif
ld de,spr_bike_large
jp m,l619f
ret

.l616a
if amstrad
  ld a,(drawn_attr)
  ld h,a
  ld a,(drawn_lean)
  inc a
  ld l,a
  ld a,(enemy_dist)
  add h
  ld h,a
  add a
  add h
  add l
  add a:add a:add a:add a
  add e:ld e,a
  adc d:sub e:ld d,a

  ld a,c:sub #3c:ld h,a
  ld a,(bc)
  ld c,h
  or a
  jp nz,draw_behind

  .draw_in_front
  ld h,back_masks / 256

  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:res 3,b:set 4,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:ld a,b:xor #38:ld b,a

  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:res 3,b:set 4,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(de):ld l,a:ld a,(bc):and (hl):or l:ld (bc),a
else
  ex de,hl
  ld a,(drawn_lean)
  inc a
  ld b,a
  ld a,(enemy_dist)
  ld c,a
  add a
  add c
  add b
  add a
  add a
  add a	; (3a + b) * 8 = 24a + 8b  

  ld b,#08
  .l6181
  ld a,(de)
  or (hl)
  ld (hl),a
  inc h
  inc de
  djnz l6181
  ld h,#48
  ld a,#e0
  add l
  ld l,a
  ld a,#10
  cp (hl)
  jr c,l619e
  ld a,#20
  add l
  ld l,a
  ld h,#59
  ld a,(drawn_attr)
  or (hl)
  ld (hl),a
  .l619e
endif
ret

.l619f
if amstrad
  ld hy,a
  ld a,(drawn_lean)
  inc a
  ld l,a
  ld a,(drawn_attr)	; Max 2
  add hy		; Max 3
  ld h,a
  add a			
  add h			; Max 9
  add l			; Max 11
  add a:add a:add a:add a
  ld l,a:ld h,0
  add hl,hl
  add hl,de
  ex de,hl
  ld a,c
  sub #3c
  ld c,a

  ld a,11 * 2 + tree_addr
  dec hy
  jr z,frontmost
  ld a,15 * 2 + tree_addr

  .frontmost
  cp lx
  jr nc,bike_behind

  inc ly
  call draw_in_front
  inc de
  ld hl,#c83c
  add hl,bc
  ld b,h
  ld c,l
  jp draw_in_front

  .bike_behind
  call draw_behind
  inc de
  ld hl,#c83c
  add hl,bc
  ld b,h
  ld c,l
  jp draw_behind

else
  ex de,hl
  ld a,(drawn_lean)
  inc a
  ld b,a
  ld a,(enemy_dist)
  add -2
  ld c,a
  add a
  add c
  add b	; 3a + b
  push hl
  ld h,#00
  ld l,a
  add hl,hl ; * 2
  add hl,hl ; * 4
  add hl,hl ; * 8
  add hl,hl ; * 16
  pop bc
  add hl,bc
  ex de,hl
  ld b,#08
  .l61bb
  ld a,(de)
  or (hl)
  ld (hl),a
  inc h
  inc de
  djnz l61bb
  ld h,#48	; Was #4860 (line 11)
  ld a,#40	; to #48a0  (line 13)
  add l
  ld l,a
  inc h		; Second scan
  ld a,(hl)
  cp #00
  jr nz,l61f2
  ld a,l
  sub #40
  ld l,a
  ld h,#59
  ld a,(drawn_attr)
  ld c,a
  ld a,(hl)
  and #f8
  or c
  ld (hl),a
  ld h,#48
  ld a,l
  add #20
  ld l,a
  ld b,#08
  .l61e5
  ld a,(de)
  ld (hl),a
  inc h
  inc de
  djnz l61e5
  ld h,#59
  ld a,(hl)
  and #f8
  or c
  ld (hl),a
  .l61f2
endif
ret

.move_enemies
ld a,(active_enemies)
bit 0,a
jr nz,move_enemy1
.l61fa
bit 1,a
jr nz,move_enemy2
ret

.move_enemy1
ld hl,active_enemies
set 3,(hl)
ld hl,enemy1_x
ld (l6244),hl
ld (l6262),hl
ld hl,enemy1_lean
ld (l6253),hl
ld (l6282),hl
ld hl,enemy1_mv_cnt
ld (l6265),hl
ld (l6278),hl
jr move_enemy

.move_enemy2
ld hl,active_enemies
res 3,(hl)
ld hl,enemy2_x
ld (l6244),hl
ld (l6262),hl
ld hl,enemy2_lean
ld (l6253),hl
ld (l6282),hl
ld hl,enemy2_mv_cnt
ld (l6265),hl
ld (l6278),hl
jr move_enemy

.l6244 equ $ + 1
.move_enemy
ld a,(enemy1_x)
cp #c8
jr c,l624c
ld a,#00
.l624c
cp #21
jr c,l6252
ld a,#20
.l6253 equ $ + 1
.l6252
ld hl,enemy1_lean
add (hl)
ld hl,is_moving
bit 0,(hl)
jr z,l6261
ld hl,handle_pos
sub (hl)
.l6262 equ $ + 1
.l6261
ld (enemy1_x),a
.l6265 equ $ + 1
ld hl,enemy1_mv_cnt
dec (hl)
xor a
cp (hl)
jr nz,l6284
call random
and #1c
srl a
srl a
ld b,a
inc b
.l6278 equ $ + 1
ld hl,enemy1_mv_cnt
ld (hl),b
and #03
cp #03
ret z
dec a
.l6282 equ $ + 1
ld (enemy1_lean),a	; -1, 0 or 1
.l6284
ld a,(active_enemies)
bit 3,a
jp nz,l61fa
ret

.l628d
if amstrad
  ld a,ink_0
  ld (bottom_ink3),a
endif
ld de,msg_keyboard
ld b,#0c
hl_scr 10,12	;#488a
call print_b
ld de,msg_kempston
hl_scr 10,14	;#48ca
ld b,#0c
call print_b
ld de,msg_copyright
hl_scr 6,16	;#5006
ld b,#16
call print_b
if amstrad
ld de,msg_conv
hl_scr 8,4
ld b,17
call print_b
hl_scr 9,6
ld b,15
call print_b
endif

ld hl,kempston
.l62b1
if amstrad
  ld a,(ktab + 8)
else
  ld a,#f7	; Key Row 3
  in a,(#fe)
endif
bit 0,a		; Key 1
jr z,l62bf
bit 1,a		; Key 2
jr z,l62c2
jr l62b1

.l62bf
ld (hl),#00
ret

.l62c2
ld (hl),#01
ifnot amstrad
  in a,(#1f)
  cp #20
  jr nc,l62bf
endif
ret

.l62cb
ld a,#02
ld (enemy_count),a
ld hl,object_flags
res 5,(hl)
ld a,(day_night)
rrca
ld (day_night),a
bit 0,a
jp nz,show_night_patrol

.l62e1
ld a,(object_x)
cp #00
jr z,l62f0
call do_object
call draw_trees
jr l62e1

.l62f0
xor a
ld (object_x),a
jp show_day_patrol

.modify_trees		; Modify tree palette - so the background is black
if amstrad
else
  ld hl,l7246
  ld de,#0009
  ld b,#02
  .l62ff
  push bc
  ld b,#93
  .l6302
  ld a,(hl)
  and #38
  cp #20			; Green ?
  jr z,l630e
  ld a,(hl)
  and #c7
  or c
  ld (hl),a
  .l630e
  add hl,de
  djnz l6302
  pop bc
  djnz l62ff
endif
ld a,#03
ld (active_enemies),a
ret

.l631b equ $ + 1
.spr_heli_left	; Heli left
if amstrad:ds 8:endif
db #01,#3f,#00,#41,#ff,#9f,#01,#00

.l6323 equ $ + 1
.spr_heli_right	; Heli right
if amstrad:ds 8:endif
db #80,#fe,#80,#c0,#f8,#fe,#ff,#fe

.spr_exp_left	; Object explosion left
if amstrad:ds 8:endif
db #0f,#3a,#75,#ea,#75,#3a,#1d,#0f

.spr_exp_right	; Object explosion right
if amstrad:ds 8:endif
db #f0,#5c,#ae,#57,#ae,#5c,#b8,#f0

.do_object
ld a,(object_flags)
bit 7,a
jr nz,object_exploding
bit 5,a
ret nz
bit 0,a
jr nz,l637c
ld a,(object_count)
dec a
jr nz,l6355
ld hl,object_flags
set 0,(hl)
ld a,50
.l6355
ld (object_count),a
ret

.object_exploding
ld a,(object_count)
ifnot amstrad
  ld hl,l6443		; Object attr
  ld (hl),a
endif
dec a
ld (object_count),a
if amstrad
  push af
  add a
  sound_reg 8,a
  pop af
ret nz
ifnot amstrad
  ld (hl),#07
endif
ld a,50
ld (object_count),a
ld a,#20
ld (object_flags),a

.reset_object
xor a
ld (object_x),a
ld hl,scr_row_6_addr
ld (obj_scr_index),hl
ret

.l637c
ld a,(object_x)
ld hl,next_tree_row + #10
ld (hl),#00
inc l
ld (hl),#00
cp #08
jr c,move_obj_handle
cp #14
ld ix,(obj_scr_index)
jr nc,l63b2
inc ix
inc ix
ifnot amstrad
  inc ix
endif
ld h,(ix+#01)
ld l,(ix+#00)
ex de,hl
hl_scr 0,11	;#4860
and a
sbc hl,de
jr nc,l63ac
ld ix,scr_row_11_addr
.l63ac
ld (obj_scr_index),ix
jr move_obj_handle

.l63b2
dec ix
dec ix
ifnot amstrad
  dec ix
endif
ld l,(ix+#00)
ld h,(ix+#01)
ex de,hl
hl_scr 0,6	;#40c0
and a
sbc hl,de
jr c,l63ac
ld ix,scr_row_6_addr
jr l63ac

.move_obj_handle
ld a,(object_x)
ld hl,is_moving
bit 0,(hl)
jr z,l63db
ld hl,handle_pos
sub (hl)
.l63db
inc a
cp #00
jr z,l63e4
cp #1e
jr c,l63e8
.l63e4
xor a
ld (object_flags),a
.l63e8
ld (object_x),a
if amstrad
  ld hl,spr_heli_left + 3
  ld a,(hl):xor #02:ld (hl),a:dec hl	; Data reversed on second row
  ld a,(hl):xor #0a:ld (hl),a
  ld hl,spr_heli_right + 3
  ld a,(hl):xor #02:ld (hl),a:dec hl
  ld a,(hl):xor #0a:ld (hl),a
else
  ld a,(l631b)	; Move heli rotors
  xor #2a	; 00101010
  ld (l631b),a
  ld a,(l6323)
  xor #2a	; 00101010
  ld (l6323),a
endif
ret

.draw_obj_left
ld a,(object_x)
cp c
ret nz
ld a,c
cp #01
if amstrad
  jp z,draw_obj_right
else
  jr z,draw_obj_right
endif
ld (drawn_obj_left),a
cp #1f
jr z,l640f
ld hl,object_flags
set 1,(hl)
.l640f
ld de,spr_heli_left
bit 7,(hl)
jr z,l641b
ld de,spr_exp_left
jr l642b

.l641b
ld a,(sector)
bit 0,a
jr nz,l642b
ld de,spr_tank_left
ld hl,scr_row_11_addr
ld (obj_scr_index),hl
.l642b
ld a,(object_x)
.l642e
ld ix,(obj_scr_index)
if amstrad
  add a
  add (ix + 0)
  ld c,a
  adc (ix + 1)
  sub c
  ld b,a

  .draw_behind
  ld h,back_masks / 256
  
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:res 3,b:set 4,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:ld a,b:xor #38:ld b,a

  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:res 3,b:set 4,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:inc c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:set 3,b
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a:inc de:dec c
  ld a,(bc):ld l,a:ld a,(de):and (hl):or l:ld (bc),a
else
  ld l,(ix+#00)
  ld h,(ix+#01)
  add l
  ld l,a
  ld a,(hl)
  cp #00
  jr nz,l6449
  ld h,(ix+#02)
  .l6443 equ $ + 1
  ld a,#07
  or (hl)
  ld (hl),a
  ld h,(ix+#01)
  .l6449
  ld b,#08
  .l644b
  ld a,(de)
  or (hl)
  ld (hl),a
  inc h
  inc de
  djnz l644b
endif
ret

.draw_obj_right
ld hl,object_flags
res 1,(hl)
ld de,spr_exp_right
bit 7,(hl)
jr nz,l6472
ld de,spr_heli_right
ld a,(sector)
bit 0,a
jr nz,l6472
ld hl,scr_row_11_addr
ld (obj_scr_index),hl
ld de,spr_tank_right
.l6472
ld a,(object_x)
inc a
ld (drawn_obj_right),a
if amstrad
  jp l642e
else
  jr l642e
endif

.explosion_sound
if amstrad
  sound_reg 6,31
  .explosion_vol equ $ + 1
  sound_reg 8,0
endif
ex af,af'
ld b,#02
.l647b
dec h
jr nz,l6484
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld h,#4b
.l6484
dec l
jr nz,l647b
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld l,#28
djnz l647b
ex af,af'
ret

.random
ld hl,(random_seed)
ld de,(random_base)
inc de
ld (random_base),de
ld a,l
add h
add a
add h
and #07
or #60
ld h,a
ld a,(hl)
add hl,de
ld (random_seed),hl
add l
ret

.sector_trees
db #07,#0f,#19,#23,#2d,#37,#41,#4b
db #55,#64,#78,#82

.place_new_trees
xor a
ld h,new_tree_buff / #100
ld l,a
ld b,a
.l64bc
ld (hl),a
inc l
djnz l64bc
ld a,(sector)
ld hl,sector_trees
.l64c6
dec a
jr z,l64cc
inc hl
jr l64c6
.l64cc
ld b,(hl)
.l64cd
call random
ld l,a
ld h,new_tree_buff / #100
ld (hl),#20
djnz l64cd
ld hl,new_tree_buff
ld b,#00
.l64dc
push bc
push hl
ld b,#03
ld a,(hl)
cp #20
jr nz,l64ed
.l64e5
inc l
cp (hl)
jr nz,l64eb
ld (hl),#00	; Make sure there's always a gap in the trees
.l64eb
djnz l64e5
.l64ed
pop hl
pop bc
inc hl
djnz l64dc
ret

.new_tree_seq
db #55

if amstrad
  .scr_row_2_addr
  dw #c000, #c03c, #c078, #c0b4

  .scr_row_6_addr
  dw #c0f0, #c12c, #c168, #c1a4, #c1e0

  .scr_row_11_addr
  dw #c21c, #c258, #c294, #c2d0, #c30c, #c348

  .scr_row_17_addr
  dw #c384, #c3c0, #c3fc
else
  .scr_row_2_addr
  db #40,#40,#58
  db #60,#40,#58
  db #80,#40,#58
  db #a0,#40,#58

  .scr_row_6_addr
  db #c0,#40,#58
  db #e0,#40,#58
  db #00,#48,#59
  db #20,#48,#59
  db #40,#48,#59

  .scr_row_11_addr
  db #60,#48,#59
  db #80,#48,#59
  db #a0,#48,#59
  db #c0,#48,#59
  db #e0,#48,#59
  db #00,#50,#5a

  .scr_row_17_addr
  db #20,#50,#5a
  db #40,#50,#5a
  db #60,#50,#5a
  db #80,#50,#5a
  db #a0,#50,#5a
endif

.clear_screen
if amstrad
  ld (save_stack),sp
  ld de,0
  ld hl,#c540
  .next_clr
  ld sp,hl
  ld b,#540 / #40
  .pushes
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  push de:push de:push de:push de
  djnz pushes
  ld a,h
  add 8
  ld h,a
  jr nc,next_clr
  
  .save_stack equ $ + 1
  ld sp,0
  ld hl,#c4ba
  ld de,#0e08
  call clr_lp
  ld hl,#c4f9
  inc d
  call clr_lp
  ld hl,#dcfa
  ld de,#800 - #40
  ld a,#5a
  call clr_row
  call clr_row
  call clr_row
  call clr_row
  jp draw_handle_bars

  .clr_lp
  ld (hl),d
  ld a,h
  add e
  ld h,a
  jr nc,clr_lp
  ld bc,#c040
  add hl,bc
  .clr_lp2
  ld (hl),d
  ld a,h
  add e
  ld h,a
  cp #d8
  jr c,clr_lp2
  ret

  .clr_row
  ld b,8
  .clr_lp3
  ld (hl),a:inc l:ld (hl),a:inc hl:ld (hl),a:inc l:ld (hl),a:inc hl
  ld (hl),a:inc l:ld (hl),a:inc hl:ld (hl),a:inc l:ld (hl),a:inc hl
  djnz clr_lp3
  add hl,de
  cpl
  ret

else
  ld hl,#4000
  ld de,#4001
  ld bc,#1800
  ld (hl),#00
  ldir
  ld bc,#02ff
  ld (hl),#3b
  ldir
  ld hl,#5ac0
  ld b,#1e
  ld (hl),#7b
  inc l
  .l654c
  ld (hl),#78
  inc hl
  djnz l654c
  ld (hl),#7b
  hl_scr 0,22	;#50c0
  ld b,#08
  ld a,#e0
  .l655a
  ld (hl),a
  inc h
  djnz l655a
  hl_scr 31,22	;#50df
  ld b,#08
  ld a,#0f
  .l6565
  ld (hl),a
  inc h
  djnz l6565
  ld c,#04
  hl_scr 0,23	;#50e0
  .l656e
  ld b,#20
  push hl
  .l6571
  ld (hl),#ff
  inc hl
  djnz l6571
  pop hl
  inc h
  dec c
  jr nz,l656e
  call draw_handle_bars
endif
ret

.init
if amstrad
  sound_reg 9,13
ifnot amstrad
  di
  ld a,(#5ae0)
  cp #24
  call nz,#0000
  ld a,#01
  ex af,af'
  call l60aa
  call l6b7f
  ld a,#03
  ex af,af'
  call l60aa
  call l6b7f
  ld a,(reset_check)
  bit 0,a
  call z,l6b96
  di
endif
ld hl,msg_high
ld b,#06
.l65a8
ld (hl),#30
inc hl
djnz l65a8
ifnot amstrad
  ex af,af'
  ld a,#07
  out (#fe),a
  ex af,af'
endif

.main_outer_loop
if amstrad
  sound_reg 7,#3f
  sound_reg 8,0
  sound_reg 10,0
endif
ld hl,vars_start
ld de,vars_start + 1
ld bc,#0030
ld (hl),#00
ldir
call reset_object
ld a,#03
ld (active_enemies),a
ld (enemy2_mv_cnt),a
ld (enemy1_mv_cnt),a
ld (object_count),a
ld (range_count),a
ld a,"3"
ld (lives),a
call clear_screen
call reset_shot
call draw_bottom_panel
ld hl,#02e0
ld (tree_clear_bytes),hl
call clear_trees	; Down to #7cc0
ld hl,#01a0
ld (tree_clear_bytes),hl
ld a,#01
ld (is_moving),a
ld (sector),a
call place_new_trees
ld a,#55
ld (day_night),a
ld b,#0a
.init_move_trees
push bc
call move_trees
pop bc
djnz init_move_trees
xor a
ld (is_moving),a
ld (sector),a
ld (enemy_dist),a
ld (enemy1_x),a
ld a,#20
ld (enemy2_x),a
ld a,#02
ld (speed_delay),a
call draw_trees
call l62cb
call l628d
call check_high
ld b,#06
ld hl,msg_score
.l6632
ld (hl),#30
inc hl
djnz l6632
call l6969
call show_hi
if amstrad
  ld a,ink_1
  ld (bottom_ink3),a
endif

.main_game_loop
if amstrad
  sound_reg 7,#31
ifnot amstrad
  ei
  di
endif
call test_speed_keys
ld a,(enemy_exploding)
bit 0,a
call z,test_fire
call test_left_right
call move_trees
ld a,(shooting)
bit 0,a
call nz,adjust_shot_x
call draw_trees
ld a,(enemy_exploding)
bit 0,a
call nz,do_explosion
call highlight_range
call score_enemy_on_screen
call move_enemies
ld a,(enemy1_x)
ld hl,enemy2_x
cp (hl)
jr nz,l667a
ld a,(enemy2_lean)
add (hl)
ld (hl),a
.l667a
ifnot disable_collision
  call check_hit_tree
endif
call adjust_range
call do_object
ld a,(enemy_exploding)
bit 0,a
jr nz,l669a
ld a,(shooting)
bit 0,a
jr z,l669a
ifnot amstrad
  call set_shot_attr
endif
call adjust_shot_x
call draw_shot
.l669a
jp main_game_loop

.test_speed_keys
ld a,(kempston)
if amstrad
  or a
  jr z,l66af
  ld a,(ktab + 9)
  bit 0,a
  jr z,accelerate
  bit 1,a
  jr z,decelerate
else
  bit 0,a
  jr z,l66af
  in a,(#1f)
  bit 2,a
  jr nz,decelerate
  bit 3,a
  jr nz,accelerate
endif
ret

.l66af
if amstrad
  ld a,(ktab + 4)
  bit 6,a
  jr z,decelerate
  bit 5,a
  ret nz
else
  ld a,#ef	; Key row 4
  in a,(#fe)
  bit 1,a		; Key 9
  jr z,accelerate
  bit 2,a		; Key 8
  jr z,decelerate
  ret
endif

.accelerate
ld a,(speed_delay)
cp #00
ret z
dec a
.l66c3
ld (speed_delay),a
ld a,#01
ld (is_moving),a
ret

.decelerate
ld a,(speed_delay)
cp #02
jr z,stop_moving
inc a
jr l66c3

.stop_moving
xor a
ld (is_moving),a
ret

; Draw handle bars
.draw_handle_bars
if amstrad
  .handle_addr equ #c3da
  ld de,handle_addr
else
  ld de,#504d
endif
.handle_offs equ $ + 1
ld hl,tile_handle_straight
if amstrad
  .handle_lp
  ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi
  .handle_step equ #800 - 14
  ld a,e:add handle_step:ld e,a
  ld a,d:adc handle_step / 256:ld d,a
  jr nc,handle_lp
  ld a,e:add #3c
  cp #3c * 2 + handle_addr
  ret z
  ld e,a
  ld a,d:adc #c0:ld d,a
  jr handle_lp  
else
  call l66e7
  ld de,#506d
  .l66e7
  ld b,#08
  .l66e9
  push bc
  push de
  ld bc,#0007
  ldir
  pop de
  inc d
  pop bc
  djnz l66e9
  ld d,#5a
  ld bc,#0007
  ldir
  ret
endif

.tree_check equ end_trees - #20 + #0e

.check_hit_tree
ld b,#05
if amstrad
  ld hl,tree_check - 1
  ld a,(handle_pos)
  inc a
  add l
  ld l,a
  adc h
  sub l
  ld h,a
  xor a
else
  ld hl,handle_pos
  ld a,tree_check
  add (hl)
  ld l,a
  ld h,tree_check / 256
  ld a,#00
endif
.l670a
cp (hl)
jr nz,l6711
inc hl
djnz l670a
ret

.l6711
if amstrad
  ld hl,tree_check - 2
  ld a,(handle_pos)
  inc a
  add l
  ld l,a
  adc h
  sub l
  ld h,a
else
  ld h,tree_check - 1 / #100
  ld l,tree_check - 1
  ld a,(handle_pos)
  add l
  ld l,a
endif
ld b,#03
.l671c
ld (hl),#20
inc hl
djnz l671c
ld b,#03
.l6723
ld (hl),#40
inc hl
djnz l6723
call draw_trees

; This code merges the handle bars with
; The data from #502f - Byte at 15, 17 
if amstrad
  hl_scr 15,17
  ld e,(hl):inc l:ld d,(hl)
  hl_scr 13,18
  ld bc,#800 - 13
  .merge_lp
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 1
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 2
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 3
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 4
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 5
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:inc hl	; 6
  ld a,(hl):or e:ld (hl),a:inc l
  ld a,(hl):or d:ld (hl),a:add hl,bc	; 7
  jr nc,merge_lp
else
  hl_scr 13,18	;#504d
  ld b,#08
  .l6730
  push hl
  push bc
  ld b,#07
  .l6734
  ld a,(#502f)
  or (hl)
  ld (hl),a
  inc hl
  djnz l6734
  pop bc
  pop hl
  inc h
  djnz l6730
endif
xor a
ld (is_moving),a
ld a,#02
ld (speed_delay),a
call do_hit_tree
call clear_screen
call clear_trees
call reset_shot
call draw_bottom_panel
call draw_handle_bars
ld a,(lives)
dec a
ld (lives),a
cp #30
push af
call show_lives
pop af
ret nz
pop hl
call show_game_over
jp main_outer_loop

.clear_trees
ld hl,end_trees - 1
ld de,end_trees - 2
ld bc,(tree_clear_bytes)
ld (hl),#00
lddr
ret

.do_hit_tree
if amstrad
  sound_reg 7,#3b
  sound_reg 5,0
  sound_reg 10,15
ex af,af'
ld b,#3c
.l6784
ld hl,#5840
ld de,#5841
ld (hl),b
push bc
if amstrad
  .wait0a
  ld a,(intno)
  or a
  jr nz,wait0a
  ld e,b
  ld a,b
  rra:rra:rra:and #07
  ld c,a
  ld b,ink_tab / #100
  ld a,(bc)
  ld (top_background),a
  ld (bottom_background),a
  ld (bottom_background2),a
  ld (panel_background),a
  ld a,e
  and #07
  ld c,a
  ld a,(bc)
  ld (panel_foreground),a
  ld (top_ink1),a
  ld (top_ink2),a
  ld (top_ink3),a
  ld (bottom_ink3),a
endif
if amstrad
  ld bc,#5440
else
  ld b,#54
endif
.l678e
push bc
bit 0,b
jr z,l679f
bit 1,b
jr z,l679f
if amstrad
  ld c,#60
  .l679f
  sound_reg 4,c
else
  xor #10
  out (#fe),a
  bit 3,b
  jr z,l679f
  .l679f
  ld bc,#0008
  ldir
  xor #10
  out (#fe),a
endif
pop bc
djnz l678e
ld (hl),#38
pop bc
djnz l6784
if amstrad
  ld de,#6010
else
  ld de,#d010
endif
.l67b3
if amstrad
  halt
  ld a,e
  add a
  add #40
  ld l,a
  adc 0
  sub l
  ld h,a
  sound_reg 5,h
  sound_reg 4,l
  ld h,1
else
  ld h,#03
endif
.l67b5
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld b,e
.l67ba
djnz l67ba
dec h
jr nz,l67b5
inc e
dec d
jr nz,l67b3
dec h
ex af,af'
if amstrad
  ld a,(day_night)
  bit 0,a
  ld hl,ink_14 * #100 + ink_1
  jr z,isday
  ld hl,ink_0 * #100 + ink_2
  .isday
  ld a,l
  ld (bottom_ink3),a
  ld a,h
  ld (top_background),a
  ld a,ink_9
  ld (bottom_background),a
  ld (bottom_background2),a
  ld a,ink_26
  ld (panel_background),a
  ld a,ink_18
  ld (top_ink1),a
  ld a,ink_8
  ld (top_ink2),a
  ld a,ink_6
  ld (top_ink3),a
  ld a,ink_0
  ld (panel_foreground),a
  sound_reg 10,0
endif
ret

.adjust_range
ld a,(speed_delay)
cp #00
jr nz,l67ee
ld a,(enemy1_x)
cp #20
jr nc,l67fa
.l67d4
ld a,(range_count)
dec a
jr z,l67de
ld (range_count),a
ret

.l67de
ld a,30
ld (range_count),a
ld a,(enemy_dist)
cp #03
ret z
inc a
ld (enemy_dist),a
ret

.l67ee
ld a,(enemy_dist)
cp #00
ret z
dec a
ld (enemy_dist),a
ret

ret

.l67fa
ld a,(enemy2_x)
cp #20
jr c,l67d4
ret

.draw_shot_in_col
ld a,(enemy_exploding)
bit 0,a
ret nz
ld a,(object_flags)
bit 7,(hl)
ret nz
ld a,(shot_x)
cp c
ret nz

.draw_shot
ld a,(object_flags)
bit 7,a
ret nz
if amstrad
  ld a,(shot_count)
  ld c,a
  cp 3

  ld a,(shot_x)
  ld b,a

  jr nc,too_low     	; Can't be bike or object

  ld a,(enemy_dist)
  cp 3

if no_object_bug
  jr nz,noen2
else
  jr nz,too_low		; This is a bug in the original, should be noten2
endif

  ld a,(enemy_shown)
  ld e,a

  ld a,b

  ld hl,(drawn_enemy1_x)
  cp l		    ; Same as enemy1_x?
  jr nz,noten1
  bit 1,e
  jr z,noten2

  jp enemy1_hit

  .noten1
  cp h
  jr nz,noten2
  bit 0,e
  jp nz,enemy2_hit

  .noten2
  dec c
  jr nz,too_low

  ld a,(drawn_obj_index)
  cp scr_row_11_addr
  jr nz,too_low

  ld a,b
  ld hl,(drawn_obj_left)
  cp h
  jp z,object_hit
  cp l
  jp z,object_hit

  .too_low
  ld a,b
  ld de,(shot_source)
  ld ix,(shot_scr_index)
  add a
  add (ix + 0)
  ld c,a
  adc (ix + 1)
  sub c
  ld b,a
  ld h,a:ld l,c
  ld a,(hl):inc l:or (hl)
  jp nz,reset_shot

  call draw_in_front
  inc de

else
  ld de,(shot_source)
  ld ix,(shot_scr_index)
  ld l,(ix+#00)
  ld h,(ix+#01)
  ld a,(shot_x)
  add l
  ld l,a
  ld a,(hl)
  inc a
  dec a
  jr nz,check_object_hit
  ld b,#08
  .l6833
  ld a,(de)
  or (hl)
  ld (hl),a
  inc h
  inc de
  djnz l6833
  ld h,(ix+#02)
  ld a,#07
  or (hl)
  ld (hl),a
endif
ld a,(shot_count)
dec a
jr z,reset_shot
dec ix
dec ix
ifnot amstrad
  dec ix
endif
ld (shot_scr_index),ix
ld (shot_source),de
ld (shot_count),a
ret

.set_shot_attr
ld ix,(shot_scr_index)
ld l,(ix+#03)
ld h,(ix+#05)
ld a,(shot_x)
add l
ld l,a
ld (hl),#23
ret

.reset_shot
ld hl,scr_row_17_addr
ld (shot_scr_index),hl
ld a,#07
ld (shot_count),a
ld hl,spr_shots
ld (shot_source),hl
ld a,#10
ld (shot_x),a
xor a
ld (shooting),a
ret

ifnot amstrad
  .check_object_hit
  ld a,(enemy_dist)
  cp 3
  jr nz,l689b
  ld h,(ix+#02)
  ld a,(hl)
  and #07
  cp #06		; 
  jr z,enemy1_hit
  cp #01		; 
  jr z,enemy2_hit
  .l689b
  cp #07
  jr z,object_hit
  jp reset_shot
endif

.enemy1_hit
ld a,(active_enemies)
res 0,a
ld (active_enemies),a
ld a,(enemy1_x)
ld (explosion_offs),a
xor a
ld (enemy1_x),a
ld (enemy1_lean),a
jr l68ce

.enemy2_hit
ld a,(active_enemies)
res 1,a
ld (active_enemies),a
ld a,(enemy2_x)
ld (explosion_offs),a
xor a
ld (enemy2_x),a
ld (enemy2_lean),a

.l68ce
ld a,#07
ld (explosion_cnt),a
if amstrad
  ld hl,(shot_scr_index)
  ld a,b
  add a
  add (hl)
  inc hl
  ld h,(hl)
  ld l,a
  adc h
  sub l
  ld h,a
endif
ld (explosion_scr_addr),hl
ld a,#01
ld (enemy_exploding),a
jr l68ea

.object_hit
ld hl,object_flags
set 7,(hl)
if amstrad
  sound_reg 6,10
  sound_reg 8,14
endif
ld a,#07
ld (object_count),a
call add_score_1000
.l68ea
call add_score_1000
jp reset_shot

.test_fire
ld a,(speed_delay)
and a
ret nz
ld a,(kempston)
if amstrad
  or a
  jr z,l6903
  ld a,(ktab + 9)
  bit 4,a
  jr z,handle_fire
else
  bit 0,a
  jr z,l6903
  in a,(#1f)
  bit 4,a
  jr nz,handle_fire
endif
ret

.l6903
if amstrad
  ld a,(ktab + 4)
  bit 4,a
  ret nz
else
  ld a,#7f	; Key row 7
  in a,(#fe)
  and #1f		; Space, Control, M, N or B
  xor #1f
  ret z
endif

.handle_fire
ld a,(object_flags)	; Object still exploding?
bit 7,a
ret nz
ld hl,shooting
ld (hl),#01
ret

; Draw bottom section of screen
.draw_bottom_panel
if amstrad
  ld hl,tile_panel
  ld de,#c43a

  .panel_lp
  push de
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  ldi:ldi:ldi:ldi:ldi:ldi:ldi:ldi
  pop de
  ld a,d
  add 8
  ld d,a
  jp nc,panel_lp
  ld a,e
  add #40
  cp #ba
  jr z,exit_panel
  ld e,a
  ld a,d
  add #c0
  ld d,a
  jp panel_lp

  .exit_panel
else
  ld de,#5080
  ld hl,tile_panel
  ld b,#10
  .l6920
  push bc
  push de
  ld bc,#0020
  ldir
  pop de
  pop bc
  inc d
  ld a,d
  and #07
  jr nz,l6932
  ld de,#50a0
  .l6932
  djnz l6920
  ld de,#5a80	; From 6fbf
  ld bc,#0040
  ldir
endif
call l6969
call show_lives
call show_range
call show_hi
ret

.print_b
push de
push hl
push bc
ld a,(de)
ex de,hl
if amstrad
  call draw_char
else
  ld bc,#3c00
  ld l,a
  ld h,#00
  add hl,hl	; * 2
  add hl,hl	; * 4
  add hl,hl	; * 8
  add hl,bc
  ex de,hl
  ld b,#08
  .l695b
  ld a,(de)
  ld (hl),a
  inc h
  inc de
  djnz l695b
endif
pop bc
pop hl
pop de
if amstrad
  inc l
endif
inc hl
inc de
djnz print_b
ret

if amstrad
  .draw_char
  add a
  ld l,a
  ld h,#38 / 8
  add hl,hl
  add hl,hl
  add hl,hl

  .draw_char_hl
  ldi:ld a,(hl):inc l:ld (de),a:set 3,d				; 12
  ld a,(hl):inc l:ld (de),a:dec e				; 6  (18)
  ld a,(hl):inc l:ld (de),a:res 3,d:set 4,d			; 9  (27)
  ldi:ld a,(hl):inc l:ld (de),a:set 3,d				; 12 (39)
  ld a,(hl):inc l:ld (de),a:dec e				; 6  (45)
  ld a,(hl):inc l:ld (de),a:ld a,d:xor #38:ld d,a		; 9  (54)
  ldi:ld a,(hl):inc l:ld (de),a:set 3,d				; 12 (66)
  ld a,(hl):inc l:ld (de),a:dec e				; 6  (72)
  ld a,(hl):inc l:ld (de),a:res 3,d:set 4,d			; 9  (81)
  ldi:ld a,(hl):inc l:ld (de),a:set 3,d				; 12 (93)
  ld a,(hl):inc l:ld (de),a:dec e:ld a,(hl):ld (de),a		; 10 (103)
  ret
endif

.l6969
hl_scr 1,21	;#50a1
ld de,msg_dollar_score
ld b,#0a
jp print_b

.show_lives
ld de,msg_lives
hl_scr 1,22	;#50c1
ld b,#0a
jp print_b

.msg_lives
db ":LIVES :"

.lives
db "3:"

.add_score_1000
ld hl,msg_score_end - 3
jr l6991

.add_score_1
ld hl,msg_score_end
.l6991
ld a,#3a
jr l6998

.l6995
ld (hl),#30
dec hl
.l6998
inc (hl)
cp (hl)
jr z,l6995
ld de,msg_score
hl_scr 4,21	;#50a4
ld b,#06
jp print_b

.score_enemy_on_screen
ld a,(speed_delay)
and a
ret nz
ld a,(enemy1_x)
cp #1f
jr c,add_score_1
ld a,(enemy2_x)
cp #1f
jr c,add_score_1
ret

.show_range
ld de,msg_range
hl_scr 22,22	;#50d6
.l69c1
ld b,#07
jp print_b

.msg_range
db "[]RANGE"

.highlight_range
ld a,(enemy_dist)
cp #03
if amstrad
  hl_scr 22,22
  jr z,in_range

  bit 7,(hl)
  ret z
  ld bc,#00f0
  ld de,#8010
  jr invert_range

  .in_range
  bit 7,(hl)
  ret nz
  ld bc,#f0f0
  ld de,#70e0

  .invert_range
  ld (hl),b:inc l:ld (hl),b:inc l:ld (hl),b:inc l:ld (hl),b:set 3,h
  ld (hl),b:dec l:ld a,(hl):xor c:ld (hl),a:dec l
  ld a,(hl):xor c:ld (hl),a:dec l:ld (hl),b:res 3,h:set 4,h
  ld (hl),b:inc l:ld (hl),d:inc l:ld (hl),e:inc l:ld (hl),b:set 3,h
  ld (hl),b:dec l:ld (hl),e:dec l:ld (hl),d:dec l:ld (hl),b:ld a,h:xor #38:ld h,a
  ld (hl),b:inc l:ld (hl),d:inc l:ld (hl),e:inc l:ld (hl),b:set 3,h
  ld (hl),b:dec l:ld (hl),e:dec l:ld (hl),d:dec l:ld (hl),b:res 3,h:set 4,h
  ld (hl),b:inc l:ld a,(hl):xor c:ld (hl),a:inc l
  ld a,(hl):xor c:ld (hl),a:inc l:ld (hl),b:set 3,h
  ld (hl),b:dec l:ld (hl),b:dec l:ld (hl),b:dec l:ld (hl),b

else
  ld hl,#5ad6
  jr z,in_range
  res 7,(hl)
  inc hl
  res 7,(hl)
  ret

  .in_range
  set 7,(hl)
  inc hl
  set 7,(hl)
endif
ret

.do_explosion
ld a,(explosion_cnt)
dec a
ld (explosion_cnt),a
jr nz,do_enemy_exp

call finish_explosion
call draw_handle_bars
xor a
ld (enemy_exploding),a
call draw_bottom_panel
ld a,(enemy_count)
dec a
ld (enemy_count),a
ret nz

ld b,#02
ld a,#01
.l6a05
ld (speed_delay),a
inc a
push bc
push af
call test_left_right
call move_trees
call draw_trees
pop af
pop bc
djnz l6a05
call stop_moving
call l62cb
ld a,(day_night)
bit 0,a
ret nz
call place_new_trees
ret

.adjust_shot_x
ld a,(handle_pos)
ld hl,shot_x
add (hl)
ld (shot_x),a
ret

.do_enemy_exp
if amstrad
  add 7
  ld (explosion_vol),a
  ld a,(explosion_offs)
  add a
  add #e0
  ld c,a
  adc #c1
  sub c
  ld b,a
  ld de,spr_explosion
  .exp_x_lp
  push bc
  call draw_in_front
  inc de
  ld hl,#c83c
  add hl,bc
  ld b,h
  ld c,l
  call draw_in_front
  inc de
  ld hl,#c83c
  add hl,bc
  ld b,h
  ld c,l
  call draw_in_front
  inc de  
  pop bc
  inc c
  inc bc
  ld a,e
  cp 9 * 16 + spr_explosion
  jr nz,exp_x_lp
else
  ld hl,#5940
  ld a,(explosion_offs)
  dec a
  add l
  ld l,a
  push hl
  ld de,#001e
  ld b,#03
  .l6a42
  ld a,(explosion_cnt)
  ld c,a
  ld a,(hl)
  and #f8
  or c
  ld (hl),a
  inc hl
  ld (hl),a
  inc hl
  ld (hl),a
  add hl,de
  djnz l6a42
  pop hl
  ld h,#48
  ld de,spr_explosion
  ld b,#03
  .l6a5a
  push bc
  push hl
  ld b,#03
  .l6a5e
  push bc
  push hl
  ld b,#08
  .l6a62
  ld a,(de)
  or (hl)
  ld (hl),a
  inc h
  inc de
  djnz l6a62
  pop hl
  ld bc,#0020
  add hl,bc
  pop bc
  djnz l6a5e
  pop hl
  inc hl
  pop bc
  djnz l6a5a
endif
call explosion_sound
ret

.spr_explosion	; Explosion graphics
if amstrad:ds 3 * 3 * 8:endif
db #01,#03,#0e,#1d,#3a,#75,#ea,#f5
db #ea,#d5,#ea,#d5,#ea,#75,#3a,#35
db #1a,#1d,#0e,#0d,#07,#06,#03,#01

db #cf,#c3,#19,#3d,#3c,#ff,#b7,#db
db #d9,#76,#6a,#7e,#54,#7e,#55,#3c
db #76,#ab,#3c,#9a,#59,#bb,#5a,#c9

db #e4,#f0,#f9,#7c,#7e,#bf,#7d,#fa
db #7f,#f6,#3f,#3f,#7e,#7c,#af,#5e
db #fe,#7e,#fc,#f8,#f0,#e0,#c0,#80

.finish_explosion
if amstrad
  ld hl,exp_char_src
else
  ld hl,#3cdd
endif
ld (explosion_src),hl
ld hl,(explosion_scr_addr)
ld a,#07
if amstrad
  ld de,#3c
else
  ld de,#0020
endif
ld b,#07
ld c,#01
.l6ad4
if amstrad
  ld a,b
  ld (explosion_vol),a
endif
push bc
ld b,c
call draw_explosion_char
.l6ad9
add hl,de
djnz l6ad9
ld b,c
call draw_explosion_char
.l6ae0
if amstrad
  inc l
endif
inc hl
djnz l6ae0
ld b,c
call draw_explosion_char
.l6ae7
and a
sbc hl,de
djnz l6ae7
ld b,c
call draw_explosion_char
.l6af0
dec hl
if amstrad
  dec l
endif
djnz l6af0
push hl
push de
push af
call test_left_right
call move_trees
call draw_trees
call explosion_sound
pop af
pop de
pop hl
pop bc
inc c
inc c
and a
sbc hl,de
dec hl
if amstrad
  dec l
endif
djnz l6ad4

if amstrad
  xor a
  ld (explosion_vol),a
endif

.draw_explosion_char
push hl
push bc
push de
push af
if amstrad
  ex de,hl
  ld hl,(explosion_src)
  call draw_char_hl
  inc l
  ld (explosion_src),hl
else
  or (hl)
  ld (hl),a
  ld a,h
  sub #58
  sla a
  sla a
  sla a
  add #40
  ld h,a
  ld b,#08
  ld de,(explosion_src)
  .l6b26
  ld a,(de)
  ld (hl),a
  inc h
  inc de
  djnz l6b26
  ld (explosion_src),de
endif
call explosion_sound
pop af
pop de
pop bc
pop hl
ret

.msg_day_patrol
db "DAY   PATROL"

.msg_night_patrol
db "NIGHT PATROL"

.msg_keyboard
db " 1=KEYBOARD "

.msg_kempston
if amstrad
  db " 2=JOYSTICK "

  .msg_conv
  db "CPC conversion by"
  db "The Executioner"
else
  db " 2=KEMPSTON "
endif

.msg_game_over
db "GAME OVER"

.show_game_over
call draw_trees
ld de,msg_game_over
hl_scr 11,13	;#48ab
ld b,#09
call print_b

.l6b7f
if amstrad
  sound_reg 10,15
endif
ex af,af'
if amstrad
  ld d,#e1
else
  ld d,#ff
endif
ld e,#1e
.l6b84
if amstrad
  halt
  ld a,e
  add #40
  ld l,a
  adc 0
  sub l
  ld h,a
  sound_reg 5,h
  sound_reg 4,l
  ld h,#03
else
  ld h,#06
endif
.l6b86
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld b,e
.l6b8b
djnz l6b8b
dec h
jr nz,l6b86
inc e
dec d
jr nz,l6b84
ex af,af'
if amstrad
  sound_reg 10,0
endif
ret

ifnot amstrad
  .l6b96
  ex af,af'
  ld a,#03
  ex af,af'
  pop hl
  call l60aa
  call l6b7f
  ld a,#fe
  in a,(#fe)
  bit 1,a
  jr z,l6bae
  ld a,#01
  ld (reset_check),a
  .l6bae
  ld a,#df
  in a,(#fe)
  bit 0,a
  ret nz
  .l6bb5
  ld a,#fd
  in a,(#fe)
  bit 1,a
  jr nz,l6bb5
  ld a,#ff
  ld ix,#4000
  ld de,#3f48
  call #04c2
  ret
endif

.msg_dollar_score
db ":$:"

.msg_score
db "00000"

.msg_score_end
db "0:"

.msg_hi
db "HI:"

.msg_high
db "000000"

.check_high
ld hl,msg_score
ld de,msg_high
ld b,#06
.l6be5
ld a,(de)
ld c,(hl)
cp c
jr c,move_high
ret nz
inc hl
inc de
djnz l6be5
ret

.move_high
ld bc,#0006
ld hl,msg_score
ld de,msg_high
ldir
ret

.show_hi
ld de,msg_hi
hl_scr 22,21	;#50b6
ld b,#09
jp print_b

.spr_tank_left	; Tank left
if amstrad:ds 8:endif
db #07,#0f,#1f,#07,#7f,#e0,#7f,#1c

.spr_tank_right	; Tank right
if amstrad:ds 8:endif
db #80,#ff,#80,#00,#ff,#07,#fc,#70

.do_bonus
call show_bonus
if amstrad
  sound_reg 5,0
  sound_reg 10,15
  sound_reg 7,#3b
endif
ld b,#0f
.l6c1c
push bc
if amstrad
  ld bc,#800 - #0b
  hl_scr 13,11
  .inv_lp
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a:inc hl
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a:inc hl
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a:inc hl
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a:inc hl
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a:inc hl
  ld a,(hl):cpl:ld (hl),a:inc l:ld a,(hl):cpl:ld (hl),a
  add hl,bc
  jr nc,inv_lp
endif
call add_score_1000
ex af,af'
ld d,#3c
ld e,#0a
.l6c25
if amstrad
  halt
  ld a,e
  add a
  add #40
  ld l,a
  adc 0
  sub l
  ld h,a
  sound_reg 5,h
  sound_reg 4,l
  ld h,#06
else
  ld h,#09
endif
.l6c27
xor #10
if amstrad
  xor #00:or a
else
  out (#fe),a
endif
ld b,e
.l6c2c
djnz l6c2c
dec h
jr nz,l6c27
dec e
dec d
jr nz,l6c25
ex af,af'
pop bc
djnz l6c1c
if amstrad
  sound_reg 10,0
endif
ret

.show_bonus
ld de,msg_bonus
ld hl,#596d
ld b,#06
.l6c42
ld (hl),#c7	; White on black
inc hl
djnz l6c42
hl_scr 13,11	;#486d
ld b,#06
call print_b
ret

.msg_bonus
db "BONUS!"

.msg_copyright
db #7f," MERVYN ESTCOURT 1983"

ifnot amstrad
ds #6d6a - $
endif

.right_tree_table
db 0:dw l72e8		; 0
db 0:dw l72e8		; 1
db 0:dw l742c		; 2

.left_tree_table
db 0:dw l7246		; 0
db 0:dw l7246		; 1
db 0:dw l738a		; 2
db 0:dw l74ce		; 3
db 0:dw l7570		; 4
db 0:dw l7612		; 5
db 0:dw l76b4		; 6
db 0:dw l7756		; 7
db 0:dw l77f8		; 8
db 1:dw l789a		; 9
db 1:dw l78d0		; 10
db 1:dw l7906		; 11
db 1:dw l793c		; 12
db 1:dw l7972		; 13
db 1:dw l79a8		; 14
db 1:dw l79de		; 15
db 1:dw l7a14		; 16
db 1:dw l7a4a		; 17
db 1:dw l7a80		; 18
db 1:dw l7ab6		; 19
db 1:dw l7aec		; 20
db 1:dw l7b22		; 21
db 1:dw l7b58		; 22
db 1:dw l7b8e		; 23
db 1:dw l7bc4		; 24

db 0

.tile_panel	; Complete bottom panel
if amstrad
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#ff,#fe,#f0,#f0,#f0,#fb,#fc,#c0
  db #00,#00,#70,#f3,#fe,#f8,#f0,#f0,#ff,#ff,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#ff,#fc,#f0,#f0,#f0,#f3,#ec,#00
  db #00,#00,#00,#73,#fe,#f8,#f0,#f0,#f7,#ff,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#ff,#f8,#f0,#f0,#f0,#f7,#e8,#00
  db #00,#00,#00,#31,#fe,#f0,#f0,#f0,#f7,#ff,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#ff,#f8,#f0,#f0,#f0,#f7,#c0,#00
  db #00,#00,#00,#31,#ff,#f0,#f0,#f0,#f3,#ff,#0f,#0f,#0f,#0f,#0f,#0f
  db #0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#ff,#f0,#f0,#f0,#f0,#f7,#c0,#00
  db #00,#00,#00,#10,#ff,#f0,#f0,#f0,#f3,#ff,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#fe,#f0,#f0,#f0,#f0,#f7,#c0,#07
  db #00,#00,#0e,#10,#ff,#f0,#f0,#f0,#f1,#ff,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#fe,#f0,#f0,#f0,#f0,#f6,#80,#05
  db #00,#00,#0a,#10,#ff,#f8,#f0,#f0,#f1,#ff,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#fc,#f0,#f0,#f0,#f0,#fe,#80,#09
  db #00,#00,#09,#00,#f7,#f8,#f0,#f0,#f0,#ff,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#fc,#f0,#f0,#f0,#f0,#fc,#80,#0a
  db #00,#00,#05,#10,#f7,#f8,#f0,#f0,#f0,#ff,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f8,#f0,#f0,#f0,#f1,#fc,#80,#0a
  db #00,#00,#04,#18,#f3,#fc,#f0,#f0,#f0,#f7,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#f1,#f8,#01,#02
  db #00,#00,#04,#08,#f3,#fc,#f0,#f0,#f0,#f7,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#f3,#f8,#01,#02
  db #00,#00,#04,#08,#73,#fe,#f0,#f0,#f0,#f3,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#f3,#f8,#01,#02
  db #00,#00,#04,#04,#71,#fe,#f0,#f0,#f0,#f3,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#f7,#e0,#01,#04
  db #00,#00,#02,#04,#71,#fe,#f0,#f0,#f0,#f1,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#f6,#c0,#02,#04
  db #00,#00,#02,#02,#70,#ff,#f0,#f0,#f0,#f1,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #0e,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#0f,#f0,#f0,#f0,#f0,#fe,#40,#02,#00
  db #00,#00,#00,#02,#70,#fe,#f0,#f0,#f0,#f0,#0f,#08,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
else
  db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#01,#ff,#f4,#3c
  db #00,#7c,#17,#ff,#00,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
  db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#03,#ff,#fc,#20
  db #00,#04,#17,#ff,#80,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
  db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#07,#ff,#f8,#60
  db #00,#02,#1f,#ff,#80,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
  db #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#07,#ff,#f8,#c0
  db #00,#02,#0f,#ff,#c0,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#0f,#ff,#f8,#c0
  db #00,#01,#0f,#ff,#c0,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#1f,#ff,#f8,#c7
  db #00,#e1,#0f,#ff,#e0,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#1f,#ff,#f9,#85
  db #00,#a1,#07,#ff,#e0,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#3f,#ff,#f1,#89
  db #00,#90,#87,#ff,#f0,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#3f,#ff,#f3,#8a
  db #00,#51,#87,#ff,#f0,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#7f,#ff,#e3,#8a
  db #00,#49,#c3,#ff,#f8,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#e7,#12
  db #00,#48,#c3,#ff,#f8,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#c7,#12
  db #00,#48,#41,#ff,#fc,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#c7,#12
  db #00,#44,#61,#ff,#fc,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#8e,#14
  db #00,#24,#61,#ff,#fe,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#9c,#24
  db #00,#22,#70,#ff,#fe,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
  db #e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f,#ff,#ff,#14,#20
  db #00,#02,#71,#ff,#ff,#f8,#00,#00,#00,#00,#00,#00,#00,#00,#00,#0f
endif

.l6fbf	; Attributes for above
ifnot amstrad
  db #7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#20,#38,#20,#4f
  db #4f,#4f,#20,#20,#20,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b,#7b
  db #7b,#78,#78,#78,#78,#78,#78,#78,#78,#78,#78,#7b,#38,#38,#20,#4f
  db #4f,#4f,#21,#20,#20,#7b,#78,#78,#78,#78,#78,#78,#78,#78,#78,#7b

  db 0
endif

.tile_handle_straight	; Handle bars straight top
if amstrad
  db #00,#00,#00,#00,#00,#00,#33,#cc,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#00,#ff,#ff,#00,#00,#00,#00,#00,#00
  db #00,#00,#00,#00,#00,#11,#ff,#ff,#88,#00,#00,#00,#00,#00
  db #00,#30,#e0,#00,#00,#33,#ee,#ff,#cc,#00,#00,#70,#e0,#00
  db #00,#f0,#f0,#c0,#00,#33,#ee,#ff,#cc,#00,#10,#f0,#f0,#00
  db #30,#f0,#f0,#e1,#00,#77,#ee,#ff,#ee,#00,#70,#f0,#f0,#c0
  db #3c,#f0,#f0,#f0,#19,#ff,#ee,#ff,#ff,#01,#78,#f0,#f0,#c3
  db #78,#f0,#f0,#f0,#0c,#ff,#ee,#ff,#ff,#8b,#f0,#f0,#f0,#e1
  db #78,#f0,#f0,#f0,#0e,#77,#ff,#ff,#cc,#0f,#f0,#f0,#f0,#e1
  db #78,#f0,#f0,#f0,#0f,#00,#11,#00,#01,#0f,#f0,#f0,#f0,#e1
  db #78,#f0,#f0,#f0,#0f,#08,#00,#00,#03,#0f,#f0,#f0,#f0,#e1
  db #20,#90,#70,#f0,#0f,#1c,#b0,#b0,#07,#0f,#f0,#f0,#d0,#61
  db #20,#f0,#30,#e1,#0f,#1c,#b0,#b0,#07,#0f,#78,#f0,#50,#20
  db #70,#f0,#b0,#e0,#07,#1c,#b0,#b0,#07,#0f,#70,#e0,#70,#e0
  db #f0,#f0,#c0,#e0,#03,#1c,#b0,#b0,#07,#0e,#30,#b0,#f0,#e0
  db #f0,#f0,#f0,#40,#01,#1c,#80,#10,#07,#0c,#10,#30,#f0,#f0
else
  db #00,#00,#00,#3c,#00,#00,#00, #00,#00,#00,#ff,#00,#00,#00
  db #00,#00,#01,#ff,#80,#00,#00, #03,#e0,#03,#ef,#c0,#07,#e0
  db #0f,#fc,#03,#ef,#c0,#1f,#f0, #3f,#ff,#07,#ef,#e0,#7f,#fc
  db #ff,#ff,#9f,#ef,#f1,#ff,#ff, #ff,#ff,#cf,#ef,#fb,#ff,#ff

  db #20,#20,#27,#27,#27,#20,#20

  ; Handle bars straight bottom
  db #ff,#ff,#e7,#ff,#cf,#ff,#ff, #ff,#ff,#f0,#10,#1f,#ff,#ff
  db #ff,#ff,#f8,#00,#3f,#ff,#ff, #29,#7f,#fd,#bb,#7f,#ff,#d7
  db #2f,#3f,#fd,#bb,#7f,#ff,#52, #7f,#be,#7d,#bb,#7f,#7e,#7e
  db #ff,#ce,#3d,#bb,#7e,#3b,#fe, #ff,#f4,#1d,#81,#7c,#13,#ff

  db #20,#20,#27,#27,#27,#20,#20
endif

.tile_handle_right	; Handle bars right top
if amstrad
  db #00,#70,#e0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
  db #00,#f0,#f0,#80,#00,#00,#00,#33,#aa,#00,#00,#00,#00,#00
  db #03,#f0,#f0,#c0,#00,#00,#11,#ff,#33,#00,#00,#00,#00,#00
  db #34,#f0,#f0,#f0,#00,#00,#33,#ee,#77,#00,#00,#00,#00,#00
  db #34,#f0,#f0,#f0,#00,#00,#77,#ee,#ff,#00,#00,#00,#00,#00
  db #78,#f0,#f0,#f0,#04,#00,#ff,#cc,#ff,#88,#00,#00,#00,#00
  db #78,#f0,#f0,#f0,#86,#11,#ff,#99,#ff,#88,#00,#00,#00,#00
  db #34,#00,#70,#f0,#87,#33,#ff,#bb,#ff,#88,#00,#f0,#e0,#00
  db #04,#f0,#30,#f0,#86,#33,#ff,#ff,#ff,#cc,#10,#f0,#f0,#00
  db #10,#f0,#80,#f0,#0f,#00,#ff,#ff,#ff,#cc,#14,#f0,#f0,#80
  db #70,#f0,#e0,#70,#0f,#08,#11,#ff,#ff,#ee,#34,#f0,#f0,#c0
  db #70,#f0,#f0,#60,#07,#0e,#00,#11,#ff,#88,#34,#f0,#f0,#e1
  db #70,#f0,#f0,#60,#03,#1e,#80,#00,#66,#03,#3c,#f0,#f0,#f0
  db #f0,#f0,#f0,#60,#00,#1c,#d0,#30,#00,#0f,#78,#f0,#f0,#f0
  db #f0,#f0,#f0,#e0,#00,#14,#80,#70,#07,#0f,#78,#f0,#f0,#f0
  db #f0,#f0,#f0,#40,#00,#14,#a0,#e1,#0f,#0f,#78,#f0,#f0,#f0
else
  db #07,#e0,#00,#00,#00,#00,#00, #0f,#f8,#00,#03,#a0,#00,#00
  db #3f,#fc,#00,#1f,#30,#00,#00, #7f,#ff,#00,#3e,#70,#00,#00
  db #7f,#ff,#00,#7e,#f0,#00,#00, #ff,#ff,#40,#fc,#f8,#00,#00
  db #ff,#ff,#e1,#f9,#f8,#00,#00, #70,#7f,#f3,#fb,#f8,#0f,#e0

  db #20,#20,#27,#27,#27,#20,#20

  ; Handle bars right bottom
  db #4f,#3f,#e3,#ff,#fc,#1f,#f0, #1f,#8f,#f0,#ff,#fc,#5f,#f8
  db #7f,#e7,#f8,#1f,#fe,#7f,#fc, #7f,#f6,#7e,#01,#f8,#7f,#ff
  db #7f,#f6,#3f,#80,#63,#ff,#ff, #ff,#f6,#0d,#d3,#0f,#ff,#ff
  db #ff,#fe,#05,#87,#7f,#ff,#ff, #ff,#f4,#05,#af,#ff,#ff,#ff

  db #20,#20,#67,#27,#27,#20,#20
endif

.tile_handle_left	; Handle bars left top
if amstrad
  db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#70,#e0,#00
  db #00,#00,#00,#00,#00,#55,#cc,#00,#00,#00,#10,#f0,#e1,#00
  db #00,#00,#00,#00,#00,#cc,#ff,#88,#00,#00,#30,#f0,#f0,#0c
  db #00,#00,#00,#00,#00,#ee,#77,#cc,#00,#00,#f0,#f0,#f0,#c2
  db #00,#00,#00,#00,#00,#ff,#77,#ee,#00,#00,#f0,#f0,#f0,#c2
  db #00,#00,#00,#00,#11,#ff,#33,#ff,#00,#02,#f0,#f0,#f0,#e1
  db #00,#00,#00,#00,#11,#ff,#99,#ff,#88,#16,#f0,#f0,#f0,#e1
  db #00,#70,#f0,#00,#11,#ff,#dd,#ff,#cc,#1e,#f0,#e0,#00,#e0
  db #00,#f0,#f0,#80,#33,#ff,#ff,#ff,#cc,#16,#f0,#c0,#f0,#20
  db #10,#f0,#f0,#82,#33,#ff,#ff,#ff,#00,#0f,#f0,#10,#f0,#80
  db #30,#f0,#f0,#c2,#77,#ff,#ff,#88,#01,#0f,#e0,#70,#f0,#e0
  db #78,#f0,#f0,#c2,#11,#ff,#88,#00,#07,#0e,#60,#f0,#f0,#e0
  db #f0,#f0,#f0,#e1,#0c,#66,#00,#10,#87,#0c,#60,#f0,#f0,#e0
  db #f0,#f0,#f0,#e1,#0f,#00,#c0,#b0,#83,#00,#60,#f0,#f0,#f0
  db #f0,#f0,#f0,#f0,#0f,#0e,#e0,#10,#82,#00,#70,#f0,#f0,#f0
  db #f0,#f0,#f0,#f0,#0f,#0f,#78,#50,#82,#00,#20,#f0,#f0,#f0
else
  db #00,#00,#00,#00,#00,#07,#e0,#00,#00,#05,#c0,#00,#1f,#f0
  db #00,#00,#0c,#f8,#00,#3f,#fc,#00,#00,#0e,#7c,#00,#ff,#fe
  db #00,#00,#0f,#7e,#00,#ff,#fe,#00,#00,#1f,#3f,#02,#ff,#ff
  db #00,#00,#1f,#9f,#87,#ff,#ff,#07,#f0,#1f,#df,#cf,#fe,#0e

  db #20,#20,#27,#27,#27,#20,#20

  ; Handle bars left bottom
  db #0f,#f8,#3f,#ff,#c7,#fc,#f2,#1f,#fa,#3f,#ff,#0f,#f1,#f8
  db #3f,#fe,#7f,#f8,#1f,#e7,#fe,#ff,#fe,#1f,#80,#7e,#6f,#fe
  db #ff,#ff,#c6,#01,#fc,#6f,#fe,#ff,#ff,#f0,#cb,#b0,#6f,#ff
  db #ff,#ff,#fe,#e1,#a0,#7f,#ff,#ff,#ff,#ff,#f5,#a0,#2f,#ff

  db #20,#20,#27,#27,#67,#20,#20

  .l717a	; ?????
  db #77,#f7,#bf,#ff,#77,#77,#77,#f7,#77,#76
endif

.spr_bike_small
if amstrad:ds 6 * 8 * 3:endif
db #00,#30,#10,#78,#3c,#7e,#6e,#24	; Bike left - small far
db #00,#00,#18,#18,#3c,#18,#18,#18	; Bike centre - small far
db #00,#0c,#08,#1e,#3c,#7e,#76,#24	; Bike right - small far

db #18,#18,#7c,#3e,#3f,#2d,#27,#02	; Bike left - small mid
db #18,#3c,#ff,#3c,#18,#18,#18,#18	; Bike centre - small mid
db #18,#18,#3e,#7c,#fc,#b4,#e4,#40	; Bike right - small mid

.spr_bike_large
if amstrad:ds 6 * 16 * 3:endif
db #60,#70,#f8,#fc,#78,#7c,#3c,#1c,#0c,#06,#04,#00,#00,#00,#00,#00	; Bike left - large mid
db #18,#18,#3c,#3c,#ff,#3c,#3c,#18,#18,#18,#18,#00,#00,#00,#00,#00	; Bike centre - large mid
db #06,#0e,#1f,#3f,#1f,#3e,#1e,#3e,#1c,#18,#30,#00,#00,#00,#00,#00	; Bike right - large mid

db #60,#70,#78,#fe,#fe,#fd,#fe,#fe,#7e,#7e,#ff,#7e,#1e,#06,#07,#03	; Bike left - large near
db #18,#18,#3c,#7e,#7e,#ff,#7e,#7e,#7e,#7e,#3c,#7e,#18,#18,#18,#18	; Bike centre - large near
db #06,#06,#1e,#3f,#7f,#3f,#7f,#7f,#7e,#7e,#ff,#7e,#78,#60,#e0,#c0	; Bike right - large near

.spr_shots
if amstrad:ds 7 * 8:endif
db #7c,#ff,#c3,#c3,#c3,#c3,#e7,#7e
db #3c,#7e,#7e,#ff,#7e,#7e,#aa,#55
db #1c,#3e,#7e,#7e,#52,#ad,#56,#18
db #3c,#3c,#18,#2a,#55,#5a,#ad,#18
db #18,#3c,#3c,#18,#2a,#54,#2a,#18
db #18,#3c,#55,#aa,#55,#28,#54,#00

db #00,#00
if amstrad
db #2b, #92,#55,#a9,#56,#dd
endif

.l7246
db #2b, #92,#55,#a9,#56,#dd,#dd,#dd,#dd
db #2b, #dd,#dd,#fd,#fd,#fd,#fd,#fd,#ff
db #2b, #ff,#ff,#ff,#ff,#df,#df,#dd,#dd
db #2b, #dd,#dd,#dd,#dd,#dd,#fd,#fd,#fd
db #2b, #fd,#fd,#fd,#fd,#fd,#fd,#fd,#df
db #2b, #df,#df,#df,#df,#df,#df,#dd,#dd
db #2b, #fd,#fd,#fd,#fd,#fd,#fd,#fd,#fd
db #2b, #ff,#ff,#df,#df,#df,#df,#df,#df
db #2b, #df,#dd,#fd,#ff,#ff,#ff,#ff,#ff
db #2b, #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #23, #ff,#ff,#ff,#ff,#ff,#ff,#fd,#fd
db #23, #ed,#ed,#ed,#ed,#ed,#ef,#ef,#ef
db #23, #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #23, #ff,#ff,#ef,#ef,#ef,#ef,#ef,#ef
db #23, #ef,#ee,#ee,#ee,#ee,#ee,#fe,#fe
db #23, #fe,#fe,#fe,#fe,#fe,#ff,#ff,#ff
db #23, #ff,#ef,#ef,#ef,#ef,#ef,#ef,#ef
db #23, #ef,#fb,#fb,#fb,#fb,#fb,#fb,#7b

.l72e8
db #2a, #db,#db,#db,#db,#db,#db,#db,#db
db #2a, #db,#df,#df,#df,#df,#df,#df,#df
db #2a, #df,#db,#db,#db,#fb,#fb,#fb,#fb
db #2a, #fb,#fb,#ff,#df,#df,#df,#df,#df
db #2a, #df,#db,#db,#db,#db,#db,#db,#fb
db #2a, #fb,#fb,#fb,#fb,#ff,#ff,#ff,#df
db #2a, #df,#df,#df,#df,#db,#db,#db,#db
db #2a, #db,#db,#db,#db,#df,#df,#df,#df
db #2a, #df,#df,#df,#ff,#ff,#ff,#ff,#ff
db #2a, #ff,#fb,#fb,#7b,#7b,#7f,#ff,#ff
db #22, #ff,#ff,#ff,#ff,#ff,#ff,#ff,#ff
db #22, #ff,#ff,#ff,#df,#df,#df,#df,#df
db #22, #d7,#d7,#d7,#f7,#f7,#f7,#f7,#f7
db #22, #f7,#f7,#f7,#f7,#f7,#f7,#f7,#d7
db #22, #d7,#d7,#d7,#d7,#d7,#d7,#d7,#d7
db #22, #dd,#dd,#dd,#dd,#df,#df,#df,#df
db #22, #df,#df,#df,#df,#df,#df,#df,#df
db #22, #df,#df,#df,#df,#df,#df,#df,#df

.l738a
db #2b, #1f,#1f,#1f,#1f,#1f,#1e,#1e,#1e
db #2b, #1e,#1e,#1e,#0e,#0e,#0f,#0f,#0f
db #2b, #0f,#0f,#0f,#0f,#0f,#0e,#0e,#0e
db #2b, #0e,#0e,#0e,#0f,#0f,#0f,#0f,#0f
db #2b, #0f,#0f,#0f,#0f,#0e,#0e,#0e,#0e
db #2b, #0e,#1e,#1e,#1f,#1f,#1f,#1f,#1f
db #2b, #1f,#1f,#1f,#1f,#1e,#1e,#1e,#1e
db #2b, #1e,#1e,#1e,#1e,#1e,#1e,#1e,#1f
db #2b, #1f,#1f,#1f,#1f,#1e,#1f,#1f,#1f
db #2b, #1f,#1f,#1f,#1f,#1f,#1f,#1f,#1f
db #23, #1f,#1f,#1f,#1f,#1f,#1e,#1e,#1e
db #23, #1f,#1f,#1f,#1f,#1f,#1d,#1d,#1d
db #23, #1d,#1d,#1d,#1d,#1d,#1d,#1f,#1f
db #23, #1d,#1d,#1d,#1f,#1f,#1f,#1f,#1f
db #23, #1f,#1f,#1d,#1d,#1d,#1f,#1d,#1d
db #23, #1d,#1d,#1d,#1d,#1d,#1d,#1d,#1f
db #23, #1f,#1b,#1f,#0f,#0f,#07,#03,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l742c
db #2a, #ec,#ec,#fc,#fc,#ec,#ec,#ec,#ec
db #2a, #ec,#ec,#ec,#ec,#fc,#fc,#fc,#fc
db #2a, #ec,#ec,#ec,#ec,#ec,#ec,#ec,#ee
db #2a, #ee,#fe,#fe,#fe,#fe,#7e,#7e,#7e
db #2a, #6e,#6e,#6e,#ec,#ec,#ec,#ec,#ec
db #2a, #ec,#ec,#fc,#fc,#7c,#7c,#7c,#7c
db #2a, #7c,#6c,#ec,#ec,#ec,#ec,#ee,#ee
db #2a, #ee,#fe,#fe,#fe,#fe,#fe,#fe,#ee
db #2a, #ee,#ae,#ae,#ae,#ee,#ee,#ee,#ee
db #2a, #ee,#fe,#fe,#fe,#fe,#fe,#fe,#fe
db #22, #fe,#fe,#fe,#fe,#fe,#ee,#ee,#ee
db #22, #ee,#ee,#ee,#ee,#ee,#fe,#fe,#fe
db #22, #fe,#fe,#fe,#fe,#ee,#6e,#6e,#6e
db #22, #6e,#6e,#6e,#7e,#7e,#7e,#7e,#7e
db #22, #fe,#fe,#fe,#fe,#ee,#ee,#ee,#ee
db #22, #ee,#ee,#6e,#6e,#6e,#ee,#ee,#ee
db #22, #ee,#ee,#fe,#fe,#fc,#f8,#f0,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l74ce
db #2b, #6f,#6f,#6b,#7b,#7b,#7b,#7b,#7b
db #2a, #7b,#7b,#7b,#7f,#6f,#6f,#6f,#6f
db #2a, #6f,#6f,#7f,#7b,#7b,#7b,#7b,#7b
db #2a, #7b,#7b,#7b,#6b,#6b,#6f,#6f,#7f
db #2a, #7f,#7f,#7f,#7f,#7f,#7f,#7f,#7b
db #2a, #6b,#6b,#7b,#7b,#7b,#6b,#6b,#6b
db #2a, #7b,#7b,#7b,#7b,#7f,#7f,#6f,#6f
db #2a, #6f,#6f,#6f,#7f,#7f,#7f,#7f,#7f
db #2a, #7b,#6b,#6b,#6b,#7b,#7b,#7f,#7f
db #2a, #7f,#7f,#7f,#7f,#7f,#7f,#7f,#7f
db #22, #7f,#7f,#7f,#6f,#6d,#6d,#7d,#7f
db #22, #7f,#7f,#7b,#7b,#7b,#6b,#6b,#6b
db #22, #7b,#7f,#7f,#7f,#7f,#77,#77,#77
db #22, #77,#77,#77,#77,#77,#77,#77,#77
db #22, #7f,#7f,#3c,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7570
db #2c, #3e,#fe,#f7,#f7,#f7,#ff,#ff,#ff
db #2c, #ff,#f7,#f7,#bb,#bb,#bb,#bb,#ff
db #2a, #36,#3e,#3e,#3a,#3a,#3a,#3e,#36
db #2a, #36,#3e,#36,#3e,#3a,#3a,#3a,#3a
db #2a, #3a,#3a,#3e,#3e,#3e,#3e,#3e,#36
db #2a, #36,#36,#36,#3e,#3a,#3a,#3a,#3a
db #2a, #3a,#3e,#3e,#3e,#3a,#3a,#3a,#3e
db #2a, #36,#36,#36,#3e,#3e,#3e,#3e,#3e
db #2a, #3e,#3e,#3a,#3a,#3e,#36,#3e,#3e
db #2a, #3e,#3e,#3e,#3e,#3e,#3e,#3e,#3e
db #22, #3e,#3e,#36,#36,#36,#36,#36,#36
db #22, #36,#3e,#3a,#3e,#3e,#36,#3e,#3a
db #22, #3a,#3a,#3a,#3e,#3e,#3e,#3e,#3e
db #22, #36,#1c,#00,#00,#00,#00,#00,#00
db #22, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7612
db #2c, #7b,#3f,#f7,#df,#db,#db,#ff,#ff
db #2c, #bf,#fb,#db,#db,#db,#df,#df,#df
db #2c, #df,#df,#ff,#7b,#7b,#7f,#7a,#1e
db #2a, #1e,#1e,#1e,#1e,#1a,#1a,#1e,#1e
db #2a, #1e,#1e,#1e,#1a,#1a,#1a,#1a,#1a
db #2a, #1e,#1e,#1a,#1a,#1e,#1e,#1e,#1e
db #2a, #1e,#1e,#1e,#1a,#1a,#1e,#1e,#1e
db #2a, #1e,#1e,#1a,#1a,#1a,#1a,#1e,#1e
db #2a, #1e,#1e,#1e,#1e,#1a,#1a,#1a,#1e
db #2a, #1e,#1e,#1e,#1e,#1e,#1e,#1e,#1e
db #22, #1e,#1a,#1e,#1e,#1e,#1e,#1a,#1a
db #22, #1e,#1e,#16,#1e,#1e,#1e,#1e,#1e
db #22, #1e,#1e,#1e,#0c,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l76b4
db #2c, #b9,#ff,#bd,#ff,#bf,#ff,#bd,#ff
db #2c, #bd,#bf,#fd,#bf,#fd,#ff,#f5,#ff
db #2c, #fd,#f7,#f7,#ff,#dd,#df,#fe,#f6
db #2c, #fe,#fe,#de,#de,#f6,#bf,#29,#3d
db #2a, #15,#1c,#1c,#1c,#1c,#1c,#1c,#14
db #2a, #14,#1c,#1c,#14,#14,#1c,#1c,#1c
db #2a, #14,#14,#1c,#1c,#14,#1c,#1c,#1c
db #2a, #14,#14,#14,#1c,#1c,#1c,#14,#14
db #2a, #1c,#1c,#1c,#1c,#14,#14,#14,#1c
db #2a, #1c,#1c,#14,#14,#1c,#1c,#1c,#1c
db #22, #1c,#14,#1c,#1c,#1c,#1c,#1c,#1c
db #22, #1c,#1c,#1c,#1c,#1c,#1c,#08,#00
db #22, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7756
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #30,#5c,#74,#3f,#f1,#bf,#f3,#bf
db #2c, #fb,#ff,#ff,#bf,#fb,#bf,#f9,#bf
db #2c, #f9,#bf,#f9,#bf,#fb,#ff,#ff,#7f
db #2c, #ff,#fb,#bd,#bb,#ff,#fb,#fc,#28
db #2a, #28,#38,#38,#28,#28,#28,#38,#38
db #2a, #28,#28,#28,#28,#38,#38,#28,#28
db #2a, #28,#38,#28,#28,#38,#28,#28,#38
db #2a, #38,#28,#28,#38,#28,#28,#28,#38
db #2a, #38,#38,#38,#38,#38,#28,#28,#38
db #22, #38,#38,#38,#38,#38,#38,#38,#38
db #22, #38,#38,#38,#10,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l77f8
db #28, #00,#00,#00,#00,#00,#00,#00,#00
db #28, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#10
db #2c, #10,#38,#6e,#2e,#e2,#9a,#fa,#9a
db #2c, #fa,#9b,#fb,#9f,#fb,#db,#7b,#5f
db #2c, #ff,#ff,#fb,#ff,#fa,#ff,#fe,#fe
db #2c, #fa,#7a,#7a,#7e,#78,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l789a
db #2c, #bf,#ec,#fe,#bc,#fe,#b9,#ff,#fa
db #2c, #7f,#3c,#ff,#bf,#ff,#3d,#ff,#f9
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#18,#18,#18,#18,#18,#18,#00

.l78d0
db #2c, #00,#00,#18,#78,#58,#7e,#fb,#7f
db #2c, #fb,#ff,#bb,#ff,#bc,#ff,#3d,#ff
db #2c, #3d,#ff,#59,#7f,#70,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#18,#18,#18,#18,#00,#00,#00

.l7906
db #2c, #00,#00,#00,#00,#30,#34,#b4,#b7
db #2c, #86,#ff,#b7,#bf,#fa,#b7,#f9,#3f
db #2c, #7b,#7f,#fb,#ff,#fa,#7e,#f8,#3e
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#18,#18,#18,#00,#00,#00,#00

.l793c
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#08,#3c,#be,#ff,#eb,#af,#ef
db #2c, #eb,#6f,#fd,#ff,#7d,#7e,#78,#3e
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #2a, #18,#18,#18,#18,#18,#18,#18,#18
db #22, #18,#18,#18,#00,#00,#00,#00,#00

.l7972
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#10,#1c,#fe,#78,#fe
db #2c, #5e,#f8,#fe,#ff,#fa,#78,#fc,#b4
db #2c, #7c,#54,#78,#10,#10,#10,#10,#10
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #22, #10,#10,#00,#00,#00,#00,#00,#00

.l79a8
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#30,#30
db #2c, #70,#f8,#b8,#ec,#fc,#fc,#78,#fe
db #2c, #ff,#fe,#f0,#7c,#18,#7c,#10,#10
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #22, #10,#00,#00,#00,#00,#00,#00,#00

.l79de
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#30
db #2c, #30,#7c,#f8,#fe,#7c,#78,#7e,#7e
db #2c, #f8,#ff,#78,#3e,#38,#38,#38,#10
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7a14
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#10,#30,#38,#78,#78,#7c,#f8
db #2c, #7c,#78,#fe,#33,#7e,#38,#7e,#18
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7a4a
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#08,#08,#18,#38,#1c,#7c
db #2c, #5c,#7c,#74,#9c,#74,#1c,#70,#1c
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7a80
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#08,#38,#3c,#7c
db #2c, #7c,#3c,#7e,#36,#7e,#3c,#74,#1e
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7ab6
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#10,#70,#78
db #2c, #3c,#38,#74,#5c,#d8,#fc,#7c,#78
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7aec
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#30
db #2c, #70,#50,#78,#58,#fc,#fc,#78,#3c
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7b22
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #10,#7c,#7c,#3c,#7c,#7e,#4c,#7c
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7b58
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#18,#18,#7c,#7e,#fc,#78
db #2a, #10,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7b8e
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#20,#28,#e0,#6c,#fe,#6c
db #2a, #00,#10,#10,#10,#10,#10,#10,#10
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7bc4
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2a, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.tree_6_col
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00

.tree_col_buff
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2c, #00,#00,#00,#00,#00,#00,#00,#00
db #2a, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00
db #20, #00,#00,#00,#00,#00,#00,#00,#00

.l7c9c

db #2b, #00, #00, #00

.next_tree_row
ds #20

.tree_buffer
;ds #20 * 23

.end_trees equ #20 * 23 + tree_buffer
;ds #100

list
.tree_code equ end_trees + #100
nolist

if amstrad

  .move
  di

  ld sp,#bff0
  ld hl,org0
  ld de,0
  ld bc,end - ink_tab
  ldir

  jp start

  .org0
  org 0,@
  .ink_tab
  db ink_0, ink_1, ink_6, ink_8, ink_9, ink_14, ink_24, ink_26

  .ktab ds 10

  ds #18 - $
  ld b,#f4
  out (c),a
  ld b,#f6
  in a,(c)
  or #c0
  out (c),a
  and #3f
  out (c),a
  ld b,#f4
  out (c),c
  ld b,#f6
  ld c,a
  or #80
  out (c),a
  out (c),c
  ret

  ds #38 - $
  push af
  .intno equ $ + 1
  ld a,0
  inc a
  cp 4
  jr c,int_less
  push bc
  jp z,int4
  cp 6
  jp nz,int5

  ld bc,#bc04
  out (c),c
  ld bc,#bd14
  out (c),c

  ld bc,#7f00
  out (c),c
  ld c,ink_13
  out (c),c

  ld bc,#bc07
  out (c),c
  ld bc,#bd0a
  out (c),c

  pop bc
  xor a
  ld (intno),a
  pop af
  ei
  ret

  .int_less
  cp 1
  jr nz,notint1

  push bc
  ld bc,#7f00
  out (c),c
  .top_background equ $ + 1
  ld a,ink_14
  out (c),a
  inc c
  out (c),c
  .top_ink1 equ $ + 1
  ld a,ink_18
  out (c),a
  inc c
  out (c),c
  .top_ink2 equ $ + 1
  ld a,ink_8
  out (c),a
  inc c
  out (c),c
  .top_ink3 equ $ + 1
  ld a,ink_6
  out (c),a

  ld a,1
  
  ld bc,#bc08
  out (c),c
  ld bc,#bd10
  out (c),c
  dec b
  out (c),a
  ld bc,#bd1e
  out (c),c
  ld bc,#bc06
  out (c),c
  ld bc,#bd16
  out (c),c
  ld bc,#bc0c
  out (c),c
  ld bc,#bd30
  out (c),c
  ld bc,#bc0d
  out (c),c
  ld bc,#bd00
  out (c),c

  pop bc

  .notint1
  ld (intno),a
  pop af
  ei
  ret

  .int4
  ld (intno),a
  ld bc,#bc07
  out (c),c
  ld bc,#bdff
  out (c),c
  ld bc,#bc04
  out (c),c
  ld bc,#bd11
  out (c),c
  ld bc,#bc0c
  out (c),c
  ld bc,#bd32
  out (c),c
  ld bc,#bc0d
  out (c),c
  ld bc,#bd1d
  out (c),c

  ld b,3
  djnz $

  ld bc,#7f01
  out (c),c
  .bottom_ink3 equ $ + 1
  ld c,ink_1
  out (c),c
  .bottom_background equ $ + 1
  ld a,ink_9
  ld b,125
  djnz $
  ld bc,#7f00
  out (c),c
  out (c),a
  pop bc
  pop af
  ei
  ret

  .int5
  ld (intno),a
  push hl
  push de

  ; Key scan routine
  ld hl,ktab	; 3
  ld bc,#f40e	; 6
  out (c),c	; 10
  ld e,b		; 11
  ld bc,#f6c0	; 14
  out (c),c	; 18
  out (c),h	; 22
  ld d,b		; 23
  ld bc,#f792	; 26
  out (c),c	; 30
  ld c,#4a	; 32
  ld a,#40	; 34
  .sclp
  ld b,d		; 1
  out (c),a	; 5
  ld b,e		; 6
  ini		; 11
  inc a		; 12
  cp c		; 13
  jr nz,sclp	; 16 * 9 + 15 = 159 + 34 = 193
  ld bc,#f782	; 196
  out (c),c	; 200

  .panel_foreground equ $ + 1
  ld a,ink_0
  ld bc,#1b01
  djnz $

  ld b,#7f
  out (c),c
  out (c),a

  ld c,3
  out (c),c

  ;; TODO: Draw score or something useful??? Sound output?
  ld b,252
  djnz $

  .panel_background equ $ + 1
  ld a,ink_26
  ld de,#0801
  .bottom_background2 equ $ + 1
  ld hl,#2000 + ink_9
  ld bc,#7f00
  out (c),l
  out (c),c
  out (c),a
  ld b,h
  out (c),d
  inc b
  out (c),c
  ld b,h
  out (c),e
  inc b
  out (c),h

  ld bc,#bc06
  out (c),c
  ld bc,#bd04
  out (c),c

  pop de
  pop hl
  pop bc
  pop af
  ei
  ret

  .wait_ffb
  ld b,#f5
  in a,(c)
  rra
  jr nc,wait_ffb
  ret

  macro zero_char
    ld (hl),a:inc l:ld (hl),a:set 3,h
    ld (hl),a:dec l:ld (hl),a:res 3,h:set 4,h
    ld (hl),a:inc l:ld (hl),a:set 3,h
    ld (hl),a:dec l:ld (hl),a:ld a,h:xor #38:ld h,a:xor a
    ld (hl),a:inc l:ld (hl),a:set 3,h
    ld (hl),a:dec l:ld (hl),a:res 3,h:set 4,h
    ld (hl),a:inc l:ld (hl),a:set 3,h
    ld (hl),a:dec l:ld (hl),a:add hl,bc
  endm

  .zeroes8
  zero_char
  .zeroes7
  zero_char
  .zeroes6
  zero_char
  .zeroes5
  zero_char
  .zeroes4
  zero_char
  .zeroes3
  zero_char
  .zeroes2
  zero_char
  .zeroes1
  zero_char
  ret

  .zero_column
  ex de,hl
  call zeroes8
  call zeroes8
  dec hy
  ret z
  jr zeroes2

  .conv_byte
  ld a,(de):and #f0:ld (hl),a:rrca:rrca:rrca:rrca:or (hl):and c:ld (hl),a:inc hl
  ld a,(de):and #f:ld (hl),a:rlca:rlca:rlca:rlca:or (hl):and c:ld (hl),a:inc hl
  inc de
  ret

  .conv_char
  call conv_bytes
  call conv_bytes
  call conv_bytes
  
  ; Convert spectrum byte to CPC screen format
  ; DE = source address, HL = dest
  .conv_bytes
  call conv_byte
  if reverse
    ld a,(de):and #f:ld (hl),a:rlca:rlca:rlca:rlca:or (hl):and c:ld (hl),a:inc hl
    ld a,(de):and #f0:ld (hl),a:rrca:rrca:rrca:rrca:or (hl):and c:ld (hl),a:inc hl
  else
    ld a,(de):and #f0:ld (hl),a:rrca:rrca:rrca:rrca:or (hl):and c:ld (hl),a:inc hl
    ld a,(de):and #f:ld (hl),a:rlca:rlca:rlca:rlca:or (hl):and c:ld (hl),a:inc hl
  endif
  inc de
  ret

  .convert_trees
;  ld c,#28
;  call modify_trees
  ld ix,tree_code
  ld iy,tree_addr + 2
  ld hl,right_tree_table + 3
  ld b,24 + 3 - 1
  .conv_tree_lp
  ld d,hx
  ld e,lx
  ld (iy + 0),e
  inc iy
  ld (iy + 0),d
  inc iy
  push bc
  call convert_tree
  pop bc
  djnz conv_tree_lp

  if 0		; 1 to test drawing

    ld hl,#c000
    ld de,#c001
    ld bc,#3fff
    ld (hl),c
    ldir

    ld de,#c002
    ld hl,tree_addr
    ld bc,#c83c
    .draw_tree_lp
    ld a,(hl)
    inc l
    push hl
    ld h,(hl)
    ld l,a
    push de
    xor a
    ld hy,0
    call call_hl
    pop de
    pop hl
    inc e:inc e
    halt:halt:halt:halt:halt:halt
    inc l
    ld a,l
    cp 28 * 2
    jr nz,draw_tree_lp

    ld b,100
    .wait_lp
    halt:halt:halt:halt:halt:halt
    djnz wait_lp
  endif
  ret

  .call_hl
  jp (hl)

  ; 000 = black
  ; 001 = blue
  ; 010 = red
  ; 011 = magenta
  ; 100 = green
  ; 101 = cyan
  ; 110 = yellow
  ; 111 = white
  ; 
  ; hex   bin       bg      fg
  ; -------------------------------
  ; #2b = 101 011 = cyan    magenta
  ; #23 = 100 011 = green   magenta
  ; #2a = 101 010 = cyan    red
  ; #22 = 100 010 = green   red
  ; #2c = 101 100 = cyan    green  .convert_tree   ; Height
  .convert_tree
  ld (ix + 0),#eb
  inc ix
  ld a,(hl)
  inc hl
  ld e,(hl)
  inc hl
  ld d,(hl)
  inc hl
  push hl
  or a
  jr z,no_conv6
  ex de,hl
  ld de,tree_col_buff
  ld bc,54
  ldir
  ld de,tree_6_col
  .no_conv6
  ld b,18
  .one_tree_lp
  ld hl,tree_buffer
  .tree_char_lp
  ld a,(de)			; Attribute
  inc de
  and #07
  ld c,#f0
  cp #04
  jr z,use_mask
  ld c,#0f
  cp #03
  jr z,use_mask
  ld c,#ff
  .use_mask
  call conv_char
  djnz tree_char_lp

  ; Count zeroes at start
  ld hl,tree_buffer
  call count_zeroes
  push hl
  ld a,18
  sub c
  cp 18
  jr z,no_z_start

  call zero_entry
  ld (ix + 0),#cd
  inc ix
  ld (ix + 0),l
  inc ix
  ld (ix + 0),h
  inc ix

  .no_z_start
  push af

  ; Now count the zeroes at the end
  ld hl,17 * 16 + tree_buffer
  ld de,-16
  call count_zeroes + 3
  
  pop af
  sub c
  ld b,a	; This leaves the ones in the middle
  pop de

  push de
  push bc

  ; Find most common bytes
  add a
  add a
  add a
  add a
  ld c,a
  ld b,0
  rl b

  xor a
  ld hl,new_tree_buff
  .clr_tb_1
  ld (hl),a
  inc l
  jr nz,clr_tb_1

  .count_lp
  ld a,(de)
  inc de
  ld l,a
  inc (hl)
  jr z,count_err
  dec bc
  ld a,b
  or c
  jr nz,count_lp

  ld l,a
  ld (hl),a	; Ignore the zero

  call find_max
  ld d,e
  call find_max

  pop bc
  pop hl

  ld a,c
  sub 2
  jr c,less2

  call do_b

  dec c
  dec c
  jr z,end_zero2a

  call zero_entry
  ld (ix + 0),#cd
  inc ix
  ld (ix + 0),l
  inc ix
  ld (ix + 0),h
  inc ix

  .end_zero2a
  ld (ix + 0),#fd	; dec ly
  inc ix
  ld (ix + 0),#25
  inc ix
  ld (ix + 0),#c8	; ret z
  inc ix

  .end_zero2
  ld de,zeroes2

  .end_zeroes
  ld (ix + 0),#c3	; jp nn
  inc ix
  ld (ix + 0),e
  inc ix

  .end_code
  ld (ix + 0),d
  inc ix
  pop hl
  ret

  .count_err
  rst 0

  .less2
  add b
  ld b,a
  call do_b
  ld (ix + 0),#fd	; dec ly
  inc ix
  ld (ix + 0),#25
  inc ix
  ld (ix + 0),#c8	; ret z
  inc ix
  ld a,2
  sub c
  jr z,no_b
  ld b,a
  call do_b_lp
  .no_b
  ld d,#c9
  ld a,c
  or a 
  jr z,end_code
  dec a
  jr nz,end_zero2
  ld de,zeroes1
  jr end_zeroes

  macro comp_byte
    ld a,(hl)
    inc hl
    or a
    jr nz,@notz
    ld a,#77		; ld (hl),a
    jr @endc
    .@notz
    cp d
    jr nz,@notd
    ld a,#72		; ld (hl),d
    jr @endc
    .@notd
    cp e
    jr nz,@note
    ld a,#73		; ld (hl),e
    jr @endc
    .@note
    ld (ix + 0),#36	; ld (hl),n
    inc ix
    .@endc
    ld (ix + 0),a
    inc ix
  endm

  .do_b
  ld (ix + 0),#11	; ld de,nn
  inc ix
  ld (ix + 0),e
  inc ix
  ld (ix + 0),d
  inc ix
  .do_b_lp
  comp_byte
  ld (ix + 0),#2c	; inc l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; set 3,h
  inc ix
  ld (ix + 0),#dc
  inc ix
  comp_byte
  ld (ix + 0),#2d	; dec l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; res 3,h
  inc ix
  ld (ix + 0),#9c
  inc ix
  ld (ix + 0),#cb	; set 4,h
  inc ix
  ld (ix + 0),#e4
  inc ix
  comp_byte
  ld (ix + 0),#2c	; inc l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; set 3,h
  inc ix
  ld (ix + 0),#dc
  inc ix
  comp_byte
  ld (ix + 0),#2d	; dec l
  inc ix
  comp_byte
  ld (ix + 0),#7c	; ld a,h
  inc ix
  ld (ix + 0),#ee	; xor n
  inc ix
  ld (ix + 0),#38	; n = #38
  inc ix
  ld (ix + 0),#67	; ld h,a
  inc ix
  ld (ix + 0),#af	; xor a
  inc ix
  comp_byte
  ld (ix + 0),#2c	; inc l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; set 3,h
  inc ix
  ld (ix + 0),#dc
  inc ix
  comp_byte
  ld (ix + 0),#2d	; dec l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; res 3,h
  inc ix
  ld (ix + 0),#9c
  inc ix
  ld (ix + 0),#cb	; set 4,h
  inc ix
  ld (ix + 0),#e4
  inc ix
  comp_byte
  ld (ix + 0),#2c	; inc l
  inc ix
  comp_byte
  ld (ix + 0),#cb	; set 3,h
  inc ix
  ld (ix + 0),#dc
  inc ix
  comp_byte
  ld (ix + 0),#2d	; dec l
  inc ix
  comp_byte
  ld (ix + 0),#09	; add hl,bc
  inc ix
  dec b
  jp nz,do_b_lp
  ret

  .find_max
  cp (hl)
  jr nc,skip_max
  ld e,l
  ld a,(hl)
  .skip_max
  inc l
  jr nz,find_max
  ld l,e
  xor a
  ld (hl),a
  ld l,a
  ret

  .zero_entry
  ld hl,zeroes1
  ld de,zeroes8 - zeroes7
  .loop_zeroes
  dec c
  ret z
  add hl,de
  jr loop_zeroes

  .count_zeroes
  ld de,16
  ld c,0
  .cnt_z_lp
  push hl
  call is_zero
  pop hl
  ret nz
  add hl,de
  inc c
  ld a,c
  cp 18
  ret z
  jr cnt_z_lp

  .is_zero
  xor a
  ld b,16
  .zero_lp
  or (hl)
  ret nz
  inc hl
  djnz zero_lp
  or a
  ret

;  .convert_bars
;  ld hl,tree_code
;  ld de,tile_handle_straight
;  call convert_bar
;  call convert_bar

;  .convert_bar
;  ld b,7 * 16
;  ld c,#ff
;  .conv_bar_lp
;  call conv_byte
;  djnz conv_bar_lp
;  ret

  .decomp
  ld a,(hl)
  cp #e5
  jr z,more
  ldi
  jp pe,decomp
  ret
  .more
  inc hl
  ld a,(hl)
  or a
  jr z,isone
  inc hl
  .loopmr
  ldi
  ret po
  dec a
  jr z,decomp
  dec hl
  jr loopmr
  .isone
  dec hl
  ldi
  ret po
  inc hl
  jr decomp

  .start
  xor a
  ld bc,#fa7e
  out (c),a

  ld hl,tree_buffer
  ld de,tree_buffer + 1
  ld bc,end_trees - tree_buffer + #ff
  ld (hl),a
  ldir

  ld hl,(#38)
  push hl

  sound_reg 9,0
  sound_reg 7,#3d

  ld hl,#c9fb
  ld (#38),hl

  ld a,ink_0
  ld bc,#7f10
  .black_lp
  out (c),c
  out (c),a
  dec c
  jp p,black_lp

  ld bc,#bc01
  out (c),c
  ld bc,#bd20
  out (c),c
  ld bc,#bc06
  out (c),c
  ld bc,#bd18
  out (c),c

  ld bc,#bc02
  out (c),c
  ld bc,#bd2a
  out (c),c

  ld hl,screen
  ld de,#c000
  .moredecomp
  push de
  ld b,#40
  xor a
  .clr_sc_lp
  ld (de),a
  inc e
  djnz clr_sc_lp
  ld bc,#5c0
  call decomp
  pop de
  ld a,d
  add 8
  ld d,a
  jr nz,moredecomp

  ld lx,200

  ei

  .wait_lp2
  halt
  ld b,#f5
  in a,(c)
  rra
  jr nc,wait_lp2

  ld a,ink_12
  ld de,ink_13 * #100 + ink_20
  ld bc,#7f03
  out (c),c
  out (c),a
  dec c
  out (c),c
  out (c),e
  dec c
  out (c),c
  out (c),d

  halt
  halt
  ld b,60
  djnz $

  ld a,ink_6
  ld bc,#7f03
  out (c),c
  out (c),a

  halt

  ld b,20
  djnz $

  ld bc,#7f02
  out (c),c
  ld e,ink_3
  out (c),e

  ld b,#70
  djnz $
  djnz $

  ld d,9
  ld a,ink_12
  ld e,ink_26
  .loop1
  ld b,6
  djnz $
  nop
  ld bc,#7f02
  out (c),c
  out (c),e
  inc c
  out (c),c
  out (c),a

  ld e,ink_3
  dec c
  out (c),c
  out (c),e

  nop

  ld e,ink_26
  dec d
  jr nz,loop1

  ld hx,8
  ld d,ink_9

  .loop2
  ld hl,#0300 + ink_24

  out (c),c
  out (c),e

  out (c),h
  out (c),l

  nop:nop:nop:nop
  nop:nop:nop:nop
  nop

  out (c),a
  out (c),c
  out (c),d

  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop

  dec hx
  jr nz,loop2

  ld hx,8
  out (c),e
  out (c),h

  .loop3
  out (c),d
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop

  out (c),l
  nop:nop
  out (c),d

  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop:nop:nop:nop
  nop

  dec hx
  jr nz,loop3

  inc b
  djnz $

  ld bc,#7f01
  ld de,ink_13 * #100 + ink_8
  ld hl,ink_18 * #100 + ink_20

  ld hx,8

  .loop4
  nop:nop:nop:nop
  nop:nop

  out (c),c
  out (c),e

  ld b,5
  djnz $

  ld b,#7f
  out (c),d

  ld b,3
  djnz $
  nop:nop:nop

  ld b,#7f
  dec hx
  jr nz,loop4

  ld hx,8
  .loop5
  out (c),h

  nop:nop:nop:nop
  out (c),e

  ld b,5
  djnz $

  ld b,#7f
  out (c),d

  ld b,4
  djnz $
  nop

  ld b,#7f
  dec hx
  jr nz,loop5

  out (c),l

  sound_reg 9,15

  ld a,lx
  cp 101
  jr c,less100
  sub 100
  .less100
  cp 51
  jr c,less50
  ld c,a
  ld a,100
  sub c
  .less50
  sub 50
  neg
  add a
  add #40
  ld l,a
  adc 0
  sub l
  ld h,a
  sound_reg 3,h
  sound_reg 2,l

  dec lx
  jp nz, wait_lp2

  sound_reg 9,0
  sound_reg 7,#3f
  sound_reg 2,0
  sound_reg 3,0

  ld bc,#7f03
  ld a,ink_0
  .black_lp2
  out (c),c
  out (c),a
  dec c
  jr nz,black_lp2

  ld hl,#c000
  ld de,#c001
  ld bc,#3fff
  ldir

  di
  pop hl
  ld (#38),hl

  ld bc,#bc04
  out (c),c
  ld bc,#bd26
  out (c),c
  ld bc,#bc07
  out (c),c
  ld bc,#bd1c
  out (c),c

  call wait_ffb

  ld de,exp_char_orig
  ld hl,exp_char_src
  ld bc,7 * 4 + 1 * #100 + #0f
  .exp_conv_lp
  call conv_char
  djnz exp_conv_lp

  ld de,norm_char_orig
  ld hl,#3a00
  ld c,#f0
  .char_conv_lp
  call conv_bytes
  bit 6,h
  jr z,char_conv_lp

  ld bc,#7f8d
  out (c),c

  ld bc,#7f10
  out (c),c
  ld c,ink_13
  out (c),c
  ld c,1
  out (c),c
  ld c,ink_6
  out (c),c
  ld c,2
  out (c),c
  ld c,ink_8
  out (c),c

  ld bc,#bc01
  out (c),c
  ld bc,#bd1e
  out (c),c

  ld bc,#bc02
  out (c),c
  ld bc,#bd2a
  out (c),c

  ld bc,#bc06
  out (c),c
  ld bc,#bd16
  out (c),c

  call wait_ffb

  ld sp,#bff0

  ei

;  call convert_bars
  ld hl,spr_heli_left
  ld de,spr_heli_left + 8
  ld c,#0f
  call conv_char
  ld de,spr_heli_right + 8
  call conv_char
  ld de,spr_exp_left + 8
  call conv_char
  ld de,spr_exp_right + 8
  call conv_char

  ld c,#f0
  ld hl,spr_tank_left
  ld de,spr_tank_left + 8
  call conv_char
  ld de,spr_tank_right + 8
  call conv_char

  ld hl,spr_shots
  ld de,7 * 8 + spr_shots
  ld b,7
  .conv_shot_lp
  call conv_char
  djnz conv_shot_lp

  ld hl,spr_bike_small
  ld de,6 * 8 * 3 + spr_bike_small
  push de
  ld b,6
  .bike_small_lp1
  call conv_char
  djnz bike_small_lp1
  pop de
  ld bc,#060f
  .bike_small_lp2
  call conv_char
  djnz bike_small_lp2

  ld de,6 * 16 * 3 + spr_bike_large
  push de
  ld bc,#0cf0
  .bike_large_lp1
  call conv_char
  djnz bike_large_lp1
  pop de
  ld bc,#0c0f
  .bike_large_lp2
  call conv_char
  djnz bike_large_lp2

  ld hl,spr_explosion
  ld de,3 * 3 * 8 + spr_explosion
  ld bc,#090f
  .exp_loop
  call conv_char
  djnz exp_loop

  ld hl,back_masks
  .back_mask_lp
  ld c,0
  ld a,l
  and #88
  jr nz,no88
  ld c,#88
  .no88
  ld a,l
  and #44
  jr nz,no44
  set 6,c
  set 2,c
  .no44
  ld a,l
  and #22
  jr nz,no22
  set 5,c
  set 1,c
  .no22
  ld a,l
  and #11
  jr nz,no11
  set 4,c
  set 0,c
  .no11
  ld (hl),c
  inc l
  jr nz,back_mask_lp
  
  call convert_trees
  jp init

  .screen
  incbin "compscr.bin"

  align 256
  .back_masks 	ds 256

  .exp_char_src
  ds 7 * 4 * 16 + 16

  list
  .end
  nolist

endif
