/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.sound;

import JCPC.core.device.sound.SoundUtil;
import JCPC.core.device.sound.SunAudio;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class JavaSound
extends SunAudio {
    public static int SAMPLE_RATE = 44100;
    public static boolean muted = false;
    protected static AudioFormat STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, true);
    protected SourceDataLine line;
    protected byte[] data;
    protected int offset = 0;
    protected int channels;
    protected long startCount;

    public JavaSound(int n, boolean bl) {
        super(n, bl);
    }

    public int getSampleRate() {
        return SAMPLE_RATE;
    }

    protected void init() {
        this.format = 2;
        this.channels = 2;
        this.data = new byte[this.samples * this.channels];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -128;
        }
        AudioFormat audioFormat = STEREO_FORMAT;
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioFormat, SAMPLE_RATE * this.channels));
            this.line.open();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void resync() {
        int n;
        int n2;
        this.line.flush();
        for (n2 = 0; n2 < this.data.length; ++n2) {
            this.data[n2] = -128;
        }
        this.startCount = this.line.getLongFramePosition();
        for (n2 = SAMPLE_RATE / 10 * this.channels; n2 > 0; n2 -= n) {
            n = Math.min(this.data.length, n2);
            this.line.write(this.data, 0, n);
        }
        System.out.println("resync: start=" + this.startCount);
    }

    public long getCount() {
        return this.line.getLongFramePosition() - this.startCount - 100L;
    }

    public long getDeviation() {
        return SAMPLE_RATE / 10;
    }

    public void play() {
        this.resync();
        this.line.start();
    }

    public void stop() {
        this.line.stop();
    }

    public void dispose() {
        this.line.close();
    }

    public void writeStereo(int n, int n2) {
        n ^= 0x80;
        n2 ^= 0x80;
        switch (this.format) {
            case 0: {
                this.data[this.offset] = SoundUtil.ulawToUPCM8((byte)n);
                this.data[this.offset + 1] = SoundUtil.ulawToUPCM8((byte)n2);
                break;
            }
            case 2: {
                this.data[this.offset] = (byte)n;
                this.data[this.offset + 1] = (byte)n2;
            }
        }
        if (muted) {
            this.data[this.offset] = 0;
            this.data[this.offset + 1] = 0;
        }
        if ((this.offset += 2) == this.data.length) {
            this.line.write(this.data, 0, this.data.length);
            this.offset = 0;
        }
        ++this.updates;
    }
}

