/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.sound;

import JCPC.core.device.Device;
import JCPC.core.device.IOPort;
import JCPC.core.device.sound.JavaSound;
import JCPC.core.device.sound.SoundDevice;
import JCPC.core.device.sound.SoundUtil;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AY_3_8910
extends SoundDevice {
    public final double[] LOG_VOLUME = new double[]{0.08286408, 0.1171875, 0.1657282, 0.234375, 0.3314563, 0.46875, 0.6629126, 0.9375, 1.325825, 1.875, 2.65165, 3.75, 5.303301, 7.5, 10.6066, 15.0};
    public boolean register13Updated = false;
    public static boolean digiblast = false;
    public static int leftChannel;
    public static int rightChannel;
    public static int blasterA;
    public static int blasterB;
    protected int digibuffer = 20000;
    public static int digicount;
    public final int BDIR_MASK = 4;
    public final int BC2_MASK = 2;
    public final int BC1_MASK = 1;
    public final int PORT_A = 0;
    public final int PORT_B = 1;
    protected static final int INACTIVE = 0;
    protected static final int LATCH = 1;
    protected static final int READ = 2;
    protected static final int WRITE = 3;
    protected static final int[] STATES;
    protected static final int AFINE = 0;
    protected static final int ACOARSE = 1;
    protected static final int BFINE = 2;
    protected static final int BCOARSE = 3;
    protected static final int CFINE = 4;
    protected static final int CCOARSE = 5;
    protected static final int NOISEPERIOD = 6;
    protected static final int ENABLE = 7;
    protected static final int AVOL = 8;
    protected static final int BVOL = 9;
    protected static final int CVOL = 10;
    protected static final int EFINE = 11;
    protected static final int ECOARSE = 12;
    protected static final int ESHAPE = 13;
    protected static final int REG_PORTA = 14;
    protected static final int REG_PORTB = 15;
    protected static final int ENABLE_A = 1;
    protected static final int ENABLE_B = 2;
    protected static final int ENABLE_C = 4;
    protected static final int NOISE_A = 8;
    protected static final int NOISE_B = 16;
    protected static final int NOISE_C = 32;
    protected static final int PORT_A_OUT = 64;
    protected static final int PORT_B_OUT = 128;
    protected static final int NOISE_ALL = 56;
    protected static final int A = 0;
    protected static final int B = 1;
    protected static final int C = 2;
    protected static final int NOISE = 3;
    protected static final int ENVELOPE = 4;
    protected int step = 32768;
    protected int[] regs = new int[16];
    protected int selReg = 0;
    protected int bdirBC2BC1 = 0;
    protected int state = 0;
    protected int clockSpeed = 1000000;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0)};
    protected int[] envelope = new int[3];
    protected int[] output = new int[4];
    protected int[] count = new int[5];
    protected int[] period = new int[5];
    protected int[] volume = new int[5];
    protected int outN;
    protected int random = 1;
    protected int countEnv;
    protected int hold;
    protected int alternate;
    protected int attack;
    protected int holding;
    protected int updateStep;
    public static boolean tape;
    private int[] a;
    private int a = 1599;
    private int b = 0;

    public AY_3_8910() {
        super("AY-3-8910/2/3 Programmable Sound Generator");
        this.setClockSpeed(this.clockSpeed);
        this.player = SoundUtil.getSoundPlayer(4410, true);
        this.player.setFormat(2);
    }

    public void setClockSpeed(int n) {
        this.clockSpeed = n;
        this.updateStep = (int)(((long)this.step << 3) * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
        this.output[3] = 255;
        for (n = 0; n <= 4; ++n) {
            this.period[n] = this.count[n] = this.updateStep;
        }
        this.period[4] = 0;
        this.count[3] = Short.MAX_VALUE;
    }

    public void changeClockSpeed(int n) {
        this.clockSpeed = n;
        this.updateStep = (int)(((long)this.step << 3) * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
    }

    public void setSelectedRegister(int n) {
        this.selReg = n & 0xF;
    }

    public int getSelectedRegister() {
        return this.selReg;
    }

    public void setBDIR_BC2_BC1(int n, int n2) {
        if (this.bdirBC2BC1 != n) {
            this.bdirBC2BC1 = n;
            this.state = STATES[this.bdirBC2BC1];
            this.writePort(0, n2);
        }
    }

    public int getBDIR_BC2_BC1() {
        return this.bdirBC2BC1;
    }

    public int readPort(int n) {
        if (this.selReg != 0) {
            if (this.state == 2) {
                return this.readRegister(this.selReg);
            }
            return 255;
        }
        return 255;
    }

    public void writePort(int n, int n2) {
        if (n == 64510 || n == 64494) {
            return;
        }
        switch (this.state) {
            case 1: {
                this.selReg = n2 & 0xF;
                return;
            }
            case 3: {
                this.setRegister(this.selReg, n2);
            }
        }
    }

    public int getRegister(int n) {
        return this.regs[n];
    }

    public int readRegister(int n) {
        if (n < 14) {
            return this.regs[n];
        }
        return this.ports[n - 14].read();
    }

    public boolean registerUpdated() {
        return this.register13Updated;
    }

    public void resetUpdated() {
        this.register13Updated = false;
    }

    public void setRegister(int n, int n2) {
        block16: {
            block15: {
                if (n == 13) {
                    this.register13Updated = true;
                }
                if (n >= 14) break block15;
                if (n != 13 && this.regs[n] == n2) break block16;
                this.regs[n] = n2;
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = ((this.regs[((n >>= 1) << 1) + 1] & 0xF) << 8 | this.regs[n << 1]) * this.updateStep;
                        int n3 = this.period[n];
                        n2 = n2 < 32768 ? 32768 : n2;
                        this.period[n] = n2;
                        n2 = this.count[n] - (n2 - n3);
                        this.count[n] = n2 <= 0 ? 1 : n2;
                        break block16;
                    }
                    case 6: {
                        n2 = (n2 & 0x1F) * this.updateStep;
                        int n4 = this.period[3];
                        n2 = (n2 <<= 1) == 0 ? this.updateStep : n2;
                        this.period[3] = n2;
                        n2 = this.count[3] - (n2 - n4);
                        this.count[3] = n2 <= 0 ? 1 : n2;
                        break block16;
                    }
                    case 7: {
                        break block16;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.volume[n - 8] = (n2 & 0x10) == 0 ? n2 & 0xF : this.volume[4];
                        break block16;
                    }
                    case 11: 
                    case 12: {
                        n2 = (this.regs[12] << 8 | this.regs[11]) * this.updateStep << 1;
                        int n5 = this.period[4];
                        this.period[4] = n2;
                        n2 = this.count[4] - (n2 - n5);
                        this.count[4] = n2 <= 0 ? 1 : n2;
                        break block16;
                    }
                    case 13: {
                        int n6 = this.attack = (n2 & 4) == 0 ? 0 : 15;
                        if ((n2 & 8) == 0) {
                            this.hold = 1;
                            this.alternate = this.attack;
                        } else {
                            this.hold = n2 & 1;
                            this.alternate = n2 & 2;
                            if (this.hold != 0) {
                                this.attack = this.alternate;
                            }
                        }
                        this.count[4] = this.period[4];
                        this.countEnv = 15;
                        this.holding = 0;
                        n2 = this.volume[4] = this.attack ^ 0xF;
                        if ((this.regs[8] & 0x10) != 0) {
                            this.volume[0] = n2;
                        }
                        if ((this.regs[9] & 0x10) != 0) {
                            this.volume[1] = n2;
                        }
                        if ((this.regs[10] & 0x10) != 0) {
                            this.volume[2] = n2;
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
            this.ports[n - 14].write(n2);
        }
    }

    public void writeAudio() {
        int n;
        int n2;
        int n3;
        int n4 = this.regs[7];
        if ((n4 & 1) != 0) {
            if (this.count[0] <= this.step) {
                this.count[0] = this.count[0] + this.step;
            }
            this.output[0] = 1;
        }
        if ((n4 & 2) != 0) {
            if (this.count[1] <= this.step) {
                this.count[1] = this.count[1] + this.step;
            }
            this.output[1] = 1;
        }
        if ((n4 & 4) != 0) {
            if (this.count[2] <= this.step) {
                this.count[2] = this.count[2] + this.step;
            }
            this.output[2] = 1;
        }
        this.outN = this.output[3] | n4;
        if ((n4 & 0x38) == 56 && this.count[3] <= this.step) {
            this.count[3] = this.count[3] + this.step;
        }
        int[] nArray = new int[3];
        int n5 = this.step;
        do {
            n3 = this.count[3] < n5 ? this.count[3] : n5;
            for (n2 = 0; n2 <= 2; ++n2) {
                int n6;
                n = this.count[n2];
                if ((this.outN & 8 << n2) != 0) {
                    block31: {
                        int n7 = n6 = this.output[n2] == 0 ? nArray[n2] : nArray[n2] + n;
                        if ((n -= n3) <= 0) {
                            int n8 = this.period[n2];
                            do {
                                if ((n += n8) > 0) {
                                    int n9 = n2;
                                    this.output[n9] = this.output[n9] ^ 1;
                                    if (this.output[n9] != 0) {
                                        n6 += n8 - n;
                                    }
                                    break block31;
                                }
                                n6 += n8;
                            } while ((n += n8) <= 0);
                            if (this.output[n2] == 0) {
                                n6 -= n;
                            }
                        } else if (this.output[n2] != 0) {
                            n6 -= n;
                        }
                    }
                    nArray[n2] = n6;
                } else if ((n -= n3) <= 0) {
                    n6 = this.period[n2];
                    do {
                        if ((n += n6) <= 0) continue;
                        int n10 = n2;
                        this.output[n10] = this.output[n10] ^ 1;
                        break;
                    } while ((n += n6) <= 0);
                }
                this.count[n2] = n;
            }
            this.count[3] = this.count[3] - n3;
            if (this.count[3] > 0) continue;
            n2 = this.random + 1;
            if ((n2 & 2) != 0) {
                this.output[3] = this.output[3] ^ 0xFF;
                this.outN = this.output[3] | n4;
            }
            this.random = (this.random & 1) == 0 ? this.random >> 1 : (this.random ^ 0x28000) >> 1;
            this.count[3] = this.count[3] + this.period[3];
        } while ((n5 -= n3) > 0);
        if (this.holding == 0 && this.period[4] != 0 && (this.count[4] = this.count[4] - this.step) <= 0) {
            n3 = this.countEnv;
            n2 = this.period[4];
            do {
                --n3;
            } while ((this.count[4] = this.count[4] + n2) <= 0);
            if (n3 < 0) {
                if (this.hold != 0) {
                    if (this.alternate != 0) {
                        this.attack ^= 0xF;
                    }
                    this.holding = 1;
                    n3 = 0;
                } else {
                    if (this.alternate != 0 && (n3 & 0x10) != 0) {
                        this.attack ^= 0xF;
                    }
                    n3 &= 0xF;
                }
            }
            this.countEnv = n3;
            n = this.volume[4] = n3 ^ this.attack;
            if ((this.regs[8] & 0x10) != 0) {
                this.volume[0] = n;
            }
            if ((this.regs[9] & 0x10) != 0) {
                this.volume[1] = n;
            }
            if ((this.regs[10] & 0x10) != 0) {
                this.volume[2] = n;
            }
        }
        n3 = (int)(this.LOG_VOLUME[this.volume[0]] * (double)nArray[0]) >> 13;
        n2 = (int)(this.LOG_VOLUME[this.volume[1]] * (double)nArray[1]) >> 13;
        n = (int)(this.LOG_VOLUME[this.volume[2]] * (double)nArray[2]) >> 13;
        leftChannel = n3 + n2;
        rightChannel = n2 + n;
        this.soundOutput();
    }

    public void setReadDevice(int n, Device device, int n2) {
        this.ports[n].setInputDevice(device, n2);
    }

    public void soundOutput() {
        if (digiblast) {
            leftChannel = blasterA;
            rightChannel = blasterB;
        }
        if (digicount != 0) {
            ++digicount;
        }
        if (digicount >= this.digibuffer) {
            digiblast = false;
            digicount = 0;
        }
        if (digiblast && !tape) {
            int n = rightChannel;
            AY_3_8910 aY_3_8910 = this;
            try {
                aY_3_8910.a[aY_3_8910.a] = n;
                aY_3_8910.a = (aY_3_8910.a + 1) % aY_3_8910.a.length;
            }
            catch (Exception exception) {}
            rightChannel = this.a();
        }
        this.player.writeStereo(leftChannel, rightChannel);
    }

    private int a() {
        try {
            int n = this.a[this.b];
            this.b = (this.b + 1) % this.a.length;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setWriteDevice(int n, Device device, int n2) {
        this.ports[n].setOutputDevice(device, n2);
    }

    static {
        digicount = 0;
        STATES = new int[]{0, 1, 0, 2, 1, 0, 3, 1};
        tape = false;
    }
}

