/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.floppy;

import JCPC.core.device.Device;
import JCPC.core.device.floppy.DiscImage;
import JCPC.core.device.floppy.DriveListener;

public class Drive
extends Device {
    public static final int HEAD_0 = 1;
    public static final int HEAD_1 = 2;
    public static final int BOTH_HEADS = 3;
    protected boolean ready = true;
    protected boolean active = false;
    protected boolean writeProtected = true;
    protected int cylinder = 0;
    protected int head = 0;
    protected int sector = 0;
    protected int sides = 1;
    protected DiscImage[] discs = new DiscImage[2];
    protected DriveListener activeListener = null;
    private int a = 0;

    public Drive(int n) {
        super(null);
        this.setSides(n);
    }

    public void setSides(int n) {
        this.sides = n;
        this.name = (n == 1 ? "Single" : "Double") + "-Sided Floppy Drive";
    }

    public void setDisc(int n, DiscImage discImage) {
        if ((n & 1) != 0) {
            this.discs[0] = discImage;
        }
        if ((n & 2) != 0) {
            this.discs[1] = discImage;
        }
    }

    public DiscImage getDisc(int n) {
        return this.discs[n];
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWriteProtected() {
        this.writeProtected = false;
        return this.writeProtected;
    }

    public void setActiveListener(DriveListener driveListener) {
        this.activeListener = driveListener;
    }

    public void setActive(boolean bl) {
        if (this.active != bl) {
            this.active = bl;
            if (this.activeListener != null) {
                this.activeListener.driveActiveChanged(this, this.active);
            }
        }
    }

    public void setCylinder(int n) {
        this.cylinder = n;
    }

    public int getCylinder() {
        return this.cylinder;
    }

    public void setHead(int n) {
        if (this.sides != 2) {
            this.head = 0;
            return;
        }
        this.head = (n | this.a) & 1;
    }

    public void setForcedHead(int n) {
        this.a = n;
    }

    public int getForcedHead() {
        return this.a;
    }

    public int getHead() {
        return this.head;
    }

    public int getSides() {
        return this.sides;
    }

    public int getSectorCount() {
        if (this.discs[this.head] == null) {
            return 0;
        }
        return this.discs[this.head].getSectorCount(this.cylinder, this.head);
    }

    public int[] getNextSectorID() {
        if (this.discs[this.head] == null) {
            return null;
        }
        int n = this.discs[this.head].getSectorCount(this.cylinder, this.head);
        if (n > 0) {
            this.sector = (this.sector + 1) % n;
            return this.discs[this.head].getSectorID(this.cylinder, this.head, this.sector);
        }
        return null;
    }

    public int[] getReadID() {
        if (this.discs[this.head] == null) {
            return null;
        }
        int n = this.discs[this.head].getSectorCount(this.cylinder, this.head);
        if (n > 0) {
            return this.discs[this.head].getSectorID(this.cylinder, this.head, this.sector %= n);
        }
        return null;
    }

    public byte[] getSector(int n, int n2, int n3, int n4) {
        if (this.discs[this.head] == null) {
            return null;
        }
        return this.discs[this.head].readSector(this.cylinder, this.head, n, n2, n3, n4);
    }

    public void resetSector() {
        this.sector = 0;
    }

    public void saveImage() {
        this.discs[this.head].saveImage();
    }

    public void writeSector(int n, int n2, int n3, int n4, byte[] byArray) {
        if (this.discs[this.head] != null) {
            this.discs[this.head].writeSector(this.cylinder, this.head, n, n2, n3, n4, byArray);
        }
    }

    public boolean step(int n) {
        this.cylinder += n;
        if (this.cylinder < 0) {
            this.cylinder = 0;
        }
        return this.cylinder == 0;
    }
}

