/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.crtc;

import JCPC.core.Util;
import JCPC.core.device.crtc.CRTC;

public class Basic6845
extends CRTC {
    public static boolean patch = true;
    private boolean a;
    private boolean b;
    private boolean c;
    private boolean d;
    private boolean e = false;
    public int CRTCType = 1;
    public static int CRTC = 1;
    protected int[] HD6845S_ReadMaskTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected int[] HD6845S_WriteMaskTable = new int[]{255, 255, 255, 255, 127, 31, 127, 127, 243, 31, 127, 31, 63, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected int[] UM6845R_ReadMaskTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0};
    protected int[] UM6845R_WriteMaskTable = new int[]{255, 255, 255, 255, 127, 31, 127, 127, 3, 31, 127, 31, 63, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected final int EVENT_HSYNC_START = 1;
    protected final int EVENT_HDISP_END = 2;
    protected final int EVENT_HDISP_START = 4;
    protected final int EVENT_VSYNC_START = 8;
    protected final int EVENT_VSYNC_END = 16;
    public static boolean CRTCCollision = false;
    protected int lastReg = 0;
    public boolean Scratch;
    public boolean Scratchdemo = false;
    protected static final int[] CURSOR_FLASH_MASKS = new int[]{64, 0, 16, 32};
    public int ra;
    protected int hCC;
    public int vCC;
    protected int hCCMask = 127;
    protected static int[] reg = new int[32];
    protected static int[] regs = new int[32];
    protected int[] orig = new int[32];
    protected int[] rdMask;
    protected int[] wrMask;
    protected int[] eventMask = new int[256];
    protected int registerSelectMask = 3;
    protected int registerSelectTest = 0;
    protected int registerWriteMask = 3;
    protected int registerWriteTest = 0;
    protected int registerReadMask = 3;
    protected int registerReadTest = 0;
    protected int registerStatusMask = 3;
    protected int registerStatusTest = 0;
    protected int selReg;
    protected int hChars = 1;
    protected int hSyncStart;
    protected int hDispEnd;
    protected int hSyncWidth;
    protected int hSyncCount;
    protected int vSyncCount;
    protected int vSyncWidth;
    protected boolean inHSync = false;
    protected boolean inVSync = false;
    public boolean hDisp = true;
    public boolean vDisp = true;
    protected boolean interlace = false;
    protected int interlaceVideo = 0;
    protected int scanAdd = 1;
    protected int maxRaster = 0;
    protected int frame = 0;
    public int maStore = 0;
    public int maCurrent = 0;
    public int maRegister = 0;
    protected int vtAdj = 0;
    protected int halfR0 = 0;
    protected int hDispDelay = 0;
    protected int cursorMA = 0;
    protected int cursorStart = 0;
    protected int cursorEnd = 0;
    protected boolean cursor = false;
    protected int cursorCount = 0;
    protected int cursorFlash = 0;
    protected int cursorDelay = 0;
    protected int cursorWait = 0;
    protected boolean repaint = true;

    public Basic6845() {
        super("Basic 6845");
        this.wrMask = new int[32];
        this.rdMask = this.wrMask;
        this.setMasks();
        this.reset();
    }

    public void init() {
        this.setMasks();
        this.Scratch = false;
        this.Scratchdemo = false;
        this.e = false;
        this.d = false;
        this.c = false;
        this.b = false;
        this.a = false;
        this.setReg3(142);
    }

    public void reset() {
        this.e = false;
        this.d = false;
        this.c = false;
        this.b = false;
        this.a = false;
        this.hCC = 0;
        this.selReg = 0;
        this.maCurrent = this.maStore;
        this.hSyncCount = 0;
        this.hSyncWidth = 0;
        this.inHSync = false;
        for (int i = 0; i < this.eventMask.length; ++i) {
            this.eventMask[i] = 0;
        }
        Basic6845.reg[0] = 0x3F & this.wrMask[0];
        Basic6845.regs[0] = 0x3F & this.wrMask[0];
        this.setEvents();
    }

    public void setWriteMask(int n, int n2) {
        this.wrMask[n] = n2;
    }

    public void setMasks() {
        for (int i = 0; i < 32; ++i) {
            if (this.CRTCType == 0) {
                this.rdMask[i] = 0xFF | this.HD6845S_ReadMaskTable[i];
                this.wrMask[i] = 0xFF & this.HD6845S_WriteMaskTable[i];
            } else {
                this.rdMask[i] = 0xFF | this.UM6845R_ReadMaskTable[i];
                this.wrMask[i] = 0xFF & this.UM6845R_WriteMaskTable[i];
            }
            this.setRegister(i, this.orig[i]);
        }
    }

    public void cycle() {
        int n;
        if (this.hCC == reg[0]) {
            this.hCC = 0;
            this.scanStart();
            this.maCurrent = this.maStore;
        } else {
            this.hCC = this.hCC + 1 & this.hCCMask;
            this.maCurrent = this.maStore + this.hCC & 0x3FFF;
        }
        if (this.inHSync) {
            this.hSyncCount = this.hSyncCount + 1 & 0xF;
            if (this.hSyncCount == this.hSyncWidth) {
                this.inHSync = false;
                this.listener.hSyncEnd();
            }
        }
        if ((n = this.eventMask[this.hCC]) != 0) {
            if ((n & 8) != 0) {
                int n2 = this.hCC;
                this.eventMask[n2] = this.eventMask[n2] & 0xFFFFFFF7;
                this.inVSync = true;
                this.listener.vSyncStart();
            } else if ((n & 0x10) != 0) {
                int n3 = this.hCC;
                this.eventMask[n3] = this.eventMask[n3] & 0xFFFFFFEF;
                this.inVSync = false;
                this.listener.vSyncEnd();
            }
            if ((n & 1) != 0) {
                this.hSyncCount = 0;
                if (this.hDisp && this.CRTCType == 1 && this.hSyncWidth == (reg[3] & 0xF)) {
                    this.vDisp = reg[6] != 0;
                    this.hSyncCount = 1;
                }
                this.inHSync = true;
                this.listener.hSyncStart();
            }
            if (this.vDisp) {
                if (this.inHSync && (n & 2) != 0 && (n & 4) == 0 && this.vCC == 0) {
                    this.updateScreen();
                }
                if ((n & 4) != 0) {
                    this.hDisp = true;
                    this.listener.hDispStart();
                    this.maCurrent = this.maStore;
                    if (CRTC == 0 && this.vCC == 0 && this.a) {
                        this.updateScreen();
                    }
                    if (this.vCC == 0 && this.CRTCType == 1 && !this.b) {
                        this.updateScreen();
                    }
                }
                if ((n & 2) != 0) {
                    this.hDisp = false;
                    this.listener.hDispEnd();
                    if ((this.ra | this.interlaceVideo) == this.maxRaster) {
                        this.maStore = this.maStore + reg[1] & 0x3FFF;
                    }
                }
            }
        }
        this.checkHSync(false);
        if (this.cursor) {
            if (this.cursorWait > 0) {
                if (--this.cursorWait == 0) {
                    this.listener.cursor();
                    return;
                }
            } else if (this.maCurrent == this.cursorMA && this.ra >= this.cursorStart && this.ra <= this.cursorEnd && this.hDisp && (this.cursorWait = this.cursorDelay) == 0) {
                this.listener.cursor();
            }
        }
    }

    protected void newFrame() {
        this.vCC = 0;
        this.frame = this.interlace ? this.frame ^ 1 : 0;
        this.ra = this.frame & this.interlaceVideo;
        this.vDisp = reg[6] != 0;
        this.updateScreen();
        this.listener.vDispStart();
        this.checkVSync(false);
        this.cursorCount = this.cursorCount + 1 | 0x40;
        this.cursor = (this.cursorCount & this.cursorFlash) != 0 && this.cursorDelay != 3;
    }

    public void updateScreen() {
        this.maCurrent = this.maStore = this.maRegister;
    }

    protected void checkVSync(boolean bl) {
        if (this.e && this.CRTCType == 0) {
            bl = true;
        } else if (bl && (reg[6] != this.ra && this.e || !this.e)) {
            if (this.vtAdj == 0 || this.CRTCType == 1) {
                this.vCC = this.vCC + 1 & 0x7F;
            }
            bl = false;
        }
        if (this.vCC == reg[7] && !this.inVSync) {
            this.vSyncCount = 0;
            if (this.interlace && this.frame == 0) {
                int n = this.halfR0;
                this.eventMask[n] = this.eventMask[n] | 8;
            } else {
                this.inVSync = true;
                this.listener.vSyncStart();
            }
        }
        if (bl && this.vtAdj == 0) {
            this.vCC = this.vCC + 1 & 0x7F;
        }
    }

    public void checkHDisp() {
        block2: {
            block4: {
                block3: {
                    if (!this.hDisp) break block2;
                    if (this.CRTCType != 0) break block3;
                    if ((reg[8] & 0x30) == 48) break block4;
                    if ((reg[8] & 0x30) == 0) {
                        this.listener.hDispStart();
                        return;
                    }
                    break block2;
                }
                if (reg[6] != 0) {
                    this.listener.hDispStart();
                    return;
                }
            }
            this.listener.hDispEnd();
        }
    }

    public void avoidCollision() {
        if (this.inVSync && reg[4] <= reg[7]) {
            if (this.vCC == reg[7]) {
                this.vSyncCount = 0;
            }
            this.repaint = true;
            CRTCCollision = true;
        } else {
            CRTCCollision = false;
            if (this.vCC == 0 && this.hCC == reg[1] && !this.inVSync && !this.inHSync && this.lastReg == 4) {
                CRTCCollision = true;
                if (this.repaint) {
                    this.repaint = false;
                }
            }
        }
        if (reg[9] == 0 && reg[4] == 0 && this.inVSync) {
            this.vtAdj = 1;
        }
    }

    protected void scanStart() {
        if (CRTC != this.CRTCType) {
            this.CRTCType = CRTC;
            System.out.println("Changed CRTC type to " + CRTC);
            this.setMasks();
        }
        if (reg[9] == 0 && reg[4] == 0 && this.CRTCType == 0) {
            this.vtAdj = 1;
        }
        this.demoDetect();
        if (this.inVSync && (this.vSyncCount = this.vSyncCount + 1 & 0xF) == this.vSyncWidth) {
            if (this.interlace && this.frame == 0) {
                int n = this.halfR0;
                this.eventMask[n] = this.eventMask[n] | 0x10;
            } else {
                this.inVSync = false;
                this.listener.vSyncEnd();
            }
        }
        if (this.vtAdj > 0 && --this.vtAdj == 0) {
            this.newFrame();
            return;
        }
        if ((this.ra | this.interlaceVideo) == this.maxRaster) {
            if (this.vCC == reg[4] && this.vtAdj == 0) {
                this.vtAdj = reg[5] & 0x1F;
                if (this.interlace && this.frame == 0) {
                    ++this.vtAdj;
                }
                if (this.vtAdj == 0) {
                    this.newFrame();
                    return;
                }
                if (this.CRTCType == 0) {
                    this.vCC = this.vCC + 1 & 0x7F;
                }
            }
            if (reg[7] < reg[6] && this.vCC == reg[7] && this.vSyncCount == reg[7]) {
                this.vtAdj = 1;
                this.vSyncWidth = 0;
            }
            this.checkVSync(true);
            if (this.vCC == reg[6]) {
                this.vDisp = false;
            }
            this.ra = this.frame & this.interlaceVideo;
            return;
        }
        this.ra = this.ra + this.scanAdd & 0x1F;
    }

    public void writePort(int n, int n2) {
        if ((n & this.registerSelectMask) == this.registerSelectTest) {
            this.selReg = n2 & 0x1F;
        } else if ((n & this.registerWriteMask) == this.registerWriteTest) {
            this.setRegister(this.selReg, n2);
        }
        this.lastReg = this.selReg;
    }

    public int readPort(int n) {
        if ((n & this.registerStatusMask) == this.registerStatusTest && this.CRTCType == 1) {
            if (this.vCC == 0) {
                return 32;
            }
            return 0;
        }
        if ((n & this.registerReadMask) == this.registerReadTest) {
            n = reg[this.selReg];
            if (this.selReg < 10 || this.selReg > 17) {
                return 0;
            }
            if (this.CRTCType == 0) {
                switch (this.selReg) {
                    case 10: 
                    case 11: {
                        return n & 0x1F;
                    }
                    case 12: 
                    case 14: 
                    case 16: {
                        return n & 0x3F;
                    }
                }
                return n & 0xFF;
            }
            switch (this.selReg) {
                case 11: {
                    return n & 0x1F;
                }
                case 12: 
                case 13: {
                    return 0;
                }
                case 16: {
                    return n & 0x3F;
                }
            }
            return n & 0xFF;
        }
        return 255;
    }

    public void setRegister(int n, int n2) {
        this.orig[n] = n2 & 0xFF;
        if (reg[n] != (n2 &= this.wrMask[n])) {
            Basic6845.reg[n] = n2;
            Basic6845.regs[n] = n2;
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    if (!this.inHSync && n2 == 49) {
                        this.checkHSync(true);
                    }
                    this.setEvents();
                    return;
                }
                case 3: {
                    this.setReg3(n2);
                    this.setEvents();
                    return;
                }
                case 8: {
                    this.setReg8(n2);
                    return;
                }
                case 9: {
                    this.maxRaster = n2 | this.interlaceVideo;
                    return;
                }
                case 10: {
                    this.cursorStart = n2 & 0x1F;
                    this.cursorFlash = CURSOR_FLASH_MASKS[n2 >> 5 & 3];
                    return;
                }
                case 11: {
                    this.cursorEnd = n2 & 0x1F;
                    return;
                }
                case 12: 
                case 13: {
                    this.setReg13();
                    return;
                }
                case 14: 
                case 15: {
                    this.cursorMA = reg[15] + (reg[14] << 8) & 0x3FFF;
                }
            }
        }
    }

    protected void setReg13() {
        this.maRegister = reg[13] + (reg[12] << 8) & 0x3FFF;
    }

    protected void demoDetect() {
        if (!patch) {
            return;
        }
        this.e = this.listener.PEEK(3554) == 68 && this.listener.PEEK(3555) == 85 && this.listener.PEEK(3556) == 79 || this.listener.PEEK(3554) == 229 && this.listener.PEEK(3555) == 58 && this.listener.PEEK(3556) == 184 || this.listener.PEEK(33474) == 55 && this.listener.PEEK(33475) == 56 && this.listener.PEEK(33476) == 55 || this.listener.PEEK(9216) == 75 && this.listener.PEEK(9218) == 77 && this.listener.PEEK(9224) == 78;
        this.b = this.listener.PEEK(34816) == 148 && this.listener.PEEK(34817) == 76 && this.listener.PEEK(34818) == 148;
        if (this.listener.PEEK(13527) == 72 && this.listener.PEEK(13528) == 97 && this.listener.PEEK(13531) == 122) {
            this.d = true;
            this.setReg3(142);
        } else {
            this.d = false;
        }
        this.a = this.listener.PEEK(6772) == 64 && this.listener.PEEK(6777) == 70 && this.listener.PEEK(2656) == 120;
        if (!this.Scratch && this.listener.PEEK(492) == 50 && this.listener.PEEK(493) == 48 && this.listener.PEEK(495) == 57) {
            this.Scratchdemo = true;
            this.setReg3(143);
            this.Scratch = true;
        }
        if (this.listener.PEEK(44528) == 108 && this.listener.PEEK(16272) == 77 && this.listener.PEEK(16273) == 79 && this.listener.PEEK(16274) == 75) {
            this.c = true;
            return;
        }
        this.c = false;
    }

    protected void demoPatch() {
        if (!patch) {
            return;
        }
        if (this.a && reg[2] != 49 && reg[2] != 0) {
            Basic6845.reg[2] = 35;
        }
        if (this.b) {
            if (reg[1] == 24) {
                Basic6845.reg[1] = 23;
                Basic6845.reg[0] = 255;
            }
            if (reg[12] == 18) {
                this.vDisp = false;
            }
        }
        if (this.c) {
            this.hSyncCount = 12;
        }
    }

    protected void setEvents() {
        int n = this.hSyncStart;
        this.eventMask[n] = this.eventMask[n] & 0xFFFFFFFE;
        int n2 = this.hDispDelay;
        this.eventMask[n2] = this.eventMask[n2] & 0xFFFFFFFB;
        int n3 = this.hDispEnd;
        this.eventMask[n3] = this.eventMask[n3] & 0xFFFFFFFD;
        this.demoPatch();
        this.hChars = reg[0] + 1;
        this.halfR0 = this.hChars >> 1;
        this.hSyncStart = reg[2];
        this.hDispDelay = 0;
        this.hDispEnd = reg[1] + this.hDispDelay;
        int n4 = this.hSyncStart;
        this.eventMask[n4] = this.eventMask[n4] | 1;
        int n5 = this.hDispDelay;
        this.eventMask[n5] = this.eventMask[n5] | 4;
        int n6 = this.hDispEnd;
        this.eventMask[n6] = this.eventMask[n6] | 2;
    }

    protected void setReg3(int n) {
        if (n != 143 && this.Scratchdemo) {
            this.Scratchdemo = false;
        }
        this.vSyncWidth = this.CRTCType == 1 ? 0 : n >> 4 & 0xF;
        if (this.d && patch && n == 142) {
            n = 141;
        }
        if (patch && n != 13 && n > 3) {
            --n;
        }
        this.hSyncWidth = n & 0xF;
    }

    protected void checkHSync(boolean bl) {
        if (this.hSyncWidth == 0 || bl) {
            this.inHSync = false;
            this.hSyncCount = 0;
            try {
                this.listener.hSyncEnd();
                return;
            }
            catch (Exception exception) {}
        }
    }

    protected void setReg8(int n) {
        this.interlace = (n & 1) != 0;
        this.interlaceVideo = (n & 3) == 3 ? 1 : 0;
        this.scanAdd = this.interlaceVideo + 1;
        this.maxRaster = reg[9] | this.interlaceVideo;
        this.cursorDelay = n >> 6 & 3;
        this.setEvents();
    }

    public void setRegisterSelectMask(int n, int n2) {
        this.registerSelectMask = n;
        this.registerSelectTest = n2;
    }

    public void setRegisterWriteMask(int n, int n2) {
        this.registerWriteMask = n;
        this.registerWriteTest = n2;
    }

    public void setRegisterReadMask(int n, int n2) {
        this.registerReadMask = n;
        this.registerReadTest = n2;
    }

    public void setRegisterStatusMask(int n, int n2) {
        this.registerStatusMask = n;
        this.registerStatusTest = n2;
    }

    public int getHCC() {
        return this.hCC;
    }

    public boolean isVDisp() {
        return this.vDisp;
    }

    public boolean isVSync() {
        return this.inVSync;
    }

    public boolean isHSync() {
        return this.inHSync;
    }

    public boolean isHDisp() {
        return this.hDisp;
    }

    public int getMA() {
        return this.maCurrent;
    }

    public int getRA() {
        return this.ra;
    }

    public int getScreenMA() {
        return this.maStore;
    }

    public int getVCC() {
        return this.vCC;
    }

    public int getVLC() {
        return this.ra;
    }

    public int getReg(int n) {
        return reg[n];
    }

    public int getRegs(int n) {
        return regs[n];
    }

    public static String getRegister(int n) {
        return Util.hex(reg[n]).substring(6);
    }

    public int getSelectedRegister() {
        return this.selReg;
    }

    public void setSelectedRegister(int n) {
        this.selReg = n & 0x1F;
    }

    public boolean isInterlace() {
        return this.interlace;
    }

    public boolean isInterlaceVideo() {
        return this.interlaceVideo == 1;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getCRTC() {
        return this.CRTCType;
    }

    public void setCRTC(int n) {
        this.CRTCType = n & 1;
        CRTC = n & 1;
        this.setMasks();
    }

    public int getRegisterValue(int n) {
        int n2 = reg[n];
        if (n == 12) {
            n2 = reg[12] << 8 | reg[13];
        } else if (n == 13) {
            n2 = reg[14] << 8 | reg[15];
        }
        return n2;
    }
}

