/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.cpu;

import JCPC.core.Util;
import JCPC.core.cpu.Processor;
import JCPC.core.device.Register;

public class Z80
extends Processor {
    protected static final byte[] Z80_TIME_PRE = new byte[]{4, 10, 7, 6, 4, 4, 7, 4, 4, 11, 7, 6, 4, 4, 7, 4, 8, 10, 7, 6, 4, 4, 7, 4, 12, 11, 7, 6, 4, 4, 7, 4, 7, 10, 16, 6, 4, 4, 7, 4, 7, 11, 16, 6, 4, 4, 7, 4, 7, 10, 13, 6, 11, 11, 10, 4, 7, 11, 13, 6, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 5, 10, 10, 10, 10, 11, 8, 11, 5, 10, 10, 4, 10, 17, 8, 11, 5, 10, 10, 8, 10, 11, 8, 11, 5, 4, 10, 8, 10, 4, 8, 11, 5, 10, 10, 19, 10, 11, 8, 11, 5, 4, 10, 4, 10, 4, 8, 11, 5, 10, 10, 4, 10, 11, 8, 11, 5, 6, 10, 4, 10, 4, 8, 11};
    public static final byte[] Z80_TIME_PRE_ED = new byte[]{4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 14, 4, 4, 11, 16, 4, 10, 4, 14, 4, 4, 11, 16, 4, 10, 4, 4, 4, 4, 11, 16, 4, 10, 4, 4, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    protected static final int CYCLES_EXTRA_JRCC = 0;
    protected static final int CYCLES_EXTRA_DJNZ = 1;
    protected static final int CYCLES_EXTRA_CALLCC = 2;
    protected static final int CYCLES_EXTRA_RETCC = 3;
    protected static final int CYCLES_EXTRA_LDIR = 4;
    protected static final int CYCLES_EXTRA_CPIR = 5;
    protected static final int CYCLES_EXTRA_INIR = 6;
    protected static final int CYCLES_EXTRA_OTIR = 7;
    protected static final int CYCLES_EXTRA_IDXNORM = 8;
    protected static final int CYCLES_EXTRA_IDXLDIN = 9;
    protected static final int CYCLES_EXTRA_IDXCB = 10;
    protected static final int CYCLES_EXTRA_IM0 = 11;
    protected static final int CYCLES_EXTRA_IM1 = 12;
    protected static final int CYCLES_EXTRA_IM2 = 13;
    protected static final int CYCLES_EXTRA_INTACK = 14;
    protected static final byte[] Z80_TIME_EXTRA = new byte[]{5, 5, 7, 6, 5, 5, 5, 5, 8, 5, 4, 0, 0, 17, 2};
    public static final int B = 0;
    public static final int C = 1;
    public static final int D = 2;
    public static final int E = 3;
    public static final int H = 4;
    public static final int L = 5;
    public static final int F = 6;
    public static final int A = 7;
    public static final int B1 = 8;
    public static final int C1 = 9;
    public static final int D1 = 10;
    public static final int E1 = 11;
    public static final int H1 = 12;
    public static final int L1 = 13;
    public static final int F1 = 14;
    public static final int A1 = 15;
    public static final int BC = 0;
    public static final int DE = 2;
    public static final int HL = 4;
    public static final int AF = 6;
    public static final int FS = 128;
    public static final int FZ = 64;
    public static final int F5 = 32;
    public static final int FH = 16;
    public static final int F3 = 8;
    public static final int FPV = 4;
    public static final int FN = 2;
    public static final int FC = 1;
    protected static final int FLAG_MASK_LDIR = 193;
    protected static final int FLAG_MASK_LDDR = 193;
    protected static final int FLAG_MASK_CPIR = 250;
    protected static final int FLAG_MASK_CPL = 197;
    protected static final int FLAG_MASK_CCF = 197;
    protected static final int FLAG_MASK_SCF = 197;
    protected static final int FLAG_MASK_ADDHL = 196;
    protected static final int FLAG_MASK_RLCA = 196;
    protected static final int FLAG_MASK_RLD = 1;
    protected static final int FLAG_MASK_BIT = 1;
    protected static final int FLAG_MASK_IN = 1;
    protected static final int FLAG_MASK_INI = 232;
    protected int[] reg = new int[16];
    public int SP;
    public int PC;
    public int IX;
    public int IY;
    protected int I;
    protected int R;
    protected int R7;
    protected int IM;
    protected boolean IFF1;
    protected boolean IFF2;
    protected boolean noWait = false;
    protected boolean inHalt = false;
    protected boolean interruptExecute = false;
    protected int interruptVector = 255;
    protected byte[] timePre = new byte[256];
    protected byte[] timePost = new byte[256];
    protected byte[] timePreCB = new byte[256];
    protected byte[] timePostCB = new byte[256];
    protected byte[] timePreED = new byte[128];
    protected byte[] timePostED = new byte[128];
    protected byte[] timeExtra = new byte[2];
    protected static int[] PARITY = new int[256];
    protected static final int[] CC_MASK;
    protected static final int[] CC_TEST;
    protected static final Register[] REGISTERS;

    public Z80(long l) {
        super("Zilog Z80", l);
        this.setTimes();
    }

    protected void setTimes() {
        int n;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray2[n] = (n & 7) != 6 ? 4 : ((n & 0xC0) == 64 ? 8 : 11);
        }
        this.setTimes(Z80_TIME_PRE, byArray, byArray2, byArray, Z80_TIME_PRE_ED, new byte[80], Z80_TIME_EXTRA);
        this.timePost[219] = 3;
        this.timePost[211] = 3;
        for (n = 0; n < 64; n += 8) {
            this.timePostED[n + 64] = 4;
            this.timePostED[n + 65] = 4;
        }
    }

    protected void setTimes(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        int n;
        this.timePre = Z80.checkByteArraySize(byArray, 256);
        this.timePost = Z80.checkByteArraySize(byArray2, 256);
        this.timePreCB = Z80.checkByteArraySize(byArray3, 256);
        this.timePostCB = Z80.checkByteArraySize(byArray4, 256);
        Z80.checkByteArraySize(byArray5, 80);
        Z80.checkByteArraySize(byArray6, 80);
        this.timePreED = new byte[256];
        this.timePostED = new byte[256];
        for (n = 0; n < 256; ++n) {
            this.timePreED[n] = this.timePre[0];
            this.timePostED[n] = this.timePost[0];
        }
        System.arraycopy(byArray5, 0, this.timePreED, 64, 64);
        System.arraycopy(byArray6, 0, this.timePostED, 64, 64);
        for (n = 0; n < 4; ++n) {
            System.arraycopy(byArray5, 64 + (n << 2), this.timePreED, 160 + (n << 3), 4);
            System.arraycopy(byArray6, 64 + (n << 2), this.timePostED, 160 + (n << 3), 4);
        }
        this.timeExtra = Z80.checkByteArraySize(byArray7, 15);
    }

    protected static byte[] checkByteArraySize(byte[] byArray, int n) {
        int n2 = byArray == null ? 0 : byArray.length;
        if (n2 != n) {
            throw new RuntimeException("Invalid Length for byte array: " + n2 + ". Should be " + n);
        }
        return byArray;
    }

    public void reset() {
        super.reset();
        for (int i = 0; i < this.reg.length; ++i) {
            this.reg[i] = 0;
        }
        this.IY = 0;
        this.IX = 0;
        this.PC = 0;
        this.SP = 0;
        this.IM = 0;
        this.R7 = 0;
        this.R = 0;
        this.I = 0;
        this.IFF2 = false;
        this.IFF1 = false;
        this.interruptPending = 0;
        this.noWait = false;
        this.inHalt = false;
        this.interruptExecute = false;
    }

    public void stepOver() {
        int n = this.memory.readByte(this.PC);
        switch (n) {
            case 118: {
                this.runTo(this.PC + 1 & 0xFFFF);
                return;
            }
            case 237: {
                this.stepOverED();
                return;
            }
            case 196: 
            case 204: 
            case 205: 
            case 212: 
            case 220: 
            case 228: 
            case 244: 
            case 252: {
                this.runTo(this.PC + 3 & 0xFFFF);
                return;
            }
        }
        this.step();
    }

    protected void stepOverED() {
        int n = this.memory.readByte(this.PC + 1 & 0xFFFF);
        switch (n) {
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                this.runTo(this.PC + 2 & 0xFFFF);
                return;
            }
        }
        this.step();
    }

    public final void step() {
        if (this.interruptExecute) {
            this.doInterrupt();
            return;
        }
        if (this.inHalt) {
            this.step(0);
            return;
        }
        this.step(this.fetchOpCode());
    }

    protected final void step(int n) {
        boolean bl = this.IFF1;
        this.noWait = false;
        this.executeNormal(n);
        this.interruptExecute = this.interruptPending != 0 && bl && this.IFF1;
    }

    protected void executeNormal(int n) {
        this.cycle(this.timePre[n]);
        ++this.R;
        switch (n) {
            case 0: {
                this.nop();
                break;
            }
            case 1: 
            case 17: 
            case 33: 
            case 49: {
                this.ldddnn(n, this.fetchWord());
                break;
            }
            case 2: {
                this.ldbca();
                break;
            }
            case 3: 
            case 19: 
            case 35: 
            case 51: {
                this.incss(n);
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 60: {
                this.incr(n);
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 61: {
                this.decr(n);
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 38: 
            case 46: 
            case 62: {
                this.ldrn(n, this.fetch());
                break;
            }
            case 7: {
                this.rlca();
                break;
            }
            case 8: {
                this.exafaf1();
                break;
            }
            case 9: 
            case 25: 
            case 41: 
            case 57: {
                this.addhlss(n);
                break;
            }
            case 10: {
                this.ldabc();
                break;
            }
            case 11: 
            case 27: 
            case 43: 
            case 59: {
                this.decss(n);
                break;
            }
            case 15: {
                this.rrca();
                break;
            }
            case 16: {
                this.djnze((byte)this.fetch());
                break;
            }
            case 18: {
                this.lddea();
                break;
            }
            case 23: {
                this.rla();
                break;
            }
            case 24: {
                this.jre((byte)this.fetch());
                break;
            }
            case 26: {
                this.ldade();
                break;
            }
            case 31: {
                this.rra();
                break;
            }
            case 32: {
                this.jrnze((byte)this.fetch());
                break;
            }
            case 34: {
                this.ldxxhl(this.fetchWord());
                break;
            }
            case 39: {
                this.daa();
                break;
            }
            case 40: {
                this.jrze((byte)this.fetch());
                break;
            }
            case 42: {
                this.ldhlxx(this.fetchWord());
                break;
            }
            case 47: {
                this.cpl();
                break;
            }
            case 48: {
                this.jrnce((byte)this.fetch());
                break;
            }
            case 50: {
                this.ldxxa(this.fetchWord());
                break;
            }
            case 52: {
                this.incchl();
                break;
            }
            case 53: {
                this.decchl();
                break;
            }
            case 54: {
                this.ldhln(this.fetch());
                break;
            }
            case 55: {
                this.scf();
                break;
            }
            case 56: {
                this.jrce((byte)this.fetch());
                break;
            }
            case 58: {
                this.ldaxx(this.fetchWord());
                break;
            }
            case 63: {
                this.ccf();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                this.ldrr(n);
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 126: {
                this.ldrhl(n);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: {
                this.ldhlr(n);
                break;
            }
            case 118: {
                this.halt();
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: {
                this.addar(n);
                break;
            }
            case 134: {
                this.addahl();
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: {
                this.adcar(n);
                break;
            }
            case 142: {
                this.adcahl();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 151: {
                this.subar(n);
                break;
            }
            case 150: {
                this.subahl();
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 159: {
                this.sbcar(n);
                break;
            }
            case 158: {
                this.sbcahl();
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: {
                this.andar(n);
                break;
            }
            case 166: {
                this.andahl();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: {
                this.xorar(n);
                break;
            }
            case 174: {
                this.xorahl();
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                this.orar(n);
                break;
            }
            case 182: {
                this.orahl();
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: {
                this.cpar(n);
                break;
            }
            case 190: {
                this.cpahl();
                break;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: 
            case 224: 
            case 232: 
            case 240: 
            case 248: {
                this.retcc(n);
                break;
            }
            case 193: 
            case 209: 
            case 225: 
            case 241: {
                this.popqq(n);
                break;
            }
            case 194: 
            case 202: 
            case 210: 
            case 218: 
            case 226: 
            case 234: 
            case 242: 
            case 250: {
                this.jpccnn(n, this.fetchWord());
                break;
            }
            case 195: {
                this.jpnn(this.fetchWord());
                break;
            }
            case 196: 
            case 204: 
            case 212: 
            case 220: 
            case 228: 
            case 236: 
            case 244: 
            case 252: {
                this.callccnn(n, this.fetchWord());
                break;
            }
            case 197: 
            case 213: 
            case 229: 
            case 245: {
                this.pushqq(n);
                break;
            }
            case 198: {
                this.addan(this.fetch());
                break;
            }
            case 199: 
            case 207: 
            case 215: 
            case 223: 
            case 231: 
            case 239: 
            case 247: 
            case 255: {
                this.rstp(n);
                break;
            }
            case 201: {
                this.ret();
                break;
            }
            case 203: {
                this.executeCB(this.fetch(), false);
                break;
            }
            case 205: {
                this.callnn(this.fetchWord());
                break;
            }
            case 206: {
                this.adcan(this.fetch());
                break;
            }
            case 211: {
                this.outna(this.fetch());
                break;
            }
            case 214: {
                this.suban(this.fetch());
                break;
            }
            case 217: {
                this.exx();
                break;
            }
            case 219: {
                this.inan(this.fetch());
                break;
            }
            case 221: {
                this.IX = this.executeDDFD(this.IX, this.fetch());
                break;
            }
            case 222: {
                this.sbcan(this.fetch());
                break;
            }
            case 227: {
                this.exsphl();
                break;
            }
            case 230: {
                this.andan(this.fetch());
                break;
            }
            case 233: {
                this.jphl();
                break;
            }
            case 235: {
                this.exdehl();
                break;
            }
            case 237: {
                this.executeED(this.fetch());
                break;
            }
            case 238: {
                this.xoran(this.fetch());
                break;
            }
            case 243: {
                this.di();
                break;
            }
            case 246: {
                this.oran(this.fetch());
                break;
            }
            case 249: {
                this.ldsphl();
                break;
            }
            case 251: {
                this.ei();
                break;
            }
            case 253: {
                this.IY = this.executeDDFD(this.IY, this.fetch());
                break;
            }
            case 254: {
                this.cpan(this.fetch());
                break;
            }
            default: {
                throw new RuntimeException("Invalid Opcode: " + Util.hex((byte)n));
            }
        }
        this.cycle(this.timePost[n]);
    }

    protected void executeCB(int n, boolean bl) {
        this.cycle(this.timePreCB[n]);
        ++this.R;
        int n2 = -1;
        switch (bl ? n & 0xF8 | 6 : n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.rlcr(n);
                break;
            }
            case 6: {
                n2 = this.rlchl();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                this.rrcr(n);
                break;
            }
            case 14: {
                n2 = this.rrchl();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                this.rlr(n);
                break;
            }
            case 22: {
                n2 = this.rlhl();
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                this.rrr(n);
                break;
            }
            case 30: {
                n2 = this.rrhl();
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.slar(n);
                break;
            }
            case 38: {
                n2 = this.slahl();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                this.srar(n);
                break;
            }
            case 46: {
                n2 = this.srahl();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: {
                this.sllr(n);
                break;
            }
            case 54: {
                n2 = this.sllhl();
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: {
                this.srlr(n);
                break;
            }
            case 62: {
                n2 = this.srlhl();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                this.bitbr(n);
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 118: 
            case 126: {
                this.bitbhl(n);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: {
                this.resbr(n);
                break;
            }
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                n2 = this.resbhl(n);
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 255: {
                this.setbr(n);
                break;
            }
            case 198: 
            case 206: 
            case 214: 
            case 222: 
            case 230: 
            case 238: 
            case 246: 
            case 254: {
                n2 = this.setbhl(n);
                break;
            }
            default: {
                throw new RuntimeException("Invalid Opcode: CB " + n);
            }
        }
        if (bl && (n & 7) != 6 && (n & 0xC0) != 64) {
            int n3 = n & 7;
            this.reg[n3] = n2;
        }
        this.cycle(this.timePostCB[n]);
    }

    protected void executeED(int n) {
        this.cycle(this.timePreED[n]);
        ++this.R;
        switch (n) {
            case 64: 
            case 72: 
            case 80: 
            case 88: 
            case 96: 
            case 104: 
            case 120: {
                this.inrc(n);
                break;
            }
            case 65: 
            case 73: 
            case 81: 
            case 89: 
            case 97: 
            case 105: 
            case 121: {
                this.outcr(n);
                break;
            }
            case 66: 
            case 82: 
            case 98: 
            case 114: {
                this.sbchlss(n);
                break;
            }
            case 67: 
            case 83: 
            case 99: 
            case 115: {
                this.ldxxdd(n, this.fetchWord());
                break;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                this.neg();
                break;
            }
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                this.retn();
                break;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                this.imn(0);
                break;
            }
            case 71: {
                this.ldia();
                break;
            }
            case 74: 
            case 90: 
            case 106: 
            case 122: {
                this.adchlss(n);
                break;
            }
            case 75: 
            case 91: 
            case 107: 
            case 123: {
                this.ldddxx(n, this.fetchWord());
                break;
            }
            case 77: 
            case 93: 
            case 109: 
            case 125: {
                this.reti();
                break;
            }
            case 79: {
                this.ldra();
                break;
            }
            case 86: 
            case 118: {
                this.imn(1);
                break;
            }
            case 87: {
                this.ldai();
                break;
            }
            case 94: 
            case 126: {
                this.imn(2);
                break;
            }
            case 95: {
                this.ldar();
                break;
            }
            case 103: {
                this.rrd();
                break;
            }
            case 111: {
                this.rld();
                break;
            }
            case 112: {
                this.inc();
                break;
            }
            case 113: {
                this.outc0();
                break;
            }
            case 160: {
                this.ldi();
                break;
            }
            case 161: {
                this.cpi();
                break;
            }
            case 162: {
                this.ini();
                break;
            }
            case 163: {
                this.outi();
                break;
            }
            case 168: {
                this.ldd();
                break;
            }
            case 169: {
                this.cpd();
                break;
            }
            case 170: {
                this.ind();
                break;
            }
            case 171: {
                this.outd();
                break;
            }
            case 176: {
                this.ldir();
                break;
            }
            case 177: {
                this.cpir();
                break;
            }
            case 178: {
                this.inir();
                break;
            }
            case 179: {
                this.otir();
                break;
            }
            case 184: {
                this.lddr();
                break;
            }
            case 185: {
                this.cpdr();
                break;
            }
            case 186: {
                this.indr();
                break;
            }
            case 187: {
                this.otdr();
                break;
            }
            default: {
                this.nop();
            }
        }
        this.cycle(this.timePostED[n]);
    }

    protected int executeDDFD(int n, int n2) {
        switch (n2) {
            case 9: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 57: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 84: 
            case 85: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 124: 
            case 125: 
            case 132: 
            case 133: 
            case 140: 
            case 141: 
            case 148: 
            case 149: 
            case 156: 
            case 157: 
            case 164: 
            case 165: 
            case 172: 
            case 173: 
            case 180: 
            case 181: 
            case 188: 
            case 189: 
            case 225: 
            case 227: 
            case 229: 
            case 233: 
            case 249: {
                n = this.swapDDFD(n, n2);
                break;
            }
            case 52: 
            case 53: 
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 126: 
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                this.indexDDFD(n, n2, 8);
                break;
            }
            case 54: {
                this.indexDDFD(n, n2, 9);
                break;
            }
            case 203: {
                this.indexDDFD(n, n2, 10);
                break;
            }
            case 102: 
            case 110: {
                this.ldrixiyd(n, n2);
                break;
            }
            case 116: 
            case 117: {
                this.ldixiydr(n, n2);
                break;
            }
            default: {
                this.executeNormal(n2);
            }
        }
        return n;
    }

    protected int swapDDFD(int n, int n2) {
        int n3 = this.getqq(4);
        this.setqq(4, n);
        this.executeNormal(n2);
        n = this.getqq(4);
        this.setqq(4, n3);
        return n;
    }

    protected void indexDDFD(int n, int n2, int n3) {
        this.cycle(this.timeExtra[n3]);
        n3 = this.getqq(4);
        this.setqq(4, n + (byte)this.fetch() & 0xFFFF);
        this.executeNormal(n2);
        this.setqq(4, n3);
    }

    protected void ldrixiyd(int n, int n2) {
        this.cycle(this.timePre[n2] + this.timeExtra[8]);
        ++this.R;
        int n3 = (n2 & 0x38) >> 3;
        this.reg[n3] = this.readByte(n + (byte)this.fetch() & 0xFFFF);
        this.cycle(this.timePost[n2]);
    }

    protected void ldixiydr(int n, int n2) {
        this.cycle(this.timePre[n2] + this.timeExtra[8]);
        ++this.R;
        int n3 = n2 & 7;
        this.writeByte(n + (byte)this.fetch() & 0xFFFF, this.reg[n3]);
        this.cycle(this.timePost[n2]);
    }

    protected void stopHalt() {
        if (this.inHalt) {
            this.inHalt = false;
            this.PC = this.PC + 1 & 0xFFFF;
        }
    }

    public void nmi() {
        this.IFF1 = false;
        this.stopHalt();
        this.cycle(this.timePre[205]);
        this.callnn(102);
        this.cycle(this.timePost[205]);
    }

    protected void doInterrupt() {
        this.interruptExecute = false;
        this.stopHalt();
        if (!this.noWait) {
            this.cycle(this.timeExtra[14]);
        }
        if (this.interruptDevice != null) {
            this.interruptDevice.setInterrupt(1);
        }
        this.interruptNotify();
        this.IFF2 = false;
        this.IFF1 = false;
        switch (this.IM) {
            case 0: {
                this.cycle(this.timeExtra[11]);
                this.step(this.interruptVector);
                return;
            }
            case 1: {
                this.cycle(this.timeExtra[12]);
                this.step(255);
                return;
            }
            case 2: {
                this.cycle(this.timeExtra[13]);
                this.push(this.PC);
                this.PC = this.readWord(this.I << 8 | this.interruptVector);
            }
        }
    }

    protected void interruptNotify() {
    }

    protected int fetchWord() {
        int n = this.fetch();
        return n | this.fetch() << 8;
    }

    protected int fetch() {
        int n = this.readByte(this.PC);
        this.PC = this.PC + 1 & 0xFFFF;
        return n;
    }

    protected int fetchOpCode() {
        int n = this.readByte(this.PC);
        this.PC = this.PC + 1 & 0xFFFF;
        return n;
    }

    protected void ldrr(int n) {
        int n2 = (n & 0x38) >> 3;
        this.reg[n2] = this.reg[n &= 7];
    }

    protected void ldrn(int n, int n2) {
        n = (n & 0x38) >> 3;
        this.reg[n] = n2;
    }

    protected void ldrhl(int n) {
        n = (n & 0x38) >> 3;
        this.reg[n] = this.readByte(this.getqq(4));
    }

    protected void ldhlr(int n) {
        this.writeByte(this.getqq(4), this.reg[n &= 7]);
    }

    protected void ldhln(int n) {
        this.writeByte(this.getqq(4), n);
    }

    protected void ldabc() {
        this.reg[7] = this.readByte(this.getqq(0));
    }

    protected void ldade() {
        this.reg[7] = this.readByte(this.getqq(2));
    }

    protected void ldaxx(int n) {
        this.reg[7] = this.readByte(n);
    }

    protected void ldbca() {
        this.writeByte(this.getqq(0), this.reg[7]);
    }

    protected void lddea() {
        this.writeByte(this.getqq(2), this.reg[7]);
    }

    protected void ldxxa(int n) {
        this.writeByte(n, this.reg[7]);
    }

    protected void ldai() {
        this.ldair(this.I);
    }

    protected void ldar() {
        this.ldair(this.R & 0x7F | this.R7);
    }

    protected void ldia() {
        this.I = this.reg[7];
        this.noWait = true;
    }

    protected void ldra() {
        this.R = this.reg[7];
        this.R7 = this.reg[7] & 0x80;
        this.noWait = true;
    }

    protected void ldddnn(int n, int n2) {
        n = (n & 0x30) >> 3;
        this.setdd(n, n2);
    }

    protected void ldhlxx(int n) {
        this.setqq(4, this.readWord(n));
    }

    protected void ldddxx(int n, int n2) {
        n = (n & 0x30) >> 3;
        this.setdd(n, this.readWord(n2));
    }

    protected void ldxxhl(int n) {
        this.writeWord(n, this.getdd(4));
    }

    protected void ldxxdd(int n, int n2) {
        n = (n & 0x30) >> 3;
        this.writeWord(n2, this.getdd(n));
    }

    protected void ldsphl() {
        this.SP = this.getqq(4);
    }

    protected void pushqq(int n) {
        n = (n & 0x30) >> 3;
        this.push(this.getqq(n));
    }

    protected void popqq(int n) {
        n = (n & 0x30) >> 3;
        this.setqq(n, this.pop());
    }

    protected void exdehl() {
        int n = this.reg[2];
        this.reg[2] = this.reg[4];
        this.reg[4] = n;
        n = this.reg[3];
        this.reg[3] = this.reg[5];
        this.reg[5] = n;
    }

    protected void exafaf1() {
        int n = this.reg[7];
        this.reg[7] = this.reg[15];
        this.reg[15] = n;
        n = this.reg[6];
        this.reg[6] = this.reg[14];
        this.reg[14] = n;
    }

    protected void exx() {
        for (int i = 0; i <= 5; ++i) {
            int n = this.reg[i];
            this.reg[i] = this.reg[i + 8];
            this.reg[i + 8] = n;
        }
    }

    protected void exsphl() {
        int n = this.readWord(this.SP);
        this.writeWord(this.SP, this.getqq(4));
        this.setqq(4, n);
        this.noWait = true;
    }

    protected void ldi() {
        int n = this.getqq(2);
        int n2 = this.getqq(4);
        this.writeByte(n++, this.readByte(n2++));
        this.setqq(2, n & 0xFFFF);
        this.setqq(4, n2 & 0xFFFF);
        n = this.getqq(0) - 1 + 1 & 0xFFFF;
        this.setqq(0, --n);
        n2 = this.reg[6] & 0xC1;
        this.reg[6] = n != 0 ? n2 | 4 : n2;
        this.noWait = true;
    }

    protected void ldir() {
        int n = this.getqq(2);
        int n2 = this.getqq(4);
        this.writeByte(n++, this.readByte(n2++));
        this.setqq(2, n & 0xFFFF);
        this.setqq(4, n2 & 0xFFFF);
        n = this.getqq(0) - 1 + 1 & 0xFFFF;
        this.setqq(0, --n);
        n2 = this.reg[6] & 0xC1;
        this.reg[6] = n != 0 ? n2 | 4 : n2;
        this.noWait = true;
        if ((this.reg[6] & 4) != 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[4]);
        }
    }

    protected void ldd() {
        int n = this.getqq(2);
        int n2 = this.getqq(4);
        this.writeByte(n--, this.readByte(n2--));
        this.setqq(2, n & 0xFFFF);
        this.setqq(4, n2 & 0xFFFF);
        n = this.getqq(0) - 1 + 1 & 0xFFFF;
        this.setqq(0, --n);
        n2 = this.reg[6] & 0xC1;
        this.reg[6] = n != 0 ? n2 | 4 : n2;
        this.noWait = true;
    }

    protected void lddr() {
        int n = this.getqq(2);
        int n2 = this.getqq(4);
        this.writeByte(n--, this.readByte(n2--));
        this.setqq(2, n & 0xFFFF);
        this.setqq(4, n2 & 0xFFFF);
        n = this.getqq(0) - 1 + 1 & 0xFFFF;
        this.setqq(0, --n);
        n2 = this.reg[6] & 0xC1;
        this.reg[6] = n != 0 ? n2 | 4 : n2;
        this.noWait = true;
        if ((this.reg[6] & 4) != 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[4]);
        }
    }

    protected void cpi() {
        this.cpid(1);
    }

    protected void cpir() {
        this.cpid(1);
        if ((this.reg[6] & 0x44) == 4) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[5]);
            this.noWait = true;
        }
    }

    protected void cpd() {
        this.cpid(-1);
    }

    protected void cpdr() {
        this.cpid(-1);
        if ((this.reg[6] & 0x44) == 4) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[5]);
            this.noWait = true;
        }
    }

    protected void addar(int n) {
        this.addan(this.reg[n &= 7], 0);
    }

    protected void addan(int n) {
        this.addan(n, 0);
    }

    protected void addahl() {
        this.addan(this.readByte(this.getqq(4)), 0);
    }

    protected void adcar(int n) {
        this.addan(this.reg[n &= 7], this.reg[6] & 1);
    }

    protected void adcan(int n) {
        this.addan(n, this.reg[6] & 1);
    }

    protected void adcahl() {
        this.addan(this.readByte(this.getqq(4)), this.reg[6] & 1);
    }

    protected void subar(int n) {
        this.suba(this.reg[n &= 7], 0);
    }

    protected void suban(int n) {
        this.suba(n, 0);
    }

    protected void subahl() {
        this.suba(this.readByte(this.getqq(4)), 0);
    }

    protected void sbcar(int n) {
        this.suba(this.reg[n &= 7], this.reg[6] & 1);
    }

    protected void sbcan(int n) {
        this.suba(n, this.reg[6] & 1);
    }

    protected void sbcahl() {
        this.suba(this.readByte(this.getqq(4)), this.reg[6] & 1);
    }

    protected void andar(int n) {
        this.andan(this.reg[n &= 7]);
    }

    protected void andan(int n) {
        n = this.reg[7] = this.reg[7] & n;
        int n2 = this.reg[7] & 0xA8 | 0x10 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void andahl() {
        this.andan(this.readByte(this.getqq(4)));
    }

    protected void orar(int n) {
        this.oran(this.reg[n &= 7]);
    }

    protected void oran(int n) {
        n = this.reg[7] = this.reg[7] | n;
        int n2 = this.reg[7] & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void orahl() {
        this.oran(this.readByte(this.getqq(4)));
    }

    protected void xorar(int n) {
        this.xoran(this.reg[n &= 7]);
    }

    protected void xoran(int n) {
        n = this.reg[7] = this.reg[7] ^ n;
        int n2 = this.reg[7] & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void xorahl() {
        this.xoran(this.readByte(this.getqq(4)));
    }

    protected void cpar(int n) {
        this.cpan(this.reg[n &= 7]);
    }

    protected void cpan(int n) {
        int n2 = this.reg[7];
        int n3 = n2 - n;
        int n4 = n3 & 0x80 | 2 | n & 0x28;
        if (n3 < 0) {
            n4 |= 1;
        }
        if (((n2 ^ n) & 0x80) != 0 && (((n3 &= 0xFF) ^ n2) & 0x80) != 0) {
            n4 |= 4;
        }
        if ((n2 & 0xF) - (n & 0xF) < 0) {
            n4 |= 0x10;
        }
        this.reg[6] = n3 == 0 ? n4 | 0x40 : n4;
    }

    protected void cpin(int n) {
        int n2 = this.reg[7];
        int n3 = n2 - n;
        int n4 = n3 & 0x80 | 2;
        if (n3 < 0) {
            n4 |= 1;
        }
        if (((n2 ^ n) & 0x80) != 0 && (((n3 &= 0xFF) ^ n2) & 0x80) != 0) {
            n4 |= 4;
        }
        if ((n2 & 0xF) - (n & 0xF) < 0) {
            n4 |= 0x10;
        }
        this.reg[6] = n3 == 0 ? n4 | 0x40 : n4;
        this.reg[6] = this.reg[6] | ((n3 -= this.reg[6] >> 4 & 1) & 2) << 4;
        this.reg[6] = this.reg[6] | n3 & 8;
    }

    protected void cpahl() {
        this.cpan(this.readByte(this.getqq(4)));
    }

    protected void incr(int n) {
        n = (n & 0x38) >> 3;
        this.reg[n] = this.incn(this.reg[n]);
    }

    protected void incchl() {
        int n = this.getqq(4);
        this.writeByte(n, this.incn(this.readByte(n)));
    }

    protected void decr(int n) {
        n = (n & 0x38) >> 3;
        this.reg[n] = this.decn(this.reg[n]);
    }

    protected void decchl() {
        int n = this.getqq(4);
        this.writeByte(n, this.decn(this.readByte(n)));
    }

    protected void daa() {
        int n = this.reg[7];
        int n2 = this.reg[6];
        int n3 = n & 0xF;
        int n4 = n3 = n3 > 9 || (n2 & 0x10) != 0 ? 6 : 0;
        if ((n2 & 1) != 0 || n > 153) {
            n2 |= 1;
            n3 |= 0x60;
        }
        if ((n2 & 2) != 0) {
            this.suba(n3, 0);
        } else {
            this.addan(n3, 0);
        }
        this.reg[6] = this.reg[6] & 0xFFFFFFFA | n2 & 1 | PARITY[this.reg[7]];
    }

    protected void cpl() {
        int n = this.reg[7] = ~this.reg[7] & 0xFF;
        this.reg[6] = this.reg[6] & 0xC5 | n & 0x28 | 0x10 | 2;
    }

    protected void neg() {
        int n = this.reg[7];
        this.reg[7] = 0;
        this.suba(n, 0);
    }

    protected void ccf() {
        int n = this.reg[6];
        this.reg[6] = n & 0xC5 ^ 1 | this.reg[7] & 0x28 | ((n & 1) == 0 ? 0 : 16);
    }

    protected void scf() {
        this.reg[6] = this.reg[6] & 0xC5 | this.reg[7] & 0x28 | 1;
    }

    protected void nop() {
    }

    protected void halt() {
        this.inHalt = true;
        this.PC = this.PC - 1 & 0xFFFF;
    }

    public void di() {
        this.IFF2 = false;
        this.IFF1 = false;
    }

    public void ei() {
        this.IFF2 = true;
        this.IFF1 = true;
    }

    protected void imn(int n) {
        this.IM = n;
    }

    protected void addhlss(int n) {
        n = (n & 0x30) >> 3;
        int n2 = this.getqq(4);
        n = this.getdd(n);
        int n3 = n2 + n;
        int n4 = this.reg[6] & 0xC4 | n3 >> 8 & 0x28;
        if ((n3 & 0x10000) != 0) {
            n4 |= 1;
        }
        if ((n2 & 0xFFF) + (n & 0xFFF) > 4095) {
            n4 |= 0x10;
        }
        this.setqq(4, n3);
        this.reg[6] = n4;
    }

    protected void adchlss(int n) {
        n = (n & 0x30) >> 3;
        int n2 = this.getqq(4);
        n = this.getdd(n);
        int n3 = this.reg[6] & 1;
        int n4 = n2 + n + n3;
        int n5 = n4 >> 8 & 0xA8;
        if ((n4 & 0x10000) != 0) {
            n5 |= 1;
        }
        if ((n2 & 0xFFF) + (n & 0xFFF) + n3 > 4095) {
            n5 |= 0x10;
        }
        if (((n2 ^ n) & 0x8000) == 0 && ((n4 ^ n2) & 0x8000) != 0) {
            n5 |= 4;
        }
        this.setqq(4, n4 &= 0xFFFF);
        this.reg[6] = n4 == 0 ? n5 | 0x40 : n5;
    }

    protected void sbchlss(int n) {
        n = (n & 0x30) >> 3;
        int n2 = this.getqq(4);
        n = this.getdd(n);
        int n3 = this.reg[6] & 1;
        int n4 = n2 - n - n3;
        int n5 = n4 >> 8 & 0xA8 | 2;
        if (n4 < 0) {
            n5 |= 1;
        }
        if ((n2 & 0xFFF) - (n & 0xFFF) - n3 < 0) {
            n5 |= 0x10;
        }
        if (((n2 ^ n) & 0x8000) != 0 && ((n4 ^ n2) & 0x8000) != 0) {
            n5 |= 4;
        }
        this.setqq(4, n4 &= 0xFFFF);
        this.reg[6] = n4 == 0 ? n5 | 0x40 : n5;
    }

    protected void incss(int n) {
        n = (n & 0x30) >> 3;
        this.setdd(n, this.getdd(n) + 1 & 0xFFFF);
    }

    protected void decss(int n) {
        n = (n & 0x30) >> 3;
        this.setdd(n, this.getdd(n) - 1 & 0xFFFF);
    }

    protected void rlca() {
        int n = this.reg[7];
        int n2 = (n & 0x80) == 0 ? 0 : 1;
        this.reg[7] = n = (n << 1 | n2) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | n & 0x28 | n2;
    }

    protected void rla() {
        int n = this.reg[7];
        int n2 = this.reg[6];
        n = n << 1 | n2 & 1;
        n2 = n2 & 0xC4 | n & 0x28;
        this.reg[7] = n & 0xFF;
        this.reg[6] = (n & 0x100) != 0 ? n2 | 1 : n2;
    }

    protected void rrca() {
        int n = this.reg[7];
        int n2 = n & 1;
        this.reg[7] = n = (n >> 1 | n2 << 7) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | n & 0x28 | n2;
    }

    protected void rra() {
        int n = this.reg[7];
        int n2 = this.reg[6];
        int n3 = n & 1;
        this.reg[7] = n = ((n2 & 1) == 0 ? n >> 1 : n >> 1 | 0x80) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | n & 0x28 | n3;
    }

    protected void rlcr(int n) {
        this.reg[n &= 7] = this.rlcn(this.reg[n]);
    }

    protected int rlchl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.rlcn(this.readByte(n)));
    }

    protected void rlr(int n) {
        this.reg[n &= 7] = this.rln(this.reg[n]);
    }

    protected int rlhl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.rln(this.readByte(n)));
    }

    protected void rrcr(int n) {
        this.reg[n &= 7] = this.rrcn(this.reg[n]);
    }

    protected int rrchl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.rrcn(this.readByte(n)));
    }

    protected void rrr(int n) {
        this.reg[n &= 7] = this.rrn(this.reg[n]);
    }

    protected int rrhl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.rrn(this.readByte(n)));
    }

    protected void slar(int n) {
        this.reg[n &= 7] = this.slan(this.reg[n]);
    }

    protected int slahl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.slan(this.readByte(n)));
    }

    protected void sllr(int n) {
        this.reg[n &= 7] = this.slln(this.reg[n]);
    }

    protected int sllhl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.slln(this.readByte(n)));
    }

    protected void srar(int n) {
        this.reg[n &= 7] = this.sran(this.reg[n]);
    }

    protected int srahl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.sran(this.readByte(n)));
    }

    protected void srlr(int n) {
        this.reg[n &= 7] = this.srln(this.reg[n]);
    }

    protected int srlhl() {
        int n = this.getqq(4);
        return this.writeByte(n, this.srln(this.readByte(n)));
    }

    protected void rld() {
        int n = this.reg[7];
        int n2 = this.getqq(4);
        int n3 = this.readByte(n2);
        this.writeByte(n2, (n3 << 4 | n & 0xF) & 0xFF);
        this.reg[7] = n = n & 0xF0 | n3 >> 4 & 0xF;
        n2 = this.reg[6] & 1 | n & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void rrd() {
        int n = this.reg[7];
        int n2 = this.getqq(4);
        int n3 = this.readByte(n2);
        this.writeByte(n2, n << 4 & 0xF0 | n3 >> 4 & 0xF);
        this.reg[7] = n = n & 0xF0 | n3 & 0xF;
        n2 = this.reg[6] & 1 | n & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void bitbr(int n) {
        int n2 = n & 7;
        this.bitbn(this.reg[n2], n);
    }

    protected void bitbhl(int n) {
        int n2 = this.getqq(4) & 0xFFFF;
        this.bitbn(this.readByte(n2), n);
    }

    protected void setbr(int n) {
        int n2 = n & 7;
        this.reg[n2] = this.setbn(this.reg[n2], n);
    }

    protected int setbhl(int n) {
        int n2 = this.getqq(4);
        return this.writeByte(n2, this.setbn(this.readByte(n2), n));
    }

    protected void resbr(int n) {
        int n2 = n & 7;
        this.reg[n2] = this.resbn(this.reg[n2], n);
    }

    protected int resbhl(int n) {
        int n2 = this.getqq(4);
        return this.writeByte(n2, this.resbn(this.readByte(n2), n));
    }

    protected void jpnn(int n) {
        this.PC = n;
    }

    protected void jpccnn(int n, int n2) {
        if ((this.reg[6] & CC_MASK[n = (n & 0x38) >> 3]) == CC_TEST[n]) {
            this.PC = n2;
        }
    }

    protected void jre(byte by) {
        this.PC = this.PC + by & 0xFFFF;
    }

    protected void jrce(byte by) {
        if ((this.reg[6] & 1) != 0) {
            this.PC = this.PC + by & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrnce(byte by) {
        if ((this.reg[6] & 1) == 0) {
            this.PC = this.PC + by & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrze(byte by) {
        if ((this.reg[6] & 0x40) != 0) {
            this.PC = this.PC + by & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrnze(byte by) {
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC + by & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jphl() {
        this.PC = this.getqq(4);
    }

    protected void djnze(byte by) {
        int n = this.reg[0] = this.reg[0] - 1 & 0xFF;
        if (this.reg[0] != 0) {
            this.PC = this.PC + by & 0xFFFF;
            this.cycle(this.timeExtra[1]);
        }
    }

    protected void callnn(int n) {
        this.push(this.PC);
        this.PC = n;
    }

    protected void callccnn(int n, int n2) {
        if ((this.reg[6] & CC_MASK[n = (n & 0x38) >> 3]) == CC_TEST[n]) {
            this.push(this.PC);
            this.PC = n2;
            this.cycle(this.timeExtra[2]);
        }
    }

    protected void ret() {
        this.PC = this.pop();
    }

    protected void retcc(int n) {
        if ((this.reg[6] & CC_MASK[n = (n & 0x38) >> 3]) == CC_TEST[n]) {
            this.PC = this.pop();
            this.cycle(this.timeExtra[3]);
        }
    }

    protected void reti() {
        this.PC = this.pop();
    }

    protected void retn() {
        this.PC = this.pop();
        this.IFF1 = this.IFF2;
    }

    protected void rstp(int n) {
        this.push(this.PC);
        this.PC = n & 0x38;
    }

    protected void inan(int n) {
        this.reg[7] = this.in(this.reg[7] << 8 | n);
    }

    protected void inrc(int n) {
        n = (n & 0x38) >> 3;
        n = this.reg[n] = this.in(this.getqq(0));
        int n2 = this.reg[6] & 1 | n & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void inc() {
        int n = this.in(this.getqq(0));
        int n2 = this.reg[6] & 1 | n & 0xA8 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
    }

    protected void ini() {
        this.inid(1);
    }

    protected void inir() {
        this.inid(1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[6]);
        }
    }

    protected void ind() {
        this.inid(-1);
    }

    protected void indr() {
        this.inid(-1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[6]);
        }
    }

    protected void outna(int n) {
        this.out(this.reg[7] << 8 | n, this.reg[7]);
    }

    protected void outcr(int n) {
        n = (n & 0x38) >> 3;
        this.out(this.getqq(0), this.reg[n]);
    }

    protected void outc0() {
        this.out(this.getqq(0), 0);
    }

    protected void outi() {
        this.outid(1);
    }

    protected void otir() {
        this.outid(1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[7]);
        }
    }

    protected void outd() {
        this.outid(-1);
    }

    protected void otdr() {
        this.outid(-1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[7]);
        }
    }

    protected void cpid(int n) {
        int n2 = this.reg[6] & 1;
        int n3 = this.getqq(4);
        this.cpin(this.readByte(n3) & 0xFFFF);
        n3 = n3 + n & 0xFFFF;
        this.setqq(4, n3);
        n = this.getqq(0) - 1 & 0xFFFF;
        this.setqq(0, n);
        n2 = this.reg[6] & 0xFA | n2;
        this.reg[6] = n != 0 ? n2 | 4 : n2;
    }

    protected void ldair(int n) {
        this.reg[7] = n;
        int n2 = n & 0xA8 | this.reg[6] & 1;
        if (this.IFF2) {
            n2 |= 4;
        }
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        this.noWait = true;
    }

    protected void addan(int n, int n2) {
        int n3 = this.reg[7];
        int n4 = n3 + n + n2;
        int n5 = n4 & 0xA8;
        if ((n4 & 0x100) != 0) {
            n5 |= 1;
        }
        this.reg[7] = n4 &= 0xFF;
        if (((n3 ^ n) & 0x80) == 0 && ((n4 ^ n3) & 0x80) != 0) {
            n5 |= 4;
        }
        if ((n3 & 0xF) + (n & 0xF) + n2 > 15) {
            n5 |= 0x10;
        }
        this.reg[6] = n4 == 0 ? n5 | 0x40 : n5;
    }

    protected void suba(int n, int n2) {
        int n3 = this.reg[7];
        int n4 = n3 - n - n2;
        int n5 = n4 & 0xA8 | 2;
        if (n4 < 0) {
            n5 |= 1;
        }
        this.reg[7] = n4 &= 0xFF;
        if (((n3 ^ n) & 0x80) != 0 && ((n4 ^ n3) & 0x80) != 0) {
            n5 |= 4;
        }
        if ((n3 & 0xF) - (n & 0xF) - n2 < 0) {
            n5 |= 0x10;
        }
        this.reg[6] = n4 == 0 ? n5 | 0x40 : n5;
    }

    protected int incn(int n) {
        n = n + 1 & 0xFF;
        int n2 = n & 0xA8 | this.reg[6] & 1;
        if ((n & 0xF) == 0) {
            n2 |= 0x10;
        }
        if (n == 128) {
            n2 |= 4;
        } else if (n == 0) {
            n2 |= 0x40;
        }
        this.reg[6] = n2;
        return n;
    }

    protected int decn(int n) {
        n = n - 1 & 0xFF;
        int n2 = n & 0xA8 | this.reg[6] & 1 | 2;
        if ((n & 0xF) == 15) {
            n2 |= 0x10;
        }
        if (n == 127) {
            n2 |= 4;
        } else if (n == 0) {
            n2 |= 0x40;
        }
        this.reg[6] = n2;
        return n;
    }

    protected int rlcn(int n) {
        int n2 = (n & 0x80) == 0 ? 0 : 1;
        n = (n << 1 | n2) & 0xFF;
        n2 = n & 0xA8 | n2 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        return n;
    }

    protected int rln(int n) {
        int n2 = this.reg[6];
        n = n << 1 | n2 & 1;
        n2 = n & 0xA8;
        if ((n & 0x100) != 0) {
            n2 |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? n2 | 0x40 : n2) | PARITY[n];
        return n;
    }

    protected int rrcn(int n) {
        int n2 = n & 1;
        n = (n >> 1 | n2 << 7) & 0xFF;
        n2 = n & 0xA8 | n2 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        return n;
    }

    protected int rrn(int n) {
        int n2 = this.reg[6];
        int n3 = n & 1;
        n = ((n2 & 1) == 0 ? n >> 1 : n >> 1 | 0x80) & 0xFF;
        n2 = n & 0xA8 | n3 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        return n;
    }

    protected int slan(int n) {
        int n2 = (n <<= 1) & 0xA8;
        if ((n & 0x100) != 0) {
            n2 |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? n2 | 0x40 : n2) | PARITY[n];
        return n;
    }

    protected int slln(int n) {
        n = n << 1 | 1;
        int n2 = n & 0xA8;
        if ((n & 0x100) != 0) {
            n2 |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? n2 | 0x40 : n2) | PARITY[n];
        return n;
    }

    protected int sran(int n) {
        int n2 = n & 1;
        n = n >> 1 | n & 0x80;
        n2 = n & 0xA8 | n2 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        return n;
    }

    protected int srln(int n) {
        int n2 = n & 1;
        n2 = (n >>= 1) & 0xA8 | n2 | PARITY[n];
        this.reg[6] = n == 0 ? n2 | 0x40 : n2;
        return n;
    }

    protected void bitbn(int n, int n2) {
        n2 = (n2 & 0x38) >> 3;
        int n3 = this.reg[6] & 1 | n & 0x28 | 0x10;
        if ((n >> n2 & 1) != 0) {
            this.reg[6] = n2 == 7 ? n3 | 0x80 : n3;
            return;
        }
        this.reg[6] = n3 | 0x44;
    }

    protected int setbn(int n, int n2) {
        n2 = (n2 & 0x38) >> 3;
        return n | 1 << n2;
    }

    protected int resbn(int n, int n2) {
        n2 = (n2 & 0x38) >> 3;
        return n & ~(1 << n2);
    }

    protected void inid(int n) {
        int n2 = this.getqq(4);
        int n3 = this.reg[0];
        int n4 = this.reg[1];
        int n5 = this.in(n3 << 8 | n4);
        this.writeByte(n2, n5);
        this.setqq(4, n2 + n & 0xFFFF);
        n4 = ((n4 + n & 0xFF) + n5 & 0x100) != 0 ? 17 : 0;
        this.reg[0] = this.decn(n3);
        this.reg[6] = this.reg[6] & 0xE8 | n4 | PARITY[n5] | (n5 & 0x80) >> 6;
    }

    protected void outid(int n) {
        int n2 = this.getqq(4);
        int n3 = this.reg[0] = this.decn(this.reg[0]);
        this.out(n3 << 8 | this.reg[1], this.readByte(n2));
        this.setqq(4, n2 + n & 0xFFFF);
    }

    protected int getqq(int n) {
        if (n == 6) {
            return this.reg[n] | this.reg[n + 1] << 8;
        }
        return this.reg[n + 1] | this.reg[n] << 8;
    }

    protected void setqq(int n, int n2) {
        if (n == 6) {
            this.reg[n] = n2 & 0xFF;
            this.reg[n + 1] = n2 >> 8 & 0xFF;
            return;
        }
        this.reg[n + 1] = n2 & 0xFF;
        this.reg[n] = n2 >> 8 & 0xFF;
    }

    protected int getdd(int n) {
        if (n == 6) {
            return this.SP;
        }
        return this.reg[n + 1] | this.reg[n] << 8;
    }

    protected void setdd(int n, int n2) {
        if (n == 6) {
            this.SP = n2 & 0xFFFF;
            return;
        }
        this.reg[n + 1] = n2 & 0xFF;
        this.reg[n] = n2 >> 8 & 0xFF;
    }

    protected int pop() {
        int n = this.readWord(this.SP);
        this.SP = this.SP + 2 & 0xFFFF;
        return n;
    }

    protected void push(int n) {
        this.SP = this.SP - 2 & 0xFFFF;
        this.writeWord(this.SP, n);
    }

    public String getState() {
        String string = "AF :" + Util.hex((short)this.getqq(6)) + " HL :" + Util.hex((short)this.getqq(4)) + " DE :" + Util.hex((short)this.getqq(2)) + " BC :" + Util.hex((short)this.getqq(0)) + " IX :" + Util.hex((short)this.IX) + " IY :" + Util.hex((short)this.IY) + "\n" + "AF':" + Util.hex((byte)this.reg[15]) + Util.hex((byte)this.reg[14]) + " HL':" + Util.hex((short)this.getqq(12)) + " DE':" + Util.hex((short)this.getqq(10)) + " BC':" + Util.hex((short)this.getqq(8)) + " Cycles: " + Util.hex((int)this.cycles);
        return string;
    }

    public Register[] getRegisters() {
        return REGISTERS;
    }

    public int getRegisterValue(int n) {
        switch (n) {
            case 0: {
                n = this.reg[6];
                break;
            }
            case 1: {
                n = this.getqq(6);
                break;
            }
            case 2: {
                n = this.reg[14] | this.reg[15] << 8;
                break;
            }
            case 3: {
                n = this.getqq(4);
                break;
            }
            case 4: {
                n = this.getqq(12);
                break;
            }
            case 5: {
                n = this.getqq(2);
                break;
            }
            case 6: {
                n = this.getqq(10);
                break;
            }
            case 7: {
                n = this.getqq(0);
                break;
            }
            case 8: {
                n = this.getqq(8);
                break;
            }
            case 9: {
                n = this.IX;
                break;
            }
            case 10: {
                n = this.SP;
                break;
            }
            case 11: {
                n = this.IY;
                break;
            }
            case 12: {
                n = this.I;
                break;
            }
            case 13: {
                n = this.PC;
                break;
            }
            case 14: {
                n = this.R & 0x7F | this.R7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public int getProgramCounter() {
        return this.PC;
    }

    public void setAF(int n) {
        this.setqq(6, n);
    }

    public void setB(int n) {
        this.setqq(0, n);
    }

    public void setBC(int n) {
        this.setqq(0, n);
    }

    public void setDE(int n) {
        this.setqq(2, n);
    }

    public void setHL(int n) {
        this.setqq(4, n);
    }

    public void setR(int n) {
        this.R = n & 0xFF;
        this.R7 = n & 0x80;
    }

    public void setI(int n) {
        this.I = n & 0xFF;
    }

    public void setIFF1(boolean bl) {
        this.IFF1 = bl;
    }

    public void setIFF2(boolean bl) {
        this.IFF2 = bl;
    }

    public int getIFF1() {
        if (this.IFF1) {
            return 1;
        }
        return 0;
    }

    public int getIFF2() {
        if (this.IFF2) {
            return 1;
        }
        return 0;
    }

    public void setIX(int n) {
        this.IX = n & 0xFFFF;
    }

    public void setIY(int n) {
        this.IY = n & 0xFFFF;
    }

    public void setSP(int n) {
        this.SP = n & 0xFFFF;
    }

    public void setPC(int n) {
        this.PC = n & 0xFFFF;
    }

    public void setIM(int n) {
        this.IM = n & 0xFF;
    }

    public int getIM() {
        return this.IM;
    }

    public void setAF1(int n) {
        this.reg[14] = n & 0xFF;
        this.reg[15] = n >> 8 & 0xFF;
    }

    public void setBC1(int n) {
        this.setqq(8, n);
    }

    public void setDE1(int n) {
        this.setqq(10, n);
    }

    public void setHL1(int n) {
        this.setqq(12, n);
    }

    public boolean isInHalt() {
        return this.inHalt;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n;
            int n2 = n = (i & 1) == 0 ? 4 : 0;
            if ((i & 2) != 0) {
                n ^= 4;
            }
            if ((i & 4) != 0) {
                n ^= 4;
            }
            if ((i & 8) != 0) {
                n ^= 4;
            }
            if ((i & 0x10) != 0) {
                n ^= 4;
            }
            if ((i & 0x20) != 0) {
                n ^= 4;
            }
            if ((i & 0x40) != 0) {
                n ^= 4;
            }
            if ((i & 0x80) != 0) {
                n ^= 4;
            }
            Z80.PARITY[i] = n;
        }
        CC_MASK = new int[]{64, 64, 1, 1, 4, 4, 128, 128};
        CC_TEST = new int[]{0, 64, 0, 1, 0, 4, 0, 128};
        REGISTERS = new Register[]{new Register("Flags", 8, "SZ-H-VNC"), new Register("AF", 16), new Register("AF'", 16, 1), new Register("HL", 16), new Register("HL'", 16, 1), new Register("DE", 16), new Register("DE'", 16, 1), new Register("BC", 16), new Register("BC'", 16, 1), new Register("IX", 16), new Register("SP", 16, 1), new Register("IY", 16), new Register("I", 8, 1), new Register("PC", 16), new Register("R", 8, 1)};
    }
}

