;; MASK loader
;;
;; - Counter like a cassette which counts down
;; - uses initial screen data to decrypt loader.
;;  with disc system must put: |TAPE (then go back and delete this line and the "Ready" line)
;; then press CTRL and ENTER. As it requires RUN" to be directly below "Ready"!!!!!!!!!
;; with tape systems with no disc interface, must press CTRL+ENTER to load!

;; - BASIC file stub with binary data
;; - border flashes light blue, black and bright green
;; - loading conditions must be perfect for it to load
;; - checksum initialised with 0, and generated from sum of all bytes
;; - there are syncs every 16 bytes giving time for counter to be drawn.

016f 00        nop     
0170 0a        ld      a,(bc)
0171 00        nop     
0172 010083    ld      bc,$8300
0175 201c      jr      nz,$0193         ; (+$1c)
0177 80        add     a,b
0178 010000    ld      bc,$0000
017b 00        nop     
017c 00        nop     
017d 00        nop     
017e 00        nop     
017f 00        nop     
;; decrypt
0180 3ad4c2    ld      a,($c2d4)
0183 4f        ld      c,a
0184 3a74c3    ld      a,($c374)
0187 a9        xor     c
0188 4f        ld      c,a
0189 219801    ld      hl,$0198
018c 116f04    ld      de,$046f
018f 7e        ld      a,(hl)
0190 a9        xor     c
0191 77        ld      (hl),a
0192 23        inc     hl
0193 1b        dec     de
0194 7a        ld      a,d
0195 b3        or      e
0196 20f7      jr      nz,$018f         ; (-$09)
0198 2180ac    ld      hl,$ac80
019b 3e52      ld      a,$52
019d be        cp      (hl)
019e 23        inc     hl
019f 20fc      jr      nz,$019d         ; (-$04)
01a1 0603      ld      b,$03
01a3 ae        xor     (hl)
01a4 23        inc     hl
01a5 10fc      djnz    $01a3            ; (-$04)
01a7 4f        ld      c,a
01a8 21b701    ld      hl,$01b7
01ab 115004    ld      de,$0450
01ae 7e        ld      a,(hl)
01af a9        xor     c
01b0 77        ld      (hl),a
01b1 23        inc     hl
01b2 1b        dec     de
01b3 7a        ld      a,d
01b4 b3        or      e
01b5 20f7      jr      nz,$01ae         ; (-$09)

;; screen mode 0
01b7 97        sub     a
01b8 cd0ebc    call    $bc0e

01bb 3e40      ld      a,$40
01bd cd08bc    call    $bc08

;; screen mode 0
01c0 97        sub     a
01c1 cd0ebc    call    $bc0e

01c4 f3        di      
01c5 313800    ld      sp,$0038

01c8 3e20      ld      a,$20
01ca dd210080  ld      ix,$8000
01ce cd9202    call    $0292			; load block

01d1 3e30      ld      a,$30
01d3 0e0c      ld      c,$0c
01d5 cd3105    call    $0531			; write data to CRTC register

;; execute loaded code
01d8 cd0080    call    $8000

01db 018c7f    ld      bc,$7f8c
01de ed49      out     (c),c

;; ??
01e0 cdd077    call    $77d0

01e3 3e10      ld      a,$10
01e5 0e0c      ld      c,$0c
01e7 cd3105    call    $0531			; write data to CRTC register

01ea 3e6b      ld      a,$6b
01ec dd2a5e02  ld      ix,($025e)
01f0 cd9202    call    $0292			; load block

01f3 3ae07f    ld      a,($7fe0)
01f6 cd4605    call    $0546
01f9 c37d04    jp      $047d

01fc 00        nop     
01fd 00        nop     
01fe 00        nop     
01ff 00        nop     
0200 00        nop     
0201 7c        ld      a,h
0202 c6c6      add     a,$c6
0204 c6c6      add     a,$c6
0206 fe7c      cp      $7c
0208 00        nop     
0209 1838      jr      $0243            ; (+$38)
020b 1818      jr      $0225            ; (+$18)
020d 187e      jr      $028d            ; (+$7e)
020f 7e        ld      a,(hl)
0210 00        nop     
0211 3c        inc     a
0212 66        ld      h,(hl)
0213 063c      ld      b,$3c
0215 60        ld      h,b
0216 7e        ld      a,(hl)
0217 7e        ld      a,(hl)
0218 00        nop     
0219 3c        inc     a
021a 66        ld      h,(hl)
021b 0c        inc     c
021c 0666      ld      b,$66
021e 7e        ld      a,(hl)
021f 3c        inc     a
0220 00        nop     
0221 1c        inc     e
0222 3c        inc     a
0223 6c        ld      l,h
0224 ccfe0c    call    z,$0cfe
0227 1e00      ld      e,$00
0229 7e        ld      a,(hl)
022a 60        ld      h,b
022b 7c        ld      a,h
022c 0666      ld      b,$66
022e 7e        ld      a,(hl)
022f 3c        inc     a
0230 00        nop     
0231 3c        inc     a
0232 60        ld      h,b
0233 7c        ld      a,h
0234 66        ld      h,(hl)
0235 66        ld      h,(hl)
0236 7e        ld      a,(hl)
0237 3c        inc     a
0238 00        nop     
0239 7e        ld      a,(hl)
023a 66        ld      h,(hl)
023b 060c      ld      b,$0c
023d 1818      jr      $0257            ; (+$18)
023f 1800      jr      $0241            ; (+$00)
0241 3c        inc     a
0242 66        ld      h,(hl)
0243 3c        inc     a
0244 66        ld      h,(hl)
0245 66        ld      h,(hl)
0246 7e        ld      a,(hl)
0247 3c        inc     a
0248 00        nop     
0249 3c        inc     a
024a 66        ld      h,(hl)
024b 3e06      ld      a,$06
024d 66        ld      h,(hl)
024e 7e        ld      a,(hl)
024f 3c        inc     a
0250 00        nop     
0251 7c        ld      a,h
0252 c6c6      add     a,$c6
0254 c6c6      add     a,$c6
0256 fe7c      cp      $7c
0258 5c        ld      e,h
0259 02        ld      (bc),a
025a 00        nop     
025b 80        add     a,b
025c 13        inc     de
025d a7        and     a
025e a7        and     a
025f 0a        ld      a,(bc)
0260 e7        rst     $20
0261 0a        ld      a,(bc)
0262 e7        rst     $20
0263 0d        dec     c
0264 87        add     a,a
0265 0e00      ld      c,$00
0267 0f        rrca    
0268 a0        and     b
0269 1c        inc     e
026a 94        sub     h
026b 2b        dec     hl
026c 84        add     a,h
026d 2ec0      ld      l,$c0
026f 2e60      ld      l,$60
0271 2f        cpl     
0272 00        nop     
0273 3000      jr      nc,$0275         ; (+$00)
0275 3800      jr      c,$0277          ; (+$00)
0277 3810      jr      c,$0289          ; (+$10)
0279 39        add     hl,sp
027a 1039      djnz    $02b5            ; (+$39)
027c b0        or      b
027d 3d        dec     a
027e b0        or      b
027f 3d        dec     a
0280 303e      jr      nc,$02c0         ; (+$3e)
0282 94        sub     h
0283 1c        inc     e
0284 94        sub     h
0285 2607      ld      h,$07
0287 06a7      ld      b,$a7
0289 0a        ld      a,(bc)
028a 00        nop     
028b 80        add     a,b
028c 00        nop     
028d ae        xor     (hl)
028e 00        nop     
028f f0        ret     p

0290 00        nop     

;;----------------------------------------------------------------------------------

0291 fb        ei      
0292 0110f6    ld      bc,$f610		; start cassette motor
0295 ed49      out     (c),c
0297 cda302    call    $02a3
029a 0100f6    ld      bc,$f600		; stop cassette motor
029d ed49      out     (c),c
029f c8        ret     z
;; load fail.. 
;; reset
02a0 c30000    jp      $0000
;;----------------------------------------------------------------------------------
;; IX = load address
;; A = sync byte

02a3 08        ex      af,af'
02a4 3e52      ld      a,$52
02a6 d9        exx     
;; select border
02a7 01107f    ld      bc,$7f10
02aa ed49      out     (c),c
;; set border colour
02ac ed79      out     (c),a
02ae d9        exx     
02af 06f5      ld      b,$f5

;; must be 50 correct pilot pulses
02b1 2632      ld      h,$32
02b3 cd3903    call    $0339			; get edge?
02b6 fe46      cp      $46
02b8 38f7      jr      c,$02b1          ; (-$09)
02ba 25        dec     h
02bb 20f6      jr      nz,$02b3         ; (-$0a)

;; 
02bd 260a      ld      h,$0a
02bf cd3903    call    $0339
02c2 fe46      cp      $46
02c4 30f7      jr      nc,$02bd         ; (-$09)
02c6 25        dec     h
02c7 20f6      jr      nz,$02bf         ; (-$0a)

;; now measure remaining pulses
02c9 97        sub     a
02ca 57        ld      d,a
02cb d9        exx     
02cc 67        ld      h,a
02cd 6f        ld      l,a
02ce 57        ld      d,a
02cf d9        exx     

;; minimum: 50+10+256=316

;; measure 256 pulses
;;
;; 8:8 fixed point number
02d0 cd3903    call    $0339			; 
02d3 d9        exx     
02d4 5f        ld      e,a
02d5 19        add     hl,de
02d6 7c        ld      a,h
02d7 d9        exx     
02d8 25        dec     h
02d9 20f5      jr      nz,$02d0         ; (-$0b)
;; measured time
02db c602      add     a,$02
02dd 323003    ld      ($0330),a


;; tone of fixed pulse width, then measured pulse width, sync byte, 
;; low byte of length, high byte of length, two edges can be any width
;; up to 16 bytes of data, one edge of any width, then extra edges that 
;; must be correct width


02e0 cd2a03    call    $032a			; read byte
02e3 08        ex      af,af'
02e4 bb        cp      e
02e5 c0        ret     nz

;; read length low byte
02e6 cd2a03    call    $032a			; read byte
02e9 6f        ld      l,a				
;; read length high byte
02ea cd2a03    call    $032a			; read byte
02ed 67        ld      h,a

02ee cd3903    call    $0339			; get edge
02f1 cd8503    call    $0385			; convert length into time in 3 digits
02f4 cd3903    call    $0339			; get edge

;; initialise checksum
02f7 fd210000  ld      iy,$0000


;; read 16 bytes at a time
02fb cd2a03    call    $032a			; read byte
02fe dd7700    ld      (ix+$00),a
0301 dd23      inc     ix
0303 fd19      add     iy,de
0305 2b        dec     hl
0306 7d        ld      a,l
0307 e60f      and     $0f
0309 c2fb02    jp      nz,$02fb

030c cd3903    call    $0339			; get edge
030f cdae03    call    $03ae			; draw digits

;; wait until the edges are the correct distance apart
0312 cd3903    call    $0339			; get edge
0315 fe46      cp      $46
0317 38f9      jr      c,$0312          ; (-$07)

;; loop for rest of bytes
0319 7c        ld      a,h
031a b5        or      l
031b c2fb02    jp      nz,$02fb

;;----------------------------------------------------------------------------
;; check checksum

031e cd2a03    call    $032a			; read byte
;; low byte of checksum
0321 fdbd      cp      iyl
0323 c0        ret     nz

0324 cd2a03    call    $032a			; read byte
;; high byte of checksum
0327 fdbc      cp      iyh
0329 c9        ret     

;;----------------------------------------------------------------
;; read byte
;; A = byte
;; E = byte

032a 1e01      ld      e,$01
032c cd3903    call    $0339
032f fe00      cp      $00
0331 3f        ccf     
0332 cb13      rl      e
0334 d22c03    jp      nc,$032c
0337 7b        ld      a,e
0338 c9        ret     

;;----------------------------------------------------------------
0339 7d        ld      a,l
033a e601      and     $01
033c c652      add     a,$52
033e d9        exx     
033f ed49      out     (c),c
0341 ed79      out     (c),a
0343 d9        exx     
0344 0e00      ld      c,$00
0346 ed78      in      a,(c)
0348 fa4603    jp      m,$0346
034b ed78      in      a,(c)
034d fa4603    jp      m,$0346
0350 ed78      in      a,(c)
0352 fa4603    jp      m,$0346
0355 ed78      in      a,(c)
0357 fa4603    jp      m,$0346
035a 3e54      ld      a,$54
035c d9        exx     
035d ed49      out     (c),c
035f ed79      out     (c),a
0361 d9        exx     
0362 0c        inc     c
0363 ed78      in      a,(c)
0365 f26203    jp      p,$0362
0368 ed78      in      a,(c)
036a f26203    jp      p,$0362
036d ed78      in      a,(c)
036f f26203    jp      p,$0362
0372 ed78      in      a,(c)
0374 f26203    jp      p,$0362
0377 79        ld      a,c
0378 c9        ret     

;;----------------------------------------------------------------------------------
;; A = HL/DE

0379 97        sub     a
037a ed52      sbc     hl,de
037c 3803      jr      c,$0381          ; (+$03)
037e 3c        inc     a
037f 18f9      jr      $037a            ; (-$07)

0381 a7        and     a
0382 ed5a      adc     hl,de
0384 c9        ret     

;;----------------------------------------------------------------------------------
;; HL = length of data in bytes
0385 e5        push    hl
0386 d9        exx     
0387 e1        pop     hl

0388 110032    ld      de,$3200			; 12800
038b cd7903    call    $0379			; A = HL/DE
038e 87        add     a,a				; x2 
038f 87        add     a,a				; x4 
0390 87        add     a,a				; x8
0391 323c04    ld      ($043c),a

0394 110005    ld      de,$0500			; 1280 
0397 cd7903    call    $0379			; A = HL/DE
039a 87        add     a,a				; x2
039b 87        add     a,a				; x4
039c 87        add     a,a				; x8
039d 323b04    ld      ($043b),a

03a0 111000    ld      de,$0010			; 16
03a3 cd7903    call    $0379			; A = HL/DE
03a6 2801      jr      z,$03a9          ; fraction?
;; fraction
03a8 3c        inc     a
03a9 323a04    ld      ($043a),a		
03ac d9        exx     
03ad c9        ret     

;;----------------------------------------------------------------------------------

03ae d9        exx     
03af 213c04    ld      hl,$043c
03b2 7e        ld      a,(hl)
03b3 e607      and     $07
03b5 2801      jr      z,$03b8          ; (+$01)
03b7 35        dec     (hl)
03b8 ed5b3a04  ld      de,($043a)
03bc 7a        ld      a,d
03bd e607      and     $07
03bf 2801      jr      z,$03c2          ; (+$01)
03c1 15        dec     d
03c2 1d        dec     e
03c3 f2cf03    jp      p,$03cf
03c6 1e4f      ld      e,$4f
03c8 15        dec     d
03c9 f2cf03    jp      p,$03cf
03cc 164f      ld      d,$4f
03ce 35        dec     (hl)
03cf ed533a04  ld      ($043a),de
03d3 2602      ld      h,$02
03d5 06c0      ld      b,$c0
03d7 117844    ld      de,$4478
03da 3a3c04    ld      a,($043c)
03dd cd0a04    call    $040a			; plot digit
03e0 3a3b04    ld      a,($043b)
03e3 cd0a04    call    $040a			; plot digit
03e6 3a3a04    ld      a,($043a)
03e9 cd0a04    call    $040a			; plot digit
03ec 2a5802    ld      hl,($0258)
03ef dd7d      ld      a,ixl
03f1 be        cp      (hl)
03f2 2011      jr      nz,$0405         ; (+$11)
03f4 23        inc     hl
03f5 dd7c      ld      a,ixh
03f7 be        cp      (hl)
03f8 200b      jr      nz,$0405         ; (+$0b)
03fa 23        inc     hl
03fb 5e        ld      e,(hl)
03fc 23        inc     hl
03fd 56        ld      d,(hl)
03fe 23        inc     hl
03ff 225802    ld      ($0258),hl
0402 d5        push    de
0403 dde1      pop     ix
0405 01107f    ld      bc,$7f10
0408 d9        exx     
0409 c9        ret     


;;----------------------------------------------------------------------------------
;; plot digit

040a d5        push    de
040b 6f        ld      l,a
040c 4e        ld      c,(hl)
040d 79        ld      a,c
040e a0        and     b
040f 12        ld      (de),a
0410 1c        inc     e
0411 cb01      rlc     c
0413 cb01      rlc     c
0415 79        ld      a,c
0416 a0        and     b
0417 12        ld      (de),a
0418 1c        inc     e
0419 cb01      rlc     c
041b cb01      rlc     c
041d 79        ld      a,c
041e a0        and     b
041f 12        ld      (de),a
0420 1c        inc     e
0421 cb01      rlc     c
0423 cb01      rlc     c
0425 79        ld      a,c
0426 a0        and     b
0427 12        ld      (de),a
0428 1d        dec     e
0429 1d        dec     e
042a 1d        dec     e
042b 23        inc     hl
042c 7a        ld      a,d
042d c608      add     a,$08
042f 57        ld      d,a
0430 e640      and     $40
0432 20d8      jr      nz,$040c         ; (-$28)
0434 d1        pop     de
0435 1c        inc     e
0436 1c        inc     e
0437 1c        inc     e
0438 1c        inc     e
0439 c9        ret     

;;----------------------------------------------------------------------------------

043a 00        nop     
043b 00        nop     
043c 00        nop     

;;----------------------------------------------------------------------------------

043d 0110f6    ld      bc,$f610
0440 ed49      out     (c),c
0442 210000    ld      hl,$0000
0445 ddcb0046  bit     0,(ix+$00)
0449 ddcb0046  bit     0,(ix+$00)
044d 2b        dec     hl
044e 7c        ld      a,h
044f b5        or      l
0450 20f3      jr      nz,$0445         ; (-$0d)
0452 c9        ret     

;;----------------------------------------------------------------------------------

0453 14        inc     d
0454 14        inc     d
0455 14        inc     d
0456 14        inc     d
0457 14        inc     d
0458 14        inc     d
0459 14        inc     d
045a 14        inc     d
045b 14        inc     d
045c 14        inc     d
045d 14        inc     d
045e 14        inc     d
045f 14        inc     d
0460 14        inc     d
0461 14        inc     d
0462 14        inc     d
0463 14        inc     d
0464 1c        inc     e
0465 0b        dec     bc
0466 00        nop     
0467 14        inc     d
0468 12        ld      (de),a
0469 161e      ld      d,$1e
046b 13        inc     de
046c 0c        inc     c
046d 17        rla     
046e 15        dec     d
046f 04        inc     b
0470 1818      jr      $048a            ; (+$18)
0472 07        rlca    
0473 14        inc     d
;;----------------------------------------------------------------------------------
;; crtc data
0474 3f        ccf     
0475 202a      jr      nz,$04a1         ; (+$2a)
0477 8e        adc     a,(hl)
0478 2603      ld      h,$03
047a 19        add     hl,de
047b 2100

;;----------------------------------------------------------------------------------

047d 3aff00    ld      a,($00ff)
0480 327880    ld      ($8078),a
0483 fd212705  ld      iy,$0527
0487 cd00f0    call    $f000
048a 2103f0    ld      hl,$f003
048d 223900    ld      ($0039),hl
0490 fb        ei      
0491 2a0880    ld      hl,($8008)
0494 220100    ld      ($0001),hl
0497 3ec3      ld      a,$c3
0499 320000    ld      ($0000),a
049c cdee04    call    $04ee
049f fdcb057e  bit     7,(iy+$05)
04a3 20f7      jr      nz,$049c         ; (-$09)
04a5 cd1039    call    $3910
04a8 218813    ld      hl,$1388
04ab 2b        dec     hl
04ac 7c        ld      a,h
04ad b5        or      l
04ae 20fb      jr      nz,$04ab         ; (-$05)
04b0 cdee04    call    $04ee
04b3 fdcb057e  bit     7,(iy+$05)
04b7 20f7      jr      nz,$04b0         ; (-$09)
04b9 215304    ld      hl,$0453
04bc cd3905    call    $0539			; write colours
04bf f3        di      
04c0 2a0680    ld      hl,($8006)
04c3 223900    ld      ($0039),hl
04c6 cd8805    call    $0588			; initialise screen address table
04c9 cd5105    call    $0551			; initialise screen address table (counter on title screen?)
04cc cd7805    call    $0578			; setup crtc 
04cf 3e30      ld      a,$30
04d1 0e0c      ld      c,$0c
04d3 cd3105    call    $0531
04d6 216404    ld      hl,$0464
04d9 ed5b0a80  ld      de,($800a)
04dd 011000    ld      bc,$0010
04e0 edb0      ldir    
04e2 219f05    ld      hl,$059f
04e5 112202    ld      de,$0222
04e8 01de08    ld      bc,$08de
04eb c30380    jp      $8003
04ee 76        halt    
04ef 212705    ld      hl,$0527
04f2 010ef4    ld      bc,$f40e
04f5 ed49      out     (c),c
04f7 06f6      ld      b,$f6
04f9 ed78      in      a,(c)
04fb e630      and     $30
04fd 4f        ld      c,a
04fe f6c0      or      $c0
0500 ed79      out     (c),a
0502 ed49      out     (c),c
0504 04        inc     b
0505 3e92      ld      a,$92
0507 ed79      out     (c),a
0509 c5        push    bc
050a cbf1      set     6,c
050c 06f6      ld      b,$f6
050e ed49      out     (c),c
0510 06f4      ld      b,$f4
0512 ed78      in      a,(c)
0514 77        ld      (hl),a
0515 23        inc     hl
0516 0c        inc     c
0517 79        ld      a,c
0518 e60f      and     $0f
051a fe0a      cp      $0a
051c 20ee      jr      nz,$050c         ; (-$12)
051e c1        pop     bc
051f 3e82      ld      a,$82
0521 ed79      out     (c),a
0523 05        dec     b
0524 ed49      out     (c),c
0526 c9        ret     

0527 ff        rst     $38
0528 ff        rst     $38
0529 ff        rst     $38
052a ff        rst     $38
052b ff        rst     $38
052c ff        rst     $38
052d ff        rst     $38
052e ff        rst     $38
052f ff        rst     $38
0530 ff        rst     $38

;;---------------------------------------------------------------------------
;; write data to CRTC register
;;
;; C = register index
;; A = data
0531 06bc      ld      b,$bc
0533 ed49      out     (c),c
0535 04        inc     b
0536 ed79      out     (c),a
0538 c9        ret     

;;---------------------------------------------------------------------------
;; write colours
 
0539 0e00      ld      c,$00
053b 7e        ld      a,(hl)
053c cd4805    call    $0548
053f 23        inc     hl
0540 0c        inc     c
0541 cb61      bit     4,c
0543 28f6      jr      z,$053b          ; (-$0a)
;; border colour
0545 7e        ld      a,(hl)

;;---------------------------------------------------------------------------
;; write colour to border
0546 0e10      ld      c,$10
;;---------------------------------------------------------------------------
;; write colour to pen or border
;; A = hardware colour number
;; C = 0-15 (pen), 16 (border)
0548 067f      ld      b,$7f
054a ed49      out     (c),c
054c cbf7      set     6,a
054e ed79      out     (c),a
0550 c9        ret     
;;----------------------------------------------------------------------------------
;; initialise screen address table

0551 21941c    ld      hl,$1c94
0554 1130c0    ld      de,$c030
0557 06a0      ld      b,$a0
0559 c5        push    bc
055a d5        push    de
055b 011000    ld      bc,$0010
055e edb0      ldir    
0560 d1        pop     de
0561 cd6805    call    $0568			; scr next line
0564 c1        pop     bc
0565 10f2      djnz    $0559            ; (-$0e)
0567 c9        ret     

;;----------------------------------------------------------------------------------
;; scr next line

0568 7a        ld      a,d
0569 c608      add     a,$08
056b 57        ld      d,a
056c e640      and     $40
056e c0        ret     nz

056f 7b        ld      a,e
0570 d6c0      sub     $c0
0572 5f        ld      e,a
0573 7a        ld      a,d
0574 de3f      sbc     a,$3f
0576 57        ld      d,a
0577 c9        ret     
;;----------------------------------------------------------------------------------

0578 217404    ld      hl,$0474
057b 0e00      ld      c,$00
057d 7e        ld      a,(hl)
057e cd3105    call    $0531			; write to CRTC register
0581 0c        inc     c
0582 23        inc     hl
0583 cb59      bit     3,c
0585 28f6      jr      z,$057d          ; (-$0a)
0587 c9        ret     
;;----------------------------------------------------------------------------------
;; initialise screen address table
0588 210030    ld      hl,$3000
058b 1140c5    ld      de,$c540
058e 0620      ld      b,$20
0590 c5        push    bc
0591 d5        push    de
0592 014000    ld      bc,$0040
0595 edb0      ldir    
0597 d1        pop     de
0598 cd6805    call    $0568			; scr next line
059b c1        pop     bc
059c 10f2      djnz    $0590            ; (-$0e)
059e c9        ret     
;;----------------------------------------------------------------------------------

059f fce3ff    call    m,$ffe3
05a2 00        nop     
05a3 00        nop     
05a4 00        nop     
05a5 00        nop     
05a6 ff        rst     $38
05a7 02        ld      (bc),a
05a8 e6ff      and     $ff
05aa 00        nop     
05ab 00        nop     
05ac 00        nop     
05ad 00        nop     
05ae ff        rst     $38
05af 04        inc     b
05b0 f8        ret     m

05b1 ff        rst     $38
05b2 00        nop     
05b3 00        nop     
05b4 00        nop     
05b5 00        nop     
05b6 ff        rst     $38
05b7 02        ld      (bc),a
05b8 0a        ld      a,(bc)
05b9 00        nop     
05ba 00        nop     
05bb 00        nop     
05bc 00        nop     
05bd 00        nop     
05be ff        rst     $38
05bf fc0d00    call    m,$000d
05c2 00        nop     
05c3 00        nop     
05c4 00        nop     
05c5 00        nop     
05c6 ff        rst     $38
05c7 f60a      or      $0a
05c9 00        nop     
05ca 00        nop     
05cb 00        nop     
05cc 00        nop     
05cd 00        nop     
05ce ff        rst     $38
05cf f4f8ff    call    p,$fff8
05d2 00        nop     
05d3 00        nop     
05d4 00        nop     
05d5 00        nop     
05d6 ff        rst     $38
05d7 f6e6      or      $e6
05d9 ff        rst     $38
05da 00        nop     
05db 00        nop     
05dc 00        nop     
05dd 00        nop     
05de ff        rst     $38
05df 00        nop     
05e0 00        nop     
05e1 00        nop     
05e2 00        nop     
05e3 00        nop     
05e4 00        nop     
05e5 00        nop     
05e6 ff        rst     $38
05e7 f8        ret     m

05e8 00        nop     
05e9 00        nop     
05ea 00        nop     
05eb 00        nop     
05ec 00        nop     
05ed 00        nop     
05ee ff        rst     $38
05ef 00        nop     
05f0 eb        ex      de,hl
05f1 ff        rst     $38
05f2 00        nop     
05f3 00        nop     
05f4 00        nop     
05f5 00        nop     
05f6 ff        rst     $38
05f7 f8        ret     m

05f8 eb        ex      de,hl
05f9 ff        rst     $38
05fa 00        nop     
05fb 00        nop     
05fc 00        nop     
05fd 00        nop     
05fe ff        rst     $38
05ff fcf8ff    call    m,$fff8
0602 00        nop     
0603 00        nop     
0604 00        nop     
0605 00        nop     
0606 ff        rst     $38
0607 00        nop     
