/* intersplit.c: maak of splits om-en-om diskbeeld, SINGLE/DOUBLE DENSITY
 * interss & splitds
 * Copyright (C) W.H.Scholten 1996,1997
 * 11-3-1996
 * Deel van bbcim.
 */

/* voor 10, 16, 18 sect per track (sec=256b), dus SD , ADFS en DD */
int  interss(char *side0, char *side1, char *interleaved, int disktype, int verbose) {
    unsigned char filebyte;
    FILE *fp0, *fp1, *fp_inter;
    int sec_per_track, track, i;


    if (file_sanitycheck(side0,verbose)) return bbcim_errno;
    if (strcmp(side0,side1)) {
	if (file_sanitycheck(side1,verbose)) return bbcim_errno; else fp1=fopen(side1,"rb");
    } else fp1=fp0;
    fp0=fopen(side0,"rb");
    if (strcmp(side0,side1)) fp1=fopen(side1,"rb"); else fp1=fp0;


    fp_inter=fopen(interleaved, "wb");

    if (verbose) printf("  %s + %s > %s\n\n", side0, side1, interleaved);


    sec_per_track=10;
#if 0
    if (dd) sec_per_track=18;
    if (adfs) sec_per_track=16;
#else
    
#endif

    fseek(fp0, 0L, SEEK_SET);
    fseek(fp1, 0L, SEEK_SET);
    fseek(fp_inter,0L, SEEK_SET);
    for (track=0; track<80;track++) {
	fseek(fp0,0L+track*256L*sec_per_track, SEEK_SET);
	for (i=0; i<256*sec_per_track; i++) {
	    if (feof(fp0) && feof(fp1)) exit(0);
	    if (feof(fp0)) filebyte=0; else fread(&filebyte,1,1,fp0);
	    fwrite(&filebyte,1,1,fp_inter);
	}
	fseek(fp1,0L+track*256L*sec_per_track, SEEK_SET);
	for (i=0; i<256*sec_per_track; i++) {
	    if (feof(fp1) && feof(fp0)) exit(0);
	    if (feof(fp1)) filebyte=0; else fread(&filebyte,1,1,fp1);
	    fwrite(&filebyte,1,1,fp_inter);
	}
    }
    fclose(fp0);
    fclose(fp1);
    fclose(fp_inter);
    return 0;
}
/*einde samenvoegen*/










/* SPLITS OM-EN-OM DISKBEELD: */
int  splitds(char *interleaved, int disktype , int verbose) {
    char  side0[50],  side1[50];
    unsigned char filebyte;
    FILE *fp0, *fp1, *fp_inter;
    int sec_per_track, track;

    int dd=0, adfs=0;


    strcpy(side0, interleaved);
    side0[strcspn(side0,".")]=0;
    strcpy(side1, side0);
    strcat(side0,".0");
    strcat(side1,".1");


    if (file_sanitycheck(interleaved,verbose)) return bbcim_errno; 
    if (verbose) printf(" %s > %s + %s\n\n",interleaved, side0, side1);

    fp_inter=fopen(interleaved, "rb");
    fp0=fopen(side0,"wb");
    fp1=fopen(side1,"wb");

#if 1
    sec_per_track=10;
    if (dd) sec_per_track=18;
    if (adfs) sec_per_track=16;
#else
    sec_per_track=disktype.tracksize
#endif

    fseek(fp_inter,0L, SEEK_SET);
    for (track=0; track<80;track++) {
	int i;
	for (i=0; i<256*sec_per_track; i++) {
	    if (!fread(&filebyte,1,1,fp_inter)) exit(0);
	    fwrite(&filebyte,1,1,fp0);
	}
	for (i=0; i<256*sec_per_track; i++) {
	    if (!fread(&filebyte,1,1,fp_inter)) exit(0);
	    fwrite(&filebyte,1,1,fp1);
	}
    }
    fclose(fp0);
    fclose(fp1);
    fclose(fp_inter);
    return 0;
} /*einde splitsen */


/* Zet een geinterlinieerd ADFS diskbeeld in een lineair diskbeeld om */
int  ds2ss(char *interleaved, int verbose) {
    char side0[50];

    char buf[512];
    long sectorsondisk;
    byte filebyte;
    FILE *fp0, *fp_inter;
    int  sec_per_track, track;

    struct diskimage image;

    image.type=ADFS_DISK; image.sides=2;
    sec_per_track=16;
    image.filename=interleaved;

    if (diskimage_sanitycheck(&image, 1)) return bbcim_errno;

    strcpy(side0, interleaved);
    strcat(interleaved, "~");
    rename(side0, interleaved);

    fp_inter=fopen(interleaved, "rb");
    fp0=fopen(side0,"wb");


    fseek(fp_inter,0L,SEEK_SET);
    fread(buf, 512,1, fp_inter);
    sectorsondisk=read3lsb(buf+252);
    if (verbose) printf("sec on disk %ld\n", sectorsondisk);

    fseek(fp_inter,0L, SEEK_SET);
    for (track=0; track<80;track++) {
	int i;
	fseek(fp0, 256*sec_per_track*track, SEEK_SET);
	for (i=0; i<256*sec_per_track; i++) {
	    if (!fread(&filebyte,1,1,fp_inter)) return errno;
	    fwrite(&filebyte,1,1,fp0);
	}
	fseek(fp0, 256*sec_per_track*track+ sectorsondisk*256/2, SEEK_SET);
	for (i=0; i<256*sec_per_track; i++) {
	    if (!fread(&filebyte,1,1,fp_inter)) return errno;
	    fwrite(&filebyte,1,1,fp0);
	}
    }
    return 0;
}
