/* (bbcim) set_boot.c
 *
 * Copyright (c) 1997 W.H. Scholten
 */


/* Acorn DFS */
int  disk_set_boot(struct diskimage *image, int bootoption, int verbose) {
    FILE *fpdisk;
    byte filebyte;
    long i;
    char *disk;


    disk=image->filename;
    if (diskimage_sanitycheck(image, verbose)) return bbcim_errno;

    fpdisk=fopen(disk,"rb+");
    filebyte=0;

    switch(image->type) {
    case DFS_DISK:
	if (image->sides==2) { bbcim_errno=BBC_NOT_IMPLEMENTED; break; }
	fseek(fpdisk,256+6L,SEEK_SET);
	/* voor kant 2 van 2 zijdig: 256+6+image->sectors*image->bytes */
	fread(&filebyte,1,1,fpdisk); /* disksize 4MSB + bootoption */
	filebyte &=0x0f;
	fseek(fpdisk,256+6L,SEEK_SET);
	/* voor kant 2 van 2 zijdig: 256+6+image->sectors*image->bytes */
	filebyte |=bootoption<<4;
	fwrite(&filebyte,1,1,fpdisk);  /* bootoption, sect on disk='size' */
	break;
    case ADFS_DISK:
    default:
	bbcim_errno=BBC_NOT_IMPLEMENTED;
    }

    fclose(fpdisk);
    if (bbcim_errno==BBC_NOT_IMPLEMENTED) {
printf("set boot err\n");
#ifdef NL
	bbcim_error="Niet geimplementeerd\n";
#else
	bbcim_error="Not implemented\n";
#endif
    }
    if (verbose) fprintf(stderr, bbcim_error);
    return bbcim_errno;
}
