/* minimaliseer.c: minimaliseer bbc diskbeeld (SINGLE DENSITY, DFS)
 *
 * Copyright (C) W.H.Scholten 1996
 * (bbcim)
 */


/* Acorn DFS */
int  disk_minimize(struct diskimage *image, int verbose) {
    FILE *fpdisk, *fpdisk2;
    char backupnaam[50];
    char bbcfile_naam[12];
    unsigned char filebyte, H, eellddss;

    long startsector, file;
    long startsector2=2;
    unsigned char files;
    long length;
    int  i;
    char *disk;



    disk=image->filename;
    if (diskimage_sanitycheck(image, verbose)) return bbcim_errno;

    fpdisk=fopen(disk, "rb");
    fseek(fpdisk,256L+5L,SEEK_SET);
    fread(&files,1,1,fpdisk);

    if (files>0){
	fclose(fpdisk);
	strcpy(backupnaam, disk);strcat(backupnaam,"%");

	remove(backupnaam);
	rename(disk,backupnaam);

	fpdisk=fopen(backupnaam,"rb");
	fpdisk2=fopen(disk,"wb");


	/*CATALOGUS KOPIEEREN */
	for(i=0;i<512;i++){
	    fread (&filebyte,1,1,fpdisk);
	    fwrite (&filebyte,1,1,fpdisk2);
	}


	/* Hoofdlus: alle bestanden opzoeken. */
	for(file=files;file>0; file -=8){

	    /* THE FOLLOWING IS ONLY NEEDED FOR FILENAME PRINTING */
	    fseek(fpdisk,file+15L,SEEK_SET);
	    fread(&filebyte,1,1,fpdisk);
	    bbcfile_naam[0]=(filebyte & 0x7F);
	    bbcfile_naam[1]='.';
    
	    fseek(fpdisk,file,SEEK_SET);
#if 0
	    for(i=0; i<7; i++){
		fread(&filebyte,1,1,fpdisk);
		bbcfile_naam[i+2]=filebyte;
	    }
#else
	    fread(bbcfile_naam+2,1,7,fpdisk);
#endif
	    bbcfile_naam[9]=0;


	    /* FILE LENGTE */
	    fseek(fpdisk,file+256L+4L,0);
	    fread(&filebyte,1,1,fpdisk);
	    fread(&H,1,1,fpdisk);
	    fread(&eellddss,1,1,fpdisk);
	    length=H*256L+filebyte+(eellddss & 0x30)*16L*256L;

	    /* STARTSECTOR */
	    fread(&filebyte,1,1,fpdisk);
	    startsector=filebyte+(eellddss & 3)*256L;

	    /* nieuwe startsector */
	    fseek(fpdisk2,256+file+6,SEEK_SET);
	    eellddss =(eellddss & 0xFC)+(startsector2>>8);
	    fwrite(&eellddss,1,1,fpdisk2);
	    filebyte=startsector2 & 0xFF;
	    fwrite(&filebyte,1,1,fpdisk2);

	    if (verbose) printf("startsector %3d > %3d\n", (int) startsector, (int) startsector2);


	    fseek(fpdisk,startsector*256, SEEK_SET);
	    fseek(fpdisk2,startsector2*256, SEEK_SET);
	    for (i=0; i<((length+255)>>8)*256; i++){
		fread(&filebyte,1,1,fpdisk);
		if (feof(fpdisk) && (i<length)){
		    if (verbose)
                       #ifdef NL
			printf("onverwacht einde van het diskbeeld" \
			   " bij bestand %s\n\n", bbcfile_naam);
                       #else
		        printf("unexpected end of the diskimage" \
			   " at file %s\n\n", bbcfile_naam);
                       #endif
		    return -1;
		}
		fwrite(&filebyte,1,1,fpdisk2);
	    }
	    startsector2=startsector2+((length+255)>>8);
	} /* FOR file */
    }
    fclose(fpdisk);
    return 0;
}
