/* expand_im.c (DFS)
 *
 * Copyright (C) 1996 W.H. Scholten
 * (bbcim)
 */

/* Voor Acorn DFS */
int  disk_expand(struct diskimage *image, int expand, int verbose) {
    FILE *fpdisk;
    unsigned char filebyte, bootoption;
    long i, length, expand_length;
    char *disk;



    disk=image->filename;
    if (diskimage_sanitycheck(image, verbose)) return bbcim_errno;

    fpdisk=fopen(disk,"ab+");
    fseek(fpdisk,0,SEEK_END);
    length=ftell(fpdisk);
    expand_length=expand*256;

    if (expand_length>length) {
	filebyte=0;
	for (i=0; i<(expand_length-length); i++)
	    fwrite(&filebyte,1,1,fpdisk);

	/* SECTORS ON DISK AANPASSEN */
	fseek(fpdisk,256L+6L,SEEK_SET);
	fread(&bootoption,1,1,fpdisk); /*rescue bootoption*/
	bootoption &=3<<4;

	filebyte=((expand >>8)&3)|bootoption;
	fseek(fpdisk,256L+6L,SEEK_SET);
	fwrite(&filebyte,1,1,fpdisk);
	filebyte=(expand & 0xFF);
	fwrite(&filebyte,1,1,fpdisk);
    }
    fclose(fpdisk);
    return 0;
}
