/* bbcimlib.c (bbcim; bbc diskbeeld manipulatie): Functies.

// Copyright (c) W.H. Scholten 1996, 1997
 
// Permission to use, copy, modify, distribute, and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appear in all copies and
// that both that copyright notice and this permission notice appear in
// supporting documentation, and that the name of the copyright holder
// not be used in advertising or publicity pertaining to distribution
// of the software without specific, written prior permission. The
// copyright holder makes no representations about the suitability of
// this software for any purpose. It is provided "as is" without express
// or implied warranty.
//
// THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
// RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
// CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// Send comments and bug-reports to 
//
//    wouters@cistron.nl
//
// Send flames to /dev/null.
//
*/

/*************** CONFIGURATION *********************/
/* Comment out for english messages from the library */
#define NL


/* Make directory: UNIX_MKDIR, MAC_MKDIR, or SYSTEM_MKDIR (using system("mkdir.."); ) */
#define UNIX_MKDIR


/* If you can't give parameters on the command line uncomment this */
/* #define NO_COMMAND_LINE */


/* Characters to be replaced in filenames:
 * Most filesystems can't handle all characters from bbc filenames.
 * Add whatever you need for your system.
 * I've put the minimum for linux in REPLACE_FEW. */
#define REPLACE_FEW


#ifdef REPLACE_FEW
char filenamechar_bad[] = {'/'};
char filenamechar_replace[] = {'_'};
#endif

#ifdef REPLACE_MANY
char filenamechar_bad[]     = { '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '.' };
char filenamechar_replace[] = { '_' , '_', '_', '_', '_', '_' , '_', '_', '_', '_' };
#endif

/************ END OF CONFIGURATION ***********************/





/*__________________INCLUDES___________________*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef MAC_MKDIR
 #include <unix.h>
#endif

#ifdef UNIX_MKDIR
 #include <sys/types.h>
 #include <fcntl.h>
 #include <unistd.h>
#endif

#ifdef SYSTEM_MKDIR
#endif

/* Should use this in various places:
#include <sys/stat.h>
struct stat file_stat;
if (stat(filename, file_stat)<0) perror("can't open file\n");
*/

#include "mytypes.h"
typedef unsigned int  uint;

#include "bbcimlib.h"

char *bbcim_error; /* points to the last error */
int  bbcim_errno;

#include "utils.c"
#include "overschrijf.c"

#include "lowlevel.c"

#include "disk_cat_extract.c"
#include "disk_add_file.c"
#include "disk_del_file.c"
#include "disk_expand.c"
#include "disk_minimize.c"
#include "disk_set_boot.c"
#include "disk_new.c"
#include "disk_identify.c"

#include "d_write_cat.c"

#include "intersplits.c"
#include "ddos_to_dfs.c"
#include "w62_to_dfs.c"

#include "split_cat.c"
#include "crc.c"
#include "archive_to_xbeeb.c"
#include "archive_cleanup.c"
