/*
 * realloc.c - the realloc routine
 *
 * realloc changes the size of a previously
 * allocated block. It frees the block, and
 * then performs a malloc style operation to
 * try and re-allocate some memory. In doing
 * the malloc, however, it will not split a
 * free block until after the old data has been
 * copied to the new block to avoid possible
 * corruption. -Pete French. 17/7/1990
 */

extern char* sbrk();

struct mlist {			/* malloc list structure */
              unsigned int len;
              char free;
              struct mlist *next;
             };

#define	FREE	'f'
#define	USED	'u'
#define MINBRK	64	/* minimum allocatable block */

extern struct mlist m_base;

char *realloc(p,s)
char *p;
unsigned int s;
{
struct mlist *ptr;
char *new;
struct mlist *newstr;
if(s<MINBRK)
 s=MINBRK;		/* if below minimum break then increase */
s=(s+1) & ~1;		/* make s an even number */
free(p);		/* free the old memory */
ptr=&m_base;
while(ptr->next != (struct mlist*)0)	/* scan the list for a block */
 {
  ptr=ptr->next;
  if((ptr->free==FREE) && (ptr->len >= s)) /* large enough free block ? */
   {
    new=(char*)ptr+sizeof(struct mlist);
    memcpy(new,p,s);			/* copy old contents to new block */
    if(ptr->len >= (s+MINBRK+sizeof(struct mlist))) /* split block ? */
     {
      register struct mlist *split;	/* split point */
      split=(struct mlist*)((long)ptr+s+sizeof(struct mlist));
      split->next=ptr->next;		/* split the list... */
      ptr->next=split;			/* ...into two */
      split->free=FREE;			/* mark 2nd half as free */
      split->len=ptr->len-s-sizeof(struct mlist);	/* size of 2nd half */
      ptr->len=s;			/* new size of 1st half */
     }
    ptr->free=USED;		/* mark as in use */
    return(new);
   }
 }
new=sbrk(s+(unsigned int)sizeof(struct mlist));	/* we need more memory */
if(new==(char*)-1)
 return((char*)0);			/* return 0 for error */
else
 {
  register struct mlist *newstr=(struct mlist*)new;
  new+=sizeof(struct mlist);
  ptr->next=newstr;			/* add new block to list */
  newstr->len=s;			/* store length of new block */
  newstr->free=USED;			/* mark as used */
  newstr->next=(struct mlist*)0;	/* mark as end of list */
  memcpy(new,p,s);			/* copy old contents to new block */
  return(new);
 }
}
