#include "misc.hpp"
#include "player.hpp"
#include "vga.hpp"
#include "wslice.hpp"
#include "trace.hpp"
#include "zox3d.hpp"

// Define NO_ASM if you for some reason want all compiled source code to
// be C or C++, i.e. no assembly.  Not fully supported at the moment.

//#define NO_ASM

#ifndef NO_ASM

// Define NO_SMC if you don't want self-modifying code.
// The resulting code if NOT defined will typically be faster and larger,
// and will modify itself on the fly.

//#define NO_SMC

// Define NO_UNROLL if you don't want unrolled loops.

//#define NO_UNROLL

#endif


int WallSlice::hitherBottom, WallSlice::hitherTop;
Fixed *tFactorX=0, *tFactorY=0, *tRatio=0;


WallSlice::WallSlice(BitmapNo n, unsigned p) :
		bno(n&0x7f),
		bmap((BitmapX&)(*resTab)[bno])
	{
	if (bno != n)
		pixel = BLOCKSIZE_WORLD-p;
	else
		pixel = p;
	}


void WallSlice::calcPos(Fixed depthRatio)
	{
	Fixed wHeight;
	FixMul(depthRatio, scaleHeight, wHeight);
	FixMul(depthRatio, guyElevScreen, wElev);
	fTop = INT2FIX(windowHeight>>1) - wElev;
	fBottom = fTop + wHeight;
	bottom = FIX2INT(fBottom-1);
	top = FIX2INT(fTop+0xffff);
	}

#define DRAW_SETUP														\
	char *dest = activeBuf, *bBase = bmap.getData()						\
		+ (FIX2INT(long(pixel) * bmap.getWidth()) * bmap.getHeight());	\
	Fixed bStep, bOff = guyElev * bmap.getHeight();						\
	FixDiv(INT2FIX(bmap.getHeight()), fBottom-fTop, bStep);				\
	if (top < 0)                                    					\
		{																\
		bOff -= (windowHeight>>1) * bStep;                        		\
		top = 0;                                    					\
		}                                           					\
	else																\
		{																\
		dest += top * bufStepY;											\
		bOff -= ((windowHeight>>1)-top) * bStep;						\
		}																\
	if (bottom >= windowHeight)											\
		bottom = windowHeight-1;

/*
 * Here follows the functions that draws the walls/mirrors.
 */

void WallSlice::drawOpaque()
	{
	DRAW_SETUP;

#ifdef NO_ASM
	int count = bottom-top+1;
	if (count <= 0)
		return;
	while (count--)
		{
		*dest = *(bBase + FIX2INT(bOff));
		dest += bufStepY;
		bOff += bStep;
		}
#else // !NO_ASM
	_CX = bottom-top+1;
	if (int(_CX) <= 0)
		return;

	asm	push	ds
	asm push	si
	asm push	di

	asm	mov		bx, [bufStepY]
	asm dec		bx					// bx <- number of bytes-1 to skip in the
									// destination buffer for each pixel.

# ifndef NO_UNROLL
	asm	jnz		short usingScreen

	asm	mov		ax, MAX_SCREENHEIGHT// bx==0 -> use fastest unrolled loop
	asm	sub		ax, cx				// Calculate entry point in unrolled code:
//	asm	imul	cx, ax, 9			//   Each iteration is 9 bytes.
	asm	mov		cx, ax				//   \
	asm	shl		ax, 3				//    > (faster than imul cx,ax,9)
	asm	add		cx, ax				//   /
	asm add		cx, offset opaqueUnrolledTemp //   Offset from first iteration.
	asm	jmp		short skip1

		usingScreen:
	asm	mov		ax, MAX_SCREENHEIGHT// bx>0 -> use slowest unrolled loop
	asm	sub		ax, cx				// Calculate entry point in inrolled code:
	asm	imul	cx, ax, 11			//   Each iteration is 11 bytes.
	asm add		cx, offset opaqueUnrolledScreen // Offset from first iteration

		skip1:
# endif // !NO_UNROLL

	asm	mov		edx, [dword ptr bStep]// edx=delta for each step through bitmap
	asm	les		di, [dest]			// es:di <- destination buffer
	asm	mov		esi, [dword ptr bOff]
	asm	lds		ax, [bBase]         // ds:eax <- bitmap - ds is destroyed(!)
	asm	shl		eax, 16				// turn eax into Fixed
	asm	add		eax, esi			// and add the Fixed start offset
//	asm	xor		esi, esi			// clear upper 16 bits of esi

# ifdef NO_UNROLL
		nextPixel:

	asm shld	esi, eax, 16		// copy integer part of eax to si
	asm movsb						// copy one pixel from bitmap to buffer
	asm add		eax, edx			// calculate next bitmap pixel
	asm add		di, bx
	asm loop	nextPixel
# else // !NO_UNROLL
	asm jmp		cx					// Jump into the unrolled code at the
									//	appropriate point.

	asm LABEL	opaqueUnrolledTemp

	asm REPT	MAX_SCREENHEIGHT
	asm shld	esi, eax, 16		// copy integer part of eax to si
	asm movsb						// copy one pixel from bitmap to buffer
	asm add		eax, edx			// calculate next bitmap pixel
//	Iteration: 9 bytes

//	asm	movsb
//	asm	add		ax, bx				// si:ax += dx:bx
//	asm	adc		si, dx
//	Iteration: 5 bytes
	asm ENDM

//	asm jmp		doneOpaque			// TASM barfs on this, therefore the
	asm	db		0E9h				// kludge here.
	asm	dw		offset opaqueDone-$-2

	asm LABEL	opaqueUnrolledScreen

	asm REPT	MAX_SCREENHEIGHT
	asm shld	esi, eax, 16		// copy integer part of eax to si
	asm movsb						// copy one pixel from bitmap to buffer
	asm add		eax, edx			// calculate next bitmap pixel
	asm add		di, bx
	asm ENDM

	asm	LABEL	opaqueDone
# endif // !NO_UNROLL

	asm pop		di
	asm pop		si
	asm	pop		ds
#endif // NO_ASM
	}





void WallSlice::drawTransparent()
	{
	DRAW_SETUP;

#ifdef NO_ASM
	int count = bottom-top+1;
	if (count <= 0)
		return;
	while (count--)
		{
		char c = *(bBase + FIX2INT(bOff));
		if (c)
			*dest = c;
		dest += bufStepY;
		bOff += bStep;
		}
#else // !NO_ASM
	_CX = bottom-top+1;
	if (int(_CX) <= 0)
		return;

	asm	push	ds
	asm push	si
	asm push	di

# ifndef NO_UNROLL
	asm	mov		ax, MAX_SCREENHEIGHT
	asm	sub		ax, cx
	asm	imul	ax, 19
	asm add		ax, offset transparentUnrolled
	asm	mov		cx, ax
# endif // !NO_UNROLL

	asm mov		eax, [dword ptr bOff]
	asm	mov		edx, [dword ptr bStep]// edx=delta for each step through bitmap
	asm	les		di, [dest]			// es:di -> destination buffer
	asm	lds		bx, [bBase]         // ds:eax->bitmap - DS is destroyed!!!!!
	asm	shl		ebx, 16				// turn eax into Fixed
	asm	add		ebx, eax			// and add the Fixed start offset

# ifdef NO_UNROLL
		nextPixel:

	asm shld	esi, ebx, 16		// copy integer part of ebx to si
	asm lodsb						// al <- ds:[si] (NOT ds:[esi]!)
	asm or		al, al				// transparent color == 0
	asm jz		transparent
	asm stosb
	asm	add		ebx, edx			// calculate next bitmap pixel
	asm	loop	nextPixel
	asm jmp		done

		transparent:

	asm inc		di
	asm add		ebx, edx
	asm loop	nextPixel

		done:
# else // !NO_UNROLL
	asm	mov		ax, cx
	asm	xor		cx, cx
	asm jmp		ax

	asm	LABEL	transparentUnrolled

	asm REPT	MAX_SCREENHEIGHT
	asm shld	esi, ebx, 16		// copy integer part of eax to si
	asm lodsb
	asm	sub		al, 1
	asm	adc		di, cx
	asm	sub		al, 0FFh
	asm	adc		cx, cx
	asm	rep		stosb
	asm add		ebx, edx			// calculate next bitmap pixel
	// Iteration: 19 bytes
	asm ENDM
/*
	asm REPT	MAX_SCREENHEIGHT
	asm shld	esi, ebx, 16		// copy integer part of eax to si
	asm lodsb
	asm	or		al, al
	asm	jz		$+5					// jump cond. to inc di below
	asm mov		es:[di], al
	asm	inc		di          		// <-- a retn is patched in here
	asm add		ebx, edx			// calculate next bitmap pixel
	// Iteration: 17 bytes
	asm ENDM
*/
# endif // !NO_UNROLL

	asm pop		di
	asm pop		si
	asm	pop		ds
#endif // !NO_ASM
	}


void WallSlice::drawColor(char color)
	{
	unsigned start = max(0, top);
	unsigned end = min(unsigned(bottom), unsigned(windowHeight-1));

#ifdef NO_ASM
	int count = end-start+1;
	if (count <= 0)
		return;
	char *dest = activeBuf + start;
	while (count--)
		*(dest++) = color;
#else // !NO_ASM
	_CX = end-start+1;
	_AX = start;
	asm push	di
	asm	les		di, [activeBuf]
	asm	cmp		cx, 0
	asm	jle		done

	asm	add		di, ax
	asm	mov		al, [color]
	asm	cld
	asm	rep		stosb
	asm pop		di

		done:
		;
#endif // !NO_ASM
	}



void WallSlice::drawFrom(char *buffer)
	{
	unsigned start = max(0, top);
	unsigned end = min(unsigned(bottom), unsigned(windowHeight-1));

#ifdef NO_ASM

	int count = end-start+1;
	if (count <= 0)
		return;
	buffer += start;
	char *dest = vgaBuf + lineOffset[start];
	while (count--)
		{
		*dest = *(buffer++);
		dest += screenWidthBytes;
		}

#else // !NO_ASM

	_CX = end-start+1;
	if (int(_CX) <= 0)
		return;

	asm push	ds
	asm push	si
	asm push	di

# ifndef NO_UNROLL
	asm	mov		ax, MAX_SCREENHEIGHT
	asm	sub		ax, cx
	asm	imul	ax, 3
	asm add		ax, offset fromUnrolled
	asm	mov		cx, ax
# endif // !NO_UNROLL

	asm les		di, [vgaBuf]
	asm	mov		ax, [start]
	asm	mov		bx, ax
	asm	shl		bx, 1
	asm	add		di, [lineOffset + bx]

	asm mov		bx, [screenWidthBytes]
	asm dec		bx
	asm	lds		si, [buffer]
	asm add		si, ax

# ifdef NO_UNROLL
		nextPixel:

	asm movsb
	asm add		di, bx
	asm loop	nextPixel
# else // !NO_UNROLL
	asm jmp		cx

	asm	LABEL	fromUnrolled

	asm REPT	MAX_SCREENHEIGHT
	asm	movsb
	asm add		di, bx
	asm ENDM
# endif // !NO_UNROLL

	asm pop		di
	asm pop		si
	asm pop		ds
#endif // !NO_ASM
	}

void WallSlice::drawFloor()
	{
	Fixed factorX, factorY;

	if (features & (DRAW_FLOOR | DRAW_SKY))
		{
		factorX = mirroredX ? -tFactorX[column] : tFactorX[column];
		factorY = mirroredY ? -tFactorY[column] : tFactorY[column];
		}

	// Draw floor if visible

	long count = hitherBottom - bottom;
	if (count > 0 && count < windowHeight)
		{
		char *pixel = activeBuf + bottom * bufStepY;

		if (features & DRAW_FLOOR)
			{
			Fixed *ratio = tRatio + bottom;

#ifdef NO_ASM
			while (count--)
				{
				Fixed wx = virtualGuyX;
				FixMulAdd(*ratio, factorX, wx);
				Fixed wy = virtualGuyY;
				FixMulAdd(*(ratio++), factorY, wy);

				*(pixel += bufStepY) =
					*(floorData+(unsigned(wx)>>4 & 0x0fc0)+(unsigned(wy)>>10));
				}
#else // !NO_ASM

			_CX = count;
			asm	push	si
			asm	push	di
# ifdef NO_SMC
			asm	mov		es, [word ptr bmap + 2]
# else
			asm	mov		ax, [bufStepY]
			asm	mov		cs:[floorPatch1+2], ax // patch bufStepY into loop
			asm	les		bx, [floorData]			// es:bx <- skyData
			asm	mov		cs:[floorPatch2+1], bx // patch bx into loop
			asm	mov		eax, [dword ptr virtualGuyX]
			asm	mov		cs:dword ptr [floorPatch3+2], eax
			asm	mov		eax, [dword ptr virtualGuyY]
			asm	mov		cs:dword ptr [floorPatch4+2], eax
# endif
			asm	lfs		si, [ratio]			// fs:si <- vertical ratio table
			asm	lgs		di, [pixel]			// gs:di <- dest. pixel

		floorLoop1:

# ifdef NO_SMC
			asm	add		di, [bufStepY]		// gs:di <- next dest. pixel
			asm	mov		bx, [word ptr bmap]	// es:bx <- skyData (ptr)

			asm	mov		eax, fs:[si]		// eax <- *ratio
			asm	imul	[dword ptr factorX]
			asm	shrd	eax, edx, 16

			asm	add		eax, [dword ptr virtualGuyX]

			asm	shr		ax, 4
			asm	and		ax, 00fc0h
			asm	add		bx, ax				// add x component to es:di

			asm	mov		eax, fs:[si]
			asm	imul	[dword ptr factorY]
			asm	shrd	eax, edx, 16

			asm	add		eax, [dword ptr virtualGuyY]

			asm	shr		ax, 10
			asm	add		bx, ax				// add y component to es:di

# else // !NO_SMC
			asm	LABEL   floorPatch1
			asm	add		di, 0ffffh			// gs:di <- next dest. pixel

			asm	LABEL   floorPatch2
			asm	mov		bx, 0ffffh			// es:bx <- skyData (ptr)

			asm	mov		eax, fs:[si]		// eax <- *ratio
			asm	imul	[dword ptr factorX]
			asm	shrd	eax, edx, 16

			asm	LABEL	floorPatch3
			asm	add		eax, 07fffffffh

			asm	shr		ax, 4
			asm	and		ax, 00fc0h
			asm	add		bx, ax				// add x component to es:di

			asm	mov		eax, fs:[si]
			asm	imul	[dword ptr factorY]
			asm	shrd	eax, edx, 16

			asm	LABEL	floorPatch4
			asm	add		eax, 07fffffffh

			asm	shr		ax, 10
			asm	add		bx, ax				// add y component to es:di

# endif // !NO_SMC

			asm	mov		al, es:[bx]			// get pixel color
			asm	mov		gs:[di], al			// and store in buffer

			asm	add		si, 4				// fs:si <- next ratio
			asm	dec		cx
			asm	jnz		floorLoop1

			asm	pop		di
			asm	pop		si
#endif
			}
		else
#ifdef NO_ASM
			while (count--)
				*(pixel += bufStepY) = 79;
#else
			{
			asm	les 	di, [pixel]
			asm	mov		cx, [count]
			asm	mov 	bx, [bufStepY]
			asm	mov		al, 79
		floorLoop2:
			asm	add		di, bx
			asm	mov		[es:di], al
			asm	loop	floorLoop2
			}
#endif
		hitherBottom = bottom;

		}

	// Draw ceiling (sky) if visible

	count = top - hitherTop;
	if (count > 0 && count < windowHeight)
		{
		char *pixel = activeBuf + (hitherTop-1) * bufStepY;
		if (features & DRAW_SKY)
			{
			Fixed *ratio = tRatio + hitherTop;

#ifdef NO_ASM
			while (count--)
				{
				Fixed wx = virtualGuyX;
				FixMulAdd(*ratio, factorX, wx);
				Fixed wy = virtualGuyY;
				FixMulAdd(*(ratio++), factorY, wy);

				*(pixel += bufStepY)
					= *(skyData + (wx >> 6 & 0xff00) + (wy >> 14 & 0x00ff));
				}
#else // !NO_ASM
			_CX = count;
			asm	push	si
			asm	push	di
# ifdef NO_SMC
			asm	mov		es, [word ptr skyData + 2]
# else
			// patch some constants directly into the loop
			asm	mov		ax, [bufStepY]
			asm	mov		cs:[ceilPatch1+2], ax // patch bufStepY into loop
			asm	les		bx, [skyData]			// es:bx <- skyData
			asm	mov		cs:[ceilPatch2+1], bx // patch bx into loop
			asm	mov		eax, [dword ptr virtualGuyX]
			asm	mov		cs:dword ptr [ceilPatch3+2], eax
			asm	mov		eax, [dword ptr virtualGuyY]
			asm	mov		cs:dword ptr [ceilPatch4+2], eax
# endif
			asm	lfs		si, [ratio]			// fs:si <- vertical ratio table
			asm	lgs		di, [pixel]			// gs:di <- dest. pixel

		ceilLoop1:

# ifdef NO_SMC
			asm	add		di, [bufStepY]		// gs:di <- next dest. pixel
			asm	mov		bx, [word ptr skyData]	// es:bx <- skyData (ptr)

			asm	mov		eax, fs:[si]		// eax <- *ratio
			asm	imul	[dword ptr factorX]
			asm	shrd	eax, edx, 16

			asm	add		eax, [dword ptr virtualGuyX]

			asm	shr		eax, 6
			asm	and		ax, 0ff00h
			asm	add		bx, ax				// add x component to es:di

			asm	mov		eax, fs:[si]
			asm	imul	[dword ptr factorY]
			asm	shrd	eax, edx, 16

			asm	add		eax, [dword ptr virtualGuyY]

			asm	shr		eax, 14
			asm	and		ax, 000ffh
			asm	add		bx, ax				// add y component to es:di

# else // !NO_SMC
			asm	LABEL   ceilPatch1
			asm	add		di, 0ffffh			// gs:di <- next dest. pixel

			asm	LABEL   ceilPatch2
			asm	mov		bx, 0ffffh			// es:bx <- skyData (ptr)

			asm	mov		eax, fs:[si]		// eax <- *ratio
			asm	imul	[dword ptr factorX]
			asm	shrd	eax, edx, 16

			asm	LABEL	ceilPatch3
			asm	add		eax, 07fffffffh

			asm	shr		eax, 6
			asm	and		ax, 0ff00h
			asm	add		bx, ax				// add x component to es:di

			asm	mov		eax, fs:[si]
			asm	imul	[dword ptr factorY]
			asm	shrd	eax, edx, 16

			asm	LABEL	ceilPatch4
			asm	add		eax, 07fffffffh

			asm	shr		eax, 14
			asm	and		ax, 000ffh
			asm	add		bx, ax				// add y component to es:di

# endif // !NO_SMC

			asm	mov		al, es:[bx]			// get pixel color
			asm	mov		gs:[di], al			// and store in buffer

			asm	add		si, 4				// fs:si <- next ratio
			asm	dec		cx
			asm	jnz		ceilLoop1

			asm	pop		di
			asm	pop		si
#endif
			}
		else
			{
#ifdef NO_ASM
			while (count--)
				*(pixel += bufStepY) = 159;
#else
			asm	les 	di, [pixel]
			asm	mov		cx, [count]
			asm	mov 	bx, [bufStepY]
			asm	mov		al, 159
		ceilLoop2:
			asm	add		di, bx
			asm	mov		[es:di], al
			asm	loop	ceilLoop2
#endif
			}
		hitherTop = top;
		}

	}
