#ifndef _RESOURCE_HPP
#define _RESOURCE_HPP

#include "ilbm.hpp"

#define NO_BITMAP (BitmapNo(-1))
typedef unsigned char BitmapNo;

class Resource;
class BitmapX;
class ResourceTable;

extern ResourceTable *resTab;

class Resource
	{
	protected:
		unsigned size;
		char *data;
	public:
		Resource(unsigned s, char *d = 0);
		~Resource()
			{ delete[] data; }
		char * &getData()
			{ return data; }
		unsigned getSize()
        	{ return size; }
	};

// BitmapX uses Resource to store a 256 color bitmap.  The X signals
// that the bitmap is stored rowwise rather than linewise, and thereby
// optimized for mode X (and the ZOX3D library).

class BitmapX : public Resource
	{
	protected:
		unsigned width, height, type;
		unsigned bound1, bound2;
	public:
		BitmapX(unsigned w, unsigned h, char *d=0, unsigned t=0)
			: Resource(w*h, d), width(w), height(h), type(t) {}
		BitmapX(unsigned, unsigned, IffBitMap &, unsigned);
		unsigned getWidth() const
			{ return width; }
		unsigned getHeight() const
			{ return height; }
		int isSpecialAt(unsigned pixel)
			{ return pixel>=bound1 && pixel<=bound2; }
	};

class ResourceTable
	{
	private:
		int resources;
		Resource **res;
	public:
		ResourceTable(istream &resDesc);
		~ResourceTable();
		Resource &operator [](unsigned i) const
			{ return *res[i /*%resources*/ ]; }
	};


#endif
