#ifndef _MOUSE_HPP
#define _MOUSE_HPP

/*
 * MOUSE.HPP
 * 
 * With MOUSE.CPP, this file defines a minimum object based interface
 * to the Microsoft Mouse interrupt services.
 * 
 * The Mouse class supports:
 * 
 *  - 2- and 3-buttoned mice adheing to the Microsoft Mouse standard
 *  - the standard mouse driver pointer (in the video modes supported
 *    by the driver)
 *  - getting and setting mouse position
 *  - retrieving information on the distances travelled since the last
 *    polling of the mouse.
 * 
 * If the Mouse object is disabled (by means of setState(0)), none of
 * the public functions do anything.
 */


#include "dos.h"

#define MOUSE_INTERRUPT	(0x33)

class Mouse
	{
	private:
		REGPACK reg;
		void callMouse(int func)
			{ reg.r_ax=func; intr(MOUSE_INTERRUPT, &reg); }
		unsigned installed : 1;
		unsigned enabled : 1;
		static int instances;
	public:
		enum MouseButtonMasks
		{ LEFT=1, RIGHT=2, MIDDLE=4 };
		Mouse();
		~Mouse()		{ hide(); }
		void setState(unsigned state)
						{ enabled = state & installed; }
		void init();
		void show()		{ if (enabled) callMouse(0x0001); }
		void hide()		{ if (enabled) callMouse(0x0002); }
		void getMotion(int &x, int &y);
		void getPosition(int &x, int &y);
		void setPosition(int x, int y);
		int getButtons();
		int isInstalled()
			{ return installed; }
	};

extern Mouse mouse;

#endif
