#include <values.h>		//for MAXINT
#include <conio.h>		//for outp()
#include <stdio.h>
#include <stdlib.h>		//for exit()
#include <mem.h>		//for memcpy()
#include <dos.h>		//for geninterrupt(), MK_FP()
#include "ilbm.hpp"		//for IFF declarations, #includes <fstream.h>


//Utilities//////////////////////////////////////////////////////////////////

char *idToString(Id id)
	{
	static char idS[5];

	for (int i=0; i<4; i++)
		idS[i] = ((char*)&id)[3-i];
	idS[4] = 0;

	return idS;
	}

IffStream& operator>>(IffStream& s, IffBitMapHeader& h)
	{
	h.w					= s.getWord();
	h.h					= s.getWord();
	h.x					= s.getWord();
	h.y					= s.getWord();
	h.nPlanes			= s.getByte();
	h.masking			= s.getByte();
	h.compression		= s.getByte();
	h.pad1 				= s.getByte();
	h.transparentColor	= s.getWord();
	h.xAspect			= s.getByte();
	h.yAspect			= s.getByte();
	h.pageWidth			= s.getWord();
	h.pageHeight		= s.getWord();

	return s;
	}

IffStream& operator>>(IffStream& s, Chunk& c)
	{
	unsigned long toRead = c.size
						 = s.activeChunk.size;
	delete[] c.data;
	if (!(c.data = (void *) new char[c.size]))
		{
		cerr << "out of memory reading chunk " << idToString(c.id) << endl;
		exit(1);
		}

	while (toRead > long(MAXINT))
		{
		s.read((char*)(c.data), MAXINT);
		toRead -= MAXINT;
		s.read((char*)(c.data)+MAXINT, toRead);
		}
	if (toRead)
		s.read((char*)(c.data), toRead);

/*
	if (s.gcount() != toRead)
		{
		cerr << "unexpected EOF reading chunk " << idToString(c.id) << endl;
		exit(1);
		}
*/
	return s;
	}


//Body methods///////////////////////////////////////////////////////////////

/*
void putPixel(unsigned char data)
	{
								//for old DP2 images
	int bitMask;

	bitMask=0x80;
	do	{
		if (data & bitMask)
			vga[scrnp]|=planeMask;
		if (++scrnp % 320 == 0)
			if ((planeMask<<=1) > 0x80)
				planeMask = 1;
			else
				scrnp-=320;
		}
	while ((bitMask>>=1) >= 1);
	}
*/


int Body::uncompress(Compression method, UWORD maxSize)
	{
	switch (method)
		{
		case NOCOMP:
//			memcpy(dest,data,size);
			break;

		case BYTERUN1:
			if (size > 65535)
				return 0;
			unsigned s = unsigned(size);	// NB!! size must be <= 64kb!
			char *newData = new char[maxSize];
			if (!newData)
				return 0;

			void *b = data;

			// The following decompresses the BODY chunk according to
			// the format described in ILBM.HPP.

			asm	{
				push	ds
				push	si

				mov		bx,[s]				// BX = size of body data

				lds		si,[b]
				add		bx,si				// DS:BX = BX+b; end address of body
				les		di, [newData]		// ES:DI points to start of dest.

				xor		cx,cx				// Init repeat counter
				cld
				}
		decode:
			asm	{
				lodsb						// Get count code into AL...
				mov		cl,al				// ...and copy to CL
				cmp		cl,0				// Is it negative?
				jl		set					// If yes, skip string copy
				}
		copy:
			asm	{
				inc		cl					// Copy next count+1 bytes into...
				rep		movsb				// ...screen memory
				cmp		si,bx				// Have we reached the last address...
				jb		decode				// ...of the BODY chunk?
				jmp		done
				}
		set:
			asm	{
				lodsb						// Copy the next single byte...
				neg		cl					// ...-count+1 times into the...
				inc		cl					// ...video memory
				rep		stosb
				cmp		si,bx				// Have we reached the last address...
				jb		decode				// ...of the BODY chunk?
				}
		done:
			asm	pop		si
			asm	pop		ds

			delete[] data;
			data = (void *)newData;
			size = maxSize;
			break;
		}
	return 1;
	}

//ColorMap methods///////////////////////////////////////////////////////////

int ColorMap::out(MapType map)
	{
	switch (map)
		{
		case C256X3:
			{
			outp(0x3c8,0);
			char *tmp = (char*)data;
			int count = 3*256;
			while (count--)
				outp(0x3c9, (*tmp++)>>2);
			break;
			}
		case C16X4:
		default:
			return 0;
		}
	return 1;
	}

//IffBitMap methods//////////////////////////////////////////////////////////


void IffBitMap::load(const char *fname)
	{
	IffStream i(fname);

	iffId = i.iffType();
	if ((iffId != Id_ILBM) && (iffId != Id_PBM))
		{
		cerr << fname << " not a valid IFF bitmap (ILBM or PBM)" << endl;
		exit(1);
		}

	ChunkHeader	info;
	while ((info=i.nextChunk()).id != 0)
		{
		switch (info.id)
			{
			case Id_BMHD:
				i >> bmhd;
				break;
			case Id_CMAP:
				cmap.id = info.id;
				i >> cmap;
				break;
			case Id_BODY:
				body.id = info.id;
				i >> body;
				break;
			}
		}
	}


int IffBitMap::uncompress()
	{
	if (bmhd.compression != NOCOMP)
		if (body.uncompress(bmhd.compression, bmhd.w * bmhd.h))
			bmhd.compression = NOCOMP;
		else
			return 0;
	return 1;
	}

int IffBitMap::showMode13h()
	{
	_AX=0x13;
	geninterrupt(0x10);
	if (uncompress())
		{
		unsigned h = getHeight();
		unsigned w = getWidth();
		const char *d = (const char *)(body.getData());
		cmap.out(ColorMap::C256X3);
		for (int y=0; y<h; y++)
			memcpy((char*)MK_FP(0xa000,0)+y*320, d+y*w, w);
		return 1;
		}
	return 0;
	}

//IffStream methods//////////////////////////////////////////////////////////

IffStream::IffStream(const char *name)
	: ifstream(name,ios::binary | ios::in | ios::nocreate)
	{
	if (ios::bad())
		{
		cerr << "IffStream: error opening " << name << endl;
		exit(1);
		}
	if (!(isForm = (getLong() == Id_FORM)))
		{
		cerr << "IffStream: " << name << " is not a proper IFF file\n";
		exit(1);
		}
	formSize = getLong();
	type = getLong();
	activeChunk.id = 0;
	offsetNextChunk = tellg();
	}

unsigned char IffStream::getByte()
	{
	if (ios::eof())
		{
		cerr << "IffStream: unexpected EOF\n";
		exit(1);
		}
	return (unsigned char)get();
	}

ChunkHeader IffStream::nextChunk()
	{
	if (offsetNextChunk >= formSize+2*sizeof(LONG))
		activeChunk.id = 0;		//end of data reached properly,
									//  not neccessarily EOF
	else
		{
		seekg(offsetNextChunk, beg);
		activeChunk.id = getLong();
		activeChunk.size = getLong();
		offsetNextChunk += 2*sizeof(LONG)+activeChunk.size+
							((activeChunk.size&1)?1:0);
		}
	return activeChunk;
	}
