#ifndef DISASM_H
#define DISASM_H

struct symbol
{
	int addr;
	int type;
#define SYM_CODE 1
#define SYM_DATA 2
#define SYM_STRING 4
	char *name;
	
	struct symbol *next;
};

struct range
{
	int addr, end;
	int type;
	
	struct range *next;
};

extern struct symbol *first_sym, *last_sym;
extern struct range *first_rng, *last_rng;
extern int base_addr;
extern int start;

extern void do_disasm (int start, int len, char *buf);
extern char *find_symbol (int addr, int type);
extern char *hex (int val);

#endif
